/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.bdctrl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.ProgressBar;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataService;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.bd.assign.AssignResult;
import kd.fi.bd.assign.OpLogHelper;
import kd.fi.bd.assign.unassign.OrgAccountInfo;
import kd.fi.bd.assign.unassign.UnAssignCtx;
import kd.fi.bd.assign.unassign.UnAssignHandle;
import kd.fi.bd.business.BDGLServiceFactory;
import kd.fi.bd.consts.AccountOperationType;
import kd.fi.bd.interfaces.service.IAccountAssignService;
import kd.fi.bd.util.AccountOperationLogUtil;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BillParamUtil;

public class AssignQueryHelper {
    private static final Log logger = LogFactory.getLog(AssignQueryHelper.class);
    private IFormView view;

    public AssignQueryHelper() {
    }

    public AssignQueryHelper(IFormView view) {
        this.view = view;
    }

    public void btnUnassign() {
        String useOrgId = this.view.getFormShowParameter().getCustomParam("useOrgId").toString();
        AccountOperationLogUtil.initRawOperationLog((Long)Long.parseLong(useOrgId), (AccountOperationType)AccountOperationType.UNASSIGN, (Long)0L, new HashSet(8));
        AccountOperationLogUtil.setOperationLog(operationLog -> operationLog.setOrgIds(new HashSet(8)));
        if (PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)Long.parseLong(useOrgId), (String)"fibd", (String)"bd_accountview", (String)"80513209000000ac") == 0) {
            String message = ResManager.loadKDString((String)"\u7528\u6237\u65e0\u53d6\u6d88\u5206\u914d\u6743\u9650\u3002", (String)"AssignQueryHelper_0", (String)"fi-bd-formplugin", (Object[])new Object[0]);
            this.view.showTipNotification(message);
            AccountOperationLogUtil.persistLog((String)message);
            return;
        }
        EntryGrid billList = (EntryGrid)this.view.getControl("entryentity");
        int[] col = billList.getSelectRows();
        if (col.length == 0) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u53d6\u6d88\u5206\u914d\u7684\u6570\u636e\u3002", (String)"AssignQueryHelper_1", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject accountObj = BusinessDataServiceHelper.loadSingle((Object)((Long)this.view.getModel().getValue("dataid", col[0])), (String)"bd_accountview");
        long accountTableId = accountObj.getLong("accounttable_id");
        HashSet<Long> accountIds = new HashSet<Long>(8);
        for (int id : col) {
            Long accId = (Long)this.view.getModel().getValue("dataid", id);
            accountIds.add(accId);
        }
        AccountOperationLogUtil.setOperationLog(operationLog -> {
            operationLog.setAccountTableId(Long.valueOf(accountTableId));
            operationLog.setAccountIds((Set)accountIds);
        });
        String lockKey = "assignlock" + accountTableId;
        DLockInfo lockInfo = DLock.getLockInfo((String)lockKey);
        if (lockInfo != null) {
            this.view.showTipNotification(lockInfo.getDesc());
            AccountOperationLogUtil.persistLog((String)lockInfo.getDesc());
            return;
        }
        if (!this.checkSubAccts()) {
            return;
        }
        if (!this.checkSubOrgDis()) {
            return;
        }
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u53d6\u6d88\u5206\u914d", "AssignQueryHelper_2", "fi-bd-formplugin");
        String allowUnassignVersionAdd = BillParamUtil.getStringValue((String)"P9H6JC5EVP1", (String)"fi.bd.account.unassign.allowunassignversionadd", (String)"false");
        if (allowUnassignVersionAdd.equals("false")) {
            SqlBuilder versionSql = new SqlBuilder();
            versionSql.append("select top 1 a.fid from t_bd_account as a ", new Object[0]);
            versionSql.append("inner join t_bd_account as b on a.fmasterid =b.fmasterid ", new Object[0]);
            versionSql.append("where a.flevel <> b.flevel ", new Object[0]);
            versionSql.appendIn("and a.fid ", new ArrayList(accountIds));
            DataSet dataSet = DB.queryDataSet((String)AssignQueryHelper.class.getName(), (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)versionSql);
            Object object = null;
            try {
                if (dataSet.hasNext()) {
                    String description = ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u53d6\u6d88\u5df2\u505a\u8d26\u7248\u672c\u5316\u65b0\u589e\u7684\u7b2c\u4e00\u4e2a\u79d1\u76ee\u3002", (String)"AssignQueryHelper_8", (String)"fi-bd-formplugin", (Object[])new Object[0]);
                    MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u4e0d\u5141\u8bb8\u53d6\u6d88\u5df2\u505a\u8d26\u7248\u672c\u5316\u65b0\u589e\u7684\u7b2c\u4e00\u4e2a\u79d1\u76ee\u3002", "AssignQueryHelper_8", "fi-bd-formplugin");
                    new OpLogHelper().addOperateLog(this.view, Long.parseLong(this.view.getFormShowParameter().getCustomParam("useOrgId").toString()), "", "unAssign", opNameBridge, opDescBridge, new String[]{""});
                    this.view.showTipNotification(description);
                    return;
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (dataSet != null) {
                    if (object != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u5f00\u59cb\u53d6\u6d88\u5206\u914d", "AssignQueryHelper_3", "fi-bd-formplugin");
        new OpLogHelper().addOperateLog(this.view, Long.parseLong(this.view.getFormShowParameter().getCustomParam("useOrgId").toString()), "", "unAssign", opNameBridge, opDescBridge, new String[]{""});
        ((ProgressBar)this.view.getControl("progressbarap")).start();
        this.view.showLoading(new LocaleString(ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u914d\u4e2d\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"AssignQueryHelper_5", (String)"fi-bd-formplugin", (Object[])new Object[0])));
        this.view.getPageCache().put("mark", "start");
        UnAssignCtx ctx = new UnAssignCtx();
        ctx.setUseOrgid(Long.valueOf(Long.parseLong(useOrgId)));
        ctx.setAccountTableId(Long.valueOf(accountTableId));
        for (Object i : (Object)col) {
            String number = (String)this.view.getModel().getValue("number", (int)i);
            String orgName = (String)this.view.getModel().getValue("useorg", (int)i);
            Long dataid = (Long)this.view.getModel().getValue("dataid", (int)i);
            Long orgId = (Long)this.view.getModel().getValue("useorgid", (int)i);
            OrgAccountInfo orgAccountInfo = new OrgAccountInfo(orgId, orgName, number);
            orgAccountInfo.getAccountIds().add(dataid);
            ctx.getOrgAndDatas().computeIfAbsent(orgId, k -> new HashMap()).put(number, orgAccountInfo);
            ctx.getAccountNumberIds().put(dataid, number);
            ctx.getUseOrgs().putIfAbsent(orgId, orgName);
            ctx.getOrgIds().add(orgId);
            ctx.getDataIDs().add(dataid);
        }
        String requestId = RequestContext.getOrCreate().getRequestId();
        ThreadService.execute(() -> {
            block34: {
                RequestContext.getOrCreate().setRequestId(requestId);
                HashSet orgIds = new HashSet(10);
                HashSet acctCheckErrMsg = new HashSet(10);
                ArrayList successPkIds = new ArrayList(10);
                HashMap successInfoMap = new HashMap(10);
                String lockMsg = String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u5206\u914d\u6216\u53d6\u6d88\u5206\u914d\u4e2d\uff0c\u8bf7\u7b49\u5f85\u64cd\u4f5c\u7ed3\u675f\u518d\u8fdb\u884c\u5206\u914d\u3002", (String)"AssignQueryHelper_4", (String)"fi-bd-formplugin", (Object[])new Object[0]), RequestContext.get().getUserName());
                try (DLock dLock = DLock.create((String)lockKey, (String)lockMsg);){
                    if (dLock.tryLock()) {
                        if (AccountVersionUtil.isUseNewAssignMethodSystemProperty()) {
                            HashMap<Long, Set> unAssignOrgAndAccountNum = new HashMap<Long, Set>(16);
                            Map orgAndDatas = ctx.getOrgAndDatas();
                            for (Map.Entry orgAndDatasMapEntry : orgAndDatas.entrySet()) {
                                unAssignOrgAndAccountNum.computeIfAbsent((Long)orgAndDatasMapEntry.getKey(), k -> new HashSet()).addAll(((Map)orgAndDatasMapEntry.getValue()).keySet());
                            }
                            IAccountAssignService accountAssignService = (IAccountAssignService)BDGLServiceFactory.getService((String)"IAccountAssignService");
                            AssignResult assignResult = accountAssignService.doUnAssign(ctx.getUseOrgid().longValue(), ctx.getAccountTableId().longValue(), unAssignOrgAndAccountNum);
                            if (AssignResult.ResultType.success != assignResult.getResultType()) {
                                acctCheckErrMsg.addAll(assignResult.getMsgs());
                            }
                        } else {
                            new UnAssignHandle(ctx, this.view).handle();
                        }
                        orgIds.addAll(ctx.getOrgIds());
                        acctCheckErrMsg.addAll(ctx.getAcctCheckErrMsg());
                        successPkIds.addAll(ctx.getSuccessPkIds());
                        successInfoMap.putAll(ctx.getSuccessInfoMap());
                    }
                    AccountOperationLogUtil.persistLog();
                }
                try {
                    if (AccountVersionUtil.isRebuildDataUseRangeSystemProperty()) {
                        ArrayList<Long> singletonList = new ArrayList<Long>(1);
                        BaseDataService baseDataService = new BaseDataService();
                        for (Long orgId : orgIds) {
                            singletonList.clear();
                            singletonList.add(orgId);
                            baseDataService.clearBaseDataFilterCache("bd_accountview", orgId);
                            BaseDataServiceHelper.refreshBaseDataUseRange((String)"bd_accountview", singletonList);
                        }
                    }
                    this.view.getPageCache().put("mark", "finish");
                    this.view.getPageCache().put("msg", acctCheckErrMsg.size() > 0 ? JSONObject.toJSONString(acctCheckErrMsg) : null);
                    this.view.getPageCache().put(this.view.getPageId() + "success", successPkIds.size() > 0 ? JSONObject.toJSONString(successPkIds) : null);
                    this.view.getPageCache().put(this.view.getPageId() + "successInfo", CollectionUtils.isEmpty(successInfoMap) ? null : JSONObject.toJSONString(successInfoMap));
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                break block34;
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    AccountOperationLogUtil.persistLog((String)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    try {
                        if (AccountVersionUtil.isRebuildDataUseRangeSystemProperty()) {
                            ArrayList<Long> singletonList = new ArrayList<Long>(1);
                            BaseDataService baseDataService = new BaseDataService();
                            for (Long orgId : orgIds) {
                                singletonList.clear();
                                singletonList.add(orgId);
                                baseDataService.clearBaseDataFilterCache("bd_accountview", orgId);
                                BaseDataServiceHelper.refreshBaseDataUseRange((String)"bd_accountview", singletonList);
                            }
                        }
                        this.view.getPageCache().put("mark", "finish");
                        this.view.getPageCache().put("msg", acctCheckErrMsg.size() > 0 ? JSONObject.toJSONString(acctCheckErrMsg) : null);
                        this.view.getPageCache().put(this.view.getPageId() + "success", successPkIds.size() > 0 ? JSONObject.toJSONString(successPkIds) : null);
                        this.view.getPageCache().put(this.view.getPageId() + "successInfo", CollectionUtils.isEmpty(successInfoMap) ? null : JSONObject.toJSONString(successInfoMap));
                    }
                    catch (Exception e2) {
                        logger.error(e2.getMessage(), (Throwable)e2);
                    }
                    catch (Throwable throwable) {
                        try {
                            if (AccountVersionUtil.isRebuildDataUseRangeSystemProperty()) {
                                ArrayList<Long> singletonList = new ArrayList<Long>(1);
                                BaseDataService baseDataService = new BaseDataService();
                                for (Long orgId : orgIds) {
                                    singletonList.clear();
                                    singletonList.add(orgId);
                                    baseDataService.clearBaseDataFilterCache("bd_accountview", orgId);
                                    BaseDataServiceHelper.refreshBaseDataUseRange((String)"bd_accountview", singletonList);
                                }
                            }
                            this.view.getPageCache().put("mark", "finish");
                            this.view.getPageCache().put("msg", acctCheckErrMsg.size() > 0 ? JSONObject.toJSONString(acctCheckErrMsg) : null);
                            this.view.getPageCache().put(this.view.getPageId() + "success", successPkIds.size() > 0 ? JSONObject.toJSONString(successPkIds) : null);
                            this.view.getPageCache().put(this.view.getPageId() + "successInfo", CollectionUtils.isEmpty(successInfoMap) ? null : JSONObject.toJSONString(successInfoMap));
                        }
                        catch (Exception e3) {
                            logger.error(e3.getMessage(), (Throwable)e3);
                        }
                        throw throwable;
                    }
                }
            }
        }, (TaskType)TaskType.FIBD_ACCOUNT_UNASSIGN_ASYNC_TASK);
    }

    private boolean checkSubAccts() {
        DynamicObject[] selectOrgInfos;
        EntryGrid billList = (EntryGrid)this.view.getControl("entryentity");
        int[] col = billList.getSelectRows();
        boolean checkResult = true;
        HashMap<Long, HashSet> selectOrgAccts = new HashMap<Long, HashSet>(50);
        HashSet<Long> userOrgIds = new HashSet<Long>(50);
        HashSet<String> selectdAccts = new HashSet<String>(50);
        HashMap<Long, String> orgNameMap = new HashMap<Long, String>(50);
        HashSet<Long> accountIds = new HashSet<Long>(50);
        for (int i : col) {
            String number = (String)this.view.getModel().getValue("number", i);
            Long l = (Long)this.view.getModel().getValue("useorgid", i);
            Long dataId = (Long)this.view.getModel().getValue("dataid", i);
            selectOrgAccts.computeIfAbsent(l, k -> new HashSet(50)).add(number);
            userOrgIds.add(l);
            selectdAccts.add(number);
            accountIds.add(dataId);
        }
        QFilter selectOrgIdFilter = new QFilter("id", "in", userOrgIds);
        for (DynamicObject dynamicObject : selectOrgInfos = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{selectOrgIdFilter})) {
            orgNameMap.put(dynamicObject.getLong("id"), dynamicObject.getString("name"));
        }
        HashMap<Long, HashSet> orgUseAcctsMap = new HashMap<Long, HashSet>();
        Long accountTableId = BusinessDataServiceHelper.loadSingle(accountIds.iterator().next(), (String)"bd_accountview").getLong("accounttable_id");
        for (Long l : userOrgIds) {
            DataSet enabledAccounts = AccountUtils.queryAccountDataSet((long)l, (long)accountTableId, (String)"number", null);
            Throwable throwable = null;
            try {
                for (Object row : enabledAccounts) {
                    orgUseAcctsMap.computeIfAbsent(l, k -> new HashSet(50)).add(row.getString("number"));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (enabledAccounts == null) continue;
                if (throwable != null) {
                    try {
                        enabledAccounts.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                enabledAccounts.close();
            }
        }
        HashMap<Long, Map> disOrgUnDisSubAcctMap = new HashMap<Long, Map>();
        for (Long userOrg : userOrgIds) {
            Object row;
            Set selectAccts = (Set)selectOrgAccts.get(userOrg);
            Set set = (Set)orgUseAcctsMap.get(userOrg);
            row = selectAccts.iterator();
            while (row.hasNext()) {
                String selectAcct = (String)row.next();
                for (String subOrgUseAcct : set) {
                    if (!subOrgUseAcct.startsWith(selectAcct) || subOrgUseAcct.length() <= selectAcct.length() || selectdAccts.contains(subOrgUseAcct)) continue;
                    disOrgUnDisSubAcctMap.computeIfAbsent(userOrg, k -> new HashMap()).computeIfAbsent(selectAcct, k -> new HashSet(50)).add(subOrgUseAcct);
                }
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>(100);
        if (!disOrgUnDisSubAcctMap.isEmpty()) {
            Set disOrgUnDisSubAcctEntrys = disOrgUnDisSubAcctMap.entrySet();
            for (Map.Entry entry : disOrgUnDisSubAcctEntrys) {
                Long userOrgId = (Long)entry.getKey();
                String userOrgName = (String)orgNameMap.get(userOrgId);
                Map selectdAcctUndisAcctsMap = (Map)entry.getValue();
                Set selectdAcctUndisAcctsEntrys = selectdAcctUndisAcctsMap.entrySet();
                for (Map.Entry selectdAcctUndisAcctsEntry : selectdAcctUndisAcctsEntrys) {
                    String selectedAcct = (String)selectdAcctUndisAcctsEntry.getKey();
                    Set unDisSubAccts = (Set)selectdAcctUndisAcctsEntry.getValue();
                    StringBuilder undisSubAcctsBuilder = new StringBuilder();
                    for (String unDisSubAcct : unDisSubAccts) {
                        undisSubAcctsBuilder.append(unDisSubAcct);
                        undisSubAcctsBuilder.append(",");
                    }
                    undisSubAcctsBuilder.deleteCharAt(undisSubAcctsBuilder.length() - 1);
                    if (undisSubAcctsBuilder.length() <= 0) continue;
                    arrayList.add(String.format(ResManager.loadKDString((String)"%1$s\u79d1\u76ee\u4e0d\u80fd\u53d6\u6d88\uff0c\u4e0b\u7ea7\u7ec4\u7ec7 %2$s \u5b58\u5728\u4e0b\u7ea7\u79d1\u76ee %3$s\uff0c\u8bf7\u5148\u53d6\u6d88\u5206\u914d\u4e0b\u7ea7\u79d1\u76ee\u3002", (String)"AssignQueryHelper_6", (String)"fi-bd-formplugin", (Object[])new Object[0]), selectedAcct, userOrgName, undisSubAcctsBuilder.toString()));
                }
            }
        }
        if (!arrayList.isEmpty()) {
            checkResult = false;
            OperationResult errorResult = new OperationResult();
            ArrayList<OperateErrorInfo> errorInfos = new ArrayList<OperateErrorInfo>(arrayList.size());
            StringBuilder stringBuilder = new StringBuilder();
            for (String info : arrayList) {
                OperateErrorInfo errorInfo = new OperateErrorInfo();
                errorInfo.setLevel(ErrorLevel.Error);
                errorInfo.setMessage(info);
                stringBuilder.append(info).append("\n");
                errorInfos.add(errorInfo);
            }
            errorResult.setAllErrorInfo(errorInfos);
            errorResult.setBillCount(arrayList.size());
            this.view.showOperationResult(errorResult);
            AccountOperationLogUtil.persistLog((String)stringBuilder.toString());
        }
        return checkResult;
    }

    private boolean checkSubOrgDis() {
        int[] col;
        boolean checkResult = true;
        HashMap<String, HashSet<Long>> acctUseOrgMap = new HashMap<String, HashSet<Long>>();
        HashSet<Long> orgIds = new HashSet<Long>(50);
        HashSet<Long> accountIds = new HashSet<Long>(50);
        HashMap<Long, String> orgNameMap = new HashMap<Long, String>(50);
        EntryGrid billList = (EntryGrid)this.view.getControl("entryentity");
        for (int i : col = billList.getSelectRows()) {
            String number = (String)this.view.getModel().getValue("number", i);
            Long orgId = (Long)this.view.getModel().getValue("useorgid", i);
            Long dataId = (Long)this.view.getModel().getValue("dataid", i);
            accountIds.add(dataId);
            acctUseOrgMap.computeIfAbsent(number, k -> new HashSet()).add(orgId);
            orgIds.add(orgId);
        }
        HashMap<Long, HashSet<Long>> userOrgSubOrgsMap = new HashMap<Long, HashSet<Long>>();
        this.getOrgSubOrgsMap(userOrgSubOrgsMap, orgIds, orgNameMap);
        if (!userOrgSubOrgsMap.isEmpty()) {
            Map<String, HashSet<Long>> acctSubOrgsMap = this.buildAcctSubOrgsMap(acctUseOrgMap, userOrgSubOrgsMap);
            Map<String, Long> acctMaseterIDMap = this.buildAcctNumMasterIDMap(accountIds);
            Map<String, HashSet<Long>> existDisRecordsubOrgsMap = this.queryAcctDisRecordInSubOrgs(accountIds, acctSubOrgsMap, acctMaseterIDMap);
            if (!acctSubOrgsMap.isEmpty()) {
                StringBuilder tipInfo = new StringBuilder();
                StringBuilder subOrgNameStrBuf = new StringBuilder();
                for (Map.Entry<String, HashSet<Long>> existDisRecordsubOrgsEntry : existDisRecordsubOrgsMap.entrySet()) {
                    String acctNum = existDisRecordsubOrgsEntry.getKey();
                    Set existDisRecordsubOrgs = existDisRecordsubOrgsEntry.getValue();
                    Set useOrgs = (Set)acctUseOrgMap.get(acctNum);
                    for (Long existDisRecordsubOrg : existDisRecordsubOrgs) {
                        if (useOrgs.contains(existDisRecordsubOrg)) continue;
                        String subOrgName = (String)orgNameMap.get(existDisRecordsubOrg);
                        subOrgNameStrBuf.append(subOrgName).append(",");
                    }
                    if (subOrgNameStrBuf.length() <= 0) continue;
                    subOrgNameStrBuf.deleteCharAt(subOrgNameStrBuf.length() - 1);
                    String msg = String.format(ResManager.loadKDString((String)"\u79d1\u76ee%1$s\u5728\u4e0b\u7ea7\u7ec4\u7ec7%2$s\u5df2\u5b58\u5728\uff0c\u8bf7\u5148\u53d6\u6d88\u5206\u914d\u6216\u8005\u5220\u9664\u4e0b\u7ea7\u7ec4\u7ec7\u8be5\u79d1\u76ee\u3002", (String)"AssignQueryHelper_7", (String)"fi-bd-formplugin", (Object[])new Object[0]), acctNum, subOrgNameStrBuf);
                    tipInfo.append(msg);
                }
                if (tipInfo.length() > 0) {
                    checkResult = false;
                    this.view.showTipNotification(tipInfo.toString());
                    AccountOperationLogUtil.persistLog((String)tipInfo.toString());
                }
            }
        }
        return checkResult;
    }

    private Map<String, Long> buildAcctNumMasterIDMap(Set<Long> accountIds) {
        HashMap<String, Long> acctNumMasterIDMap = new HashMap<String, Long>();
        if (!accountIds.isEmpty()) {
            DynamicObject[] accts;
            QFilter acctIDs = new QFilter("id", "in", accountIds);
            for (DynamicObject acctDyObj : accts = BusinessDataServiceHelper.load((String)"bd_accountview", (String)"id,number,masterid", (QFilter[])new QFilter[]{acctIDs})) {
                acctNumMasterIDMap.put(acctDyObj.getString("number"), acctDyObj.getLong("masterid"));
            }
        }
        return acctNumMasterIDMap;
    }

    private Map<String, HashSet<Long>> buildAcctSubOrgsMap(Map<String, HashSet<Long>> acctOrgMap, Map<Long, HashSet<Long>> orgSubOrgs) {
        HashMap<String, HashSet<Long>> acctSubOrgsMap = new HashMap<String, HashSet<Long>>();
        for (Map.Entry<String, HashSet<Long>> entry : acctOrgMap.entrySet()) {
            String acctNum = entry.getKey();
            HashSet<Long> orgSets = entry.getValue();
            for (Long disOrg : orgSets) {
                Set subOrgs = orgSubOrgs.get(disOrg);
                if (subOrgs == null || subOrgs.isEmpty()) continue;
                acctSubOrgsMap.computeIfAbsent(acctNum, k -> new HashSet()).addAll(subOrgs);
            }
        }
        return acctSubOrgsMap;
    }

    private Map<Long, HashSet<Long>> getOrgSubOrgsMap(Map<Long, HashSet<Long>> orgSubOrgsMap, Set<Long> orgIds, Map<Long, String> orgNameMap) {
        DynamicObject[] selectOrgInfos;
        QFilter f2 = new QFilter("view", "=", (Object)10);
        QFilter f3 = new QFilter("parent", "in", orgIds);
        HashSet<Long> subOrgs = new HashSet<Long>();
        try (DataSet dt = QueryServiceHelper.queryDataSet((String)"getUseregParams", (String)"bos_org_structure", (String)"org,parent,name,fullname", (QFilter[])new QFilter[]{f2, f3}, null);){
            for (Row row : dt) {
                Long orgId = row.getLong("org");
                subOrgs.add(orgId);
                orgSubOrgsMap.computeIfAbsent(row.getLong("parent"), k -> new HashSet()).add(orgId);
            }
        }
        QFilter selectOrgIdFilter = new QFilter("id", "in", subOrgs);
        for (DynamicObject orgDynObj : selectOrgInfos = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{selectOrgIdFilter})) {
            orgNameMap.put(orgDynObj.getLong("id"), orgDynObj.getString("name"));
        }
        return orgSubOrgsMap;
    }

    private Map<String, HashSet<Long>> queryAcctDisRecordInSubOrgs(Set<Long> accountIds, Map<String, HashSet<Long>> acctSubOrgsMap, Map<String, Long> acctMaseterIDMap) {
        HashMap<String, HashSet<Long>> paramsResultMap = new HashMap<String, HashSet<Long>>(8);
        if (accountIds.isEmpty() || acctSubOrgsMap.isEmpty()) {
            return paramsResultMap;
        }
        Long accountTableId = BusinessDataServiceHelper.loadSingle((Object)accountIds.iterator().next(), (String)"bd_accountview").getLong("accounttable_id");
        for (List acctSubOrgsList : Lists.partition(new ArrayList<Map.Entry<String, HashSet<Long>>>(acctSubOrgsMap.entrySet()), (int)100)) {
            SqlBuilder useRegSqlByNumber = new SqlBuilder();
            useRegSqlByNumber.append(" select reg.fdataid fdataid, reg.fuseorgid fuseorgid, acct.fmasterid fmasterid, acct.fnumber ", new Object[0]);
            useRegSqlByNumber.append(" from t_bd_accountusereg reg ", new Object[0]);
            useRegSqlByNumber.append(" left join t_bd_account acct on reg.fdataid = acct.fid ", new Object[0]);
            useRegSqlByNumber.append(" where acct.faccounttableid = ? ", new Object[]{accountTableId});
            useRegSqlByNumber.append("and (", new Object[0]);
            for (int i = 0; i < acctSubOrgsList.size(); ++i) {
                if (i > 0) {
                    useRegSqlByNumber.append(" or ", new Object[0]);
                }
                Map.Entry acountSubOrgsMapEntry = (Map.Entry)acctSubOrgsList.get(i);
                String acountNumber = (String)acountSubOrgsMapEntry.getKey();
                Set orgids = (Set)acountSubOrgsMapEntry.getValue();
                useRegSqlByNumber.append("( acct.fnumber = ? ", new Object[]{acountNumber});
                useRegSqlByNumber.append(" and acct.fmasterid= ? ", new Object[]{acctMaseterIDMap.get(acountNumber)});
                useRegSqlByNumber.appendIn(" and reg.fuseorgid ", new ArrayList(orgids));
                useRegSqlByNumber.append(")", new Object[0]);
            }
            useRegSqlByNumber.append(")", new Object[0]);
            DataSet dataSet = DB.queryDataSet((String)"queryAcctDisRecordInSubOrgs", (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)useRegSqlByNumber);
            Throwable throwable = null;
            try {
                for (Row row : dataSet) {
                    Long fuseorgid = row.getLong("fuseorgid");
                    String fnumber = row.getString("fnumber");
                    paramsResultMap.computeIfAbsent(fnumber, k -> new HashSet()).add(fuseorgid);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataSet == null) continue;
                if (throwable != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dataSet.close();
            }
        }
        return paramsResultMap;
    }
}

