/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.bdctrl;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockInfo;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.assign.OpLogHelper;
import kd.fi.bd.formplugin.bdctrl.AssignQueryHelper;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.DebugTrace;

public class AssignQueryPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log logger = LogFactory.getLog(AssignQueryPlugin.class);
    public static final String PROGRESSBARAP = "progressbarap";
    public static final String baseDataUseRegSuffix = "UseReg";
    public static final String baseDataExcSuffix = "Exc";
    public static final String entityID_org_structure = "bos_org_structure";
    public static final String UNASSIGN_PERM = "80513209000000ac";
    private static final int MAX_ROW = BillParamUtil.getIntegerValue((String)"P9H6JC5EVP1", (String)"fi.bd.account.query.assign.limitsiz", (int)100000);

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnunassign"});
        ProgressBar bar = (ProgressBar)this.getControl(PROGRESSBARAP);
        bar.addProgressListener((ProgresssListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.fillAccount();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (control.getKey().equals("btnunassign")) {
            new AssignQueryHelper(this.getView()).btnUnassign();
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        EntryGrid billList = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = billList.getSelectRows();
        String test = this.getPageCache().get("mark");
        DLockInfo lockInfo = null;
        if (selectRows != null && selectRows.length > 0) {
            ArrayList<Long> ids = new ArrayList<Long>(selectRows.length);
            for (int selectRow : selectRows) {
                ids.add((Long)this.getModel().getValue("dataid", selectRow));
            }
            QFilter idFilters = new QFilter("id", "in", ids);
            DynamicObject accountObj = QueryServiceHelper.queryOne((String)"bd_accountview", (String)"accounttable_id", (QFilter[])idFilters.toArray());
            if (accountObj != null) {
                lockInfo = DLock.getLockInfo((String)("assignlock" + accountObj.getLong("accounttable_id")));
            }
        }
        if (lockInfo == null && "finish".equals(test)) {
            String msg = this.getPageCache().get("msg");
            Set acctCheckErrMsg = new HashSet();
            if (StringUtils.isNotEmpty((CharSequence)msg)) {
                acctCheckErrMsg = (Set)JSONObject.parseObject((String)msg, Set.class);
            }
            String successIds = this.getPageCache().get(this.getView().getPageId() + "success");
            List successPkIds = new ArrayList(10);
            if (StringUtils.isNotBlank((CharSequence)successIds)) {
                successPkIds = (List)JSONObject.parseObject((String)successIds, List.class);
            }
            Map successInfoMap = new HashMap(10);
            String successInfo = this.getPageCache().get(this.getView().getPageId() + "successInfo");
            if (StringUtils.isNotBlank((CharSequence)successInfo)) {
                successInfoMap = (Map)JSONObject.parseObject((String)successInfo, Map.class);
            }
            MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u53d6\u6d88\u5206\u914d\u5b8c\u6210", "CalLogUtils_1", "fi-cal-common");
            if (acctCheckErrMsg.size() > 0) {
                OperationResult r = new OperationResult();
                r.setSuccess(false);
                int billCount = 0;
                if (selectRows != null && selectRows.length > 0) {
                    billCount = selectRows.length;
                }
                r.setBillCount(billCount);
                r.setSuccessPkIds(successPkIds);
                r.setBillNos(successInfoMap);
                ArrayList errInfos = acctCheckErrMsg.stream().map(m -> {
                    OperateErrorInfo e = new OperateErrorInfo("common", ErrorLevel.Error, (Object)"test");
                    e.setMessage(m);
                    return e;
                }).collect(() -> new ArrayList(10), (x, y) -> x.add(y), (l, f) -> l.addAll(f));
                r.setAllErrorInfo((List)errInfos);
                opDescBridge = new MultiLangEnumBridge("\u53d6\u6d88\u5206\u914d\u5b58\u5728\u5931\u8d25", "CalLogUtils_1", "fi-cal-common");
                r.setMessage(opDescBridge.getDescription());
                this.getView().showOperationResult(r);
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"AssignHandle_0", (String)"fi-bd-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            }
            MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u53d6\u6d88\u5206\u914d", "AssignQueryHelper_2", "fi-bd-formplugin");
            new OpLogHelper().addOperateLog(this.getView(), Long.parseLong(this.getView().getFormShowParameter().getCustomParam("useOrgId").toString()), "", "unAssign", opNameBridge, opDescBridge, new String[]{""});
            this.getPageCache().put("mark", "closeview");
            this.getView().getModel().deleteEntryData("entryentity");
            this.reflesh();
        } else if (lockInfo == null && "closeview".equals(test)) {
            ProgressBar bar = (ProgressBar)this.getControl(PROGRESSBARAP);
            bar.setPercent(100);
            bar.stop();
            this.getView().hideLoading();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.reflesh();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue;
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (newValue == (oldValue = changeData[0].getOldValue())) {
            return;
        }
        switch (key) {
            case "accountview": {
                this.reflesh();
            }
        }
    }

    private void reflesh() {
        String assignOrgId = this.getView().getFormShowParameter().getCustomParam("useOrgId").toString();
        Long adminOrg = Long.parseLong(assignOrgId);
        DynamicObjectCollection accountViews = (DynamicObjectCollection)this.getModel().getValue("accountview");
        List accNunbers = accountViews.stream().map(e -> e.getDynamicObject("fbasedataid").getString("number")).collect(Collectors.toList());
        if (accNunbers == null || accNunbers.size() <= 0) {
            accNunbers = (List)this.getView().getFormShowParameter().getCustomParam("accNumbers");
        }
        logger.info(String.format("AssignQueryPlugin,reflesh():ids.size= %d,idStr= %s", accNunbers.size(), accNunbers.stream().collect(Collectors.joining(","))));
        HashSet<Long> oidSet = new HashSet<Long>();
        List<Map<String, String>> result = this.queryAssignRelation(adminOrg, accNunbers, oidSet);
        HashMap<String, String[]> orgNameMap = new HashMap<String, String[]>(16);
        if (oidSet.size() > 0) {
            SqlBuilder orgNameSql = new SqlBuilder();
            orgNameSql.append("select o.fid, ol.fname,o.fnumber from t_org_org_l ol INNER JOIN t_org_org o on o.fid = ol.fid", new Object[0]);
            orgNameSql.append("where ol.flocaleid = ?", new Object[]{this.getLocalLang()});
            orgNameSql.appendIn("and ol.fid", new ArrayList<Long>(oidSet));
            try (DataSet dataSet = DB.queryDataSet((String)"test", (DBRoute)DBRoute.basedata, (SqlBuilder)orgNameSql);){
                for (Row row : dataSet) {
                    orgNameMap.put(row.getString("fid"), new String[]{row.getString("fname"), row.getString("fnumber")});
                }
            }
        }
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        if (result.size() > 0) {
            int index = 0;
            model.batchCreateNewEntryRow("entryentity", result.size() > MAX_ROW ? MAX_ROW : result.size());
            DynamicObjectCollection doc = model.getEntryEntity("entryentity");
            for (Map<String, String> map : result) {
                if (index >= MAX_ROW) break;
                ((DynamicObject)doc.get(index)).set("name", (Object)map.get("name"));
                ((DynamicObject)doc.get(index)).set("number", (Object)map.get("number"));
                String createorgid = map.get("createorgid");
                ((DynamicObject)doc.get(index)).set("createorg", (Object)((String[])orgNameMap.get(createorgid))[0]);
                String adminorgid = map.get("adminorgid");
                ((DynamicObject)doc.get(index)).set("adminorg", (Object)(orgNameMap.get(adminorgid) == null ? "" : ((String[])orgNameMap.get(adminorgid))[0]));
                String useorgid = map.get("useorgid");
                ((DynamicObject)doc.get(index)).set("useorg", (Object)(orgNameMap.get(useorgid) == null ? "" : ((String[])orgNameMap.get(useorgid))[0]));
                ((DynamicObject)doc.get(index)).set("useorgnum", (Object)(orgNameMap.get(useorgid) == null ? "" : ((String[])orgNameMap.get(useorgid))[1]));
                ((DynamicObject)doc.get(index)).set("useorgid", (Object)map.get("useorgid"));
                ((DynamicObject)doc.get(index)).set("dataid", (Object)map.get("dataid"));
                ((DynamicObject)doc.get(index)).set("assignorgid", (Object)map.get("assignorgid"));
                ++index;
            }
            this.getModel().updateEntryCache(doc);
            this.getView().updateView("entryentity");
        }
        if (result.size() >= MAX_ROW) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u91cf\u8d85\u51fa\u9650\u5236\uff0c\u8bf7\u7f29\u5c0f\u67e5\u8be2\u8303\u56f4\u3002", (String)"AssignQueryPlugin_6", (String)"fi-bd-formplugin", (Object[])new Object[0]));
        }
    }

    private List<Map<String, String>> queryAssignRelation(Long adminOrg, List<String> accNumbers, Set<Long> allOrgIds) {
        Map assignRelation;
        String key;
        Throwable throwable;
        DataSet dataSet;
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(MAX_ROW);
        LinkedHashMap<String, Map> assignRelations = new LinkedHashMap<String, Map>(MAX_ROW);
        Long accTableId = (Long)this.getView().getFormShowParameter().getCustomParam("accTableId");
        Set childOrgIds = BDUtil.getAllChildrenOrgIds((long)adminOrg, (boolean)false);
        if (childOrgIds.size() > 0) {
            SqlBuilder queryBySupSql = new SqlBuilder();
            queryBySupSql.append("SELECT top " + (MAX_ROW + 1), new Object[0]);
            queryBySupSql.append("a.fnumber, al.fname, a.fcreateorgid, a.fenddate,", new Object[0]);
            queryBySupSql.append("u.fdataid, u.fuseorgid", new Object[0]);
            queryBySupSql.append("from t_bd_account_u u ", new Object[0]);
            queryBySupSql.append("INNER JOIN t_bd_account a on  a.fid = u.fdataid", new Object[0]);
            queryBySupSql.append("left JOIN t_bd_account_l al on a.fid = al.fid and al.flocaleid = ? ", new Object[]{this.getLocalLang()});
            queryBySupSql.appendIn("where a.fnumber ", new ArrayList<String>(new HashSet<String>(accNumbers)));
            queryBySupSql.append("and a.faccounttableid = ?  ", new Object[]{accTableId});
            queryBySupSql.appendIn("and u.fuseorgid ", new ArrayList(childOrgIds));
            queryBySupSql.append("and a.fenddate = ?  ", new Object[]{AccountVersionUtil.getEndDate()});
            queryBySupSql.append("ORDER BY a.fnumber", new Object[0]);
            if (DebugTrace.enable()) {
                logger.info(String.format("AssignQueryPlugin,reflesh():queryBySupSql= %s", queryBySupSql.toString()));
            }
            dataSet = DB.queryDataSet((String)"queryAssignRelation_queryBySupSql", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)queryBySupSql);
            throwable = null;
            try {
                for (Row row : dataSet) {
                    if (assignRelations.size() > MAX_ROW) {
                        break;
                    }
                    key = row.getString("fnumber") + "-" + row.getString("fuseorgid");
                    assignRelation = assignRelations.computeIfAbsent(key, k -> new LinkedHashMap(16));
                    assignRelation.put("name", row.getString("fname"));
                    assignRelation.put("number", row.getString("fnumber"));
                    assignRelation.put("createorgid", row.getString("fcreateorgid"));
                    assignRelation.put("adminorgid", row.getString("fcreateorgid"));
                    assignRelation.put("useorgid", row.getString("fuseorgid"));
                    assignRelation.put("dataid", row.getString("fdataid"));
                    assignRelation.put("assignorgid", adminOrg.toString());
                    allOrgIds.add(row.getLong("fcreateorgid"));
                    allOrgIds.add(row.getLong("fuseorgid"));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataSet != null) {
                    if (throwable != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        SqlBuilder queryByCreateSql = new SqlBuilder();
        queryByCreateSql.append("SELECT top " + (MAX_ROW + 1), new Object[0]);
        queryByCreateSql.append("a.fnumber, al.fname, a.fcreateorgid, a.fenddate,", new Object[0]);
        queryByCreateSql.append("u.fdataid, u.fuseorgid, u.fadminorgid, u.fassignorgid", new Object[0]);
        queryByCreateSql.append("from t_bd_accountusereg u", new Object[0]);
        queryByCreateSql.append("INNER JOIN t_bd_account a on  a.fid = u.fdataid", new Object[0]);
        queryByCreateSql.append("LEFT JOIN t_bd_account_l al on a.fid = al.fid and al.flocaleid = ?", new Object[]{this.getLocalLang()});
        queryByCreateSql.appendIn("where a.fnumber ", new ArrayList<String>(new HashSet<String>(accNumbers)));
        queryByCreateSql.append("and a.faccounttableid = ?", new Object[]{accTableId});
        queryByCreateSql.append("and a.fcreateorgid = ?", new Object[]{adminOrg});
        queryByCreateSql.append("and u.fuseorgid != ?", new Object[]{adminOrg});
        queryByCreateSql.append("and a.fenddate = ?", new Object[]{AccountVersionUtil.getEndDate()});
        queryByCreateSql.append("ORDER BY a.fnumber", new Object[0]);
        if (DebugTrace.enable()) {
            logger.info(String.format("AssignQueryPlugin,reflesh():queryByCreateSql= %s", queryByCreateSql.toString()));
        }
        dataSet = DB.queryDataSet((String)"queryAssignRelation_queryByCreateSql", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)queryByCreateSql);
        throwable = null;
        try {
            for (Row row : dataSet) {
                if (assignRelations.size() > MAX_ROW) {
                    break;
                }
                key = row.getString("fnumber") + "-" + row.getString("fuseorgid");
                assignRelation = assignRelations.computeIfAbsent(key, k -> new LinkedHashMap(16));
                assignRelation.put("name", row.getString("fname"));
                assignRelation.put("number", row.getString("fnumber"));
                assignRelation.put("createorgid", row.getString("fcreateorgid"));
                assignRelation.put("adminorgid", row.getString("fadminorgid"));
                assignRelation.put("useorgid", row.getString("fuseorgid"));
                assignRelation.put("dataid", row.getString("fdataid"));
                assignRelation.put("assignorgid", adminOrg.toString());
                allOrgIds.add(row.getLong("fcreateorgid"));
                allOrgIds.add(row.getLong("fadminorgid"));
                allOrgIds.add(row.getLong("fuseorgid"));
            }
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            if (dataSet != null) {
                if (throwable != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        result.addAll(assignRelations.values());
        return result;
    }

    private String getLocalLang() {
        Locale locale = RequestContext.get().getLang().getLocale();
        return locale.getLanguage() + "_" + locale.getCountry();
    }

    private void fillAccount() {
        BasedataEdit accountview = (BasedataEdit)this.getControl("accountview");
        accountview.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            List ids = (List)this.getView().getFormShowParameter().getCustomParam("ids");
            Long accTableId = (Long)this.getView().getFormShowParameter().getCustomParam("accTableId");
            QFilter idFilter = new QFilter("id", "in", (Object)ids);
            ArrayList<QFilter> qFilter = new ArrayList<QFilter>(2);
            qFilter.add(idFilter);
            if (accTableId != null && accTableId != 0L) {
                QFilter accTableFilter = new QFilter("accounttable.id", "=", (Object)accTableId);
                qFilter.add(accTableFilter);
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().addAll(qFilter);
        });
    }
}

