/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.bdctrl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockInfo;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.org.model.OrgTreeBuildType;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.bd.assign.OpLogHelper;
import kd.fi.bd.formplugin.bdctrl.AssignQueryHelper;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.BillParamUtil;

public class AssignQueryPluginNew
extends AbstractListPlugin
implements TreeNodeQueryListener,
TreeNodeCheckListener,
SearchEnterListener,
ProgresssListener {
    private static final String PROGRESSBARAP = "progressbarap";
    public static final String TREEVIEW = "treeviewap";
    public static final String entityID_org_structure = "bos_org_structure";
    public static final String baseDataExcSuffix = "Exc";
    private static final String ASIGNEDDATAS = "asignedDatas";
    private static final String ASIGNEDORGS = "asignedOrgs";
    private static final String ALLORGLIST_KEY = "allOrgListKey";
    private static final String CURRENTQUERYRES = "currentQueryResult";
    private static final String ORGNAME = "orgname";
    public static final String UNASSIGN_PERM = "80513209000000ac";
    private static final int MAX_ROW = BillParamUtil.getIntegerValue((String)"P9H6JC5EVP1", (String)"fi.bd.account.query.assign.limitsiz", (int)100000);

    public void initialize() {
        super.initialize();
        TreeView tvLeft = (TreeView)this.getControl(TREEVIEW);
        tvLeft.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        tvLeft.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        this.addClickListeners(new String[]{"btn_query", "btn_assign_cancel"});
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        ProgressBar bar = (ProgressBar)this.getControl(PROGRESSBARAP);
        bar.addProgressListener((ProgresssListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (control.getKey().equals("btn_query")) {
            String filedlistStr = this.getPageCache().get("filedList");
            String filedValue = this.getPageCache().get("searchfiled");
            List filedList = null;
            if (StringUtils.isNotBlank((CharSequence)filedlistStr)) {
                filedList = (List)SerializationUtils.fromJsonString((String)filedlistStr, List.class);
            }
            this.refresh(filedList, filedValue);
        } else if (control.getKey().equals("btn_assign_cancel")) {
            new AssignQueryHelper(this.getView()).btnUnassign();
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        String test = this.getPageCache().get("mark");
        EntryGrid billList = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = billList.getSelectRows();
        DLockInfo lockInfo = null;
        if (selectRows != null && selectRows.length > 0) {
            ArrayList<Long> ids = new ArrayList<Long>(selectRows.length);
            for (int selectRow : selectRows) {
                ids.add((Long)this.getModel().getValue("dataid", selectRow));
            }
            QFilter idFilters = new QFilter("id", "in", ids);
            DynamicObject accountObj = QueryServiceHelper.queryOne((String)"bd_accountview", (String)"accounttable_id", (QFilter[])idFilters.toArray());
            if (accountObj != null) {
                lockInfo = DLock.getLockInfo((String)("assignlock" + accountObj.getLong("accounttable_id")));
            }
        }
        if (lockInfo == null && "finish".equals(test)) {
            String msg = this.getPageCache().get("msg");
            Set acctCheckErrMsg = new HashSet();
            if (StringUtils.isNotEmpty((CharSequence)msg)) {
                acctCheckErrMsg = (Set)JSONObject.parseObject((String)msg, Set.class);
            }
            String successIds = this.getPageCache().get(this.getView().getPageId() + "success");
            List successPkIds = new ArrayList(10);
            if (StringUtils.isNotBlank((CharSequence)successIds)) {
                successPkIds = (List)JSONObject.parseObject((String)successIds, List.class);
            }
            Map successInfoMap = new HashMap(10);
            String successInfo = this.getPageCache().get(this.getView().getPageId() + "successInfo");
            if (StringUtils.isNotBlank((CharSequence)successInfo)) {
                successInfoMap = (Map)JSONObject.parseObject((String)successInfo, Map.class);
            }
            MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u53d6\u6d88\u5206\u914d\u5b8c\u6210", "CalLogUtils_1", "fi-cal-common");
            if (acctCheckErrMsg.size() > 0) {
                OperationResult r = new OperationResult();
                r.setSuccess(false);
                int billCount = 0;
                if (selectRows != null && selectRows.length > 0) {
                    billCount = selectRows.length;
                }
                r.setBillCount(billCount);
                r.setSuccessPkIds(successPkIds);
                r.setBillNos(successInfoMap);
                ArrayList errInfos = acctCheckErrMsg.stream().map(m -> {
                    OperateErrorInfo e = new OperateErrorInfo("common", ErrorLevel.Error, (Object)"test");
                    e.setMessage(m);
                    return e;
                }).collect(() -> new ArrayList(10), (x, y) -> x.add(y), (l, f) -> l.addAll(f));
                r.setAllErrorInfo((List)errInfos);
                opDescBridge = new MultiLangEnumBridge("\u53d6\u6d88\u5206\u914d\u5b58\u5728\u5931\u8d25", "CalLogUtils_1", "fi-cal-common");
                r.setMessage(opDescBridge.getDescription());
                this.getView().showOperationResult(r);
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"AssignHandle_0", (String)"fi-bd-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            }
            MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u53d6\u6d88\u5206\u914d", "AssignQueryHelper_2", "fi-bd-formplugin");
            new OpLogHelper().addOperateLog(this.getView(), Long.parseLong(this.getView().getFormShowParameter().getCustomParam("useOrgId").toString()), "", "unAssign", opNameBridge, opDescBridge, new String[]{""});
            this.getPageCache().put("mark", "closeview");
            this.getView().getModel().deleteEntryData("entryentity");
            String filedlistStr = this.getPageCache().get("filedList");
            String filedValue = this.getPageCache().get("searchfiled");
            List filedList = null;
            if (StringUtils.isNotBlank((CharSequence)filedlistStr)) {
                filedList = (List)SerializationUtils.fromJsonString((String)filedlistStr, List.class);
            }
            this.refresh(filedList, filedValue);
        } else if (lockInfo == null && "closeview".equals(test)) {
            ProgressBar bar = (ProgressBar)this.getControl(PROGRESSBARAP);
            bar.setPercent(100);
            bar.stop();
            this.getView().hideLoading();
        }
    }

    public void afterCreateNewData(EventObject e) {
        HashMap<String, Boolean> treeParams = new HashMap<String, Boolean>();
        treeParams.put("cpn", Boolean.FALSE);
        this.getView().updateControlMetadata(TREEVIEW, treeParams);
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entityNumber");
        DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entityNumber);
        if (null == ctrlview) {
            return;
        }
        List<TreeNode> orgList = this.getAllOrg(ctrlview);
        if (!CollectionUtils.isEmpty(orgList)) {
            this.getView().getPageCache().putBigObject(ALLORGLIST_KEY, SerializationUtils.toJsonString(orgList));
        }
        this.initCUAssignTree((Long)ctrlview.getPkValue());
        this.reloadData();
    }

    private void reloadData() {
        String asignDatasStr = (String)this.getView().getFormShowParameter().getCustomParam(ASIGNEDDATAS);
        String useOrgIdsStrs = (String)this.getView().getFormShowParameter().getCustomParam(ASIGNEDORGS);
        if (StringUtils.isNotEmpty((CharSequence)asignDatasStr) && StringUtils.isNotEmpty((CharSequence)useOrgIdsStrs)) {
            List asignDataIds = (List)SerializationUtils.fromJsonString((String)asignDatasStr, List.class);
            Set useOrgIds = (Set)SerializationUtils.fromJsonString((String)useOrgIdsStrs, Set.class);
            this.queryBillListByMerialIds(asignDataIds, useOrgIds);
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
        String allOrgStr = this.getView().getPageCache().getBigObject(ALLORGLIST_KEY);
        if (null == allOrgStr) {
            return;
        }
        String currentNodeId = treeNodeEvent.getNodeId().toString();
        TreeView tvLeft = (TreeView)this.getControl(TREEVIEW);
        List allNodeList = SerializationUtils.fromJsonStringToList((String)allOrgStr, TreeNode.class);
        for (TreeNode node : allNodeList) {
            String nodeId = node.getId();
            if (!currentNodeId.equals(nodeId)) continue;
            tvLeft.addNodes(node.getChildren());
            break;
        }
    }

    private void initCUAssignTree(Long orgViewId) {
        TreeView tvLeft = (TreeView)this.getControl(TREEVIEW);
        tvLeft.deleteAllNodes();
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewId(orgViewId.longValue());
        TreeNode rootNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        if (rootNode == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u4e1a\u52a1\u5355\u5143\u6839\u7ec4\u7ec7\u5931\u8d25\u3002", (String)"AssignQueryPluginNew_2", (String)"fi-bd-formplugin", (Object[])new Object[0]));
        }
        tvLeft.addNode(rootNode);
        tvLeft.queryTreeNodeChildren("", rootNode.getId());
    }

    private void refresh(List<String> filedList, String filedValue) {
        String entity = (String)this.getView().getFormShowParameter().getCustomParam("entityNumber");
        String lang = RequestContext.get().getLang().getLocale().getLanguage() + "_" + RequestContext.get().getLang().getLocale().getCountry();
        SqlBuilder sql = this.makeSQLBySearchText(entity, lang, filedList, filedValue);
        HashSet<String> oidSet = new HashSet<String>();
        Map<String, Map<String, String>> result = this.queryDB(sql, entity, oidSet);
        Map<String, String> orgNameMap = this.getOrgNameByOrgId(oidSet);
        this.makeBillList(result, orgNameMap);
        if (result.size() >= MAX_ROW) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u91cf\u8d85\u51fa\u9650\u5236\uff0c\u8bf7\u7f29\u5c0f\u67e5\u8be2\u8303\u56f4\u3002", (String)"AssignQueryPlugin_6", (String)"fi-bd-formplugin", (Object[])new Object[0]));
        }
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        List searchFields = searchEnterEvent.getSearchFields();
        if (searchFields == null) {
            this.getPageCache().put("filedList", null);
            this.getPageCache().put("searchfiled", null);
            this.refresh(null, null);
        } else {
            List filedList = (List)((Map)searchFields.get(0)).get("fieldName");
            List text = (List)((Map)searchFields.get(0)).get("value");
            String filelistStr = SerializationUtils.toJsonString((Object)filedList);
            this.getPageCache().put("filedList", filelistStr);
            this.getPageCache().put("searchfiled", (String)text.get(0));
            this.refresh(filedList, (String)text.get(0));
        }
    }

    private SqlBuilder makeSQLBySearchText(String entity, String lang, List<String> filedList, String filedValue) {
        String primaryKey = ORM.create().getDataEntityType(entity).getPrimaryKey().getAlias();
        TreeView treeView = (TreeView)this.getView().getControl(TREEVIEW);
        List orgIDs = treeView.getTreeState().getCheckedNodeIds();
        HashSet uOrgIds = Sets.newHashSetWithExpectedSize((int)orgIDs.size());
        for (String id : orgIDs) {
            uOrgIds.add(Long.parseLong(id));
        }
        if (orgIDs.size() == 0) {
            uOrgIds.add(0L);
        }
        long accTableId = Long.parseLong(this.getView().getFormShowParameter().getCustomParam("accTableId").toString());
        SqlBuilder sb = new SqlBuilder();
        sb.append(" SELECT top " + (MAX_ROW + 1) + " m.fnumber mfnumber, ml.fname mlfname, mu.fdataid fdataid, m.fcreateorgid coid, mu.fuseorgid uoid, mu.fadminorgid aoid, mu.fassignorgid assignorgid ", new Object[0]);
        sb.append(" from t_bd_accountusereg mu ", new Object[0]);
        sb.append(" INNER JOIN t_bd_account m on  m.", new Object[0]).append(primaryKey, new Object[0]).append(" = mu.fdataid", new Object[0]);
        sb.append(" INNER JOIN t_bd_account_l ml on m.", new Object[0]).append(primaryKey, new Object[0]).append(" = ml.", new Object[0]).append(primaryKey, new Object[0]);
        sb.append(" and ml.flocaleid = ? ", new Object[]{lang});
        sb.appendIn(" where mu.fuseorgid ", new ArrayList(uOrgIds));
        sb.append("and mu.fisassign = '1'  ", new Object[0]);
        sb.append(" and m.faccounttableid = ?", new Object[]{accTableId});
        sb.append(" and m.fenddate = ?  ", new Object[]{AccountVersionUtil.getEndDate()});
        String searchFilter = this.getSearchFilter(filedList, filedValue);
        if (StringUtils.isNotBlank((CharSequence)searchFilter)) {
            sb.append(searchFilter, new Object[0]);
        }
        sb.append(" ORDER BY m.fnumber", new Object[0]);
        return sb;
    }

    private String getSearchFilter(List<String> filedList, String filedValue) {
        StringBuilder sb = new StringBuilder();
        if (filedList != null && filedValue != null) {
            String[] values = filedValue.split("\\s+");
            filedValue = this.convertToStringParam(values);
            for (int i = 0; i < filedList.size(); ++i) {
                String filed = filedList.get(i);
                String filedStr = " m.fnumber ";
                if ("name".equals(filed)) {
                    filedStr = " ml.fname ";
                }
                String operator = " and ";
                if (i > 0) {
                    operator = " or ";
                }
                sb.append(operator);
                if (i == 0) {
                    sb.append("(");
                }
                sb.append(filedStr).append("in(").append(filedValue).append(") ");
            }
            sb.append(')');
        }
        return sb.toString();
    }

    private String convertToStringParam(String[] values) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            result.append("'").append(values[i]).append("'");
            if (i + 1 == values.length) continue;
            result.append(',');
        }
        if (result.length() == 0) {
            return "''";
        }
        return result.toString();
    }

    private Map<String, Map<String, String>> queryDB(SqlBuilder sql, String entity, final Set<String> oidSet) {
        String dbRouteKey = ORM.create().getDataEntityType(entity).getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        Map result = (Map)DB.query((DBRoute)dbRoute, (SqlBuilder)sql, (ResultSetHandler)new ResultSetHandler<Map<String, Map<String, String>>>(){

            public Map<String, Map<String, String>> handle(ResultSet rs) throws Exception {
                LinkedHashMap<String, Map<String, String>> dataMap = new LinkedHashMap<String, Map<String, String>>(16);
                while (rs.next()) {
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    map.put("name", rs.getString("mlfname"));
                    map.put("number", rs.getString("mfnumber"));
                    oidSet.add(rs.getString("coid"));
                    oidSet.add(rs.getString("aoid"));
                    oidSet.add(rs.getString("uoid"));
                    map.put("assignorgid", rs.getString("assignorgid"));
                    map.put("createorgid", rs.getString("coid"));
                    map.put("adminorgid", rs.getString("aoid"));
                    map.put("useorgid", rs.getString("uoid"));
                    map.put("dataid", rs.getString("fdataid"));
                    dataMap.put(rs.getString("mfnumber") + rs.getString("uoid"), map);
                }
                return dataMap;
            }
        });
        String jsonString = SerializationUtils.toJsonString((Object)result);
        this.getPageCache().put(CURRENTQUERYRES, jsonString);
        return result;
    }

    private Map<String, String> getOrgNameByOrgId(Set<String> oidSet) {
        HashMap<String, String> orgNameMap = new HashMap<String, String>();
        if (oidSet != null && oidSet.size() > 0) {
            QFilter filter = new QFilter("id", "in", (Object)BDUtil.groupTransferStr2Long(oidSet, new LinkedList()));
            QFilter[] filters = new QFilter[]{filter};
            Map dynamicObjects = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id,name", (QFilter[])filters);
            for (DynamicObject org : dynamicObjects.values()) {
                String id = org.getString("id");
                String name = org.getString("name");
                orgNameMap.put(id, name);
            }
        }
        String jsonString = SerializationUtils.toJsonString(orgNameMap);
        this.getPageCache().put(ORGNAME, jsonString);
        return orgNameMap;
    }

    private void makeBillList(Map<String, Map<String, String>> result, Map<String, String> orgNameMap) {
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        if (result.size() > 0) {
            int index = 0;
            model.batchCreateNewEntryRow("entryentity", result.size());
            DynamicObjectCollection doc = model.getEntryEntity("entryentity");
            for (Map.Entry<String, Map<String, String>> entry : result.entrySet()) {
                Map<String, String> map = entry.getValue();
                ((DynamicObject)doc.get(index)).set("name", (Object)map.get("name"));
                ((DynamicObject)doc.get(index)).set("number", (Object)map.get("number"));
                ((DynamicObject)doc.get(index)).set("assignorgid", (Object)map.get("assignorgid"));
                ((DynamicObject)doc.get(index)).set("createorg", (Object)orgNameMap.get(map.get("createorgid")));
                ((DynamicObject)doc.get(index)).set("adminorg", (Object)orgNameMap.get(map.get("adminorgid")));
                ((DynamicObject)doc.get(index)).set("useorg", (Object)orgNameMap.get(map.get("useorgid")));
                ((DynamicObject)doc.get(index)).set("useorgid", (Object)map.get("useorgid"));
                ((DynamicObject)doc.get(index)).set("dataid", (Object)map.get("dataid"));
                ++index;
            }
            this.getModel().updateEntryCache(doc);
            this.getView().updateView("entryentity");
        }
    }

    public void queryBillListByMerialIds(List<Long> asignDataIds, Set<String> orgIds) {
        String entity = (String)this.getView().getFormShowParameter().getCustomParam("entityNumber");
        String lang = RequestContext.get().getLang().getLocale().getLanguage() + "_" + RequestContext.get().getLang().getLocale().getCountry();
        SqlBuilder sql = this.makeSQL(entity, lang, asignDataIds, orgIds);
        HashSet<String> oidSet = new HashSet<String>();
        Map<String, Map<String, String>> result = this.queryDB(sql, entity, oidSet);
        Map<String, String> orgNameMap = this.getOrgNameByOrgId(oidSet);
        this.makeBillList(result, orgNameMap);
    }

    private SqlBuilder makeSQL(String entity, String lang, List<Long> asignDataIds, Set<String> useOrgIds) {
        String primaryKey = ORM.create().getDataEntityType(entity).getPrimaryKey().getAlias();
        HashSet uOrgIds = Sets.newHashSetWithExpectedSize((int)useOrgIds.size());
        for (String id : useOrgIds) {
            uOrgIds.add(Long.parseLong(id));
        }
        SqlBuilder sb = new SqlBuilder();
        sb.append(" SELECT m.fnumber mfnumber, ml.fname mlfname, mu.fdataid fdataid, m.fcreateorgid coid, mu.fuseorgid uoid, mu.fadminorgid aoid, mu.fassignorgid assignorgid", new Object[0]);
        sb.append(" from t_bd_accountusereg mu ", new Object[0]);
        sb.append(" INNER JOIN t_bd_account m on  m.", new Object[0]).append(primaryKey, new Object[0]).append(" = mu.fdataid", new Object[0]);
        sb.append(" INNER JOIN t_bd_account_l ml on m.", new Object[0]).append(primaryKey, new Object[0]).append(" = ml.", new Object[0]).append(primaryKey, new Object[0]);
        sb.append(" and ml.flocaleid = ? ", new Object[]{lang});
        sb.appendIn(" where mu.fuseorgid ", new ArrayList(uOrgIds));
        sb.appendIn(" and mu.fdataid ", new ArrayList<Long>(new HashSet<Long>(asignDataIds)));
        sb.append(" and m.fenddate = ?  ", new Object[]{AccountVersionUtil.getEndDate()});
        sb.append(" ORDER BY m.fnumber", new Object[0]);
        return sb;
    }

    public void treeNodeCheck(TreeNodeCheckEvent event) {
        List nodeList;
        String allOrgStr = this.getView().getPageCache().getBigObject(ALLORGLIST_KEY);
        if (StringUtils.isEmpty((CharSequence)allOrgStr)) {
            return;
        }
        String checkedNodeId = event.getNodeId().toString();
        TreeNode node = this.getTreeNode(checkedNodeId, nodeList = SerializationUtils.fromJsonStringToList((String)allOrgStr, TreeNode.class));
        if (null == node) {
            return;
        }
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(16);
        nodes.add(node);
        if (((Boolean)this.getModel().getValue("chkincludechild")).booleanValue()) {
            this.getChildrenNodeList(node, nodes);
        }
        TreeView tvLeft = (TreeView)this.getControl(TREEVIEW);
        if (event.getChecked().booleanValue()) {
            tvLeft.checkNodes(nodes);
            return;
        }
        ArrayList uncheckNodeIds = new ArrayList(nodes.size());
        nodes.forEach(unCheckNode -> uncheckNodeIds.add(unCheckNode.getId()));
        tvLeft.uncheckNodes(uncheckNodeIds);
    }

    private List<TreeNode> getAllOrg(DynamicObject ctrlView) {
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewNumber(String.valueOf(ctrlView.get("number")));
        param.setTreeBuildType(OrgTreeBuildType.FILL_HIDDEN_PARENT_ALL);
        TreeNode rootNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        List allChildOrgNodeList = OrgUnitServiceHelper.getTreeChildren((OrgTreeParam)param);
        if (null == rootNode) {
            return Collections.emptyList();
        }
        SqlBuilder builder = new SqlBuilder();
        builder.append("select forgid from t_org_structure where fisctrlunit = '1' and fviewid = ?;", new Object[]{ctrlView.getPkValue()});
        Set allCtrlUintOrgIds = (Set)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)builder, rs -> {
            HashSet<String> result = new HashSet<String>(16);
            while (rs.next()) {
                result.add(rs.getString("forgid"));
            }
            return result;
        });
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(allChildOrgNodeList.size());
        ArrayList<TreeNode> rootNodeChildList = new ArrayList<TreeNode>(allChildOrgNodeList.size());
        if (allCtrlUintOrgIds.contains(rootNode.getId())) {
            rootNode.setChildren(rootNodeChildList);
            nodeList.add(rootNode);
        }
        if (CollectionUtils.isEmpty((Collection)allChildOrgNodeList)) {
            return nodeList;
        }
        ArrayList<TreeNode> cuOrgChildNodeList = new ArrayList<TreeNode>(allChildOrgNodeList.size());
        for (TreeNode node : allChildOrgNodeList) {
            if (!allCtrlUintOrgIds.contains(node.getId())) continue;
            List children = node.getChildren();
            if (!CollectionUtils.isEmpty((Collection)children)) {
                ArrayList<TreeNode> tempChildOrgList = new ArrayList<TreeNode>(children.size());
                for (TreeNode childrenNode : children) {
                    if (!allCtrlUintOrgIds.contains(childrenNode.getId())) continue;
                    tempChildOrgList.add(childrenNode);
                }
                if (tempChildOrgList.size() > 0) {
                    node.setChildren(tempChildOrgList);
                } else {
                    node.setChildren(null);
                }
            }
            if (node.getParentid().equals(rootNode.getId())) {
                rootNodeChildList.add(node);
            }
            nodeList.add(node);
            cuOrgChildNodeList.add(node);
        }
        this.getChildNode(cuOrgChildNodeList, nodeList, allCtrlUintOrgIds);
        return nodeList;
    }

    private void getChildNode(List<TreeNode> orgChildrenTreeData, List<TreeNode> allOrgs, Set<String> allCtrlUintOrgIds) {
        for (TreeNode node : orgChildrenTreeData) {
            List childNode = node.getChildren();
            if (null == childNode || childNode.isEmpty()) continue;
            ArrayList<TreeNode> tempChildOrgs = new ArrayList<TreeNode>(node.getChildren().size());
            for (TreeNode childrenNode : node.getChildren()) {
                if (!allCtrlUintOrgIds.contains(childrenNode.getId())) continue;
                allOrgs.add(childrenNode);
                tempChildOrgs.add(childrenNode);
            }
            if (tempChildOrgs.size() > 0) {
                node.setChildren(tempChildOrgs);
            } else {
                node.setChildren(null);
            }
            this.getChildNode(childNode, allOrgs, allCtrlUintOrgIds);
        }
    }

    private TreeNode getTreeNode(String checkedNodeId, List<TreeNode> nodeList) {
        for (TreeNode node : nodeList) {
            String nodeId = node.getId();
            if (!checkedNodeId.equals(nodeId)) continue;
            return node;
        }
        return null;
    }

    private void getChildrenNodeList(TreeNode node, List<TreeNode> list) {
        List children = node.getChildren();
        if (CollectionUtils.isEmpty((Collection)children)) {
            return;
        }
        list.addAll(children);
        children.forEach(child -> this.getChildrenNodeList((TreeNode)child, list));
    }
}

