/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.bdctrl;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;

public class AssignTreePlugin
extends AbstractTreeListPlugin {
    private static Log logger = LogFactory.getLog(AbstractTreeListPlugin.class);
    private static final String TREEVIEW = "treeviewap";
    private static final String checkedNodes = "checkedNodes";
    private static final String ISCTRlUNIT = "1";

    public void afterCreateNewData(EventObject eventObject) {
        Object useOrgId = this.getView().getFormShowParameter().getCustomParam("useOrgId");
        if (!(useOrgId instanceof Integer) && !(useOrgId instanceof Long)) {
            logger.error("############\u52a0\u8f7d\u7ec4\u7ec7ID\u5f02\u5e38");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u52a0\u8f7d\u7ec4\u7ec7ID\u5f02\u5e38", (String)"AssignTreePlugin_0", (String)"bos-form-business", (Object[])new Object[0]));
        }
    }

    private Long getUseOrgId() {
        Long useOrgId = 0L;
        if (this.getView().getFormShowParameter().getCustomParam("useOrgId") instanceof Integer) {
            useOrgId = ((Integer)this.getView().getFormShowParameter().getCustomParam("useOrgId")).longValue();
        } else if (this.getView().getFormShowParameter().getCustomParam("useOrgId") instanceof Long) {
            useOrgId = (Long)this.getView().getFormShowParameter().getCustomParam("useOrgId");
        } else {
            logger.error("############\u52a0\u8f7d\u7ec4\u7ec7ID\u5f02\u5e38");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u52a0\u8f7d\u7ec4\u7ec7ID\u5f02\u5e38", (String)"AssignTreePlugin_0", (String)"bos-form-business", (Object[])new Object[0]));
        }
        return useOrgId;
    }

    public void registerListener(EventObject e) {
        Search search_tree = (Search)this.getControl("searchap_tree");
        search_tree.addEnterListener((SearchEnterListener)this);
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String searchText = searchEnterEvent.getText();
        TreeView treeView = (TreeView)this.getView().getControl(TREEVIEW);
        if (!StringUtils.isBlank((CharSequence)searchText)) {
            String checkedNodesStr = this.getPageCache().get(this.getView().getPageId() + checkedNodes);
            if (StringUtils.isNotEmpty((CharSequence)checkedNodesStr)) {
                ArrayList<String> nodeIds = new ArrayList<String>(8);
                List nodes = SerializationUtils.fromJsonStringToList((String)checkedNodesStr, TreeNode.class);
                for (TreeNode node : nodes) {
                    nodeIds.add(node.getId());
                }
                treeView.uncheckNodes(nodeIds);
            }
            List checkNodes = treeView.getTreeState().getCheckedNodeIds();
            treeView.uncheckNodes(checkNodes);
            this.checkTreeNodes(searchText, treeView);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u67e5\u8be2\u5173\u952e\u5b57\u3002", (String)"AssignTreePlugin_1", (String)"bos-form-business", (Object[])new Object[0]));
        }
    }

    private void recursive(TreeNode treeNode, List<TreeNode> pTreeNodes) {
        if (StringUtils.isNotEmpty((CharSequence)treeNode.getParentid())) {
            List<TreeNode> pSearchTreeNodes = new ArrayList<TreeNode>(10);
            pSearchTreeNodes = this.searchTreeNodeById(treeNode.getParentid(), pSearchTreeNodes);
            if (null != pSearchTreeNodes && pSearchTreeNodes.size() > 0) {
                pTreeNodes.add(pSearchTreeNodes.get(0));
                this.recursive(pSearchTreeNodes.get(0), pTreeNodes);
            }
        }
    }

    private void checkTreeNodes(String searchText, TreeView treeView) {
        List<TreeNode> treeNodes = this.searchTreeNode(searchText);
        if (!CollectionUtils.isEmpty(treeNodes)) {
            treeView.focusNode(treeNodes.get(0));
            for (TreeNode node : treeNodes) {
                String nodeId = node.getId();
                treeView.queryTreeNodeChildren("", node.getId());
                treeView.expand(nodeId);
                treeView.checkNode(node);
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"AssignTreePlugin_2", (String)"bos-form-business", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put(this.getView().getPageId() + checkedNodes, SerializationUtils.toJsonString(treeNodes));
    }

    private List<TreeNode> searchTreeNode(String searchText) {
        Long orgId = this.getUseOrgId();
        ArrayList<TreeNode> resultTreeNodes = new ArrayList<TreeNode>(10);
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entityNumber");
        DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entityNumber);
        Long ctrlViewId = (Long)ctrlview.getPkValue();
        List subOrgIds = OrgServiceHelper.getAllSubordinateOrgs((String)ctrlViewId.toString(), Collections.singletonList(orgId), (boolean)true);
        SqlBuilder newBf = new SqlBuilder();
        newBf.append(" SELECT o.fid,t.forgid,t.fparentid,o.fnumber,o.fname from t_org_structure t ", new Object[0]);
        newBf.append(" left join T_ORG_ORG o on t.forgid=o.fid where t.FVIEWID = ? ", new Object[]{ctrlViewId});
        newBf.append(" and t.fisctrlunit = ? ", new Object[]{ISCTRlUNIT});
        newBf.appendIn(" and t.forgid ", new ArrayList(subOrgIds));
        newBf.append(" order by t.flevel,o.fid asc", new Object[0]);
        HashMap<Long, TreeNode> treeNodeIndexMap = new HashMap<Long, TreeNode>(8);
        HashSet<Long> matchedNodeIdSet = new HashSet<Long>(8);
        try (DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.basedata, (SqlBuilder)newBf);){
            for (Row row : dataSet) {
                Long nodeId = row.getLong("fid");
                String name = row.getString("fname");
                String number = row.getString("fnumber");
                TreeNode currNode = new TreeNode(row.getString("fparentid"), nodeId.toString(), name);
                treeNodeIndexMap.put(nodeId, currNode);
                if (!name.contains(searchText) && !number.contains(searchText)) continue;
                matchedNodeIdSet.add(nodeId);
                Long parentId = row.getLong("fparentid");
                resultTreeNodes.add(currNode);
                this.checkParentNode(orgId, resultTreeNodes, treeNodeIndexMap, matchedNodeIdSet, nodeId, parentId);
            }
        }
        return resultTreeNodes;
    }

    private void checkParentNode(Long orgId, List<TreeNode> resultTreeNodes, Map<Long, TreeNode> treeNodeIndexMap, Set<Long> matchedNodeIdSet, Long nodeId, Long parentId) {
        if (!nodeId.equals(orgId) && matchedNodeIdSet.add(parentId)) {
            TreeNode parentNode = treeNodeIndexMap.get(parentId);
            if (null == parentNode) {
                return;
            }
            Long pPNodeId = Long.parseLong(parentNode.getParentid());
            resultTreeNodes.add(parentNode);
            this.checkParentNode(orgId, resultTreeNodes, treeNodeIndexMap, matchedNodeIdSet, parentId, pPNodeId);
        }
    }

    private List<TreeNode> searchTreeNodeById(String searchId, List<TreeNode> treeNodes) {
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entityNumber");
        DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entityNumber);
        Long ctrlViewId = (Long)ctrlview.getPkValue();
        StringBuilder bf = new StringBuilder();
        bf.append("SELECT o.fid,o.fname,t.fparentid,t.fviewid from t_org_structure t ");
        bf.append("left join T_ORG_ORG o on t.forgid=o.fid where t.FVIEWID = ? and o.fid = ?");
        bf.append(" and t.fisctrlunit = ?");
        Object[] params = null;
        params = new SqlParameter[]{new SqlParameter(":fviewid", -5, (Object)ctrlViewId), new SqlParameter(":fid", -5, (Object)Long.valueOf(searchId)), new SqlParameter(":fisctrlunit", 12, (Object)ISCTRlUNIT)};
        bf.append(" order by o.fid asc");
        String sql = bf.toString();
        treeNodes = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<TreeNode>>(){

            public List<TreeNode> handle(ResultSet rs) throws Exception {
                ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(8);
                while (rs.next()) {
                    String id = rs.getString(1);
                    String name = rs.getString(2);
                    String parentid = rs.getString(3);
                    TreeNode treeNode = new TreeNode(parentid, id, name);
                    treeNodes.add(treeNode);
                }
                return treeNodes;
            }
        });
        return treeNodes;
    }
}

