/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.bdctrl;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class AssignTreeQueryPlugin
extends AbstractTreeListPlugin {
    private static final String TREEVIEW = "treeviewap";
    private static final String checkedNodes = "checkedNodes";

    public void registerListener(EventObject e) {
        Search search_tree = (Search)this.getControl("searchap_tree");
        search_tree.addEnterListener((SearchEnterListener)this);
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String searchText = searchEnterEvent.getText();
        TreeView treeView = (TreeView)this.getView().getControl(TREEVIEW);
        if (!StringUtils.isBlank((CharSequence)searchText)) {
            String checkedNodesStr = this.getPageCache().get(this.getView().getPageId() + checkedNodes);
            if (StringUtils.isNotEmpty((CharSequence)checkedNodesStr)) {
                ArrayList<String> nodeIds = new ArrayList<String>(8);
                List nodes = SerializationUtils.fromJsonStringToList((String)checkedNodesStr, TreeNode.class);
                for (TreeNode node : nodes) {
                    nodeIds.add(node.getId());
                }
                treeView.uncheckNodes(nodeIds);
            }
            this.checkTreeNodes(searchText, treeView);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u67e5\u8be2\u5173\u952e\u5b57\u3002", (String)"AssignTreeQueryPlugin_0", (String)"bos-form-business", (Object[])new Object[0]));
        }
    }

    private void checkTreeNodes(String searchText, TreeView treeView) {
        List<TreeNode> treeNodes = new ArrayList<TreeNode>();
        if ((treeNodes = this.searchTreeNode(searchText, treeNodes)).size() > 0) {
            treeView.focusNode(treeNodes.get(0));
            for (TreeNode node : treeNodes) {
                String parentId = node.getParentid();
                String nodeId = node.getId();
                treeView.queryTreeNodeChildren(parentId, nodeId);
                treeView.expand(nodeId);
                treeView.checkNode(node);
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"AssignTreeQueryPlugin_1", (String)"bos-form-business", (Object[])new Object[0]));
        }
        this.getPageCache().put(this.getView().getPageId() + checkedNodes, SerializationUtils.toJsonString(treeNodes));
    }

    private List<TreeNode> searchTreeNode(String searchText, List<TreeNode> treeNodes) {
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entityNumber");
        DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entityNumber);
        Long ctrlViewId = (Long)ctrlview.getPkValue();
        StringBuilder bf = new StringBuilder();
        bf.append("SELECT o.fid,o.fname,t.fparentid,t.fviewid from t_org_structure t ");
        bf.append("left join T_ORG_ORG o ");
        bf.append("on t.forgid=o.fid ");
        bf.append("where t.FVIEWID = ? and o.fname like ? order by o.fid asc");
        String sql = bf.toString();
        Object[] params = new SqlParameter[]{new SqlParameter(":fviewid", -5, (Object)ctrlViewId), new SqlParameter(":fname", 12, (Object)("%" + searchText + "%"))};
        treeNodes = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<TreeNode>>(){

            public List<TreeNode> handle(ResultSet rs) throws Exception {
                ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(8);
                while (rs.next()) {
                    String id = rs.getString(1);
                    String name = rs.getString(2);
                    String parentid = rs.getString(3);
                    TreeNode treeNode = new TreeNode(parentid, id, name);
                    treeNodes.add(treeNode);
                }
                return treeNodes;
            }
        });
        return treeNodes;
    }
}

