/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.bdctrl.asstctl;

import java.util.EventObject;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.checktools.account.check.AccountCheckType;
import kd.fi.bd.checktools.account.check.CheckHandle;
import kd.fi.bd.checktools.account.check.ControlCheckCtx;
import kd.fi.bd.util.BillParamUtil;

public class AccountAssistVersionControlCheckerPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log logger = LogFactory.getLog(AccountAssistVersionControlCheckerPlugin.class);
    private static final DBRoute DB_ROUTE = DBRoute.of((String)"gl");
    private static final String CACHEKEY_ACCOUNTTABLEID = "accTableId";
    private static final String PROGRESSBARAP = "progressbarap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        ProgressBar bar = (ProgressBar)this.getControl(PROGRESSBARAP);
        bar.addProgressListener((ProgresssListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "checkbytable": {
                this.checkbytable(AccountCheckType.ALL);
                break;
            }
            case "asst": {
                this.checkbytable(AccountCheckType.ASST);
                break;
            }
            case "higher_and_lower_isleaf": {
                this.checkbytable(AccountCheckType.HIGHER_AND_LOWER_ISLEAF);
                break;
            }
            case "long_number_name": {
                this.checkbytable(AccountCheckType.LONG_NUMBER_NAME);
                break;
            }
            case "repeat": {
                this.checkbytable(AccountCheckType.REPEAT);
                break;
            }
            case "defect_rel": {
                this.checkbytable(AccountCheckType.DEFECT_REL);
                break;
            }
            case "biz_check": {
                this.checkbytable(AccountCheckType.BIZ_CHECK);
                break;
            }
            case "version_date": {
                this.checkbytable(AccountCheckType.VERSION_DATE);
                break;
            }
            case "all": {
                this.checkbytable(AccountCheckType.ALL);
                break;
            }
            case "check_prop": {
                this.checkbytable(AccountCheckType.CHECK_PROP);
            }
            case "check_firstlevel_account": {
                this.checkbytable(AccountCheckType.CHECK_FIRST_LEVEL_ACC);
                break;
            }
            case "check_journal": {
                this.checkbytable(AccountCheckType.CHECK_JOURNAL);
                break;
            }
            case "check_userange_exc": {
                this.checkbytable(AccountCheckType.CHECK_USERANGE_EXC);
                break;
            }
            case "asst_repeat": {
                this.checkbytable(AccountCheckType.ASST_REPEAT);
                break;
            }
            case "checkassignrelationship": {
                this.checkbytable(AccountCheckType.CHECK_ASSIGN);
                break;
            }
            case "checkusedata": {
                this.checkbytable(AccountCheckType.CHECK_USE_EXC);
            }
        }
    }

    private void checkbytable(AccountCheckType checkType) {
        Object accounttable = this.getModel().getValue("accounttable");
        if (accounttable == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u68c0\u67e5\u7684\u79d1\u76ee\u8868\u3002", (String)"AccountAssistVersionControlCheckerPlugin_0", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            return;
        }
        logger.info("check_begin:" + accounttable);
        this.getPageCache().put("mark", "start");
        ((ProgressBar)this.getControl(PROGRESSBARAP)).start();
        this.getPageCache().put("percent", "0");
        this.showLoading();
        Long tableId = ((DynamicObject)accounttable).getLong("id");
        this.getPageCache().put(CACHEKEY_ACCOUNTTABLEID, Long.toString(tableId));
        this.checkbytable(tableId, checkType);
    }

    private void checkbytable(Long tableId, AccountCheckType checkType) {
        Boolean checkedToRepair = BillParamUtil.getBooleanValue((String)"P9H6JC5EVP1", (String)"fi.bd.account.acccheck", (boolean)false);
        this.getView().getPageCache().put(this.getView().getPageId(), checkedToRepair.toString());
        Set selectedOrgs = null;
        if (checkedToRepair.booleanValue()) {
            Object orgs = this.getModel().getValue("orgs");
            if (Objects.isNull(orgs)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u68c0\u67e5\u7684\u7ec4\u7ec7", (String)"AccountAssistVersionControlCheckerPlugin_2", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            }
            DynamicObjectCollection orgCollection = (DynamicObjectCollection)orgs;
            selectedOrgs = orgCollection.stream().map(x -> x.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
        }
        this.getPageCache().put("showLoadingMsg", null);
        ControlCheckCtx ctx = new ControlCheckCtx(this.getView(), tableId, checkType, selectedOrgs);
        ThreadService.execute(() -> new CheckHandle(ctx).handle(), (TaskType)TaskType.FIBD_ACCOUNT_ASSIST_VERSION_CONTROL_CHECK_ASYNC);
    }

    public void onProgress(ProgressEvent progressEvent) {
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select forgid,forgname,faccountnumber,fresult,fdesc,ftype from t_bd_accountcheckrs ", new Object[0]);
        try (DataSet dataSet = DB.queryDataSet((String)"AccountAssistVersionControlCheckerPlugin", (DBRoute)DB_ROUTE, (SqlBuilder)sb);){
            for (Row row : dataSet) {
                int rowIndex = model.createNewEntryRow("entryentity");
                model.setValue("orgid", (Object)row.getLong("forgid"), rowIndex);
                model.setValue("orgname", (Object)row.getString("forgname"), rowIndex);
                model.setValue("accountnumber", (Object)row.getString("faccountnumber"), rowIndex);
                model.setValue("result", (Object)row.getString("fresult"), rowIndex);
                model.setValue("desc", (Object)row.getString("fdesc"), rowIndex);
                model.setValue("type", (Object)row.getString("ftype"), rowIndex);
            }
        }
        String progress = this.getPageCache().get("mark");
        if ("finish".equals(progress)) {
            String acctCheckErrMsg = this.getPageCache().get("msg");
            if (StringUtils.isNotEmpty((CharSequence)acctCheckErrMsg)) {
                this.getView().showErrorNotification(acctCheckErrMsg);
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"AccountAssistVersionControlCheckerPlugin_1", (String)"fi-bd-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            }
            ProgressBar bar = (ProgressBar)this.getControl(PROGRESSBARAP);
            bar.setPercent(100);
            bar.stop();
            this.getView().hideLoading();
        } else {
            String results = this.getView().getPageCache().get("results");
            if (results == null) {
                this.showLoading();
                return;
            }
        }
    }

    private void showLoading() {
        this.getView().showLoading(new LocaleString(this.getPageCache().get("showLoadingMsg")));
    }
}

