/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.billparam;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.util.StringUtils;
import kd.fi.bd.formplugin.billparam.FaBillParamTypeListPlugin;
import kd.fi.fa.enums.BillParamValueTypeEnum;

public class FaBillParamListPlugin
extends FaBillParamTypeListPlugin {
    private static final String BTN_BILLPARAMTYPE = "billparamtype";

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
    }

    @Override
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.setOrderBy("createdate desc");
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ChangeBillListDataProvider());
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (BTN_BILLPARAMTYPE.equals(key)) {
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId("fa_billparam_type");
            parameter.setFormId("bos_list");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setCustomParam("bizcloud", (Object)this.getPageCache().get("query_bizcloud_id"));
            parameter.setCustomParam("bizapp", (Object)this.getPageCache().get("query_bizapp_id"));
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private static class ChangeBillListDataProvider
    extends ListDataProvider {
        private ChangeBillListDataProvider() {
        }

        public void setListFields(List<ListField> listFields) {
            ListField paramTypeField = new ListField("paramtype");
            paramTypeField.setFieldName("paramtype");
            listFields.add(paramTypeField);
            super.setListFields(listFields);
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection rows = super.getData(start, limit);
            for (DynamicObject row : rows) {
                String value;
                DynamicObject paramType = row.getDynamicObject("paramtype");
                if (paramType == null) continue;
                String valueType = paramType.getString("valuetype");
                if (!BillParamValueTypeEnum.PASSWORD.getType().equals(valueType) || !StringUtils.isNotEmpty((String)(value = row.getString("value")))) continue;
                int len = value.length();
                String passwordVal = IntStream.range(0, len).mapToObj(t -> "*").collect(Collectors.joining());
                row.set("value", (Object)passwordVal);
            }
            return rows;
        }
    }
}

