/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.billparam;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class FaBillParamTypeListPlugin
extends AbstractListPlugin {
    private static Log log = LogFactory.getLog(FaBillParamTypeListPlugin.class);
    public static final String PAGE_CACHE_QUERY_BIZCLOUD_ID = "query_bizcloud_id";
    public static final String PAGE_CACHE_QUERY_BIZAPP_ID = "query_bizapp_id";

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        this.beforeF7BizAppSelect(args);
        this.beforeF7BizCloudSelect(args);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter showParameter = (ListShowParameter)this.getView().getFormShowParameter();
        Map customParams = showParameter.getCustomParams();
        String bizCloudId = (String)customParams.get("bizcloud");
        String bizAppId = (String)customParams.get("bizapp");
        if (StringUtils.isEmpty((String)bizCloudId) && StringUtils.isEmpty((String)bizAppId)) {
            List filters = showParameter.getListFilterParameter().getQFilters();
            for (QFilter filter : filters) {
                if ("bizcloud".equals(filter.getProperty())) {
                    bizCloudId = (String)filter.getValue();
                }
                if (!"bizapp".equals(filter.getProperty())) continue;
                bizAppId = (String)filter.getValue();
            }
        }
        this.getPageCache().put(PAGE_CACHE_QUERY_BIZCLOUD_ID, bizCloudId);
        this.getPageCache().put(PAGE_CACHE_QUERY_BIZAPP_ID, bizAppId);
        if (StringUtils.isEmpty((String)bizCloudId) || StringUtils.isEmpty((String)bizAppId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u4e91\u3001\u4e1a\u52a1\u7cfb\u7edf\u4e3a\u7a7a\u3002\u8bf7\u5728\u9875\u9762\u8df3\u8f6c\u53c2\u6570\u4e2d\u8bbe\u7f6e\u3002", (String)"FaBillParamEditPlugin_4", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            return;
        }
        List filterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumns) {
            if (filterColumn.getFieldName().contains("bizcloud")) {
                filterColumn.setDefaultValue(bizCloudId);
                ((CommonFilterColumn)filterColumn).setComboItems(this.getCloudComboItems(bizCloudId));
                continue;
            }
            if (!filterColumn.getFieldName().contains("bizapp")) continue;
            filterColumn.setDefaultValue(bizAppId);
            ((CommonFilterColumn)filterColumn).setComboItems(this.getAppComboItems(bizAppId));
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String bizCloudId = this.getPageCache().get(PAGE_CACHE_QUERY_BIZCLOUD_ID);
        String bizAppId = this.getPageCache().get(PAGE_CACHE_QUERY_BIZAPP_ID);
        List qFilters = e.getQFilters();
        boolean cloudHasFilter = false;
        boolean appHasFilter = false;
        for (QFilter filter : qFilters) {
            if (filter.getProperty().contains("bizcloud")) {
                cloudHasFilter = true;
                filter.__setValue((Object)bizCloudId);
                continue;
            }
            if (!filter.getProperty().contains("bizapp")) continue;
            appHasFilter = true;
            filter.__setValue((Object)bizAppId);
        }
        if (!cloudHasFilter) {
            qFilters.add(new QFilter("bizcloud", "=", (Object)bizCloudId));
        }
        if (!appHasFilter) {
            qFilters.add(new QFilter("bizapp", "=", (Object)bizAppId));
        }
    }

    private void beforeF7BizCloudSelect(BeforeFilterF7SelectEvent args) {
        String[] fieldArray = args.getFieldName().split("\\.");
        String billName = fieldArray[0];
        if (!"bizcloud".equals(billName)) {
            return;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(1);
        filters.add(new QFilter("id", "=", (Object)this.getPageCache().get(PAGE_CACHE_QUERY_BIZCLOUD_ID)));
        args.setQfilters(filters);
        args.setSelectedIds(new Object[]{this.getPageCache().get(PAGE_CACHE_QUERY_BIZCLOUD_ID)});
    }

    private void beforeF7BizAppSelect(BeforeFilterF7SelectEvent args) {
        String[] fieldArray = args.getFieldName().split("\\.");
        String billName = fieldArray[0];
        if (!"bizapp".equals(billName)) {
            return;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        filters.add(new QFilter("bizcloud", "=", (Object)this.getPageCache().get(PAGE_CACHE_QUERY_BIZCLOUD_ID)));
        filters.add(new QFilter("id", "=", (Object)this.getPageCache().get(PAGE_CACHE_QUERY_BIZAPP_ID)));
        args.setQfilters(filters);
        args.setSelectedIds(new Object[]{this.getPageCache().get(PAGE_CACHE_QUERY_BIZAPP_ID)});
    }

    private List<ComboItem> getCloudComboItems(String bizCloudId) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(8);
        DynamicObject cloudInfo = QueryServiceHelper.queryOne((String)"bos_devportal_bizcloud", (String)"id, name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bizCloudId)});
        if (Objects.nonNull(cloudInfo)) {
            comboItems.add(new ComboItem(new LocaleString(cloudInfo.getString("name")), cloudInfo.getString("id")));
        }
        return comboItems;
    }

    private List<ComboItem> getAppComboItems(String bizAppId) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(8);
        DynamicObject appInfo = QueryServiceHelper.queryOne((String)"bos_devportal_bizapp", (String)"id, name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bizAppId)});
        if (Objects.nonNull(appInfo)) {
            comboItems.add(new ComboItem(new LocaleString(appInfo.getString("name")), appInfo.getString("id")));
        }
        return comboItems;
    }
}

