/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.business;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bd.util.BusinessItemUtils;
import org.apache.commons.lang3.StringUtils;

public class BusItemRelBillSettingPlugin
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"editbilltype"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.fillBillTypeEntry();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ((Label)this.getControl("busitemslabel")).setText(BusinessItemUtils.fillBusItemLabel(this.getBusItemPks()));
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("editbilltype".equals(key)) {
            this.openRelBillType();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "bar_save": {
                List<Long> busItemPks = this.getBusItemPks();
                List<Object> relatedBillTypePks = this.getRelatedBillTypePks();
                this.deleteRelation(busItemPks.toArray());
                this.saveRelation(busItemPks.toArray(), relatedBillTypePks.toArray());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"BusItemRelBillSettingPlugin_0", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                break;
            }
            case "bar_refresh": {
                this.fillBillTypeEntry();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("er_billtype".equalsIgnoreCase(actionId)) {
            this.fillBillTypeEntry();
        }
    }

    private void fillBillTypeEntry() {
        List<Long> busItemPks = this.getBusItemPks();
        DynamicObject[] allBillTypes = BusinessDataServiceHelper.load((String)"er_billtype", (String)"id", (QFilter[])new QFilter("enable", "=", (Object)Boolean.TRUE).toArray());
        DynamicObject[] relatedBillType = BusinessDataServiceHelper.load((String)"bd_businessitembill", (String)"billtype.id", (QFilter[])new QFilter[]{new QFilter("businessitem.id", "in", busItemPks)});
        Set relatedBillTypePks = Stream.of(relatedBillType).map(v -> v.getDynamicObject("billtype") != null ? v.getDynamicObject("billtype").getPkValue() : Integer.valueOf(-1)).collect(Collectors.toSet());
        this.getModel().deleteEntryData("billtypeentry");
        ArrayList<Object> relatedBillTypes = new ArrayList<Object>(10);
        ArrayList<DynamicObject> noRelatedBillTypes = new ArrayList<DynamicObject>(10);
        for (DynamicObject billType : allBillTypes) {
            if (relatedBillTypePks.contains(billType.getPkValue())) {
                relatedBillTypes.add(billType);
                continue;
            }
            noRelatedBillTypes.add(billType);
        }
        relatedBillTypes.addAll(noRelatedBillTypes);
        this.getModel().beginInit();
        for (DynamicObject dynamicObject : relatedBillTypes) {
            int rowIndex = this.getModel().createNewEntryRow("billtypeentry");
            this.getModel().setValue("billtype", dynamicObject.getPkValue(), rowIndex);
            if (!relatedBillTypePks.contains(dynamicObject.getPkValue())) continue;
            this.getModel().setValue("setrelate", (Object)Boolean.TRUE, rowIndex);
        }
        this.getModel().endInit();
        this.getView().updateView("billtypeentry");
    }

    private List<Long> getBusItemPks() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        List busItems = (List)showParameter.getCustomParam("busitems");
        ArrayList<Long> busItemPks = new ArrayList<Long>();
        if (busItems != null && busItems.size() > 0) {
            for (String item : busItems) {
                busItemPks.add(Long.parseLong(item));
            }
        }
        return busItemPks;
    }

    private List<Object> getRelatedBillTypePks() {
        ArrayList<Object> curRelatedbillTypePks = new ArrayList<Object>();
        DynamicObjectCollection billTypeEntry = this.getModel().getEntryEntity("billtypeentry");
        billTypeEntry.forEach(billType -> {
            if (billType.getBoolean("setrelate")) {
                curRelatedbillTypePks.add(billType.getDynamicObject("billtype").getPkValue());
            }
        });
        return curRelatedbillTypePks;
    }

    private void openRelBillType() {
        ListShowParameter formShowParameter;
        ListShowParameter listShowParameter = formShowParameter = new ListShowParameter();
        formShowParameter.setFormId("bos_list");
        listShowParameter.setBillFormId("er_billtype");
        listShowParameter.setLookUp(false);
        listShowParameter.setListFilterParameter(null);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u8d39\u7528\u7c7b\u578b\u5173\u8054\u5355\u636e\u5217\u8868", (String)"BusItemRelBillSettingPlugin_1", (String)"fi-bd-formplugin", (Object[])new Object[0]));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "er_billtype"));
        formShowParameter.setShowTitle(true);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void deleteRelation(Object[] busItemPks) {
        DeleteServiceHelper.delete((String)"bd_businessitembill", (QFilter[])new QFilter[]{new QFilter("businessitem.id", "in", (Object)busItemPks)});
    }

    private void saveRelation(Object[] busItemPks, Object[] billTypePks) {
        if (billTypePks.length > 0) {
            ArrayList<DynamicObject> relationColl = new ArrayList<DynamicObject>();
            for (Object busItemPk : busItemPks) {
                for (Object billTypePK : billTypePks) {
                    DynamicObject busItemBill = BusinessDataServiceHelper.newDynamicObject((String)"bd_businessitembill");
                    busItemBill.set("businessitem", busItemPk);
                    busItemBill.set("billtype", billTypePK);
                    busItemBill.set("createOrg", (Object)RequestContext.get().getOrgId());
                    busItemBill.set("enable", (Object)1);
                    busItemBill.set("status", (Object)BillStatus.A.toString());
                    relationColl.add(busItemBill);
                }
            }
            SaveServiceHelper.save((DynamicObject[])relationColl.toArray(new DynamicObject[0]));
        }
        this.updateRelBillType(busItemPks, billTypePks);
    }

    private void updateRelBillType(Object[] busItemPks, Object[] billTypePks) {
        String relBillType = "";
        DynamicObject[] busItems = BusinessDataServiceHelper.load((String)"bd_businessitem", (String)"id,relbilltype", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)busItemPks)});
        if (billTypePks.length > 0) {
            Map billTypes = BusinessDataServiceHelper.loadFromCache((String)"er_billtype", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)billTypePks)});
            List billTypeNames = billTypes.values().stream().map(v -> v.getString("name")).collect(Collectors.toList());
            relBillType = StringUtils.join(billTypeNames, (String)";");
        }
        for (DynamicObject busItem : busItems) {
            busItem.set("relbilltype", (Object)relBillType);
        }
        SaveServiceHelper.update((DynamicObject[])busItems);
    }
}

