/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.business;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.bd.util.BusinessItemUtils;
import kd.fi.bd.util.ObjectCloneUtils;

public class BusItemRelDeptSettingPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(BusItemRelDeptSettingPlugin.class);
    private static final String ORGTREE = "tree_allorg";
    private static final String ORGREL = "orgrelate";
    private static final String ORG = "bos_org";
    private static final String ORGSTRUCTURE = "bos_org_structure";
    private static final int BATCH_INSERT_COUNT = 1000;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbar"});
        this.addClickListeners(new String[]{"btn_add", "btn_del"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        List busItems = (List)showParameter.getCustomParam("busitems");
        this.getPageCache().put("busItems", SerializationUtils.serializeToBase64((Object)busItems));
        List<Long> busItemPks = busItems.stream().map(item -> Long.parseLong(item)).collect(Collectors.toList());
        String busitemLabel = BusinessItemUtils.fillBusItemLabel(busItemPks);
        ((Label)this.getControl("busitemslabel")).setText(busitemLabel);
        String org = (String)showParameter.getCustomParam("org");
        TreeView orgTree = (TreeView)this.getControl(ORGTREE);
        List<Long> orgList = this.createTreeNew(org, orgTree);
        Set<Long> relDeptIds = this.checkRelDepts(orgList, orgTree, busItemPks);
        orgTree.expand(org);
        this.fillOrgRelatedEntry(relDeptIds);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "btn_add": {
                this.addRelDept();
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bar_save": {
                this.saveBusItemRelDept();
                break;
            }
            case "bar_cancel": {
                this.getView().close();
            }
        }
    }

    private Set<Long> checkRelDepts(List<Long> orgList, TreeView orgTree, List<Long> busItems) {
        QFilter filter = new QFilter("businessitem.id", "in", busItems);
        filter.and(new QFilter("relorg.id", "in", orgList));
        HashSet<Long> relDeptIds = new HashSet<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"checkRelDepts", (String)"bd_busitemreldept", (String)"relorg", (QFilter[])new QFilter[]{filter}, null);
             DataSet distinct = dataSet.distinct();){
            while (distinct.hasNext()) {
                Row next = distinct.next();
                Long relOrgId = next.getLong("relorg");
                relDeptIds.add(relOrgId);
            }
        }
        if (relDeptIds.size() > 0) {
            orgTree.checkNodesWithoutChild(relDeptIds.stream().map(p -> new TreeNode(null, String.valueOf(p), null)).collect(Collectors.toList()));
        }
        return relDeptIds;
    }

    private List<Long> createTreeNew(String orgId, TreeView orgTree) {
        ArrayList<Long> orgList = new ArrayList<Long>();
        orgList.add(Long.parseLong(orgId));
        List rootOrgs = OrgUnitServiceHelper.getAdminOrgRelation(orgList, (boolean)true);
        rootOrgs.add(Long.parseLong(orgId));
        Map rootOrgDyms = BusinessDataServiceHelper.loadFromCache((Object[])rootOrgs.toArray(), (String)ORG);
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        rootOrgDyms.forEach((id, rootOrgDym) -> {
            TreeNode node = new TreeNode();
            node.setId(id.toString());
            node.setText(rootOrgDym.getLocaleString("name").getLocaleValue());
            nodes.add(node);
        });
        List orgs = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)1L, (List)rootOrgs, (boolean)true);
        String selectFields = "org,org.name name,parent,longnumber,isleaf,isctrlunit,view.treetype treetype";
        QFilter orgFilter = new QFilter("org", "in", (Object)orgs);
        orgFilter.and(new QFilter("org", "not in", (Object)rootOrgs));
        QFilter viewFilter = new QFilter("view", "=", (Object)1L);
        QFilter orgEnableFilter = new QFilter("org.enable", "=", (Object)"1");
        viewFilter = viewFilter.and(orgEnableFilter);
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)"0");
        viewFilter = viewFilter.and(freezeFilter);
        String sortFields = this.getTreeOrderByFields();
        DynamicObjectCollection orgDyms = QueryServiceHelper.query((String)ORGSTRUCTURE, (String)selectFields, (QFilter[])new QFilter[]{viewFilter, orgEnableFilter, orgFilter}, (String)sortFields);
        for (DynamicObject orgDym : orgDyms) {
            String id2 = orgDym.getString("org");
            String orgName = orgDym.getString("name");
            String parentId = orgDym.getString("parent");
            TreeNode node = new TreeNode(parentId, id2, orgName);
            nodes.add(node);
        }
        orgTree.addNodes(nodes);
        return orgs;
    }

    private String getTreeOrderByFields() {
        String sortFields = OrgUnitServiceHelper.getOrgStructureSortFields();
        if (!sortFields.contains("level")) {
            sortFields = "level," + sortFields;
        } else {
            String levelOrder = ",level";
            if (sortFields.contains(levelOrder)) {
                sortFields = sortFields.replace(levelOrder, "");
                sortFields = "level," + sortFields;
            }
        }
        return sortFields;
    }

    private void addRelDept() {
        TreeView allOrg = (TreeView)this.getControl(ORGTREE);
        List selectedDepts = allOrg.getTreeState().getSelectedNodes();
        HashSet selectDeptIds = new HashSet();
        selectedDepts.forEach(dept -> selectDeptIds.add(Long.parseLong(dept.get("id").toString())));
        HashSet selectDeptIds_bak = (HashSet)ObjectCloneUtils.cloneObject(selectDeptIds);
        DynamicObjectCollection authedOrgs = this.getModel().getEntryEntity(ORGREL);
        authedOrgs.forEach(authedOrg -> selectDeptIds_bak.remove(authedOrg.getLong("orgid")));
        this.fillOrgRelatedEntry(selectDeptIds_bak);
    }

    private void fillOrgRelatedEntry(Set<Long> deptIds) {
        IDataModel model = this.getModel();
        Map depts = BusinessDataServiceHelper.loadFromCache((String)ORG, (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", deptIds)});
        if (!depts.isEmpty()) {
            Collection values = depts.values();
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("orgid", new Object[0]);
            vs.addField("orgname", new Object[0]);
            vs.addField("orgnumber", new Object[0]);
            for (DynamicObject dept : values) {
                vs.addRow(new Object[]{dept.getPkValue(), dept.getString("name"), dept.getString("number")});
            }
            ((AbstractFormDataModel)model).batchCreateNewEntryRow(ORGREL, vs);
            model.endInit();
            this.getView().updateView(ORGREL);
        }
    }

    private void saveBusItemRelDept() {
        DynamicObjectCollection orgrelate = this.getModel().getEntryEntity(ORGREL);
        String busItemsString = this.getPageCache().get("busItems");
        List busItems = (List)SerializationUtils.deSerializeFromBase64((String)busItemsString);
        HashSet allBusItems = new HashSet();
        busItems.forEach(item -> {
            Long itemId = Long.parseLong(item);
            allBusItems.add(itemId);
            List subBusItemIds = BusinessItemUtils.getAllSubBusItem((Long)itemId);
            if (subBusItemIds.size() > 0) {
                allBusItems.addAll(subBusItemIds);
            }
        });
        QFilter qFilter = new QFilter("businessitem", "in", allBusItems);
        DeleteServiceHelper.delete((String)"bd_busitemreldept", (QFilter[])new QFilter[]{qFilter});
        MainEntityType iDataEntityType = EntityMetadataCache.getDataEntityType((String)"bd_busitemreldept");
        DBRoute rt = new DBRoute(iDataEntityType.getDBRouteKey());
        logger.info(String.format("org collection size is %s, busItem collection is %s", orgrelate.size(), allBusItems.size()));
        boolean saveSuccess = true;
        try (TXHandle handle = TX.requiresNew();){
            long willInsertCount = (long)allBusItems.size() * (long)orgrelate.size();
            int min = (int)Math.min(1000L, willInsertCount);
            ArrayList<Object[]> authOrgItems = new ArrayList<Object[]>(min);
            long[] ids = DB.genLongIds((String)"t_bd_businessitemreldept", (int)min);
            int idIndex = 0;
            int loop = 1;
            try {
                for (Long busItem : allBusItems) {
                    for (DynamicObject org : orgrelate) {
                        Object[] objects = new Object[]{ids[idIndex++], busItem, org.getLong("orgid")};
                        authOrgItems.add(objects);
                        if (authOrgItems.size() < 1000) continue;
                        DB.executeBatch((DBRoute)rt, (String)"insert into t_bd_businessitemreldept(fid,fbusinesstypeid,frelorgid) values(?,?,?)", authOrgItems);
                        long residue = willInsertCount - (long)loop * (long)authOrgItems.size();
                        authOrgItems.clear();
                        if (residue <= 0L) continue;
                        min = (int)Math.min(1000L, residue);
                        ids = DB.genLongIds((String)"t_bd_businessitemreldept", (int)min);
                        idIndex = 0;
                        ++loop;
                    }
                }
                if (authOrgItems.size() > 0) {
                    DB.executeBatch((DBRoute)rt, (String)"insert into t_bd_businessitemreldept(fid,fbusinesstypeid,frelorgid) values(?,?,?)", authOrgItems);
                }
            }
            catch (Exception e) {
                handle.markRollback();
                logger.error((Throwable)e);
                saveSuccess = false;
            }
        }
        if (saveSuccess) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"BusItemRelDeptSettingPlugin_0", (String)"fi-bd-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"BusItemRelDeptSettingPlugin_1", (String)"fi-bd-formplugin", (Object[])new Object[0]));
        }
        this.addOperationLog();
    }

    private void addOperationLog() {
        MultiLangEnumBridge descBridge = new MultiLangEnumBridge("\u8bbe\u7f6e\u4e1a\u52a1\u7c7b\u578b\u5173\u8054\u90e8\u95e8\u3002", "BusItemRelDeptSettingPlugin_2", "fi-bd-formplugin");
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4fdd\u5b58", "BusItemRelDeptSettingPlugin_3", "fi-bd-formplugin");
        AppLogInfo logInfo = BusItemRelDeptSettingPlugin.buildLogInfo(this.getView(), descBridge, null, "bd_busitemreldept_setting", opNameBridge);
        LogServiceHelper.addLog((AppLogInfo)logInfo);
    }

    public static AppLogInfo buildLogInfo(IFormView formView, MultiLangEnumBridge opDescBridge, Long orgId, String bizObjId, MultiLangEnumBridge opNameBridge) {
        AppInfo appInfo;
        OpLogAppInfo logInfo = new OpLogAppInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getUserId()));
        String appNumber = formView.getFormShowParameter().getAppId();
        String appId = " ";
        if (StringUtils.isNotEmpty((CharSequence)appNumber) && null != (appInfo = AppMetadataCache.getAppInfo((String)appNumber))) {
            appId = appInfo.getId();
        }
        logInfo.setBizAppID(appId);
        logInfo.setBizObjID(bizObjId);
        logInfo.setOrgID(orgId);
        TimeService timeService = new TimeService();
        logInfo.setOpTime(timeService.getCurrentSystemTime());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        logInfo.setOpName("busItemRelDeptSetting", opNameBridge);
        logInfo.setOpDesc(opDescBridge, new String[0]);
        return logInfo;
    }
}

