/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.business;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;

public class BusinessItemPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(BusinessItemPlugin.class);

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"tbmain", "advcontoolbarap2"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"editbilltype", "paramentry"});
        BasedataEdit biztype = (BasedataEdit)this.getControl("paramnumber");
        biztype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject parent = (DynamicObject)this.getModel().getValue("parent");
        if (parent != null) {
            this.getModel().setValue("number", (Object)(parent.get("number") + "."));
        }
    }

    public void beforeBindData(EventObject e) {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.EDIT.equals((Object)status)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"parent"});
        }
    }

    public void afterBindData(EventObject e) {
        Boolean isPersonalizeData;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && (isPersonalizeData = (Boolean)customParams.get("isPersonalizeData")) != null && isPersonalizeData.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"paramentry", "billtypeentry"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"addentryparam"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"delentryparam"});
        }
        this.fillBillTypeEntry();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.EDIT.equals((Object)status)) {
            this.getPageCache().put("flag", "1");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("er_billtype".equalsIgnoreCase(actionId)) {
            this.fillBillTypeEntry();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        this.getModel().setDataChanged(true);
        OperationStatus opStatus = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)opStatus)) {
            this.getPageCache().put("saveChange", "1");
        } else if (OperationStatus.EDIT.equals((Object)opStatus)) {
            this.getPageCache().remove("flag");
        }
        DynamicObject item = e.getChangeSet()[0].getDataEntity();
        String propName = e.getProperty().getName();
        IDataModel model = this.getModel();
        ChangeData changeData = e.getChangeSet()[0];
        Object oldValue = changeData.getOldValue();
        if ("number".equalsIgnoreCase(propName)) {
            this.whenNumberChanged(model, oldValue);
        } else if ("parent".equalsIgnoreCase(propName)) {
            String number;
            DynamicObject parent = (DynamicObject)this.getModel().getValue("parent");
            if (parent != null && (number = parent.getString("number") + ".") != null) {
                this.getModel().setValue("number", (Object)number);
                this.getModel().setValue("level", (Object)number.split("\\.").length);
            }
        } else if ("setrelate".equalsIgnoreCase(propName)) {
            List<Object> relBillTypes = this.getRelatedBillTypePks();
            StringBuilder relBillTypeName = new StringBuilder();
            Map billTypes = BusinessDataServiceHelper.loadFromCache((String)"er_billtype", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", relBillTypes)});
            if (billTypes != null && billTypes.size() > 0) {
                List billTypeNames = billTypes.values().stream().map(v -> v.getString("name")).collect(Collectors.toList());
                for (String str : billTypeNames) {
                    relBillTypeName.append(str).append(';');
                }
                this.getModel().setValue("relbilltype", (Object)relBillTypeName.toString());
            }
        } else if ("paramnumber".equalsIgnoreCase(propName)) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            DynamicObjectCollection dc = this.getModel().getEntryEntity("paramentry");
            DynamicObject d = (DynamicObject)dc.get(rowIndex);
            Object paramNumber = this.getModel().getValue("paramnumber", rowIndex);
            int flag = -1;
            if (paramNumber == null) {
                return;
            }
            for (int i = rowIndex - 1; i >= 0; --i) {
                if (!paramNumber.equals(this.getModel().getValue("paramnumber", i))) continue;
                flag = i;
            }
            if (flag != -1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53c2\u6570\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"BusinessItemPlugin_0", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                this.getModel().deleteEntryRow("paramentry", rowIndex);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        super.click((EventObject)evt);
        Control source = (Control)evt.getSource();
        String key = evt.getItemKey();
        if ("editbilltype".equalsIgnoreCase(key)) {
            this.openEditBillType();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            List<Object> relatedBillTypePks;
            DynamicObjectCollection paramEntry = this.getModel().getEntryEntity("paramentry");
            ArrayList relatedParams = new ArrayList(paramEntry.size());
            if (CollectionUtils.isNotEmpty((Collection)paramEntry)) {
                for (DynamicObject param : paramEntry) {
                    Long paramId = param.getLong("paramnumber.id");
                    String paramValue = param.getString("paramvalue");
                    if (paramId == null || paramId.equals(0L)) continue;
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("paramId", paramId);
                    map.put("paramValue", paramValue);
                    relatedParams.add(map);
                }
            }
            if (CollectionUtils.isNotEmpty(relatedParams)) {
                this.getPageCache().put("relatedParams", SerializationUtils.toJsonString(relatedParams));
            }
            if (CollectionUtils.isNotEmpty(relatedBillTypePks = this.getRelatedBillTypePks())) {
                this.getPageCache().put("relatedBillTypePks", SerializationUtils.toJsonString(relatedBillTypePks));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        Boolean isPersonalizeData;
        Map customParams;
        Boolean result;
        super.afterDoOperation(afterDoOperationEventArgs);
        Object busItemPk = this.getModel().getDataEntity().getPkValue();
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("save".equals(operateKey) && (result = Boolean.valueOf(afterDoOperationEventArgs.getOperationResult().isSuccess())).booleanValue() && (customParams = this.getView().getFormShowParameter().getCustomParams()) != null && ((isPersonalizeData = (Boolean)customParams.get("isPersonalizeData")) == null || !isPersonalizeData.booleanValue())) {
            int len;
            List relatedParams = Collections.emptyList();
            String relatedParamsStr = this.getPageCache().get("relatedParams");
            if (StringUtils.isNotBlank((CharSequence)relatedParamsStr)) {
                relatedParams = (List)SerializationUtils.fromJsonString((String)relatedParamsStr, List.class);
            }
            this.deleteRelationParam(new Object[]{busItemPk});
            int n = len = relatedParams == null ? 0 : relatedParams.size();
            if (len > 0) {
                this.saveRelationParam(new Object[]{busItemPk}, relatedParams);
            }
            List relatedBillTypePks = Collections.emptyList();
            String relatedBillTypePksStr = this.getPageCache().get("relatedBillTypePks");
            if (StringUtils.isNotBlank((CharSequence)relatedBillTypePksStr)) {
                relatedBillTypePks = (List)SerializationUtils.fromJsonString((String)relatedBillTypePksStr, List.class);
            }
            this.deleteRelation(new Object[]{busItemPk});
            this.saveRelation(new Object[]{busItemPk}, relatedBillTypePks.toArray());
            this.updateRelBillType(new Object[]{busItemPk}, relatedBillTypePks.toArray());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"BusinessItemPlugin_1", (String)"fi-bd-formplugin", (Object[])new Object[0]));
        }
    }

    private void updateRelBillType(Object[] busItemPks, Object[] billTypePks) {
        String relBillType = "";
        DynamicObject[] busItems = BusinessDataServiceHelper.load((String)"bd_businessitem", (String)"id,relbilltype", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)busItemPks)});
        if (billTypePks.length > 0) {
            Map billTypes = BusinessDataServiceHelper.loadFromCache((String)"er_billtype", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)billTypePks)});
            List billTypeNames = billTypes.values().stream().map(v -> v.getString("name")).collect(Collectors.toList());
            relBillType = String.join((CharSequence)";", billTypeNames);
        }
        for (DynamicObject busItem : busItems) {
            busItem.set("relbilltype", (Object)relBillType);
        }
        SaveServiceHelper.update((DynamicObject[])busItems);
    }

    private List<Object> getRelatedBillTypePks() {
        DynamicObjectCollection billTypeEntry = this.getModel().getEntryEntity("billtypeentry");
        ArrayList<Object> curRelatedbillTypePks = new ArrayList<Object>();
        billTypeEntry.forEach(billType -> {
            if (billType.getBoolean("setrelate")) {
                curRelatedbillTypePks.add(billType.getDynamicObject("billtype").getPkValue());
            }
        });
        return curRelatedbillTypePks;
    }

    private void fillBillTypeEntry() {
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        DynamicObject parent = (DynamicObject)this.getModel().getValue("parent");
        if (Long.valueOf(0L).equals(pkValue)) {
            if (this.copyData(this.getView())) {
                BaseShowParameter formShowParameter = (BaseShowParameter)this.getView().getFormShowParameter();
                pkValue = formShowParameter.getPkId();
                if (parent != null) {
                    this.getModel().setValue("number", (Object)(parent.get("number") + "."));
                }
            } else if (parent != null) {
                pkValue = parent.getPkValue();
            }
        }
        DynamicObject[] relatedParam = BusinessDataServiceHelper.load((String)"bd_busitemrelparam", (String)"paramid.id,value", (QFilter[])new QFilter[]{new QFilter("businessitem.id", "=", pkValue)});
        this.getModel().deleteEntryData("paramentry");
        for (DynamicObject param : relatedParam) {
            int rowIndex = this.getModel().createNewEntryRow("paramentry");
            this.getModel().setValue("paramnumber", param.get("paramid"), rowIndex);
            this.getModel().setValue("paramvalue", param.get("value"), rowIndex);
        }
        DynamicObject[] allBillTypes = BusinessDataServiceHelper.load((String)"er_billtype", (String)"id", (QFilter[])new QFilter("enable", "=", (Object)Boolean.TRUE).toArray());
        DynamicObject[] relatedBillType = BusinessDataServiceHelper.load((String)"bd_businessitembill", (String)"billtype.id", (QFilter[])new QFilter[]{new QFilter("businessitem.id", "=", pkValue)});
        Set relatedBillTypePks = Stream.of(relatedBillType).map(v -> v.getDynamicObject("billtype").getPkValue()).collect(Collectors.toSet());
        this.getModel().deleteEntryData("billtypeentry");
        IDataModel model = this.getModel();
        ArrayList<Object> seletePk = new ArrayList<Object>(10);
        ArrayList<Object> unSeletePk = new ArrayList<Object>(10);
        for (DynamicObject billType : allBillTypes) {
            if (relatedBillTypePks.contains(billType.getPkValue())) {
                seletePk.add(billType.getPkValue());
                continue;
            }
            unSeletePk.add(billType.getPkValue());
        }
        int select_len = seletePk.size();
        seletePk.addAll(unSeletePk);
        model.beginInit();
        this.getModel().batchCreateNewEntryRow("billtypeentry", allBillTypes.length);
        for (int j = 0; j < seletePk.size(); ++j) {
            this.getModel().setValue("billtype", seletePk.get(j), j);
            if (j >= select_len) continue;
            this.getModel().setValue("setrelate", (Object)Boolean.TRUE, j);
        }
        model.endInit();
        this.getView().updateView("billtypeentry");
    }

    private boolean copyData(IFormView view) {
        BaseShowParameter formShowParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        Object iscopy = formShowParameter.getCustomParam("iscopy");
        return Boolean.TRUE.equals(iscopy);
    }

    private void openEditBillType() {
        ListShowParameter formShowParameter;
        ListShowParameter listShowParameter = formShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("er_billtype");
        listShowParameter.setFormId("bos_list");
        listShowParameter.setLookUp(false);
        listShowParameter.setListFilterParameter(null);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u8d39\u7528\u5355\u636e\u7c7b\u578b\u5217\u8868", (String)"BusinessItemPlugin_2", (String)"fi-bd-formplugin", (Object[])new Object[0]));
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "er_billtype"));
        formShowParameter.setShowTitle(true);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String saveChange;
        super.beforeClosed(e);
        boolean b = this.getModel().getDataChanged();
        OperationStatus opStatus = this.getView().getFormShowParameter().getStatus();
        String status = this.getModel().getValue("status").toString();
        if (OperationStatus.EDIT.equals((Object)opStatus) && BillStatus.C.toString().equals(status) && this.getModel().getDataChanged()) {
            String flag = this.getPageCache().get("flag");
            if (flag == null || !"1".equals(flag)) {
                ConfirmCallBackListener exitConfirm = new ConfirmCallBackListener("exit");
                this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"BusinessItemPlugin_3", (String)"fi-bd-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, exitConfirm);
                e.setCancel(true);
            } else {
                this.getModel().setDataChanged(false);
            }
        } else if (OperationStatus.ADDNEW.equals((Object)opStatus) && BillStatus.C.toString().equals(status) && this.getModel().getDataChanged() && ((saveChange = this.getPageCache().get("saveChange")) == null || !"1".equals(saveChange))) {
            this.getModel().setDataChanged(false);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("exit".equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getPageCache().put("flag", "1");
                this.getView().close();
            }
        } else if ("saveExit".equals(callBackId)) {
            this.getPageCache().remove("saveChange");
            this.getView().close();
        }
    }

    private void saveRelation(Object[] busItemPks, Object[] billTypePks) {
        if (billTypePks.length > 0) {
            ArrayList<DynamicObject> relationColl = new ArrayList<DynamicObject>();
            for (Object busItemPk : busItemPks) {
                for (Object billTypePK : billTypePks) {
                    DynamicObject busItemBill = BusinessDataServiceHelper.newDynamicObject((String)"bd_businessitembill");
                    busItemBill.set("businessitem", busItemPk);
                    busItemBill.set("billtype", billTypePK);
                    busItemBill.set("createOrg", (Object)RequestContext.get().getOrgId());
                    busItemBill.set("enable", (Object)1);
                    busItemBill.set("status", (Object)BillStatus.A.toString());
                    relationColl.add(busItemBill);
                }
            }
            SaveServiceHelper.save((DynamicObject[])relationColl.toArray(new DynamicObject[0]));
        }
    }

    private void saveRelationParam(Object[] busItemPks, List<Map<String, Object>> relatedParams) {
        if (CollectionUtils.isNotEmpty(relatedParams)) {
            ArrayList<DynamicObject> relationColl = new ArrayList<DynamicObject>();
            for (Object busItemPk : busItemPks) {
                for (Map<String, Object> paramMap : relatedParams) {
                    DynamicObject busItemParam = BusinessDataServiceHelper.newDynamicObject((String)"bd_busitemrelparam");
                    busItemParam.set("businessitem", busItemPk);
                    busItemParam.set("paramid", paramMap.get("paramId"));
                    busItemParam.set("value", paramMap.get("paramValue"));
                    relationColl.add(busItemParam);
                }
            }
            SaveServiceHelper.save((DynamicObject[])relationColl.toArray(new DynamicObject[0]));
        }
    }

    private void deleteRelation(Object[] busItemPks) {
        DeleteServiceHelper.delete((String)"bd_businessitembill", (QFilter[])new QFilter[]{new QFilter("businessitem.id", "in", (Object)busItemPks)});
    }

    private void deleteRelationParam(Object[] busItemPks) {
        DeleteServiceHelper.delete((String)"bd_busitemrelparam", (QFilter[])new QFilter[]{new QFilter("businessitem.id", "in", (Object)busItemPks)});
    }

    private void whenNumberChanged(IDataModel model, Object oldValue) {
        String number = model.getValue("number").toString();
        if (StringUtils.isBlank((CharSequence)number)) {
            return;
        }
        Long parentId = -1L;
        int level = 1;
        if (!number.contains(".")) {
            parentId = null;
        } else {
            String parentNumber = number.substring(0, number.lastIndexOf(46));
            DynamicObject[] businessItem = BusinessDataServiceHelper.load((String)"bd_businessitem", (String)"id", (QFilter[])new QFilter[]{QFilter.of((String)"number=?", (Object[])new Object[]{parentNumber})});
            if (businessItem == null || businessItem.length < 1) {
                model.beginInit();
                model.setValue("number", oldValue);
                model.endInit();
                this.getView().updateView("number");
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7236\u8282\u70b9\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"BusinessItemPlugin_4", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            } else if (businessItem.length == 1) {
                log.info("\u6709\u4e00\u4e2a\u7236\u8282\u70b9\u4e3a:" + SerializationUtils.toJsonString((Object)businessItem[0]));
                parentId = (Long)businessItem[0].getPkValue();
                level = number.split("\\.").length;
            } else {
                log.error("\u6709\u591a\u4e2a\u7236\u8282\u70b9:" + SerializationUtils.toJsonString((Object)businessItem));
            }
        }
        if (!Long.valueOf(-1L).equals(parentId)) {
            model.beginInit();
            model.setValue("parent", (Object)parentId);
            model.endInit();
            this.getView().updateView("parent");
        }
        this.getModel().setValue("level", (Object)level);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        ListShowParameter showParam = (ListShowParameter)e.getFormShowParameter();
        showParam.setMultiSelect(false);
        int openRow = e.getRow();
        DynamicObjectCollection paramSelect = this.getModel().getEntryEntity("paramentry");
        int len = paramSelect.size();
        if (len > 0) {
            ArrayList<Object> selected = new ArrayList<Object>(10);
            for (int j = 0; j < len; ++j) {
                if (paramSelect.get(j) == null || ((DynamicObject)paramSelect.get(j)).get("paramnumber") == null) continue;
                Object pkId = ((DynamicObject)((DynamicObject)paramSelect.get(j)).get("paramnumber")).getPkValue();
                if (openRow == j) {
                    showParam.setSelectedRow(pkId);
                    continue;
                }
                selected.add(pkId);
            }
            QFilter filter = new QFilter("id", "not in", selected);
            showParam.getListFilterParameter().setFilter(filter);
        }
    }
}

