/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.business;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bd.util.BusinessItemUtils;

public class BusitemRelExpItemSettingPlugin
extends AbstractFormPlugin
implements SearchEnterListener {
    private static final String EXPTREE = "expenseitem_tree";
    private static final String EXPREL = "expenseitem_rel";
    private TreeView expItemTree;

    public void initialize() {
        super.initialize();
        this.expItemTree = (TreeView)this.getView().getControl(EXPTREE);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbar"});
        this.addClickListeners(new String[]{"btn_add", "btn_del"});
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List busItems = (List)this.getView().getFormShowParameter().getCustomParam("busitems");
        List<Long> busItemPks = busItems.stream().map(item -> Long.parseLong(item)).collect(Collectors.toList());
        this.getPageCache().put("busItems", SerializationUtils.serializeToBase64(busItemPks));
        String busitemLabel = BusinessItemUtils.fillBusItemLabel(busItemPks);
        ((Label)this.getControl("busitemslabel")).setText(busitemLabel);
        String useOrg = (String)this.getView().getFormShowParameter().getCustomParam("useorg");
        if (StringUtils.isNotBlank((CharSequence)useOrg)) {
            ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(20);
            List<Long> expItemList = this.constructTree(useOrg, treeNodes);
            TreeNode root = this.buildTreeRootNode();
            root.setChildren(treeNodes);
            this.expItemTree.setRootVisible(false);
            this.expItemTree.addNode(root);
            this.expItemTree.expand(root.getId());
            this.getPageCache().put("expItems", SerializationUtils.serializeToBase64(expItemList));
            this.getPageCache().put("expItemTreeNodeList", SerializationUtils.serializeToBase64(treeNodes));
            DynamicObject[] relExpenseItems = this.checkRelExpenseItems(expItemList, this.expItemTree, busItemPks);
            this.fillTable(relExpenseItems);
        }
    }

    private TreeNode buildTreeRootNode() {
        TreeNode root = new TreeNode();
        root.setId("-1");
        root.setText(ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c", (String)"BusitemRelExpItemSettingPlugin_0", (String)"fi-bd-formplugin", (Object[])new Object[0]));
        root.setCheckable(false);
        return root;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "btn_add": {
                this.addRelExpenseItem();
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bar_save": {
                this.saveBusItemRelExpItem();
                break;
            }
            case "bar_cancel": {
                this.getView().close();
            }
        }
    }

    private void fillTable(DynamicObject[] expenseItems) {
        this.getModel().beginInit();
        for (DynamicObject item : expenseItems) {
            int rowIndex = this.getModel().createNewEntryRow(EXPREL);
            this.getModel().setValue("expenseitemid", (Object)item.getLong("id"), rowIndex);
            this.getModel().setValue("expenseitemnumber", (Object)item.getString("number"), rowIndex);
            this.getModel().setValue("expenseitemname", (Object)item.getString("name"), rowIndex);
            this.getModel().setValue("isleaf", item.get("isleaf"), rowIndex);
        }
        this.getModel().endInit();
        this.getView().updateView(EXPREL);
    }

    private List<Long> constructTree(String useOrg, List<TreeNode> treeNodes) {
        DynamicObject[] expItems;
        QFilter qFilters = BaseDataServiceHelper.getBaseDataFilter((String)"er_expenseitemedit", (Long)Long.parseLong(useOrg));
        qFilters.and(new QFilter("enable", "=", (Object)"1"));
        String selectFields = "id,number,name,isleaf,parent,longnumber";
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<Long> expItemIds = new ArrayList<Long>(10);
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(16);
        for (DynamicObject expItem : expItems = BusinessDataServiceHelper.load((String)"er_expenseitemedit", (String)selectFields, (QFilter[])new QFilter[]{qFilters})) {
            TreeNode node = new TreeNode();
            Long id = expItem.getLong("id");
            node.setId(id + "");
            stringBuilder.append(expItem.get("number")).append(' ').append(expItem.getLocaleString("name").getLocaleValue());
            node.setText(stringBuilder.toString());
            DynamicObject parent = expItem.getDynamicObject("parent");
            String parentId = (parent != null ? parent.getPkValue() : Integer.valueOf(0)) + "";
            node.setLongNumber(expItem.get("longnumber") + "");
            node.setParentid(parentId);
            nodes.add(node);
            expItemIds.add(id);
            stringBuilder.setLength(0);
        }
        HashMap<String, TreeNode> dctItems = new HashMap<String, TreeNode>(16);
        for (TreeNode node : nodes) {
            dctItems.put(node.getId(), node);
        }
        for (TreeNode node : nodes) {
            TreeNode parentNode = (TreeNode)dctItems.get(node.getParentid());
            if (parentNode != null) {
                if (parentNode.getChildren() == null) {
                    parentNode.addChildren(new ArrayList());
                }
                parentNode.getChildren().add(node);
                continue;
            }
            treeNodes.add(node);
        }
        return expItemIds;
    }

    private List<Long> constructTreeRoot(TreeView expItemTree, QFilter filter, List<TreeNode> treeNodes) {
        QFilter filters = new QFilter("parent", "=", (Object)0L);
        filters.and(new QFilter("enable", "=", (Object)Character.valueOf('1')));
        filters.and(filter);
        DynamicObject[] expItemTreeRoot = BusinessDataServiceHelper.load((String)"er_expenseitemedit", (String)"id,number,name,isleaf", (QFilter[])new QFilter[]{filters});
        ArrayList<Long> expItemIds = new ArrayList<Long>(10);
        StringBuilder stringBuilder = new StringBuilder();
        for (DynamicObject expItem : expItemTreeRoot) {
            TreeNode node = new TreeNode();
            Long id = expItem.getLong("id");
            expItemIds.add(id);
            node.setId(id + "");
            stringBuilder.append(expItem.getString("number")).append(' ').append(expItem.getLocaleString("name").getLocaleValue());
            node.setText(stringBuilder.toString());
            if (!expItem.getBoolean("isleaf")) {
                node.addChildren(this.constructTreeChild(id, expItemIds, filter));
            }
            expItemTree.addNode(node);
            treeNodes.add(node);
            stringBuilder.setLength(0);
        }
        return expItemIds;
    }

    private List<TreeNode> constructTreeChild(Long nodeId, List<Long> expItemIds, QFilter filter) {
        QFilter filters = new QFilter("parent", "=", (Object)nodeId);
        filters.and(new QFilter("enable", "=", (Object)Character.valueOf('1')));
        filters.and(filter);
        DynamicObject[] expenseItems = BusinessDataServiceHelper.load((String)"er_expenseitemedit", (String)"id,name,number,parent,isleaf", (QFilter[])new QFilter[]{filters});
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(10);
        StringBuilder stringBuilder = new StringBuilder();
        for (DynamicObject expItem : expenseItems) {
            DynamicObject parent = expItem.getDynamicObject("parent");
            String parentId = (parent != null ? parent.getPkValue() : Integer.valueOf(0)) + "";
            Long id = expItem.getLong("id");
            expItemIds.add(id);
            stringBuilder.append(expItem.getString("number")).append(' ').append(expItem.getLocaleString("name").getLocaleValue());
            TreeNode node = new TreeNode(parentId, id + "", stringBuilder.toString());
            stringBuilder.setLength(0);
            if (!expItem.getBoolean("isleaf")) {
                node.addChildren(this.constructTreeChild(id, expItemIds, filter));
            }
            nodes.add(node);
        }
        return nodes;
    }

    private DynamicObject[] checkRelExpenseItems(List<Long> expItemList, TreeView expTree, List<Long> busItems) {
        QFilter filter = new QFilter("businessitem.id", "in", busItems);
        filter.and(new QFilter("expenseitem.id", "in", expItemList));
        DynamicObject[] relExpenseItems = BusinessDataServiceHelper.load((String)"bd_busitemrelexpitem_", (String)"expenseitem", (QFilter[])new QFilter[]{filter});
        ArrayList<TreeNode> checkNodes = new ArrayList<TreeNode>(10);
        ArrayList<DynamicObject> expenseItems = new ArrayList<DynamicObject>(10);
        for (DynamicObject item : relExpenseItems) {
            DynamicObject relExpenseItem = (DynamicObject)item.get("expenseitem");
            expenseItems.add(relExpenseItem);
            TreeNode treeNode = new TreeNode();
            treeNode.setId(relExpenseItem.getLong("id") + "");
            checkNodes.add(treeNode);
        }
        if (checkNodes.size() > 0) {
            expTree.checkNodesWithoutChild(checkNodes);
        }
        return expenseItems.toArray(new DynamicObject[0]);
    }

    private void addRelExpenseItem() {
        List selectedItems = ((TreeView)this.getControl(EXPTREE)).getTreeState().getSelectedNodes();
        HashSet selectedItemIds = new HashSet();
        selectedItems.forEach(item -> selectedItemIds.add(Long.parseLong(item.get("id").toString())));
        selectedItemIds.remove(-1L);
        DynamicObjectCollection relatedItems = this.getModel().getEntryEntity(EXPREL);
        for (DynamicObject relatedItem : relatedItems) {
            Long id = relatedItem.getLong("expenseitemid");
            selectedItemIds.remove(id);
        }
        QFilter[] filter = new QFilter[]{new QFilter("id", "in", selectedItemIds)};
        DynamicObject[] expenseItems = BusinessDataServiceHelper.load((String)"er_expenseitemedit", (String)"id,name,number,isleaf", (QFilter[])filter);
        this.fillTable(expenseItems);
    }

    private void saveBusItemRelExpItem() {
        DynamicObjectCollection relatedExpItems = this.getModel().getEntryEntity(EXPREL);
        List busItems = (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("busItems"));
        HashSet allBusItems = new HashSet();
        busItems.forEach(item -> {
            allBusItems.add(item);
            List subBusItemIds = BusinessItemUtils.getAllSubBusItem((Long)item);
            if (subBusItemIds.size() > 0) {
                allBusItems.addAll(subBusItemIds);
            }
        });
        List expItems = (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("expItems"));
        QFilter filter = new QFilter("businessitem.id", "in", (Object)busItems);
        filter.and(new QFilter("expenseitem.id", "in", (Object)expItems));
        DeleteServiceHelper.delete((String)"bd_busitemrelexpitem_", (QFilter[])new QFilter[]{filter});
        ArrayList relItems = new ArrayList(10);
        allBusItems.forEach(busItem -> relatedExpItems.forEach(item -> {
            DynamicObject rel = BusinessDataServiceHelper.newDynamicObject((String)"bd_busitemrelexpitem_");
            rel.set("businessitem", busItem);
            rel.set("expenseitem", (Object)item.getString("expenseitemid"));
            relItems.add(rel);
        }));
        if (relItems.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])relItems.toArray(new DynamicObject[0]));
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"BusitemRelExpItemSettingPlugin_1", (String)"fi-bd-formplugin", (Object[])new Object[0]));
    }

    public void search(SearchEnterEvent evt) {
        String text = evt.getText();
        List treeNodes = (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("expItemTreeNodeList"));
        List expItemList = (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("expItems"));
        List busItemPks = (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("busItems"));
        this.expItemTree.deleteAllNodes();
        TreeNode root = this.buildTreeRootNode();
        if (StringUtils.isNotBlank((CharSequence)text)) {
            ArrayList<TreeNode> resultNodes = new ArrayList<TreeNode>(10);
            for (TreeNode treeNode : treeNodes) {
                List<TreeNode> filterNodes;
                if (this.patten(treeNode.getText(), text)) {
                    resultNodes.add(treeNode);
                    continue;
                }
                if (treeNode.getChildren() == null || treeNode.getChildren().isEmpty() || (filterNodes = this.filterNode(treeNode, text)).isEmpty()) continue;
                treeNode.setChildren(filterNodes);
                resultNodes.add(treeNode);
            }
            root.setChildren(resultNodes);
            this.expItemTree.addNode(root);
            this.expandAll(this.expItemTree, resultNodes);
        } else {
            root.setChildren(treeNodes);
            this.expItemTree.addNode(root);
        }
        this.expItemTree.expand(root.getId());
        this.checkRelExpenseItems(expItemList, this.expItemTree, busItemPks);
    }

    private void expandAll(TreeView expItemTree, List<TreeNode> treeNodeList) {
        treeNodeList.stream().filter(x -> !x.isLeaf()).forEach(x -> {
            expItemTree.expand(x.getId());
            if (x.getChildren() != null) {
                this.expandAll(expItemTree, x.getChildren());
            }
        });
    }

    private List<TreeNode> filterNode(TreeNode treeNode, String searchText) {
        List nodes = treeNode.getChildren();
        ArrayList<TreeNode> newNodes = new ArrayList<TreeNode>(10);
        for (TreeNode node : nodes) {
            List<TreeNode> retNodes;
            if (this.patten(node.getText(), searchText)) {
                newNodes.add(node);
                continue;
            }
            if (node.getChildren() == null || node.getChildren().isEmpty() || (retNodes = this.filterNode(node, searchText)).isEmpty()) continue;
            node.setChildren(retNodes);
            newNodes.add(node);
        }
        return newNodes;
    }

    private boolean patten(String name, String search) {
        return Pattern.matches(".*" + search + ".*", name);
    }
}

