/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.cdcservice;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.indexing.constant.ExIndexConstant;
import kd.fi.bd.indexing.es.ElasticSearchHelper;
import kd.fi.bd.indexing.integrator.ESTextIndexGLIntegrator;
import kd.fi.bd.indexing.integrator.GLStatisticIntegrator;
import kd.fi.bd.util.data.IDataValueUtil;
import kd.fi.bd.util.filter.QFilterBuilder;

public class ESIndexCDCServicePlugin
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener,
ProgresssListener {
    private static final Log logger = LogFactory.getLog(ESIndexCDCServicePlugin.class);
    private static final String EN_FORMID_ESIndexCDCService = "bd_esindexcdcservice";
    private static final String KEY_INFO_TOOLBAR = "advcontoolbarap1";
    private static final String KEY_DOREFRESHING = "dorefreshing";
    private static final String KEY_REGNEWINDEX = "regnewindex";
    private static final String KEY_CREATEINDEX = "createindex";
    private static final String KEY_CLEARINDEXDATA = "clearindexdata";
    private static final String KEY_INDEXENTITY = "indexentity";
    private static final String KEY_L_SELREGNUM = "selregnum";
    private static final String KEY_L_SELINDEXNAME = "selindexname";
    private static final String KEY_L_SELREGSTATUS = "selregstatus";
    private static final String KEY_MULORG = "mulorg";
    private static final String KEY_DATERANGE = "daterange";
    private static final String KEY_INDEXINIT = "indexinit";
    private static final String KEY_INDEXUNINIT = "indexuninit";
    private static final String KEY_GROUPINIT = "groupinit";
    private static final String KEY_GROUPUNINIT = "groupuninit";
    private static final String KEY_TEXT = "text";
    private static final String KEY_SEARCHTEST = "searchtest";
    private static final String KEY_CLEANALL = "cleanall";
    private static final String KEY_SEARCHENTITY = "searchentity";
    private static final String KEY_PROGRESSBAR = "progressbar";
    private static final String KEY_TASK_TOOLBAR = "advcontoolbarap";
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_REFRESH = "entityrefresh";
    private static final String KEY_ENTITYDELETE = "entitydelete";
    private static final String[] Table_Header = new String[]{"id", "tasktype", "org", "period", "lastcomptime", "transregdt", "instanceid", "last_cdc_id", "last_max_srcid", "last_max_srcentryid", "laststatus"};
    private static final String CACHEKEY_STARTPROPGRESS = "false";
    private static final String CACHEKEY_PROGRESS = "";
    private static final String[] Button_Disable = new String[]{"regnewindex", "createindex", "clearindexdata", "entitydelete", "indexinit", "indexuninit", "groupinit", "groupuninit"};
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_INFO_TOOLBAR, KEY_TASK_TOOLBAR, "toolbarap"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_INDEXENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{KEY_INDEXINIT, KEY_INDEXUNINIT, KEY_SEARCHTEST, KEY_CLEANALL, "startout"});
        ProgressBar progress = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        progress.addProgressListener((ProgresssListener)this);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "searchtest": {
                this.doESIndexSearchTest();
                break;
            }
            case "cleanall": {
                this.doCleanSearchLog();
                break;
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (KEY_REFRESH.equals(itemKey) || KEY_DOREFRESHING.equals(itemKey)) {
            return;
        }
        this.disabledOperation(itemKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        try {
            switch (itemKey) {
                case "dorefreshing": {
                    this.doESIndexInfoRefresh();
                    return;
                }
                case "regnewindex": {
                    this.enableOperation(itemKey);
                    return;
                }
                case "createindex": {
                    this.doESIndexCreate();
                    return;
                }
                case "clearindexdata": {
                    this.doESIndexClear();
                    return;
                }
                case "entityrefresh": {
                    this.doRefreshESSyncTaskStatus();
                    return;
                }
                case "entitydelete": {
                    this.doDeleteCDCTaskStatus();
                    return;
                }
                case "indexinit": {
                    this.doESIndexInit();
                    return;
                }
                case "indexuninit": {
                    this.doESIndexUnInit();
                    return;
                }
                case "groupinit": {
                    this.doGroupIndexCreate();
                    return;
                }
                case "groupuninit": {
                    this.doGroupIndexDelete();
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return;
        }
        finally {
            this.enableOperation(itemKey);
        }
    }

    protected void doESIndexSearchTest() {
        Collection<Long> periodIds = this.getPeriodIds();
        Collection<Long> orgs = this.getOrgIds();
        String text = (String)this.getModel().getValue(KEY_TEXT);
        ArrayList queryResult = new ArrayList(50);
        ESTextIndexGLIntegrator.getInstance().queryESGLVoucherIndex(this.getCurrentSelectedIndexName(), text, orgs, periodIds, 50, 1, 1, v -> queryResult.add(IDataValueUtil.getLong((Object[])v, (int)0)));
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData(KEY_SEARCHENTITY);
        model.clearNoDataRow();
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", queryResult)};
        try (DataSet bd_regtextinfo = QueryServiceHelper.queryDataSet((String)"kd.fi.bd.formplugin.cdcservice.ESIndexCDCServicePlugin.doESIndexSearchTest", (String)"bd_regtextinfo", (String)"id, orgid, period, regtext", (QFilter[])qFilters, (String)"id");){
            for (Row row : bd_regtextinfo) {
                int rowIndex = model.createNewEntryRow(KEY_SEARCHENTITY);
                model.setValue("textid", row.get(0), rowIndex);
                model.setValue("orgid", row.get(1), rowIndex);
                model.setValue("periodid", row.get(2), rowIndex);
                model.setValue("textvalue", row.get(3), rowIndex);
            }
        }
        model.endInit();
        this.getView().updateView(KEY_SEARCHENTITY);
    }

    private void doCleanSearchLog() {
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData("logentity");
        model.endInit();
        this.getView().updateView("logentity");
    }

    private void createLog(String message) {
        IDataModel model = this.getModel();
        model.beginInit();
        int newEntryRow = model.createNewEntryRow("logentity");
        model.setValue("logtime", (Object)new Date(), newEntryRow);
        model.setValue("loginfo", (Object)message, newEntryRow);
        model.endInit();
        this.getView().updateView("logentity");
        EntryGrid logentity = (EntryGrid)this.getView().getControl("logentity");
        logentity.focusCell(newEntryRow, "logtime");
    }

    private void doGroupIndexCreate() {
        this.createLog("The group index initialization method starts to execute ...");
        Collection<Long>[] orgPeriods = this.getPageInputOrgPeriodFilterValues();
        GLStatisticIntegrator.initOrgPeriodDimGroupFromGLVoucher(orgPeriods[0], orgPeriods[1]);
        this.createLog("The group index initialization method is completed !");
    }

    private void doGroupIndexDelete() {
        this.createLog("The group index uninit method starts to execute ...");
        Collection<Long>[] orgPeriods = this.getPageInputOrgPeriodFilterValues();
        GLStatisticIntegrator.deleteOrgPeriodDimGroup(orgPeriods[0], orgPeriods[1]);
        this.createLog("The group index uninit method is completed !");
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        EntryGrid source = (EntryGrid)evt.getSource();
        String key = source.getKey();
        int row = evt.getRow();
        if (KEY_INDEXENTITY.equals(key)) {
            DynamicObject[] entryEntity = this.getModel().getEntryEntity(KEY_INDEXENTITY, row, row + 1);
            String esindexname = (String)entryEntity[0].get("esindexname");
            String regstatus = (String)entryEntity[0].get("regstatus");
            String regnum = (String)entryEntity[0].get("regnum");
            ((Label)this.getView().getControl(KEY_L_SELINDEXNAME)).setText(esindexname);
            ((Label)this.getView().getControl(KEY_L_SELREGSTATUS)).setText(regstatus);
            ((Label)this.getView().getControl(KEY_L_SELREGNUM)).setText(regnum);
            this.getView().updateView("flexpanelap1");
        }
    }

    private void doESIndexInfoRefresh() {
        this.createLog("ES index base info refreshing ...");
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData(KEY_INDEXENTITY);
        Map indexList = ElasticSearchHelper.getSystemConfiguredESIndex((String)CACHEKEY_PROGRESS);
        for (Map.Entry en : indexList.entrySet()) {
            boolean indexExist;
            int rowIndex = model.createNewEntryRow(KEY_INDEXENTITY);
            String esindexName = (String)en.getKey();
            Integer esIndexRegNum = ESTextIndexGLIntegrator.getInstance().getRegisterESIndexSeqNum(esindexName);
            model.setValue("esindexname", (Object)esindexName, rowIndex);
            model.setValue("regstatus", (Object)(esIndexRegNum != null ? 1 : 0), rowIndex);
            model.setValue("regnum", (Object)esIndexRegNum, rowIndex);
            try {
                indexExist = ElasticSearchHelper.isIndexExist((String)((String)en.getKey()));
            }
            catch (Exception ex) {
                indexExist = false;
            }
            model.setValue("isexisted", (Object)indexExist, rowIndex);
            model.setValue("connectinfo", en.getValue(), rowIndex);
        }
        model.endInit();
        this.getView().updateView(KEY_INDEXENTITY);
        this.createLog("ES index base info was refreshed !!!");
    }

    protected Collection<Long>[] getPageInputOrgPeriodFilterValues() {
        DateRangeEdit control = (DateRangeEdit)this.getView().getControl(KEY_DATERANGE);
        Date datestart = (Date)this.getModel().getValue(control.getStartDateFieldKey());
        Date dateend = (Date)this.getModel().getValue(control.getEndDateFieldKey());
        Collection[] result = new Collection[]{((DynamicObjectCollection)this.getModel().getValue(KEY_MULORG)).stream().map(x -> (Long)x.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList()), this.convertDateRangeToPeriodIds(datestart, dateend)};
        for (int i = 0; i < result.length; ++i) {
            if (result[i] == null || !result[i].isEmpty()) continue;
            result[i] = null;
        }
        return result;
    }

    protected void doESIndexCreate() {
        this.createLog("The index create method starts to execute ...");
        ESTextIndexGLIntegrator.getInstance().registerGLVoucherDescriptionESIndex("fi", this.getCurrentSelectedIndexName());
        this.createLog("The index create method is completed !");
    }

    protected void doESIndexInit() {
        this.createLog("The es index initialization method starts to execute ...");
        Collection<Long>[] orgPeriods = this.getPageInputOrgPeriodFilterValues();
        try {
            this.start();
            this.doInitializeESIndexData(this.getCurrentSelectedIndexName(), orgPeriods[0], orgPeriods[1]);
        }
        catch (Exception e) {
            this.stop();
            this.createLog("The es index initialization method failed !");
            throw new RuntimeException(e);
        }
        this.createLog("The es index initialization method is completed !");
    }

    protected void doESIndexUnInit() {
        this.createLog("The es index uninit method starts to execute ...");
        Collection<Long>[] orgPeriods = this.getPageInputOrgPeriodFilterValues();
        ESTextIndexGLIntegrator.deleteRegText(orgPeriods[0], orgPeriods[1]);
        this.createLog("The es index uninit method is completed !");
    }

    private Collection<Long> convertDateRangeToPeriodIds(Date startDate, Date endDate) {
        QFilterBuilder builder1 = new QFilterBuilder();
        builder1.add("begindate", "<=", (Object)endDate).add("enddate", ">=", (Object)startDate);
        return QueryServiceHelper.queryPrimaryKeys((String)"bd_period", (QFilter[])builder1.toArray(new QFilter[0]), null, (int)-1).stream().map(x -> Long.valueOf(x.toString())).collect(Collectors.toSet());
    }

    private void doInitializeESIndexData(String esIndexName, Collection<Long> orgIds, Collection<Long> periodIds) throws Exception {
        int esIndex = ESTextIndexGLIntegrator.getInstance().registerGLVoucherDescriptionESIndex("fi", esIndexName);
        ESTextIndexGLIntegrator.getInstance().startGLVoucherTextProcessTask(0, this.getView().getPageId(), esIndex, orgIds, periodIds);
        System.out.printf("doInitializeESIndexData Completed! index=%s, orgs=%s, period=%s%n", esIndexName, orgIds, periodIds);
    }

    protected void doRefreshESSyncTaskStatus() {
        this.createLog("The method of Refresh the ES synchronization task state starts to execute ...");
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData(KEY_ENTRYENTITY);
        QFilterBuilder filterBuilder = new QFilterBuilder().addEqual("tasktype", (Object)0);
        model.clearNoDataRow();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.bd.formplugin.cdcservice.ESIndexCDCServicePlugin.doRefreshESSyncTaskStatus", (String)"bd_cdc_taskstatus", (String)"id,tasktype,org,period,lastcomptime,transregdt,instanceid,last_cdc_id,last_max_srcid,last_max_srcentryid,laststatus", (QFilter[])filterBuilder.toArray(new QFilter[0]), (String)"lastcomptime desc, org, period");){
            if (dataSet != null) {
                while (dataSet.hasNext()) {
                    Row dataRow = dataSet.next();
                    int rowIndex = model.createNewEntryRow(KEY_ENTRYENTITY);
                    int i = 0;
                    for (String t : Table_Header) {
                        model.setValue(t, dataRow.get(i++), rowIndex);
                    }
                }
            }
        }
        model.endInit();
        this.getView().updateView(KEY_ENTRYENTITY);
        this.createLog("The method of Refresh the ES synchronization task state is completed !");
    }

    private String getCurrentSelectedIndexName() {
        EntryGrid indexEntity = (EntryGrid)this.getView().getControl(KEY_INDEXENTITY);
        int[] selectRows = indexEntity.getSelectRows();
        DynamicObjectCollection indexentity = this.getModel().getEntryEntity(KEY_INDEXENTITY);
        DynamicObject dynamicObject = (DynamicObject)indexentity.get(selectRows[0]);
        return (String)dynamicObject.get("esindexname");
    }

    protected void doESIndexCheck() {
        String indexName = this.getCurrentSelectedIndexName();
        if (!ExIndexConstant.isESIndexRegisteredOnSystemProperty((String)indexName)) {
            ExIndexConstant.registerESIndexOnSystemProperty((String)"fi", (String)indexName);
        }
    }

    protected void doESIndexClear() {
        ESTextIndexGLIntegrator.getInstance().clearESIndexAllData(this.getCurrentSelectedIndexName());
    }

    private void doDeleteCDCTaskStatus() {
        this.createLog("The method of delete the ES synchronization task state starts to execute ...");
        EntryGrid control = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        int[] selectRows = control.getSelectRows();
        IDataModel model = this.getModel();
        Long[] idS = new Long[selectRows.length];
        for (int i = 0; i < selectRows.length; ++i) {
            idS[i] = IDataValueUtil.getLong((Object)model.getEntryRowEntity(KEY_ENTRYENTITY, selectRows[i]).get("id"));
        }
        QFilterBuilder filterBuilder = new QFilterBuilder();
        filterBuilder.addIn("id", (Object)idS);
        BusinessDataWriter.delete((String)"bd_cdc_taskstatus", (QFilter[])filterBuilder.toArray(new QFilter[0]));
        this.doRefreshESSyncTaskStatus();
        this.createLog("The method of delete the ES synchronization task state is completed !");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.isBeingUsed()) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bd_eics_form");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("starttime", new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
            customParams.put("periodIds", this.getPeriodIds());
            customParams.put("orgIds", this.getOrgIds());
            showParameter.setCustomParams(customParams);
            this.disabledOperation(CACHEKEY_PROGRESS);
            this.getView().showForm(showParameter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.doESIndexInfoRefresh();
        this.doRefreshESSyncTaskStatus();
    }

    public void onProgress(ProgressEvent progressEvent) {
        int progress = Integer.parseInt(this.getPageCache().get("progress"));
        progressEvent.setProgress(progress);
        String text = this.getPageCache().get(KEY_TEXT);
        progressEvent.setText(text);
    }

    private void start() {
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        progressBar.setPercent(0, "start execute...");
        this.getPageCache().put(CACHEKEY_STARTPROPGRESS, "true");
        this.getPageCache().put(CACHEKEY_PROGRESS, "0");
        this.getModel().setValue("processinfo", (Object)"task start");
    }

    private Collection<Long> getPeriodIds() {
        DateRangeEdit control = (DateRangeEdit)this.getView().getControl(KEY_DATERANGE);
        Date datestart = (Date)this.getModel().getValue(control.getStartDateFieldKey());
        Date dateend = (Date)this.getModel().getValue(control.getEndDateFieldKey());
        return this.convertDateRangeToPeriodIds(datestart, dateend);
    }

    private Collection<Long> getOrgIds() {
        DynamicObjectCollection mulorg = (DynamicObjectCollection)this.getModel().getValue(KEY_MULORG);
        LinkedList<Long> orgs = new LinkedList<Long>();
        for (DynamicObject row : mulorg) {
            orgs.add((Long)row.getDynamicObject("fbasedataid").getPkValue());
        }
        return orgs;
    }

    private void stop() {
        this.getPageCache().put(CACHEKEY_STARTPROPGRESS, CACHEKEY_STARTPROPGRESS);
        this.getPageCache().put(CACHEKEY_PROGRESS, CACHEKEY_PROGRESS);
        this.enableOperation(CACHEKEY_PROGRESS);
    }

    private void disabledOperation(String current) {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        fieldMap.put("vi", "0");
        for (String b : Button_Disable) {
            if (current.equals(b)) continue;
            this.getView().setEnable(Boolean.valueOf(false), new String[]{b});
            this.getView().updateControlMetadata(b, fieldMap);
        }
    }

    private void enableOperation(String current) {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        fieldMap.put("vi", "1");
        for (String b : Button_Disable) {
            if (current.equals(b)) continue;
            this.getView().setEnable(Boolean.valueOf(true), new String[]{b});
            this.getView().updateControlMetadata(b, fieldMap);
        }
    }

    private boolean isBeingUsed() {
        try (DLock lock = DLock.create((String)EN_FORMID_ESIndexCDCService).fastMode();){
            if (lock.tryLock()) {
                lock.unlock();
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    private void doWaitForUnLock() {
        this.start();
        logger.info("Waiting Unlock bd_esindexcdcservice");
    }

    private void doForcibleUnlocking() {
        try (DLock lock = DLock.create((String)EN_FORMID_ESIndexCDCService).fastMode();){
            lock.unlock();
        }
        logger.info("Force Unlock bd_esindexcdcservice");
        this.enableOperation(CACHEKEY_PROGRESS);
    }
}

