/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.ext;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bd.accversion.AccountAddingAssistValidateTaskImpl;
import kd.fi.bd.accversion.AssistAddingContext;
import kd.fi.bd.consts.BDCommonResource;
import kd.fi.bd.enhance.treetask.AccountAddingAssistAdapter;
import kd.fi.bd.enhance.treetask.AccountContext;
import kd.fi.bd.enhance.treetask.DependBiTreeNode;
import kd.fi.bd.enhance.treetask.ITaskService;
import kd.fi.bd.enhance.treetask.TreeDepthFirstScheduleExecutor;
import kd.fi.bd.formplugin.ext.AccountAddingAssistTaskImpl;
import kd.fi.bd.util.BiTreeNode;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.TaskExecutionResult;
import kd.fi.bd.vo.AccountOrgPairVO;
import kd.fi.bd.vo.AccountVO;
import kd.fi.bd.vo.OrgVO;

public class AccountVersionSaveExtension {
    private static final Log LOG = LogFactory.getLog(AccountVersionSaveExtension.class);
    public static final String PROP_FULL_CHILD = "_fullDependNodes";

    public static DependBiTreeNode<AccountContext> executeAddAssistOp(AssistAddingContext assistAddingContext) {
        DependBiTreeNode taskTreeNode = assistAddingContext.getRootTask();
        TreeDepthFirstScheduleExecutor executor = new TreeDepthFirstScheduleExecutor(taskTreeNode);
        executor.execute((ITaskService)new AccountAddingAssistTaskImpl());
        return taskTreeNode;
    }

    public static List<TaskExecutionResult<AccountOrgPairVO>> executeValidateAssistOp(AssistAddingContext assistAddingContext) {
        BiTreeNode orgTreeNode = assistAddingContext.getRootOrg();
        LOG.info("org_tree_for_validate as:" + orgTreeNode.showFormatTree("\n"));
        BiTreeNode accTreeNode = assistAddingContext.getRootAccount();
        LOG.info("account_tree_for_validate as:" + accTreeNode.showFormatTree("\n"));
        AccountAddingAssistAdapter adapter = new AccountAddingAssistAdapter();
        DependBiTreeNode taskTreeNode = adapter.buildAccOrgTree(orgTreeNode, accTreeNode, (Object)assistAddingContext);
        TreeDepthFirstScheduleExecutor executor = new TreeDepthFirstScheduleExecutor(taskTreeNode);
        executor.execute((ITaskService)new AccountAddingAssistValidateTaskImpl());
        return AccountVersionSaveExtension.collectResults((DependBiTreeNode<AccountContext>)taskTreeNode, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TaskExecutionResult<AccountOrgPairVO>> collectResults(DependBiTreeNode<AccountContext> taskTreeNode, boolean isValidate) {
        ArrayList<TaskExecutionResult<AccountOrgPairVO>> arrayList;
        long tick = System.currentTimeMillis();
        HashSet nodeSet = new HashSet(8);
        taskTreeNode.preTravel(x -> nodeSet.add((DependBiTreeNode)x));
        taskTreeNode.deepFirstTravel(x -> {
            HashSet fullDependNodes = new HashSet(8);
            if (!CollectionUtils.isEmpty((Collection)x.getChild()) || !((DependBiTreeNode)x).getDependencies().isEmpty()) {
                DependBiTreeNode curNode = (DependBiTreeNode)x;
                Stream.concat(curNode.getChild().stream(), curNode.getDependencies().stream()).forEach(c -> {
                    if (TaskExecutionResult.Status.failed == ((AccountContext)c.getData()).getExecutionResult().getStatus()) {
                        fullDependNodes.add((DependBiTreeNode)c);
                    }
                    if (!CollectionUtils.isEmpty((Collection)((Set)c.getPropValue(PROP_FULL_CHILD)))) {
                        ((Set)c.getPropValue(PROP_FULL_CHILD)).stream().forEach(y -> {
                            if (TaskExecutionResult.Status.failed == ((AccountContext)y.getData()).getExecutionResult().getStatus()) {
                                fullDependNodes.add(y);
                            }
                        });
                    }
                });
            }
            x.setPropValue(PROP_FULL_CHILD, fullDependNodes);
        });
        LOG.info("tttt collectResults :" + taskTreeNode.showFormatTree("\n", x -> String.valueOf(x.getId()) + ((AccountContext)((DependBiTreeNode)x).getData()).getExecutionResult().getStatus()));
        taskTreeNode.collect(x -> {
            DependBiTreeNode curNode = (DependBiTreeNode)x;
            TaskExecutionResult curResult = ((AccountContext)x.getData()).getExecutionResult();
            AssistAddingContext assistAddingContext = ((AccountContext)x.getData()).getAssistAddingContext();
            String accountNumber = ((AccountContext)x.getData()).getAccountNumber();
            long orgId = ((AccountContext)x.getData()).getOrgId();
            DynamicObject orgDyn = (DynamicObject)assistAddingContext.getOrgIdDynObjMap().get(orgId);
            if (Objects.isNull(orgDyn)) {
                LOG.info(String.format("currOrgId: %s, accountNumber: %s", orgId, accountNumber));
                return curResult;
            }
            if (TaskExecutionResult.Status.fast_failed == ((AccountContext)curNode.getData()).getExecutionResult().getStatus()) {
                if (assistAddingContext.tryGetAccountIdByOrgAndAccNum(orgId, accountNumber).isPresent()) {
                    List dependFailedNodes = ((Set)x.getPropValue(PROP_FULL_CHILD)).stream().filter(c -> TaskExecutionResult.Status.failed == ((AccountContext)c.getData()).getExecutionResult().getStatus()).collect(Collectors.toList());
                    String refineMsg = String.join((CharSequence)",", dependFailedNodes.stream().map(c -> {
                        Tuple info = ((AccountContext)c.getData()).getData();
                        return String.format("%s:%s", ((OrgVO)((BiTreeNode)info.item2).getData()).getName(), ((AccountVO)((BiTreeNode)info.item1).getData()).getNumber());
                    }).collect(Collectors.toList()));
                    String msgTemplate = isValidate ? ResManager.loadKDString((String)"\u7531\u4e8e\u4e0b\u7ea7\u7ec4\u7ec7\u79d1\u76ee\u201c%s\u201d\u6821\u9a8c\u5931\u8d25\uff0c\u5f53\u524d\u7ec4\u7ec7\u79d1\u76ee\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6821\u9a8c\u5931\u8d25\u7684\u7ec4\u7ec7\u4ee5\u53ca\u79d1\u76ee\u3002", (String)"MeesageConstants_E005", (String)"fi-bd-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7531\u4e8e\u4e0b\u7ea7\u7ec4\u7ec7\u6216\u4e0b\u7ea7\u79d1\u76ee\uff08%s\uff09\u7248\u672c\u5316\u79d1\u76ee\u5931\u8d25\uff0c\u5f53\u524d\u7ec4\u7ec7\u79d1\u76ee\u7248\u672c\u5316\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7248\u672c\u5316\u5931\u8d25\u7684\u7ec4\u7ec7\u4ee5\u53ca\u79d1\u76ee\u3002", (String)"MeesageConstants_E004", (String)"fi-bd-common", (Object[])new Object[0]);
                    curResult.setFailedMsg(String.format(msgTemplate, refineMsg));
                } else {
                    curResult.setStatus(TaskExecutionResult.Status.skip);
                    curResult.setMsgCode("S001");
                    if (DebugTrace.enable()) {
                        LOG.info(String.format("currAccId: %s, orgDyn is null: %s, accountNumber: %s", orgId, Objects.isNull(orgDyn), accountNumber));
                    }
                    curResult.setFailedMsg(String.format(BDCommonResource.getMessageConstantsS001Text(), orgDyn.getString("name"), accountNumber));
                }
            }
            return curResult;
        });
        try {
            arrayList = new ArrayList<TaskExecutionResult<AccountOrgPairVO>>(taskTreeNode.collect(x -> {
                DependBiTreeNode curNode = (DependBiTreeNode)x;
                TaskExecutionResult curResult = ((AccountContext)x.getData()).getExecutionResult();
                curResult.setScheduleSeq(((DependBiTreeNode)x).getScheduleSeq());
                if (Objects.nonNull(curNode.getProxyNode())) {
                    curResult.setStatus(((AccountContext)curNode.getProxyNode().getData()).getExecutionResult().getStatus());
                }
                return curResult;
            }));
        }
        catch (Throwable throwable) {
            LOG.info(String.format("%s collect results cost: %s", AccountVersionSaveExtension.class.getName(), System.currentTimeMillis() - tick));
            throw throwable;
        }
        LOG.info(String.format("%s collect results cost: %s", AccountVersionSaveExtension.class.getName(), System.currentTimeMillis() - tick));
        return arrayList;
    }
}

