/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.model;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class OrgTreeSearchParam {
    public static final String CACHE_KEY_SEARCH_NODES = "_searchNodes";
    public static final String CACHE_KEY_OLD_SEARCH_TEXT = "_oldSearchText";
    public static final String CACHE_KEY_OLD_VIEW_SCHEMA = "_oldSearchViewSchema";
    public static final String CACHE_KEY_RESULT_TOTAL = "_resultTotalCacheKey";
    private String searchText;
    private IFormView formView;
    private TreeView treeView;
    private String rootNodeCacheKey;
    private String orgViewNumber;
    private QFilter orgFilter;
    private IPageCache pageCache;

    public OrgTreeSearchParam(String searchText, IFormView formView, TreeView treeView, String rootNodeCacheKey, long orgViewSchemaId, QFilter orgFilter) {
        this.searchText = searchText;
        this.formView = formView;
        this.treeView = treeView;
        this.rootNodeCacheKey = rootNodeCacheKey;
        this.pageCache = formView.getPageCache();
        this.orgFilter = orgFilter;
        DynamicObject viewObj = BusinessDataServiceHelper.loadSingleFromCache((Object)orgViewSchemaId, (String)"bos_org_viewschema", (String)"number");
        this.orgViewNumber = viewObj == null ? "15" : viewObj.getString("number");
    }

    public String getSearchText() {
        return this.searchText;
    }

    public IFormView getFormView() {
        return this.formView;
    }

    public TreeView getTreeView() {
        return this.treeView;
    }

    public TreeNode getRootNode() {
        if (StringUtils.isBlank((CharSequence)this.rootNodeCacheKey)) {
            return null;
        }
        String rootNodeCache = this.getPageCache().get(this.rootNodeCacheKey);
        if (StringUtils.isNotBlank((CharSequence)rootNodeCache)) {
            return (TreeNode)SerializationUtils.fromJsonString((String)rootNodeCache, TreeNode.class);
        }
        return null;
    }

    public String getOrgViewNumber() {
        return this.orgViewNumber;
    }

    public QFilter getOrgFilter() {
        return this.orgFilter;
    }

    public IPageCache getPageCache() {
        return this.pageCache;
    }
}

