/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.schedual;

import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.IFormView;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.util.StringUtils;

public class FiSchedualConfigPlugin
extends AbstractBasePlugIn {
    private static final String FILTERGRID = "filtergrid";
    private static final String BILL_NUMBER = "number";
    private static final String SELBILL = "selbill";
    private static final String SCH_SCHEDULE = "schschedule";
    public static final String SELBILLFILTER = "selbillfilter";
    public static final String SELBILLFILTER_TAG = "selbillfilter_tag";

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData changeSet = e.getChangeSet()[0];
        Object newValue = changeSet.getNewValue();
        if (newValue == null) {
            return;
        }
        switch (e.getProperty().getName()) {
            case "selbill": {
                this.billEntityOnChanged();
                break;
            }
            case "schschedule": {
                this.schJobOnChanged();
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        this.initBillFilterGrid();
        IDataModel model = this.getModel();
        this.loadFilterGrid(this.getView(), (String)model.getValue(SELBILLFILTER_TAG));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (op.getOperateKey()) {
            case "save": {
                this.beforeDoSave();
                break;
            }
        }
    }

    private void beforeDoSave() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        IDataModel model = this.getModel();
        DynamicObject schedule = dataEntity.getDynamicObject(SCH_SCHEDULE);
        model.setValue(BILL_NUMBER, (Object)schedule.getString(BILL_NUMBER));
        model.setValue("name", (Object)schedule.getString("name"));
        model.setValue("status", (Object)"A");
        model.setValue(SELBILLFILTER_TAG, null);
        model.setValue(SELBILLFILTER, (Object)"");
        DynamicObject selEntity = dataEntity.getDynamicObject(SELBILL);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRID);
        FilterGrid.FilterGridState filterState = filterGrid.getFilterGridState();
        if (selEntity != null && filterState != null && filterState.getFilterCondition() != null) {
            model.setValue(SELBILLFILTER_TAG, (Object)SerializationUtils.toJsonString((Object)filterState.getFilterCondition()));
            String entityName = selEntity.getString(BILL_NUMBER);
            FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityName), filterState.getFilterCondition(), true);
            fb.buildFilter(true);
            if (fb.getQFilter() != null) {
                model.setValue(SELBILLFILTER, (Object)fb.getQFilter().toString());
            }
        }
    }

    private void initBillFilterGrid() {
        DynamicObject billEntity = (DynamicObject)this.getModel().getValue(SELBILL);
        this.initFilterGrid(this.getView(), billEntity != null ? billEntity.getString(BILL_NUMBER) : null);
    }

    private void billEntityOnChanged() {
        this.initBillFilterGrid();
        IDataModel model = this.getModel();
        model.setValue(SELBILLFILTER, (Object)"");
        model.setValue(SELBILLFILTER_TAG, null);
        this.getView().updateView();
    }

    private void schJobOnChanged() {
        IDataModel model = this.getModel();
        model.setValue(SELBILL, null);
        model.setValue(SELBILLFILTER, (Object)"");
        model.setValue(SELBILLFILTER_TAG, null);
        this.getView().updateView();
    }

    private void initFilterGrid(IFormView formView, String entityNumber) {
        if (StringUtils.isEmpty((String)entityNumber)) {
            return;
        }
        FilterGrid filterGrid = (FilterGrid)formView.getControl(FILTERGRID);
        filterGrid.setEntityNumber(entityNumber);
        filterGrid.SetValue(new FilterCondition());
        formView.updateView(FILTERGRID);
    }

    private void loadFilterGrid(IFormView formView, String filterTag) {
        if (StringUtils.isEmpty((String)filterTag)) {
            return;
        }
        FilterGrid filterGrid = (FilterGrid)formView.getControl(FILTERGRID);
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterTag, FilterCondition.class);
        if (filterCondition != null) {
            filterGrid.SetValue(filterCondition);
        }
    }
}

