/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.accountref;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.ext.fi.accountref.AssGrpDefaultVal;

public class AccountRef
implements Serializable {
    private static final long serialVersionUID = 6938002344781256917L;
    private static final int INIT_CAPACITY = 100;
    private Map<Long, Set<Long>> accountRef = new HashMap<Long, Set<Long>>(100);
    private Map<Long, Long> oldAndNewAccountRef = new HashMap<Long, Long>(100);
    private Map<Long, AssGrpDefaultVal> accountDefAssgrpMap = new HashMap<Long, AssGrpDefaultVal>(100);
    private Map<Long, String> accountLongNumberRef = new HashMap<Long, String>(100);

    protected Set<Long> getOldAccountInfos(Long newAccountId) {
        return this.accountRef.get(newAccountId);
    }

    protected Long getNewAccountId(Long oldAccountId) {
        return this.oldAndNewAccountRef.get(oldAccountId);
    }

    protected Set<Long> getNewAccountIdSet() {
        return this.accountRef.keySet();
    }

    protected Set<Long> getOldAccountIdSet() {
        HashSet<Long> idSet = new HashSet<Long>();
        for (Set<Long> v : this.accountRef.values()) {
            idSet.addAll(v);
        }
        return idSet;
    }

    protected AssGrpDefaultVal getAccountDefAssgrp(Long oldAccountId) {
        return this.accountDefAssgrpMap.get(oldAccountId);
    }

    public void addAccountRef(Long newAccountId, Long oldAccountId, Map<String, Object> assgrpMap) {
        Set oldAccountIds = this.accountRef.computeIfAbsent(newAccountId, key -> new HashSet(100));
        oldAccountIds.add(oldAccountId);
        this.oldAndNewAccountRef.put(oldAccountId, newAccountId);
        AssGrpDefaultVal accountRefDetails = new AssGrpDefaultVal();
        for (Map.Entry<String, Object> entry : assgrpMap.entrySet()) {
            accountRefDetails.addAssgrpRef(entry.getKey(), entry.getValue());
        }
        this.accountDefAssgrpMap.put(oldAccountId, accountRefDetails);
    }

    public Map<Long, Long> getOldAndNewAccountRef() {
        return this.oldAndNewAccountRef;
    }

    public void setOldAndNewAccountRef(Map<Long, Long> oldAndNewAccountRef) {
        this.oldAndNewAccountRef = oldAndNewAccountRef;
    }

    public Map<Long, String> getAccountLongNumberRef() {
        return this.accountLongNumberRef;
    }

    public void setAccountLongNumberRef(Map<Long, String> accountLongNumberRef) {
        this.accountLongNumberRef = accountLongNumberRef;
    }
}

