/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.accountref.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.EntryProp;
import kd.bos.ext.fi.accountref.impl.AbstractAssgrpReplaceService;
import kd.bos.ext.fi.accountref.impl.AssgrpLoader;
import kd.bos.ext.fi.accountref.impl.AssgrpSubEntryReplace;
import kd.bos.ext.fi.accountref.impl.AssistItem;
import kd.bos.ext.fi.accountref.impl.BackUpAssgrpUtil;
import kd.bos.ext.fi.accountref.impl.DynamicObjectJsonParser;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

class AssgrpBillEntryReplace
extends AbstractAssgrpReplaceService {
    private static Log logger = LogFactory.getLog(AssgrpSubEntryReplace.class);

    AssgrpBillEntryReplace() {
    }

    @Override
    List<DynamicObject> replaceAccountAssgrp(List<DynamicObject> entityList, String entryName, String accountField, String assgrpField, String subEntryAssgrp, String rowIdField, Set<Long> rowIds) {
        String assgrpFilter = StringUtils.isEmpty((CharSequence)assgrpField) ? entryName : assgrpField;
        HashMap<String, DynamicObject> assgrpRowMap = new HashMap<String, DynamicObject>();
        for (DynamicObject entity : entityList) {
            IDataEntityProperty prop = (IDataEntityProperty)entity.getDataEntityType().getProperties().get((Object)entryName);
            if (entryName == null || prop == null) continue;
            DynamicObjectCollection entryEntity = entity.getDynamicObjectCollection(prop);
            DynamicProperty accountProp = entryEntity.getDynamicObjectType().getProperty(accountField);
            DynamicProperty rowIdProp = entryEntity.getDynamicObjectType().getProperty(rowIdField);
            if (accountProp == null || rowIdProp == null) continue;
            for (DynamicObject entryRow : entryEntity) {
                if (!rowIds.contains(entryRow.getLong("id"))) continue;
                long acctId = entryRow.getLong(accountField + "_id");
                String rowId = entryRow.getString(rowIdField);
                QFilter rowIdFilter = new QFilter("assgrprow", "=", (Object)rowId);
                DynamicObject assgrpRow = (DynamicObject)assgrpRowMap.get(rowId);
                if (assgrpRow == null) {
                    List assgrpRowPk = QueryServiceHelper.queryPrimaryKeys((String)"gl_finalprocess_assgrp", (QFilter[])rowIdFilter.toArray(), null, (int)1);
                    if (assgrpRowPk == null || assgrpRowPk.isEmpty() || (assgrpRow = BusinessDataServiceHelper.loadSingle(assgrpRowPk.get(0), (String)"gl_finalprocess_assgrp")) == null) continue;
                    assgrpRowMap.put(rowId, assgrpRow);
                }
                DynamicObjectCollection assgrpRowColl = null;
                if (acctId == 0L || assgrpRow == null || (assgrpRowColl = assgrpRow.getDynamicObjectCollection("entryentity")) == null || assgrpRowColl.isEmpty()) continue;
                Set<String> flexFields = AssgrpLoader.loadAcctFlexField(this.acctFlexFieldMap, acctId);
                ArrayList<DynamicObject> backUpRowList = new ArrayList<DynamicObject>(10);
                boolean needBackUp = false;
                Iterator iter = assgrpRowColl.iterator();
                while (iter.hasNext()) {
                    DynamicObject assistRow = (DynamicObject)iter.next();
                    long fieldNameId = assistRow.getLong(subEntryAssgrp + "_id");
                    AssistItem assistItem = AssgrpLoader.loadAssistItem(this.assgrpMap, fieldNameId);
                    backUpRowList.add(assistRow);
                    if (flexFields.contains(assistItem.getFlexField())) continue;
                    iter.remove();
                    needBackUp = true;
                }
                if (!needBackUp) continue;
                for (DynamicObject backUpRow : backUpRowList) {
                    String oriJsonVal = DynamicObjectJsonParser.toJson(backUpRow);
                    this.addBackUpEntryRow(entity, entryRow, oriJsonVal, assgrpFilter);
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])assgrpRowMap.values().toArray(new DynamicObject[0]));
        return entityList;
    }

    private void addBackUpEntryRow(DynamicObject entity, DynamicObject entryRow, String oriJsonVal, String assgrpFilter) {
        DynamicObject updateRecord = BusinessDataServiceHelper.newDynamicObject((String)"bd_asstacttype_update");
        updateRecord.set("dataId", entity.get("id"));
        updateRecord.set("metadata_id", (Object)entity.getDataEntityType().getName());
        updateRecord.set("changeType", (Object)"2");
        updateRecord.set("dataEntryId", entryRow.getPkValue());
        updateRecord.set("befAsstValue", (Object)oriJsonVal);
        updateRecord.set("fieldname", (Object)assgrpFilter);
        updateRecord.set("creater", (Object)Long.parseLong(RequestContext.get().getUserId()));
        updateRecord.set("createtime", (Object)new Date());
        this.backUpRecordList.add(updateRecord);
    }

    @Override
    void recoverAccountAssgrp(List<DynamicObject> entityList, String metadata, String entryName, String accountField, String assgrpField, String subEntryAssgrp, String rowIdField, Set<Long> rowIds) {
        String assgrpFilter = StringUtils.isEmpty((CharSequence)assgrpField) ? entryName : assgrpField;
        DynamicObject[] updateRecordArray = BackUpAssgrpUtil.loadBackUpAssgrpRecordByEntityName(entityList, assgrpFilter, rowIds);
        if (updateRecordArray == null || updateRecordArray.length == 0) {
            logger.info("no recover back-up data --" + metadata);
            return;
        }
        HashSet<Long> dataIdSet = new HashSet<Long>();
        HashMap<Long, List<DynamicObject>> updateRecordMap = new HashMap<Long, List<DynamicObject>>();
        BackUpAssgrpUtil.collectUpdateRecord(updateRecordArray, dataIdSet, updateRecordMap);
        ArrayList<Object> deleteRecords = new ArrayList<Object>();
        Map dataMap = BusinessDataServiceHelper.loadFromCache((Object[])dataIdSet.toArray(), (String)metadata);
        HashMap<String, DynamicObject> assgrpRowMap = new HashMap<String, DynamicObject>();
        for (Map.Entry data : dataMap.entrySet()) {
            Object id = data.getKey();
            DynamicObject entity = (DynamicObject)data.getValue();
            List updateRecordList = (List)updateRecordMap.get(id);
            if (updateRecordList == null) continue;
            for (DynamicObject updateRecord : updateRecordList) {
                DynamicObjectCollection entryEntity;
                DynamicProperty rowIdProp;
                String asstValue = updateRecord.getString("befasstvalue");
                Long entryId = updateRecord.getLong("dataentryid");
                if (asstValue == null) continue;
                IDataEntityProperty prop = (IDataEntityProperty)entity.getDataEntityType().getProperties().get((Object)entryName);
                if (entryName == null || !(prop instanceof EntryProp) || (rowIdProp = (entryEntity = entity.getDynamicObjectCollection(prop)).getDynamicObjectType().getProperty(rowIdField)) == null) continue;
                for (DynamicObject entryRow : entryEntity) {
                    IDataEntityProperty assistEntryProp;
                    String rowId = entryRow.getString(rowIdField);
                    QFilter rowIdFilter = new QFilter("assgrprow", "=", (Object)rowId);
                    DynamicObject assgrpRow = (DynamicObject)assgrpRowMap.get(rowId);
                    if (assgrpRow == null) {
                        List assgrpRowPk = QueryServiceHelper.queryPrimaryKeys((String)"gl_finalprocess_assgrp", (QFilter[])rowIdFilter.toArray(), null, (int)1);
                        if (assgrpRowPk == null || assgrpRowPk.isEmpty() || (assgrpRow = BusinessDataServiceHelper.loadSingle(assgrpRowPk.get(0), (String)"gl_finalprocess_assgrp")) == null) continue;
                        assgrpRowMap.put(rowId, assgrpRow);
                    }
                    if (!((assistEntryProp = (IDataEntityProperty)assgrpRow.getDataEntityType().getProperties().get((Object)"entryentity")) instanceof EntryProp) || !entryId.equals(entryRow.getPkValue())) continue;
                    DynamicObjectCollection coll = assgrpRow.getDynamicObjectCollection(assistEntryProp);
                    DynamicObjectJsonParser.fromJson(coll, asstValue);
                    deleteRecords.add(updateRecord.get("id"));
                }
            }
        }
        try (TXHandle handle = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])assgrpRowMap.values().toArray(new DynamicObject[0]));
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bd_asstacttype_update"), (Object[])deleteRecords.toArray());
            }
            catch (Exception e) {
                handle.markRollback();
                logger.error((Throwable)e);
            }
        }
    }
}

