/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.accountref.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.flex.FlexEntireData;
import kd.bos.ext.fi.accountref.impl.AssistItem;
import kd.bos.flex.FlexService;
import kd.bos.servicehelper.BusinessDataServiceHelper;

class AssgrpLoader {
    AssgrpLoader() {
    }

    protected static Set<String> loadAcctFlexField(Map<Long, Set<String>> acctFlexFieldMap, long accountId) {
        Set<String> flexFields = acctFlexFieldMap.get(accountId);
        if (flexFields == null) {
            flexFields = new HashSet<String>();
            String select = "id,number,checkitementry.id,checkitementry.asstactitem";
            DynamicObject accountview = BusinessDataServiceHelper.loadSingleFromCache((Object)accountId, (String)"bd_accountview", (String)select);
            DynamicObjectCollection checkitementry = accountview.getDynamicObjectCollection("checkitementry");
            for (DynamicObject assitem : checkitementry) {
                DynamicObject asstactitem = (DynamicObject)assitem.get("asstactitem");
                if (asstactitem == null) continue;
                String flexField = asstactitem.getString("flexfield");
                flexFields.add(flexField);
            }
            acctFlexFieldMap.put(accountId, flexFields);
        }
        return flexFields;
    }

    protected static AssistItem loadAssistItem(Map<Long, AssistItem> assgrpMap, long assistId) {
        AssistItem assistItem = assgrpMap.get(assistId);
        if (assistItem == null) {
            assistItem = new AssistItem();
            String select = "id, flexfield";
            DynamicObject assistItemDy = BusinessDataServiceHelper.loadSingleFromCache((Object)assistId, (String)"bd_asstacttype", (String)select);
            if (assistItemDy != null) {
                assistItem.setId(assistItemDy.getLong("id"));
                assistItem.setFlexField(assistItemDy.getString("flexfield"));
            }
            assgrpMap.put(assistId, assistItem);
        }
        return assistItem;
    }

    protected static FlexEntireData buildFlexEntireData(Map<String, Object> flexFieldValueMap) {
        FlexEntireData flexEntireData = new FlexEntireData();
        ArrayList<FlexEntireData.FlexData> flexDatas = new ArrayList<FlexEntireData.FlexData>();
        for (Map.Entry<String, Object> entry : flexFieldValueMap.entrySet()) {
            String flexField = entry.getKey();
            Object value = entry.getValue();
            FlexEntireData.FlexData flexData = new FlexEntireData.FlexData(flexEntireData);
            if (value instanceof Long) {
                flexData.setDbType(FlexEntireData.FlexFieldDataType.LONG);
            } else if (value instanceof String) {
                flexData.setDbType(FlexEntireData.FlexFieldDataType.STRING);
            }
            flexData.setPropId(flexField);
            flexData.setValue(value);
            if (value == null) continue;
            flexDatas.add(flexData);
        }
        flexEntireData.setFlexDatas(flexDatas);
        return flexEntireData;
    }

    protected static Map<String, Long> saveNewAssgrpVal(List<FlexEntireData> flexEntireDatas) {
        MainEntityType mainEntity = new MainEntityType();
        mainEntity.setAlias("T_GL_ASSIST");
        mainEntity.setDBRouteKey("gl");
        HashMap<String, Long> valAndIdMap = new HashMap<String, Long>(flexEntireDatas.size());
        FlexService.batchSaveFlexData((MainEntityType)mainEntity, flexEntireDatas);
        for (FlexEntireData flexEntireData : flexEntireDatas) {
            valAndIdMap.put(flexEntireData.concatFlexData(), flexEntireData.getId());
        }
        return valAndIdMap;
    }
}

