/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.accountref.impl;

import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.accountref.impl.AbstractAssgrpReplaceService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

class BackUpAssgrpRegInfo {
    private static Log logger = LogFactory.getLog(BackUpAssgrpRegInfo.class);
    private long id;
    private String metadata;
    private String entryName;
    private String accountField;
    private String assgrpfield;
    private String subentryassgrp;
    private String rowidfield;
    private String pluginname;

    BackUpAssgrpRegInfo() {
    }

    BackUpAssgrpRegInfo(DynamicObject regInfo) {
        if (regInfo == null) {
            return;
        }
        this.id = regInfo.getLong("id");
        this.metadata = regInfo.getString("metadata_id");
        this.entryName = regInfo.getString("entryName");
        this.accountField = regInfo.getString("accountField");
        this.assgrpfield = regInfo.getString("assgrpfield");
        this.subentryassgrp = regInfo.getString("subentryassgrp");
        this.rowidfield = regInfo.getString("rowidfield");
        this.pluginname = regInfo.getString("pluginname");
    }

    long getId() {
        return this.id;
    }

    void setId(long id) {
        this.id = id;
    }

    String getMetadata() {
        return this.metadata;
    }

    void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    String getEntryName() {
        return this.entryName;
    }

    void setEntryName(String entryName) {
        this.entryName = entryName;
    }

    String getAccountField() {
        return this.accountField;
    }

    void setAccountField(String accountField) {
        this.accountField = accountField;
    }

    String getAssgrpfield() {
        return this.assgrpfield;
    }

    void setAssgrpfield(String assgrpfield) {
        this.assgrpfield = assgrpfield;
    }

    String getSubentryassgrp() {
        return this.subentryassgrp;
    }

    void setSubentryassgrp(String subentryassgrp) {
        this.subentryassgrp = subentryassgrp;
    }

    String getRowidfield() {
        return this.rowidfield;
    }

    void setRowidfield(String rowidfield) {
        this.rowidfield = rowidfield;
    }

    String getPluginname() {
        return this.pluginname;
    }

    void setPluginname(String pluginname) {
        this.pluginname = pluginname;
    }

    void replaceAccountAssgrp(List<DynamicObject> oriEntity, Set<Long> entryIds) {
        if (this.pluginname == null || StringUtils.isEmpty((CharSequence)this.pluginname)) {
            logger.info("no plugin  metadata:" + this.metadata);
            return;
        }
        try (TXHandle tx = TX.required();){
            try {
                Object newInstance = Class.forName(this.pluginname.trim()).newInstance();
                if (newInstance instanceof AbstractAssgrpReplaceService) {
                    AbstractAssgrpReplaceService service = (AbstractAssgrpReplaceService)newInstance;
                    service.replaceAccountAssgrp(oriEntity, this.entryName, this.accountField, this.assgrpfield, this.subentryassgrp, this.rowidfield, entryIds);
                    service.afterReplaceAccountAssgrp();
                }
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error(e.getMessage(), (Throwable)e);
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    void recoverAccountAssgrp(List<DynamicObject> dataEntity, Set<Long> entryIds) {
        if (this.pluginname == null || StringUtils.isEmpty((CharSequence)this.pluginname)) {
            logger.info("no plugin  metadata:" + this.metadata);
            return;
        }
        try (TXHandle tx = TX.required();){
            String trim = this.pluginname.trim();
            if (StringUtils.isEmpty((CharSequence)trim)) {
                return;
            }
            try {
                Object newInstance = Class.forName(trim).newInstance();
                if (newInstance instanceof AbstractAssgrpReplaceService) {
                    AbstractAssgrpReplaceService service = (AbstractAssgrpReplaceService)newInstance;
                    service.recoverAccountAssgrp(dataEntity, this.metadata, this.entryName, this.accountField, this.assgrpfield, this.subentryassgrp, this.rowidfield, entryIds);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error(e.getMessage(), (Throwable)e);
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }
}

