/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.accountref.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.ext.fi.accountref.impl.BackUpAssgrpRegInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

class BackUpAssgrpUtil {
    BackUpAssgrpUtil() {
    }

    protected static DynamicObject[] loadBackUpAssgrpRecordByEntityName(List<DynamicObject> entityList, String assgrpFilter, Set<Long> rowIds) {
        if (entityList == null || entityList.isEmpty()) {
            return null;
        }
        String metadata = null;
        HashSet<Object> dataIdSet = new HashSet<Object>(10);
        for (DynamicObject entity : entityList) {
            metadata = entity.getDynamicObjectType().getName();
            dataIdSet.add(entity.getPkValue());
        }
        String selectProperties = "id,dataid,metadata,entryname,changetype,dataentryid,fieldtype,fieldname,befasstvalue";
        QFilter metadataFilter = new QFilter("metadata", "=", (Object)metadata);
        QFilter dataIdFilter = new QFilter("dataid", "in", dataIdSet);
        QFilter fieldnameFilter = new QFilter("fieldname", "=", (Object)assgrpFilter);
        QFilter dataentryidFilter = new QFilter("dataentryid", "in", rowIds);
        DynamicObject[] updateRecordArray = BusinessDataServiceHelper.load((String)"bd_asstacttype_update", (String)selectProperties, (QFilter[])new QFilter[]{metadataFilter, dataIdFilter, fieldnameFilter, dataentryidFilter});
        return updateRecordArray;
    }

    protected static void collectUpdateRecord(DynamicObject[] updateRecordArray, Set<Long> dataIdSet, Map<Long, List<DynamicObject>> updateRecordMap) {
        for (DynamicObject updateRecord : updateRecordArray) {
            long dataId = updateRecord.getLong("dataid");
            dataIdSet.add(dataId);
            List entryIdUpdateRecordSet = updateRecordMap.computeIfAbsent(dataId, v -> new ArrayList());
            entryIdUpdateRecordSet.add(updateRecord);
        }
    }

    protected static List<DynamicObject> excuteAssgrpReplaceService(String metadata, List<DynamicObject> dataEntity, Map<String, Set<Long>> map) {
        QFilter filter = new QFilter("metadata", "=", (Object)metadata);
        Map regInfoMap = BusinessDataServiceHelper.loadFromCache((String)"bd_assisttype_reginfo", (QFilter[])filter.toArray());
        for (Map.Entry entry : regInfoMap.entrySet()) {
            BackUpAssgrpRegInfo regInfoEntity = new BackUpAssgrpRegInfo((DynamicObject)entry.getValue());
            String accountField = regInfoEntity.getAccountField();
            Set<Long> entryIds = map.get(accountField);
            if (CollectionUtils.isEmpty(entryIds)) continue;
            regInfoEntity.replaceAccountAssgrp(dataEntity, entryIds);
        }
        return dataEntity;
    }

    protected static void excuteAssgrpRecoverService(String metadata, List<DynamicObject> dataEntity, Map<String, Set<Long>> map) {
        QFilter filter = new QFilter("metadata", "=", (Object)metadata);
        Map regInfoMap = BusinessDataServiceHelper.loadFromCache((String)"bd_assisttype_reginfo", (QFilter[])filter.toArray());
        for (Map.Entry entry : regInfoMap.entrySet()) {
            BackUpAssgrpRegInfo regInfoEntity = new BackUpAssgrpRegInfo((DynamicObject)entry.getValue());
            String accountField = regInfoEntity.getAccountField();
            Set<Long> entryIds = map.get(accountField);
            if (CollectionUtils.isEmpty(entryIds)) continue;
            regInfoEntity.recoverAccountAssgrp(dataEntity, entryIds);
        }
    }
}

