/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.accountref.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.flex.FlexEntireData;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.ext.fi.accountref.impl.AbstractAssgrpReplaceService;
import kd.bos.ext.fi.accountref.impl.AssgrpLoader;
import kd.bos.ext.fi.accountref.impl.BackUpAssgrpUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

class FlexReplaceService
extends AbstractAssgrpReplaceService {
    private static Log logger = LogFactory.getLog(FlexReplaceService.class);
    private Map<String, String> assgrpIdToConcatStr = new HashMap<String, String>(16);
    private List<FlexEntireData> flexEntireDataList = new ArrayList<FlexEntireData>(10);

    FlexReplaceService() {
    }

    @Override
    List<DynamicObject> replaceAccountAssgrp(List<DynamicObject> entityList, String entryName, String accountField, String assgrpField, String subEntryAssgrp, String rowIdField, Set<Long> rowIds) {
        return this.replaceAccountAssgrp(entityList, entryName, assgrpField, rowIds);
    }

    protected List<DynamicObject> replaceAccountAssgrp(List<DynamicObject> entityList, String entryName, String assgrpField, Set<Long> rowIds) {
        if (entityList == null || entityList.isEmpty()) {
            return entityList;
        }
        for (DynamicObject entity : entityList) {
            IDataEntityProperty prop = (IDataEntityProperty)entity.getDataEntityType().getProperties().get((Object)entryName);
            if (entryName != null && prop != null) {
                this.entryFlexAssgrpBeforeReplace(entryName, assgrpField, entity, prop, rowIds);
                continue;
            }
            IDataEntityProperty assgrpProp = (IDataEntityProperty)entity.getDataEntityType().getProperties().get((Object)assgrpField);
            this.flexAssgrpBeforeReplace(assgrpProp, entity, rowIds);
        }
        Map<String, Long> flexSaveResult = AssgrpLoader.saveNewAssgrpVal(this.flexEntireDataList);
        for (DynamicObject entity : entityList) {
            IDataEntityProperty prop = (IDataEntityProperty)entity.getDataEntityType().getProperties().get((Object)entryName);
            if (entryName != null && prop != null) {
                this.entryFlexAssgrpReplace(entryName, assgrpField, this.acctFlexFieldMap, entity, prop, flexSaveResult);
                continue;
            }
            IDataEntityProperty assgrpProp = (IDataEntityProperty)entity.getDataEntityType().getProperties().get((Object)assgrpField);
            this.flexAssgrpReplace(entity.getLong("id"), assgrpProp, entity, flexSaveResult, entity.getDataEntityType().getName());
        }
        return entityList;
    }

    private void entryFlexAssgrpReplace(String entryField, String assgrpField, Map<Long, Set<String>> acctFlexFieldMap2, DynamicObject entity, IDataEntityProperty prop, Map<String, Long> flexSaveResult) {
        if (prop instanceof EntryProp) {
            EntryProp entryProp = (EntryProp)prop;
            IDataEntityType entryType = entryProp.getItemType();
            DynamicObjectCollection entryEntity = entity.getDynamicObjectCollection(entryField);
            IDataEntityProperty entryItemProp = (IDataEntityProperty)entryType.getProperties().get((Object)assgrpField);
            for (DynamicObject entryRow : entryEntity) {
                this.flexAssgrpReplace(entity.getLong("id"), entryItemProp, entryRow, flexSaveResult, entity.getDataEntityType().getName());
            }
        }
    }

    private void flexAssgrpReplace(long id, IDataEntityProperty assgrpProp, DynamicObject entity, Map<String, Long> flexSaveResult, String entityName) {
        FlexProp flexProp;
        DynamicObject flexDyObj;
        if (assgrpProp instanceof FlexProp && (flexDyObj = entity.getDynamicObject((IDataEntityProperty)(flexProp = (FlexProp)assgrpProp))) != null) {
            long oriFlexId = flexDyObj.getLong("id");
            String basePropName = flexProp.getBasePropertyKey();
            long accountId = entity.getLong(basePropName + "_id");
            if (accountId == 0L || oriFlexId == 0L) {
                return;
            }
            String assgrpKey = accountId + "-" + oriFlexId;
            String concatStr = this.assgrpIdToConcatStr.get(assgrpKey);
            if (concatStr == null) {
                return;
            }
            Long rebuildAssgrpId = flexSaveResult.get(concatStr);
            if (rebuildAssgrpId != null) {
                entity.set(flexProp.getRefIdProp(), (Object)rebuildAssgrpId);
                Object pkValue = entity.getPkValue();
                DynamicObject updateRecord = BusinessDataServiceHelper.newDynamicObject((String)"bd_asstacttype_update");
                updateRecord.set("dataId", (Object)id);
                updateRecord.set("metadata_id", (Object)entityName);
                updateRecord.set("changeType", (Object)"2");
                updateRecord.set("dataEntryId", pkValue);
                updateRecord.set("befAsstValue", (Object)oriFlexId);
                updateRecord.set("fieldname", (Object)flexProp.getName());
                updateRecord.set("creater", (Object)Long.parseLong(RequestContext.get().getUserId()));
                updateRecord.set("createtime", (Object)new Date());
                this.backUpRecordList.add(updateRecord);
            }
        }
    }

    private void entryFlexAssgrpBeforeReplace(String entryField, String assgrpField, DynamicObject entity, IDataEntityProperty prop, Set<Long> rowIds) {
        if (prop instanceof EntryProp) {
            EntryProp entryProp = (EntryProp)prop;
            IDataEntityType entryType = entryProp.getItemType();
            DynamicObjectCollection entryEntity = entity.getDynamicObjectCollection(entryField);
            IDataEntityProperty entryItemProp = (IDataEntityProperty)entryType.getProperties().get((Object)assgrpField);
            for (DynamicObject entryRow : entryEntity) {
                this.flexAssgrpBeforeReplace(entryItemProp, entryRow, rowIds);
            }
        }
    }

    private void flexAssgrpBeforeReplace(IDataEntityProperty assgrpProp, DynamicObject entity, Set<Long> rowIds) {
        if (assgrpProp instanceof FlexProp) {
            if (!rowIds.contains(entity.getLong("id"))) {
                return;
            }
            FlexProp flexProp = (FlexProp)assgrpProp;
            String basePropName = flexProp.getBasePropertyKey();
            long accountId = entity.getLong(basePropName + "_id");
            if (accountId == 0L) {
                return;
            }
            Set<String> flexFields = AssgrpLoader.loadAcctFlexField(this.acctFlexFieldMap, accountId);
            if (flexFields.isEmpty()) {
                return;
            }
            DynamicObject flexDyObj = entity.getDynamicObject((IDataEntityProperty)flexProp);
            if (flexDyObj != null) {
                String value = flexDyObj.getString("value");
                long oriFlexId = flexDyObj.getLong("id");
                Map flexValue = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
                Iterator flexValueIter = flexValue.entrySet().iterator();
                boolean needRebuild = false;
                while (flexValueIter.hasNext()) {
                    Map.Entry entry = flexValueIter.next();
                    String flexField = (String)entry.getKey();
                    if (flexFields.contains(flexField)) continue;
                    needRebuild = true;
                    flexValueIter.remove();
                }
                if (needRebuild) {
                    String assgrpKey = accountId + "-" + oriFlexId;
                    FlexEntireData flexEntireData = AssgrpLoader.buildFlexEntireData(flexValue);
                    String concatData = flexEntireData.concatFlexData();
                    this.assgrpIdToConcatStr.put(assgrpKey, concatData);
                    this.flexEntireDataList.add(flexEntireData);
                }
            }
        }
    }

    @Override
    void recoverAccountAssgrp(List<DynamicObject> entityList, String metadata, String entryName, String accountField, String assgrpField, String subEntryAssgrp, String rowIdField, Set<Long> rowIds) {
        String assgrpFilter = StringUtils.isEmpty((CharSequence)assgrpField) ? entryName : assgrpField;
        DynamicObject[] updateRecordArray = BackUpAssgrpUtil.loadBackUpAssgrpRecordByEntityName(entityList, assgrpFilter, rowIds);
        if (updateRecordArray == null || updateRecordArray.length == 0) {
            logger.info("no recover back-up data --" + metadata);
            return;
        }
        HashSet<Long> dataIdSet = new HashSet<Long>();
        HashMap<Long, List<DynamicObject>> updateRecordMap = new HashMap<Long, List<DynamicObject>>();
        BackUpAssgrpUtil.collectUpdateRecord(updateRecordArray, dataIdSet, updateRecordMap);
        ArrayList<Object> deleteRecords = new ArrayList<Object>();
        Map dataMap = BusinessDataServiceHelper.loadFromCache((Object[])dataIdSet.toArray(), (String)metadata);
        for (Map.Entry data : dataMap.entrySet()) {
            Object id = data.getKey();
            DynamicObject entity = (DynamicObject)data.getValue();
            List updateRecordList = (List)updateRecordMap.get(id);
            if (updateRecordList == null) continue;
            for (DynamicObject updateRecord : updateRecordList) {
                String asstValue = updateRecord.getString("befasstvalue");
                Long entryId = updateRecord.getLong("dataentryid");
                if (asstValue == null) continue;
                IDataEntityProperty prop = (IDataEntityProperty)entity.getDataEntityType().getProperties().get((Object)entryName);
                if (entryName != null && prop != null) {
                    if (!(prop instanceof EntryProp)) continue;
                    EntryProp entryProp = (EntryProp)prop;
                    IDataEntityType entryType = entryProp.getItemType();
                    DynamicObjectCollection entryEntity = entity.getDynamicObjectCollection(entryName);
                    IDataEntityProperty entryItemProp = (IDataEntityProperty)entryType.getProperties().get((Object)assgrpField);
                    for (DynamicObject entryRow : entryEntity) {
                        if (!(entryItemProp instanceof FlexProp) || !entryId.equals(entryRow.getPkValue())) continue;
                        entryRow.set(entryItemProp, (Object)Long.valueOf(asstValue));
                        deleteRecords.add(updateRecord.get("id"));
                    }
                    continue;
                }
                IDataEntityProperty entryItemProp = (IDataEntityProperty)entity.getDynamicObjectType().getProperties().get((Object)assgrpField);
                if (!(entryItemProp instanceof FlexProp)) continue;
                entity.set(entryItemProp, (Object)Long.valueOf(asstValue));
                deleteRecords.add(updateRecord.get("id"));
            }
        }
        try (TXHandle handle = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])dataMap.values().toArray(new DynamicObject[0]));
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bd_asstacttype_update"), (Object[])deleteRecords.toArray());
            }
            catch (Exception e) {
                handle.markRollback();
                logger.error((Throwable)e);
            }
        }
    }
}

