/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.accountref.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.ext.fi.accountref.CheckResult;
import kd.bos.ext.fi.accountref.IAccountTableRefService;
import kd.bos.ext.fi.accountref.impl.AcctUpdateUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class GlAcceditImpl
implements IAccountTableRefService {
    private static Log logger = LogFactory.getLog(GlAcceditImpl.class);

    @Override
    public void enable(long orgId, Date enableDate, AccountTableRef accountIdRef) {
        try (TXHandle handle = TX.requiresNew((String)"kd.bos.ext.fi.accountref.impl.GlAcceditImpl.enable");){
            try {
                ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
                filters.add(new QFilter("org.id", "=", (Object)orgId));
                Set<Long> acctIds = accountIdRef.getAccountRef().getOldAndNewAccountRef().keySet();
                Map<Long, Long> oldAndNewAccountRef = accountIdRef.getAccountRef().getOldAndNewAccountRef();
                filters.add(new QFilter("entryentity.accounts.fbasedataid_id", "in", acctIds));
                Map dataMap = BusinessDataServiceHelper.loadFromCache((String)"gl_accedit", (QFilter[])filters.toArray(new QFilter[0]));
                if (dataMap != null && !dataMap.isEmpty()) {
                    ArrayList<DynamicObject> dyns = new ArrayList<DynamicObject>(dataMap.size());
                    ArrayList<DynamicObject> updateRecords = new ArrayList<DynamicObject>(dataMap.size());
                    for (DynamicObject dyn : dataMap.values()) {
                        DynamicObjectCollection entrys = dyn.getDynamicObjectCollection("entryentity");
                        for (DynamicObject entry : entrys) {
                            DynamicObjectCollection baseentrys = entry.getDynamicObjectCollection("accounts");
                            for (DynamicObject baseentry : baseentrys) {
                                Long oldAcctId = baseentry.getLong("fbasedataid_id");
                                if (!acctIds.contains(oldAcctId)) continue;
                                baseentry.set("fbasedataid_id", (Object)oldAndNewAccountRef.get(oldAcctId));
                                DynamicObject updateRecord = AcctUpdateUtil.buildUpdateRecord("gl_accedit", dyn.getLong("id"), Long.valueOf(baseentry.getPkValue() + ""), orgId, "accounts", oldAcctId, oldAndNewAccountRef.get(oldAcctId), "entryentity", "acct", enableDate, "0");
                                updateRecords.add(updateRecord);
                            }
                        }
                        dyns.add(dyn);
                    }
                    SaveServiceHelper.save((DynamicObject[])dyns.toArray(new DynamicObject[0]));
                    SaveServiceHelper.save((DynamicObject[])updateRecords.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                logger.info(AcctUpdateUtil.printError(e));
                handle.markRollback();
                throw e;
            }
        }
    }

    @Override
    public CheckResult enableCheck(long orgId, Date enableDate, AccountTableRef accountIdRef) {
        return new CheckResult();
    }

    @Override
    public void disable(long orgId, Date disableDate, AccountTableRef accountIdRef) {
        try (TXHandle handle = TX.requiresNew((String)"kd.bos.ext.fi.accountref.impl.GlAcceditImpl.disable");){
            try {
                String selectFields = "id,metadata,fieldtype,dataid,dataentryid,org,fieldname,entryname,reaccountid,afaccountid,versiondate,recordsource";
                ArrayList<QFilter> filters = new ArrayList<QFilter>(6);
                filters.add(new QFilter("metadata", "=", (Object)"gl_accedit"));
                filters.add(new QFilter("fieldtype", "=", (Object)"acct"));
                filters.add(new QFilter("versiondate", "=", (Object)disableDate));
                filters.add(new QFilter("org", "=", (Object)orgId));
                filters.add(new QFilter("afaccountid", "in", accountIdRef.getAccountRef().getOldAndNewAccountRef().values()));
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"bd_account_updaterecord", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]));
                ArrayList<Long> ids = new ArrayList<Long>(collection.size());
                ArrayList<DynamicObject> dyns = new ArrayList<DynamicObject>(collection.size());
                for (DynamicObject dyn : collection) {
                    ids.add(dyn.getLong("id"));
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)dyn.getLong("dataid"), (String)"gl_accedit");
                    DynamicObjectCollection entrys = dynamicObject.getDynamicObjectCollection("entryentity");
                    for (DynamicObject entry : entrys) {
                        DynamicObjectCollection baseEntrys = entry.getDynamicObjectCollection("accounts");
                        for (DynamicObject baseEntry : baseEntrys) {
                            if (!Long.valueOf(baseEntry.getPkValue() + "").equals(dyn.getLong("dataentryid"))) continue;
                            baseEntry.set("fbasedataid_id", (Object)dyn.getLong("reaccountid"));
                        }
                    }
                    dyns.add(dynamicObject);
                }
                SaveServiceHelper.save((DynamicObject[])dyns.toArray(new DynamicObject[0]));
                DeleteServiceHelper.delete((String)"bd_account_updaterecord", (QFilter[])new QFilter("id", "in", ids).toArray());
            }
            catch (Exception e) {
                logger.info(AcctUpdateUtil.printError(e));
                handle.markRollback();
                throw e;
            }
        }
    }

    @Override
    public CheckResult disableCheck(long orgId, Date disableDate, AccountTableRef accountIdRef) {
        return new CheckResult();
    }
}

