/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.accountref.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.ext.fi.accountref.IAccountTableRefService;
import kd.bos.ext.fi.accountref.impl.AcctUpdateUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class MultColSchemeImpl
implements IAccountTableRefService {
    private static Log logger = LogFactory.getLog(MultColSchemeImpl.class);

    @Override
    public void enable(long orgId, Date enableDate, AccountTableRef accountIdRef) {
        try (TXHandle handle = TX.requiresNew((String)"kd.bos.ext.fi.accountref.impl.MultColSchemeImpl.enable");){
            try {
                ArrayList<QFilter> qfilters = new ArrayList<QFilter>(3);
                Long newAccountTableId = accountIdRef.getNewAccountTableId();
                Long oldAccountTableId = accountIdRef.getOldAccountTableId();
                Map<Long, Long> map = accountIdRef.getAccountRef().getOldAndNewAccountRef();
                Collection<Long> values = map.values();
                qfilters.add(new QFilter("org.id", "=", (Object)orgId));
                qfilters.add(new QFilter("accounttable.id", "=", (Object)oldAccountTableId));
                Map mapdyns = BusinessDataServiceHelper.loadFromCache((String)"gl_multcol_scheme", (QFilter[])qfilters.toArray(new QFilter[0]));
                ArrayList<DynamicObject> updateRecords = new ArrayList<DynamicObject>(mapdyns.size());
                if (newAccountTableId.equals(oldAccountTableId)) {
                    for (DynamicObject dyn : mapdyns.values()) {
                        Long accountId = dyn.getLong("account_id");
                        if (map.containsKey(accountId)) {
                            dyn.set("account_id", (Object)map.get(accountId));
                            dyn.set("number", (Object)dyn.getString("account.number"));
                            DynamicObject updateRecord = AcctUpdateUtil.buildUpdateRecord("gl_multcol_scheme", dyn.getLong("id"), 0L, orgId, "account", accountId, map.get(accountId), null, "acct", enableDate, "1");
                            updateRecords.add(updateRecord);
                        }
                        DynamicObjectCollection entryentity = dyn.getDynamicObjectCollection("entryentity");
                        for (DynamicObject entity : entryentity) {
                            Long accountnumId = entity.getLong("accountnum_id");
                            if (!map.containsKey(accountnumId)) continue;
                            entity.set("accountnum_id", (Object)map.get(accountnumId));
                            DynamicObject updateRecord = AcctUpdateUtil.buildUpdateRecord("gl_multcol_scheme", dyn.getLong("id"), Long.valueOf(entity.getPkValue() + ""), orgId, "accountnum", accountnumId, map.get(accountnumId), null, "acct", enableDate, "1");
                            updateRecords.add(updateRecord);
                        }
                    }
                    SaveServiceHelper.save((DynamicObject[])updateRecords.toArray(new DynamicObject[0]));
                    SaveServiceHelper.save((DynamicObject[])mapdyns.values().toArray(new DynamicObject[0]));
                } else {
                    CloneUtils util = new CloneUtils(true, true);
                    DeleteServiceHelper.delete((String)"gl_multcol_scheme", (QFilter[])new QFilter[]{new QFilter("org.id", "=", (Object)orgId), new QFilter("accounttable.id", "=", (Object)newAccountTableId)});
                    ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(mapdyns.size());
                    for (DynamicObject dyn : mapdyns.values()) {
                        DynamicObject dynamicObject = (DynamicObject)util.clone((IDataEntityBase)dyn);
                        dynamicObject.set("id", null);
                        dynamicObject.set("accounttable_id", (Object)newAccountTableId);
                        Long accountId = dyn.getLong("account_id");
                        dynamicObject.set("account_id", (Object)map.get(accountId));
                        dynamicObject.set("number", (Object)dyn.getString("account.number"));
                        DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
                        for (DynamicObject entity : entryentity) {
                            System.out.println();
                            Long accountnumId = entity.getLong("accountnum_id");
                            entity.set("accountnum_id", (Object)map.get(accountnumId));
                        }
                        list.add(dynamicObject);
                    }
                    SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                logger.info(AcctUpdateUtil.printError(e));
                handle.markRollback();
                throw e;
            }
        }
    }

    @Override
    public void disable(long orgId, Date disableDate, AccountTableRef accountIdRef) {
        try (TXHandle handle = TX.requiresNew((String)"kd.bos.ext.fi.accountref.impl.MultColSchemeImpl.disable");){
            try {
                Long oldAccountTableId = accountIdRef.getOldAccountTableId();
                Long newAccountTableId = accountIdRef.getNewAccountTableId();
                if (oldAccountTableId.equals(newAccountTableId)) {
                    this.returnAccountId(orgId, disableDate, accountIdRef);
                } else {
                    DeleteServiceHelper.delete((String)"gl_multcol_scheme", (QFilter[])new QFilter[]{new QFilter("org.id", "=", (Object)orgId), new QFilter("accounttable.id", "=", (Object)newAccountTableId)});
                }
            }
            catch (Exception e) {
                logger.info(AcctUpdateUtil.printError(e));
                handle.markRollback();
                throw e;
            }
        }
    }

    private void returnAccountId(long orgId, Date disableDate, AccountTableRef accountIdRef) {
        DynamicObject[] dyns;
        String selectFields = "id,metadata,fieldtype,dataid,dataentryid,org,fieldname,entryname,reaccountid,afaccountid,versiondate,recordsource";
        ArrayList<QFilter> filters = new ArrayList<QFilter>(5);
        filters.add(new QFilter("metadata", "=", (Object)"gl_multcol_scheme"));
        filters.add(new QFilter("fieldtype", "=", (Object)"acct"));
        filters.add(new QFilter("versiondate", "=", (Object)disableDate));
        filters.add(new QFilter("reaccountid", "in", accountIdRef.getAccountRef().getOldAndNewAccountRef().values()));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bd_account_updaterecord", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]));
        ArrayList<Long> ids = new ArrayList<Long>(collection.size());
        ArrayList<Long> dataIds = new ArrayList<Long>(collection.size());
        HashMap<Long, Long> newAndOldIds = new HashMap<Long, Long>(collection.size());
        Map<Long, Long> oldAndNewIds = accountIdRef.getAccountRef().getOldAndNewAccountRef();
        for (DynamicObject dyn : collection) {
            ids.add(dyn.getLong("id"));
            dataIds.add(dyn.getLong("dataid"));
        }
        for (Map.Entry<Long, Long> entry : oldAndNewIds.entrySet()) {
            newAndOldIds.put(entry.getValue(), entry.getKey());
        }
        for (DynamicObject dyn : dyns = BusinessDataServiceHelper.load((Object[])dataIds.toArray(new Long[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"gl_multcol_scheme"))) {
            Long accountId = dyn.getLong("account_id");
            if (newAndOldIds.containsKey(accountId)) {
                dyn.set("account_id", newAndOldIds.get(accountId));
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle(newAndOldIds.get(accountId), (String)"bd_accountview");
                if (dynamicObject != null) {
                    dyn.set("number", (Object)dynamicObject.getString("number"));
                }
            }
            DynamicObjectCollection entryentity = dyn.getDynamicObjectCollection("entryentity");
            for (DynamicObject entity : entryentity) {
                Long accountNumId = entity.getLong("accountnum_id");
                if (!newAndOldIds.containsKey(accountNumId)) continue;
                entity.set("accountnum_id", newAndOldIds.get(accountNumId));
            }
        }
        SaveServiceHelper.save((DynamicObject[])dyns);
        DeleteServiceHelper.delete((String)"bd_account_updaterecord", (QFilter[])new QFilter("id", "in", ids).toArray());
    }
}

