/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.accountref.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.ext.fi.accountref.IAccountTableRefService;
import kd.bos.ext.fi.accountref.impl.AcctUpdateUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataService;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ReciprocalSchemeImpl
implements IAccountTableRefService {
    private static Log logger = LogFactory.getLog(ReciprocalSchemeImpl.class);

    @Override
    public void enable(long orgId, Date enableDate, AccountTableRef accountIdRef) {
        try (TXHandle handle = TX.requiresNew((String)"kd.bos.ext.fi.accountref.impl.ReciprocalSchemeImpl.enable");){
            try {
                ArrayList<QFilter> qfilters = new ArrayList<QFilter>(3);
                Long newAccountTableId = accountIdRef.getNewAccountTableId();
                Long oldAccountTableId = accountIdRef.getOldAccountTableId();
                Map<Long, Long> map = accountIdRef.getAccountRef().getOldAndNewAccountRef();
                Set<Long> oldAccountIds = map.keySet();
                Collection<Long> values = map.values();
                HashSet<Long> newAccountIds = new HashSet<Long>(values.size());
                for (Long id : values) {
                    newAccountIds.add(id);
                }
                Map<Long, Boolean> acheckNewAccountIds = this.getAcheckAccountIds(newAccountIds);
                qfilters.add(new QFilter("createorg.id", "=", (Object)orgId));
                qfilters.add(new QFilter("accounttable.id", "=", (Object)oldAccountTableId));
                qfilters.add(new QFilter("account.fbasedataid.id", "in", oldAccountIds));
                Map mapdyns = BusinessDataServiceHelper.loadFromCache((String)"gl_reciprocal_scheme", (QFilter[])qfilters.toArray(new QFilter[0]));
                if (!newAccountTableId.equals(oldAccountTableId)) {
                    CloneUtils util = new CloneUtils(true, true);
                    DeleteServiceHelper.delete((String)"gl_reciprocal_scheme", (QFilter[])new QFilter[]{new QFilter("createorg.id", "=", (Object)orgId), new QFilter("accounttable.id", "=", (Object)newAccountTableId)});
                    ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(mapdyns.size());
                    for (DynamicObject dyn : mapdyns.values()) {
                        DynamicObject dynamicObject = (DynamicObject)util.clone((IDataEntityBase)dyn);
                        dynamicObject.set("id", null);
                        dynamicObject.set("iscopy", (Object)Character.valueOf('1'));
                        list.add(dynamicObject);
                    }
                    SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
                }
                ArrayList<DynamicObject> updateRecords = new ArrayList<DynamicObject>(mapdyns.size());
                ArrayList<DynamicObject> dyns = new ArrayList<DynamicObject>(mapdyns.size());
                for (DynamicObject dyn : mapdyns.values()) {
                    dyn.set("accounttable_id", (Object)newAccountTableId);
                    DynamicObject updateRecord = AcctUpdateUtil.buildUpdateRecord("gl_reciprocal_scheme", dyn.getLong("id"), 0L, orgId, "accounttable", oldAccountTableId, newAccountTableId, null, "accttable", enableDate, "1");
                    updateRecords.add(updateRecord);
                    DynamicObjectCollection accounts = dyn.getDynamicObjectCollection("account");
                    Iterator iterators = accounts.iterator();
                    while (iterators.hasNext()) {
                        DynamicObject account = (DynamicObject)iterators.next();
                        Long id = account.getLong("fbasedataid_id");
                        if (!acheckNewAccountIds.isEmpty() && acheckNewAccountIds.containsKey(map.get(id)) && acheckNewAccountIds.get(map.get(id)).booleanValue()) {
                            account.set("fbasedataid_id", (Object)map.get(id));
                            updateRecord = AcctUpdateUtil.buildUpdateRecord("gl_reciprocal_scheme", dyn.getLong("id"), Long.valueOf(account.getPkValue() + ""), orgId, "account", id, map.get(id), null, "acct", enableDate, "1");
                            updateRecords.add(updateRecord);
                            continue;
                        }
                        if (acheckNewAccountIds.isEmpty() || !acheckNewAccountIds.containsKey(map.get(id)) || acheckNewAccountIds.get(map.get(id)).booleanValue()) continue;
                        iterators.remove();
                    }
                    dyns.add(dyn);
                }
                SaveServiceHelper.save((DynamicObject[])updateRecords.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])dyns.toArray(new DynamicObject[0]));
                ReciprocalSchemeImpl.clearCache(orgId);
            }
            catch (Exception e) {
                logger.info(AcctUpdateUtil.printError(e));
                handle.markRollback();
                throw e;
            }
        }
        ReciprocalSchemeImpl.clearCache(orgId);
    }

    private Map<Long, Boolean> getAcheckAccountIds(Set<Long> accountIds) {
        HashMap<Long, Boolean> map = new HashMap<Long, Boolean>(accountIds.size());
        Map dyns = BusinessDataServiceHelper.loadFromCache((String)"bd_accountview", (String)"id,accheck", (QFilter[])new QFilter("id", "in", accountIds).toArray());
        for (DynamicObject row : dyns.values()) {
            map.put(row.getLong("id"), row.getBoolean("accheck"));
        }
        return map;
    }

    @Override
    public void disable(long orgId, Date disableDate, AccountTableRef accountIdRef) {
        try (TXHandle handle = TX.requiresNew((String)"kd.bos.ext.fi.accountref.impl.ReciprocalSchemeImpl.disable");){
            try {
                Long oldAccountTableId = accountIdRef.getOldAccountTableId();
                Long newAccountTableId = accountIdRef.getNewAccountTableId();
                if (oldAccountTableId.equals(newAccountTableId)) {
                    this.returnAccountId(orgId, disableDate, accountIdRef, true);
                } else {
                    DeleteServiceHelper.delete((String)"gl_reciprocal_scheme", (QFilter[])new QFilter[]{new QFilter("createorg.id", "=", (Object)orgId), new QFilter("accounttable.id", "=", (Object)oldAccountTableId), new QFilter("iscopy", "=", (Object)Character.valueOf('1'))});
                    this.returnAccountId(orgId, disableDate, accountIdRef, false);
                }
            }
            catch (Exception e) {
                logger.info(AcctUpdateUtil.printError(e));
                handle.markRollback();
                throw e;
            }
        }
        ReciprocalSchemeImpl.clearCache(orgId);
    }

    private void returnAccountId(long orgId, Date disableDate, AccountTableRef accountIdRef, boolean isSameAcctable) {
        String selectFields = "id,metadata,fieldtype,dataid,dataentryid,org,fieldname,entryname,reaccountid,afaccountid,versiondate,recordsource";
        ArrayList<QFilter> filters = new ArrayList<QFilter>(5);
        filters.add(new QFilter("metadata", "=", (Object)"gl_reciprocal_scheme"));
        filters.add(new QFilter("fieldtype", "=", (Object)"acct"));
        filters.add(new QFilter("versiondate", "=", (Object)disableDate));
        filters.add(new QFilter("org.id", "=", (Object)orgId));
        filters.add(new QFilter("afaccountid", "in", accountIdRef.getAccountRef().getOldAndNewAccountRef().values()));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bd_account_updaterecord", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]));
        ArrayList<Long> ids = new ArrayList<Long>(collection.size());
        ArrayList<Long> dataIds = new ArrayList<Long>(collection.size());
        Map<Long, Long> oldAndNewIds = accountIdRef.getAccountRef().getOldAndNewAccountRef();
        HashMap<Long, Long> newAndOldIds = new HashMap<Long, Long>(collection.size());
        if (isSameAcctable) {
            for (Map.Entry<Long, Long> entry : oldAndNewIds.entrySet()) {
                newAndOldIds.put(entry.getValue(), entry.getKey());
            }
        }
        for (Object dyn : collection) {
            ids.add(dyn.getLong("id"));
            dataIds.add(dyn.getLong("dataid"));
            if (isSameAcctable) continue;
            newAndOldIds.put(dyn.getLong("afaccountid"), dyn.getLong("reaccountid"));
        }
        Map map = BusinessDataServiceHelper.loadFromCache((Object[])dataIds.toArray(new Object[0]), (String)"gl_reciprocal_scheme");
        for (DynamicObject dyn : map.values()) {
            DynamicObjectCollection accounts = dyn.getDynamicObjectCollection("account");
            for (DynamicObject account : accounts) {
                Long accountId = account.getLong("fbasedataid_id");
                if (!newAndOldIds.containsKey(accountId)) continue;
                account.set("fbasedataid_id", newAndOldIds.get(accountId));
            }
        }
        SaveServiceHelper.save((DynamicObject[])map.values().toArray(new DynamicObject[0]));
        DeleteServiceHelper.delete((String)"bd_account_updaterecord", (QFilter[])new QFilter("id", "in", ids).toArray());
        Long oldAccountTableId = accountIdRef.getOldAccountTableId();
        if (oldAccountTableId.longValue() != accountIdRef.getNewAccountTableId()) {
            filters.clear();
            filters.add(new QFilter("metadata", "=", (Object)"gl_reciprocal_scheme"));
            filters.add(new QFilter("fieldtype", "=", (Object)"accttable"));
            filters.add(new QFilter("versiondate", "=", (Object)disableDate));
            filters.add(new QFilter("reaccountid", "=", (Object)oldAccountTableId));
            filters.add(new QFilter("org.id", "=", (Object)orgId));
            collection = QueryServiceHelper.query((String)"bd_account_updaterecord", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]));
            ids = new ArrayList(collection.size());
            dataIds = new ArrayList(collection.size());
            collection = QueryServiceHelper.query((String)"bd_account_updaterecord", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]));
            for (DynamicObject dyn : collection) {
                ids.add(dyn.getLong("id"));
                dataIds.add(dyn.getLong("dataid"));
            }
            map = BusinessDataServiceHelper.loadFromCache((Object[])dataIds.toArray(new Object[0]), (String)"gl_reciprocal_scheme");
            for (DynamicObject dyn : map.values()) {
                dyn.set("accounttable_id", (Object)oldAccountTableId);
            }
            SaveServiceHelper.save((DynamicObject[])map.values().toArray(new DynamicObject[0]));
            DeleteServiceHelper.delete((String)"bd_account_updaterecord", (QFilter[])new QFilter("id", "in", ids).toArray());
        }
    }

    private static void clearCache(Long orgId) {
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        orgIds.add(orgId);
        BaseDataService baseDataService = new BaseDataService();
        baseDataService.clearBaseDataFilterCache("gl_reciprocal_scheme", orgId);
        BaseDataServiceHelper.refreshBaseDataUseRange((String)"gl_reciprocal_scheme", orgIds);
    }
}

