/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.flex;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.ext.fi.flex.FlexFilterUtil;
import kd.bos.ext.fi.flex.FlexRelationUtil;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FlexEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.flex.AbstractFlexBasedataService;
import kd.bos.form.flex.event.FlexControlMetaEvent;
import kd.bos.form.flex.event.GridFlexBindDataEvent;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.form.FormDataModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.FlexUtils;
import kd.fi.bd.util.QFBuilder;
import kd.fi.bd.util.filter.QFilterBuilder;

public class FlexBasedataServiceImpl
extends AbstractFlexBasedataService {
    private static final Log log = LogFactory.getLog(FlexBasedataServiceImpl.class);

    protected boolean isBankAccount(String entity) {
        return FlexFilterUtil.isBankAccount(entity);
    }

    public void beforeFlexItemF7(BeforeF7SelectEvent e) {
        FlexProperty flexProperty;
        super.beforeFlexItemF7(e);
        String entityId = "";
        IDataModel model = null;
        IFormView view = null;
        BasedataEdit edit = (BasedataEdit)e.getSource();
        view = edit.getView();
        entityId = view.getEntityId();
        model = view.getModel();
        if (model == null) {
            return;
        }
        BasedataProp prop = (BasedataProp)e.getProperty();
        String basedataId = prop.getBaseEntityId();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)basedataId);
        String name = prop.getName();
        String flexfield = prop.getAlias();
        String orgFunc = null;
        if (prop instanceof OrgProp) {
            orgFunc = ((OrgProp)prop).getOrgFunc();
        }
        if ("bos_org".equals(basedataId) && null != (flexProperty = FlexEntityMetaUtils.getFlexProperty((String)flexfield)) && StringUtils.isNotBlank((CharSequence)flexProperty.getOrgFuncNumber())) {
            e.getFormShowParameter().setCustomParam("orgFuncId", (Object)flexProperty.getOrgFuncNumber());
        }
        switch (entityId) {
            case "gl_voucher": 
            case "gl_voucher_ajust": 
            case "gl_voucher_cashflowedit": {
                this.assgrpEntryFilter(e, model, basedataId, mainType, name, "entries", "org_id", orgFunc);
                this.setFilterWithCur(e, model, basedataId, entityId);
                if (!name.startsWith("$$assgrp") && !name.startsWith("$$mcfassgrp") && !name.startsWith("$$maincfassgrp")) break;
                int row = model.getEntryCurrentRowIndex("entries");
                this.filterByAssgrpFilter(e, model, row, true, flexfield, mainType, "org_id", "book", "book_id", "account_id");
                break;
            }
            case "gl_presetcashflowitem": {
                QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)basedataId, (Long)((Long)model.getValue("createorg_id")));
                if (filter != null) {
                    ListShowParameter list = (ListShowParameter)e.getFormShowParameter();
                    list.getListFilterParameter().getQFilters().add(filter);
                }
                this.assgrpEntryFilter(e, model, basedataId, mainType, name, "entryentity", "createorg_id", orgFunc);
                break;
            }
            case "gl_accdesignate_assgrp": {
                this.setDesignateFilterWithCur(e, model, basedataId, entityId);
                if (basedataId.equals("bos_org") || basedataId.equals("bos_adminorg")) {
                    DynamicObject maincf = (DynamicObject)model.getValue("maincf");
                    boolean isLeaf = this.isCFSetLeaf(maincf, name);
                    long orgId = (Long)model.getValue("org_id");
                    this.setOrgFilter(e, orgId, basedataId, isLeaf, orgFunc);
                    break;
                }
                if (basedataId.equals("bd_admindivision") || !mainType.getFields().containsKey("parent") || !mainType.getFields().containsKey("isleaf") || !StringUtils.isNotEmpty((CharSequence)((IDataEntityProperty)mainType.getFields().get("isleaf")).getAlias())) break;
                DynamicObject maincf = (DynamicObject)model.getValue("maincf");
                boolean isLeaf = this.isCFSetLeaf(maincf, name);
                this.setTreeBasedataFilter(e, isLeaf);
                break;
            }
            case "gl_initbalance": {
                this.setFilterForOrg(e, model, basedataId, "account", name, "org_id", mainType, "booktype_id", orgFunc);
                this.setFilterWithCur(e, model, basedataId, entityId);
                if (basedataId.equals("bd_accountbanks") || !basedataId.equals("am_accountbank")) {
                    // empty if block
                }
                this.filterByAssgrpFilter(e, model, -1, false, flexfield, mainType, "org_id", "accounttable", "accounttable_id", "account_id");
                break;
            }
            case "gl_transplprogram": {
                this.assgrpFilterLikeVch(e, model, basedataId, "yearprofitacct", name, "org_id", mainType, "book_id", orgFunc);
                this.filterByAssgrpFilter(e, model, -1, false, flexfield, mainType, "org_id", "booktype", "book_id", "yearprofitacct_id");
                break;
            }
            case "gl_adjustexchangerate": {
                this.assgrpFilterLikeVch(e, model, basedataId, "placcountid", name, "org_id", mainType, "bookstype_id", orgFunc);
                this.filterByAssgrpFilter(e, model, -1, false, flexfield, mainType, "org_id", "booktype", "bookstype_id", "placcountid_id");
                break;
            }
            case "gl_templatevoucher": {
                if (!name.startsWith("$$assgrp") && !name.startsWith("$$mcfassgrp")) break;
                int rowIndex = model.getEntryCurrentRowIndex("voucherentity");
                this.assgrpEntryFilter(e, model, basedataId, mainType, name, "voucherentity", "org_id", orgFunc);
                this.addTemplateVoucherBankFilter(e, model, basedataId, entityId, rowIndex);
                this.filterByAssgrpFilter(e, model, rowIndex, true, flexfield, mainType, "org_id", "book", "book_id", "account_id");
                break;
            }
            case "gl_reciprocal_initlist": {
                this.filterByAssgrpFilter(e, model, -1, false, flexfield, mainType, "org_id", "booktype", "booktype_id", "account_id");
                this.setFilterWithCur(e, model, basedataId, entityId);
                break;
            }
            case "gl_initacccurrent": {
                this.filterByAssgrpFilter(e, model, -1, false, flexfield, mainType, "org_id", "accounttable", "accounttable_id", "account_id");
                this.setFilterWithCur(e, model, basedataId, entityId);
                break;
            }
            case "gl_autotrans_percent": {
                this.assgrpEntryFilter(e, model, basedataId, mainType, name, "entryentity", "org_id", orgFunc);
                int row = model.getEntryCurrentRowIndex("entryentity");
                this.filterByAssgrpFilter(e, model, row, true, flexfield, mainType, "org_id", "book", "accountbook_id", "account_id");
                break;
            }
            case "gl_initcashflowassgrp": {
                Long assgrpid;
                DynamicObject assgrp;
                QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)basedataId, (Long)((Long)model.getValue("org_id")));
                if (orgFilter != null) {
                    ListShowParameter list = (ListShowParameter)e.getFormShowParameter();
                    list.getListFilterParameter().getQFilters().add(orgFilter);
                }
                this.setFilterWithCur(e, model, basedataId, entityId);
                if (!name.startsWith("$$assgrp") || (assgrp = BusinessDataServiceHelper.loadSingle((String)"bd_asstacttype", (String)"id", (QFilter[])new QFilter("flexfield", "=", (Object)flexfield).toArray())) == null || (assgrpid = Long.valueOf(assgrp.getLong("id"))) <= 0L) break;
                Object cfitem = ((DynamicObject)model.getValue("cfitem")).getPkValue();
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"gl_cashflowitem", (String)"assistentry.asstypeid, assistentry.isdetail", (QFilter[])new QFilter[]{new QFilter("id", "=", cfitem)});
                boolean isLeaf = false;
                for (DynamicObject dyn : collection) {
                    if (!assgrpid.equals(dyn.getLong("assistentry.asstypeid")) || !dyn.getBoolean("assistentry.isdetail")) continue;
                    isLeaf = true;
                }
                if (isLeaf) {
                    if (basedataId.equals("bos_org") || basedataId.equals("bos_adminorg")) {
                        long orgId = (Long)model.getValue("org_id");
                        this.setOrgFilter(e, orgId, basedataId, isLeaf, orgFunc);
                    } else if (!basedataId.equals("bd_admindivision") && mainType.getFields().containsKey("parent") && mainType.getFields().containsKey("isleaf") && StringUtils.isNotEmpty((CharSequence)((IDataEntityProperty)mainType.getFields().get("isleaf")).getAlias())) {
                        this.setTreeBasedataFilter(e, true);
                    }
                }
                if (!"bos_assistantdata_detail".equals(basedataId)) break;
                ListShowParameter list = (ListShowParameter)e.getFormShowParameter();
                List qFilters = list.getListFilterParameter().getQFilters();
                List<Long> superiorIds = BDUtil.getAllSuperiorOrgIds((Long)model.getValue("org_id"), true);
                QFilter qfilter = new QFilter("createorg.id", "in", superiorIds);
                qFilters.add(qfilter);
                break;
            }
        }
    }

    private Long getAccountTableId(String bywhat, Long orgid, String field, IDataModel model) {
        Long accounttableid = 0L;
        switch (bywhat) {
            case "booktype": {
                Long bookstype = (Long)model.getValue(field);
                DynamicObject accountBookDyn = this.getAccountBookDyn(orgid, bookstype);
                if (accountBookDyn == null) break;
                accounttableid = accountBookDyn.getLong("accounttable.id");
                break;
            }
            case "book": {
                DynamicObject accountbook;
                Long bookid = (Long)model.getValue(field);
                if (bookid <= 0L || (accountbook = BusinessDataServiceHelper.loadSingle((Object)bookid, (String)"gl_accountbook", (String)"accounttable")) == null) break;
                DynamicObject accounttable = accountbook.getDynamicObject("accounttable");
                accounttableid = accounttable.getLong("id");
                break;
            }
            case "accounttable": {
                accounttableid = (Long)model.getValue(field);
            }
        }
        return accounttableid;
    }

    private DynamicObject getAccountBookDyn(long orgId, long bookTypeId) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("org", "=", orgId);
        qfBuilder.add("bookstype", "=", bookTypeId);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"gl_accountbook", (QFilter[])qfBuilder.toArray());
    }

    private void filterByAssgrpFilter(BeforeF7SelectEvent e, IDataModel model, int row, boolean isEntry, String flexField, MainEntityType mainType, String orgField, String bywhat, String bookField, String accountField) {
        Long orgid = (Long)model.getValue(orgField);
        if (orgid > 0L && mainType != null) {
            QFilter assgrpFilter;
            Long assgrpid;
            DynamicObject assgrp;
            Long accounttableid = this.getAccountTableId(bywhat, orgid, bookField, model);
            Long accountid = 0L;
            if (!isEntry) {
                accountid = (Long)model.getValue(accountField);
            } else if (row > -1) {
                accountid = (Long)model.getValue(accountField, row);
            }
            if (accountid > 0L && (assgrp = BusinessDataServiceHelper.loadSingle((String)"bd_asstacttype", (String)"id", (QFilter[])new QFilter("flexfield", "=", (Object)flexField).toArray())) != null && (assgrpid = Long.valueOf(assgrp.getLong("id"))) > 0L && (assgrpFilter = FlexFilterUtil.getAssgrpFilter(orgid, accounttableid, accountid, assgrpid, mainType)) != null) {
                ListShowParameter list = (ListShowParameter)e.getFormShowParameter();
                List qFilters = list.getListFilterParameter().getQFilters();
                qFilters.add(assgrpFilter);
            }
        }
    }

    private void filterByRealtion(BeforeF7SelectEvent e, BasedataProp prop, IFormView view, IDataModel model) {
        Long orgid = (Long)model.getValue("org_id");
        if (orgid <= 0L) {
            return;
        }
        String propname = prop.getName();
        String assgrpKey = propname.contains("mcfassgrp") ? "mcfassgrp" : "assgrp";
        FlexEdit edit = (FlexEdit)view.getControl(assgrpKey);
        IDataModel flexModel = edit.getFlexModel();
        DataEntityPropertyCollection properties = flexModel.getDataEntityType().getProperties();
        String prefix = "$$" + assgrpKey + "__";
        String suffix = "_id";
        String fromFelxIdKey = propname + suffix;
        HashMap<String, Object> toFlexToVal = new HashMap<String, Object>();
        for (IDataEntityProperty iDataEntityProperty : properties) {
            Object value;
            String name = iDataEntityProperty.getName();
            if (!name.startsWith(prefix) || !name.endsWith(suffix) || name.equals(fromFelxIdKey) || FlexBasedataServiceImpl.isValNull(value = flexModel.getValue(name))) continue;
            String key = name.replace(prefix, "").replace(suffix, "");
            toFlexToVal.put(key, value);
        }
        String fromFlex = prop.getAlias();
        List<QFilter> filters = FlexRelationUtil.getFilterByRelationMap(fromFlex, toFlexToVal, orgid);
        ListShowParameter list = (ListShowParameter)e.getFormShowParameter();
        List qFilters = list.getListFilterParameter().getQFilters();
        qFilters.addAll(filters);
    }

    private static boolean isValNull(Object obj) {
        return StringUtils.isBlank((Object)obj) || "0".equals(String.valueOf(obj));
    }

    private void assgrpFilterLikeVch(BeforeF7SelectEvent e, IDataModel model, String basedataId, String accountField, String name, String orgField, MainEntityType mainType, String bookField, String orgFunc) {
        boolean isLeaf;
        DynamicObject account = (DynamicObject)model.getValue(accountField);
        if (basedataId.equals("bos_org") || basedataId.equals("bos_adminorg")) {
            isLeaf = this.getIsLeafByAccount(name, account);
            long orgId = (Long)model.getValue(orgField);
            this.setOrgFilter(e, orgId, basedataId, isLeaf, orgFunc);
        } else if (!basedataId.equals("bd_admindivision") && mainType.getFields().containsKey("parent") && mainType.getFields().containsKey("isleaf") && StringUtils.isNotEmpty((CharSequence)((IDataEntityProperty)mainType.getFields().get("isleaf")).getAlias())) {
            isLeaf = this.getIsLeafByAccount(name, account);
            this.setTreeBasedataFilter(e, isLeaf);
        }
        if (this.isBankAccount(basedataId)) {
            Long orgId = (Long)model.getValue(orgField);
            Long bookTypeId = (Long)model.getValue(bookField);
            this.setBankFilter(e, null, basedataId, orgId, bookTypeId);
        }
    }

    private void setFilterForOrg(BeforeF7SelectEvent e, IDataModel model, String basedataId, String accountField, String name, String orgField, MainEntityType mainType, String bookField, String orgFunc) {
        DynamicObject account = (DynamicObject)model.getValue(accountField);
        if (basedataId.equals("bos_org") || basedataId.equals("bos_adminorg")) {
            boolean isLeaf = this.getIsLeafByAccount(name, account);
            long orgId = (Long)model.getValue(orgField);
            this.setOrgFilter(e, orgId, basedataId, isLeaf, orgFunc);
        } else if (!basedataId.equals("bd_admindivision") && mainType.getFields().containsKey("parent") && mainType.getFields().containsKey("isleaf") && StringUtils.isNotEmpty((CharSequence)((IDataEntityProperty)mainType.getFields().get("isleaf")).getAlias())) {
            boolean isLeaf = this.getIsLeafByAccount(name, account);
            this.setTreeBasedataFilter(e, isLeaf);
        }
    }

    private void setBankFilter(BeforeF7SelectEvent e, List<Long> curIds, String basedataId, Long orgId, Long bookTypeId) {
        FlexFilterUtil.getAccountbankFilter(basedataId, e, orgId, bookTypeId, curIds);
    }

    private boolean getIsLeafByAccount(String name, DynamicObject account) {
        boolean isLeaf = false;
        if (name.startsWith("$$assgrp")) {
            isLeaf = this.isAcctSetLeaf(account, name);
        }
        return isLeaf;
    }

    private void assgrpEntryFilter(BeforeF7SelectEvent e, IDataModel model, String basedataId, MainEntityType mainType, String name, String entryKey, String orgField, String orgFunc) {
        if (basedataId.equals("bos_org") || basedataId.equals("bos_adminorg")) {
            boolean isLeaf = this.getIsLeaf(name, basedataId, model, entryKey);
            long orgId = (Long)model.getValue(orgField);
            this.setOrgFilter(e, orgId, basedataId, isLeaf, orgFunc);
        } else if (!basedataId.equals("bd_admindivision") && mainType.getFields().containsKey("parent") && mainType.getFields().containsKey("isleaf") && StringUtils.isNotEmpty((CharSequence)((IDataEntityProperty)mainType.getFields().get("isleaf")).getAlias())) {
            boolean isLeaf = this.getIsLeaf(name, basedataId, model, entryKey);
            this.setTreeBasedataFilter(e, isLeaf);
        }
    }

    private boolean getIsLeaf(String assgrpname, String basedataId, IDataModel m, String entryKey) {
        boolean isLeaf = false;
        if (assgrpname.startsWith("$$assgrp")) {
            int index = m.getEntryCurrentRowIndex(entryKey);
            DynamicObject acct = (DynamicObject)m.getValue("account", index);
            isLeaf = this.isAcctSetLeaf(acct, assgrpname);
        } else if (assgrpname.startsWith("$$mcfassgrp") || assgrpname.startsWith("$$maincfassgrp")) {
            int index = m.getEntryCurrentRowIndex(entryKey);
            DynamicObject maincf = (DynamicObject)m.getValue("maincfitem", index);
            isLeaf = this.isCFSetLeaf(maincf, assgrpname);
        }
        return isLeaf;
    }

    private void setFilterWithCur(BeforeF7SelectEvent e, IDataModel model, String basedataId, String entityId) {
        if (this.isBankAccount(basedataId)) {
            Long curId = this.getCurrencyId(model, entityId);
            ArrayList<Long> curIds = new ArrayList<Long>(1);
            curIds.add(curId);
            Long orgId = (Long)model.getValue("org_id");
            Long bookTypeId = (Long)model.getValue("booktype_id");
            this.setBankFilter(e, curIds, basedataId, orgId, bookTypeId);
        }
    }

    private void addTemplateVoucherBankFilter(BeforeF7SelectEvent e, IDataModel model, String basedataId, String entityId, int rowIndex) {
        if (this.isBankAccount(basedataId)) {
            Long curId = (Long)model.getValue("currency_id", rowIndex);
            ArrayList<Long> curIds = new ArrayList<Long>(1);
            curIds.add(curId);
            Long orgId = (Long)model.getValue("org_id");
            Long bookTypeId = (Long)model.getValue("bookstype_id");
            this.setBankFilter(e, curIds, basedataId, orgId, bookTypeId);
        }
    }

    private void setDesignateFilterWithCur(BeforeF7SelectEvent e, IDataModel model, String basedataId, String entityId) {
        if (this.isBankAccount(basedataId)) {
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(2);
            IFormView view = SessionManager.getCurrent().getView(((FormDataModel)model).getPageId());
            FormShowParameter parameter = view.getFormShowParameter();
            JSONArray voucherId = (JSONArray)parameter.getCustomParam("voucherid");
            qFilterList.add(new QFilter("id", "in", (Object)voucherId));
            String acctid = (String)parameter.getCustomParam("acctid");
            if (null != acctid) {
                qFilterList.add(new QFilter("entries.account", "in", (Object)Long.parseLong(acctid)));
            }
            DynamicObject[] vouchers = BusinessDataServiceHelper.load((String)"gl_voucher", (String)"entries.currency", (QFilter[])qFilterList.toArray(new QFilter[0]));
            ArrayList<Long> curIds = new ArrayList<Long>(10);
            for (DynamicObject voucher : vouchers) {
                DynamicObjectCollection entries = voucher.getDynamicObjectCollection("entries");
                for (DynamicObject entry : entries) {
                    curIds.add((Long)entry.getDynamicObject("currency").getPkValue());
                }
            }
            Long orgId = Long.parseLong((String)parameter.getCustomParam("org"));
            Long bookTypeId = Long.parseLong((String)parameter.getCustomParam("booktype"));
            this.setBankFilter(e, curIds, basedataId, orgId, bookTypeId);
        }
    }

    private Long getCurrencyId(IDataModel model, String entityId) {
        Long curId = 0L;
        switch (entityId) {
            case "gl_voucher": 
            case "gl_voucher_ajust": {
                int index = model.getEntryCurrentRowIndex("entries");
                curId = (Long)model.getValue("currency_id", index);
                break;
            }
            case "gl_initbalance": 
            case "gl_initacccurrent": 
            case "gl_reciprocal_initlist": 
            case "gl_initcashflowassgrp": {
                curId = (Long)model.getValue("currency_id");
            }
        }
        return curId;
    }

    protected void setTreeBasedataFilter(BeforeF7SelectEvent e, boolean isLeaf) {
        ListFilterParameter filterParameter = ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter();
        List qFilters = filterParameter.getQFilters();
        if (isLeaf) {
            qFilters.add(new QFilter("isleaf", "=", (Object)Boolean.TRUE));
        } else {
            QFilterBuilder qFilterBuilder = QFilterBuilder.removeQFilter(qFilters, "isleaf");
            filterParameter.setQFilters(qFilterBuilder.getFilters());
        }
    }

    private void setOrgFilter(BeforeF7SelectEvent e, long orgId, String basedataId, boolean isLeaf, String orgFunc) {
        if (isLeaf) {
            if (basedataId.equals("bos_org")) {
                String func = orgFunc == null || "".equals(orgFunc) ? "15" : orgFunc;
                List<Long> ids = this.getLeafOrgId(func);
                ListShowParameter list = (ListShowParameter)e.getFormShowParameter();
                list.getListFilterParameter().getQFilters().add(new QFilter("id", "in", ids));
            } else {
                List<Long> ids = this.getLeafOrgId("01");
                ListShowParameter list = (ListShowParameter)e.getFormShowParameter();
                list.getListFilterParameter().getQFilters().add(new QFilter("id", "in", ids));
            }
        }
        if (basedataId.equals("bos_adminorg") && this.isAdminOrg(orgId)) {
            boolean isCurrAndSub;
            AppParam param = new AppParam("83bfebc8000017ac", "10", Long.valueOf(orgId), Long.valueOf(0L));
            Object result = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)"currorg");
            if (null == result) {
                log.info("###\u83b7\u53d6\u63a7\u5236\u7ec4\u7ec7\u53c2\u6570\uff1a" + result);
            }
            boolean bl = isCurrAndSub = null == result ? true : (Boolean)result;
            if (isCurrAndSub) {
                List orgs = OrgServiceHelper.getOrgAllSubIds((Long)orgId, (String)"01", (boolean)true);
                ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)orgs));
            }
        }
    }

    private boolean isCFSetLeaf(DynamicObject basedata, String assgrpname) {
        DynamicObjectCollection checkitementry = basedata.getDynamicObjectCollection("assistentry");
        String flexField = assgrpname.split("__")[1];
        for (DynamicObject obj : checkitementry) {
            long asstId = obj.getLong("asstypeid_id");
            DynamicObject asst = BusinessDataServiceHelper.loadSingleFromCache((Object)asstId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_asstacttype"));
            if (!flexField.equals(asst.getString("flexfield"))) continue;
            return obj.getBoolean("isdetail");
        }
        return false;
    }

    private boolean isAcctSetLeaf(DynamicObject basedata, String assgrpname) {
        DynamicObjectCollection checkitementry = basedata.getDynamicObjectCollection("checkitementry");
        String flexField = assgrpname.split("__")[1];
        for (DynamicObject obj : checkitementry) {
            long asstId = obj.getLong("asstactitem_id");
            DynamicObject asst = BusinessDataServiceHelper.loadSingleFromCache((Object)asstId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_asstacttype"));
            if (!flexField.equals(asst.getString("flexfield"))) continue;
            return obj.getBoolean("isdetail");
        }
        return false;
    }

    private boolean isAdminOrg(long orgId) {
        QFilter filterOrgId = new QFilter("org.id", "=", (Object)orgId);
        QFilter filterTreeType = new QFilter("view.treetype", "=", (Object)"01");
        QFilter filterDefault = new QFilter("view.isdefault", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{filterOrgId, filterTreeType, filterDefault};
        return QueryServiceHelper.exists((String)"bos_org_structure", (QFilter[])filters);
    }

    private List<Long> getLeafOrgId(String orgViewType) {
        ArrayList<Long> ids = new ArrayList<Long>();
        QFilter fviewType = new QFilter("view.treetype", "=", (Object)orgViewType);
        QFilter fisleaf = new QFilter("isleaf", "=", (Object)"1");
        QFilter filterDefault = new QFilter("view.isdefault", "=", (Object)"1");
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryLeftOrg", (String)"bos_org_structure", (String)"org", (QFilter[])new QFilter[]{fviewType, fisleaf, filterDefault}, null);){
            for (Row r : ds) {
                ids.add(r.getLong("org"));
            }
        }
        return ids;
    }

    public void createFlexControlMetas(FlexControlMetaEvent e) {
        String entityId;
        super.createFlexControlMetas(e);
        FlexEdit source = (FlexEdit)e.getSource();
        IFormView formView = source.getView();
        switch (entityId = formView.getEntityId()) {
            case "gl_reciprocal_initlist": 
            case "gl_initacccurrent": {
                Long accountId = (Long)formView.getModel().getValue("account_id");
                DynamicObject account = BusinessDataServiceHelper.loadSingleFromCache((Object)accountId, (String)"bd_accountview");
                String key = source.getFieldKey();
                ArrayList<String> accheckFlexField = new ArrayList<String>();
                DynamicObjectCollection assistEntry = account.getDynamicObjectCollection("checkitementry");
                for (DynamicObject assistRow : assistEntry) {
                    Boolean enaccheck = assistRow.getBoolean("enaccheck");
                    String flexField = assistRow.getString("asstactitem.flexfield");
                    flexField = "$$" + key + "__" + flexField;
                    if (enaccheck.booleanValue()) continue;
                    accheckFlexField.add(flexField);
                }
                e.setVisable(false, accheckFlexField);
                Map<Boolean, List<String>> mustInputType = this.getMustInput_Acct(accountId, key);
                if (mustInputType.containsKey(Boolean.FALSE)) {
                    e.setMustInput(false, mustInputType.get(Boolean.FALSE));
                }
                if (!mustInputType.containsKey(Boolean.TRUE)) break;
                e.setMustInput(true, mustInputType.get(Boolean.TRUE));
                break;
            }
            case "gl_initbalance": 
            case "gl_voucher": 
            case "gl_voucher_ajust": {
                String key = source.getFieldKey();
                if ("mcfassgrp".equals(key)) {
                    long maincfId = (Long)formView.getModel().getValue("maincf_id");
                    if (maincfId == 0L) break;
                    Map<Boolean, List<String>> mustInput = this.getMustInput_Maincf(maincfId, key);
                    if (mustInput.containsKey(Boolean.FALSE)) {
                        e.setMustInput(false, mustInput.get(Boolean.FALSE));
                    }
                    if (!mustInput.containsKey(Boolean.TRUE)) break;
                    e.setMustInput(true, mustInput.get(Boolean.TRUE));
                    break;
                }
                if (!"assgrp".equals(key)) break;
                int entryCurrentRowIndex = formView.getModel().getEntryCurrentRowIndex("entries");
                Long accountId = (Long)formView.getModel().getValue("account_id", entryCurrentRowIndex);
                if (accountId == 0L) break;
                Map<Boolean, List<String>> mustInput = this.getMustInput_Acct(accountId, key);
                if (mustInput.containsKey(Boolean.FALSE)) {
                    e.setMustInput(false, mustInput.get(Boolean.FALSE));
                }
                if (!mustInput.containsKey(Boolean.TRUE)) break;
                e.setMustInput(true, mustInput.get(Boolean.TRUE));
                break;
            }
            case "gl_voucher_cashflowedit": {
                long maincfId;
                String key = source.getFieldKey();
                if (!"maincfassgrp".equals(key) || (maincfId = ((Long)formView.getModel().getValue("maincfitem_id")).longValue()) == 0L) break;
                Map<Boolean, List<String>> mustInput = this.getMustInput_Maincf(maincfId, key);
                if (mustInput.containsKey(Boolean.FALSE)) {
                    e.setMustInput(false, mustInput.get(Boolean.FALSE));
                }
                if (!mustInput.containsKey(Boolean.TRUE)) break;
                e.setMustInput(true, mustInput.get(Boolean.TRUE));
                break;
            }
            case "gl_accdesignate_assgrp": {
                String key = source.getFieldKey();
                long maincfId = (Long)formView.getModel().getValue("maincf_id");
                Map<Boolean, List<String>> mustInput = this.getMustInput_Maincf(maincfId, key);
                if (mustInput.containsKey(Boolean.FALSE)) {
                    e.setMustInput(false, mustInput.get(Boolean.FALSE));
                }
                if (!mustInput.containsKey(Boolean.TRUE)) break;
                e.setMustInput(true, mustInput.get(Boolean.TRUE));
                break;
            }
            case "gl_initcashflowassgrp": {
                this.setMustInput(e, "cfitem_id");
                break;
            }
        }
    }

    private void setMustInput(FlexControlMetaEvent e, String keyAssgrp) {
        FlexEdit source = (FlexEdit)e.getSource();
        String key = source.getFieldKey();
        IFormView formView = source.getView();
        long maincfId = (Long)formView.getModel().getValue(keyAssgrp);
        Map<Boolean, List<String>> mustInput = this.getMustInput_Maincf(maincfId, key);
        if (mustInput.containsKey(Boolean.FALSE)) {
            e.setMustInput(false, mustInput.get(Boolean.FALSE));
        }
        if (mustInput.containsKey(Boolean.TRUE)) {
            e.setMustInput(true, mustInput.get(Boolean.TRUE));
        }
    }

    private Map<Boolean, List<String>> getMustInput_Maincf(long maincfId, String flexkey) {
        DynamicObject maincf = BusinessDataServiceHelper.loadSingleFromCache((Object)maincfId, (String)"gl_cashflowitem");
        DynamicObjectCollection assistEntry = maincf.getDynamicObjectCollection("assistentry");
        return assistEntry.stream().collect(Collectors.groupingBy(x -> x.getBoolean("isrequire"), Collectors.mapping(x -> "$$" + flexkey + "__" + x.getString("asstypeid.flexfield"), Collectors.toList())));
    }

    private Map<Boolean, List<String>> getMustInput_Acct(long acctId, String flexkey) {
        DynamicObject account = BusinessDataServiceHelper.loadSingleFromCache((Object)acctId, (String)"bd_accountview");
        if (account == null) {
            return Collections.emptyMap();
        }
        DynamicObjectCollection assistEntry = account.getDynamicObjectCollection("checkitementry");
        return assistEntry.stream().collect(Collectors.groupingBy(x -> x.getBoolean("isrequire"), Collectors.mapping(x -> "$$" + flexkey + "__" + x.getString("asstactitem.flexfield"), Collectors.toList())));
    }

    public void afterGridBindData(GridFlexBindDataEvent e) {
        String formId;
        EntryGrid eg = (EntryGrid)e.getSource();
        switch (formId = eg.getView().getFormShowParameter().getFormId()) {
            case "gl_voucher": 
            case "gl_voucher_ajust": {
                DynamicObjectCollection col = eg.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entries");
                ArrayList<String> flexField = null;
                int row = 0;
                Map<Long, String> map = this.resovleFlex();
                for (DynamicObject obj : col) {
                    DynamicObject acct = obj.getDynamicObject("account");
                    if (acct == null || !acct.getBoolean("isassist")) {
                        ++row;
                        continue;
                    }
                    flexField = new ArrayList<String>(8);
                    DynamicObjectCollection assCol = acct.getDynamicObjectCollection("checkitementry");
                    for (DynamicObject ass : assCol) {
                        String field;
                        if (!ass.getBoolean("isrequire") || (field = map.get(ass.getLong("asstactitem_id"))) == null) continue;
                        flexField.add("$$assgrp__" + field);
                    }
                    e.setFlexMustInput(true, flexField, row++);
                }
                break;
            }
        }
    }

    private Map<Long, String> resovleFlex() {
        return (Map)ThreadCache.get((Object)"FlexBasedataServiceImpl_resovleFlex", () -> FlexUtils.getAllFlexFieldIdMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (o, n) -> n)));
    }
}

