/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.flex;

import com.google.common.collect.ImmutableSet;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.flex.FlexBDValueCondition;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.property.OrgProp;
import kd.bos.ext.fi.gl.flexplugin.AbstractCustomFlexFilter;
import kd.bos.ext.fi.gl.flexplugin.FilterArgs;
import kd.bos.ext.fi.gl.flexplugin.FilterInfo;
import kd.bos.ext.fi.gl.flexplugin.SourceType;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.bd.util.QFBuilder;

public class FlexFilterUtil {
    private static final Set<String> BANK_ACCOUNT_ENTITY = ImmutableSet.of((Object)"bd_accountbanks", (Object)"am_accountbank", (Object)"cas_accountcash", (Object)"ifm_inneracct");
    private static final Map<String, String> ORG_VIEW_MAP = new HashMap<String, String>();
    private static final Log log = LogFactory.getLog((String)"FlexFilterUtil");
    private static final String BOS_ORG = "bos_org";
    private static final String GL_ASSGRPFILTER = "gl_assgrpfilter";
    private static final String ID = "id";
    private static final String ORG = "org";
    private static final String ACCOUNTTABLE = "accounttable";
    private static final String ENABLE = "enable";
    private static final String ENTRYENTITY_ASSGRP = "entryentity.assgrp";
    private static final String ENTRYENTITY_ACCOUNT = "entryentity.account";
    private static final String ENTRYENTITY_FILTERCONDITION_TAG = "entryentity.filtercondition_tag";
    private static final String TRUE_STR = "1";
    private static final String FALSE_STR = "0";
    private static final String COMMA = ",";
    private static final String POINT = ".";
    private static final String POINT_REGEX = "\\.";
    private static final String PARENT = "parent";
    private static final String AND = "and";
    private static final String OR = "or";

    private FlexFilterUtil() {
    }

    private static boolean checkArgument(long orgId, long accountTableId, long accountId, long assistTypeId) {
        return orgId != 0L && (accountTableId != 0L || accountId != 0L) && assistTypeId != 0L;
    }

    private static QFilter[] buildFilters(long orgId, long accountTableId, List<Long> accIdList, long assistTypeId) {
        QFilter accountFilter;
        QFilter orgFilter = new QFilter(ORG, "=", (Object)orgId);
        QFilter enableFilter = new QFilter(ENABLE, "=", (Object)Boolean.TRUE);
        QFilter assistTypeFilter = new QFilter(ENTRYENTITY_ASSGRP, "=", (Object)assistTypeId);
        if (accIdList.isEmpty()) {
            accountFilter = new QFilter(ENTRYENTITY_ACCOUNT, "=", (Object)0L);
        } else {
            ArrayList<Long> accIdListTemp = new ArrayList<Long>(accIdList.size() + 1);
            accIdListTemp.addAll(accIdList);
            accIdListTemp.add(0L);
            accountFilter = new QFilter(ENTRYENTITY_ACCOUNT, "in", accIdListTemp);
        }
        if (accountTableId > 0L) {
            QFilter accountTableFilter = new QFilter(ACCOUNTTABLE, "=", (Object)accountTableId);
            return new QFilter[]{orgFilter, accountTableFilter, enableFilter, assistTypeFilter, accountFilter};
        }
        return new QFilter[]{orgFilter, enableFilter, assistTypeFilter, accountFilter};
    }

    private static List<Long> getSameMasterIdAndNumberAccountIdList(long accountId) {
        if (accountId <= 0L) {
            return Collections.emptyList();
        }
        DynamicObject accDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)accountId, (String)"bd_accountview", (String)String.join((CharSequence)COMMA, "masterid", "number"));
        if (accDyn == null) {
            return Collections.emptyList();
        }
        QFilter masterIdFilter = new QFilter("masterid", "=", (Object)accDyn.getLong("masterid"));
        QFilter numFilter = new QFilter("number", "=", (Object)accDyn.getString("number"));
        List accPkList = QueryServiceHelper.queryPrimaryKeys((String)"bd_accountview", (QFilter[])new QFilter[]{masterIdFilter, numFilter}, null, (int)-1);
        return accPkList.stream().map(x -> Long.valueOf(x.toString())).collect(Collectors.toList());
    }

    private static FlexBDValueCondition getFlexBdValueCondition(long orgId, long accountTableId, long accountId, long assistTypeId) {
        HashMap<Long, String> accountFilterMap = new HashMap<Long, String>(8);
        List<Long> accIdList = FlexFilterUtil.getSameMasterIdAndNumberAccountIdList(accountId);
        QFilter[] filters = FlexFilterUtil.buildFilters(orgId, accountTableId, accIdList, assistTypeId);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)FlexFilterUtil.class.getName(), (String)GL_ASSGRPFILTER, (String)String.join((CharSequence)COMMA, ENTRYENTITY_ACCOUNT, ENTRYENTITY_FILTERCONDITION_TAG), (QFilter[])filters, null);){
            for (Row row : ds) {
                accountFilterMap.put(row.getLong(ENTRYENTITY_ACCOUNT), row.getString(ENTRYENTITY_FILTERCONDITION_TAG));
            }
        }
        String filterJson = (String)accountFilterMap.get(0L);
        if (accountId > 0L) {
            String accountFilter = (String)accountFilterMap.get(accountId);
            if (StringUtils.isBlank((CharSequence)accountFilter)) {
                for (long accId : accIdList) {
                    String accFilter = (String)accountFilterMap.get(accId);
                    if (!StringUtils.isNotBlank((CharSequence)accFilter)) continue;
                    filterJson = accFilter;
                    break;
                }
            } else {
                filterJson = accountFilter;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)filterJson)) {
            return (FlexBDValueCondition)SerializationUtils.fromJsonString((String)filterJson, FlexBDValueCondition.class);
        }
        return null;
    }

    private static FilterCondition getFilterCondition(FlexBDValueCondition flexBDValueCondition, long orgId, MainEntityType mainEntityType) {
        FilterCondition filterCondition = flexBDValueCondition.getFilterCondition();
        List filterRows = filterCondition.getFilterRow();
        for (SimpleFilterRow simpleFilterRow : filterRows) {
            FlexFilterUtil.handleFilterRow(simpleFilterRow, orgId, mainEntityType);
        }
        return filterCondition;
    }

    private static void handleFilterRow(SimpleFilterRow simpleFilterRow, long orgId, MainEntityType mainEntityType) {
        String compareType = simpleFilterRow.getCompareType();
        if (CompareTypeEnum.CURRENTUSERDEPT.getId().equals(compareType)) {
            simpleFilterRow.setCompareType(CompareTypeEnum.ORGIN.getId());
            String fieldOnCurEntity = simpleFilterRow.getFieldName();
            String fieldOnOrgEntity = fieldOnCurEntity.substring(fieldOnCurEntity.indexOf(POINT) + 1);
            simpleFilterRow.setValue(FlexFilterUtil.getOrgFilterValues(Collections.singletonList(orgId), fieldOnOrgEntity));
        } else if (CompareTypeEnum.CURRENTUSERDEPTS.getId().equals(compareType)) {
            simpleFilterRow.setCompareType(CompareTypeEnum.ORGIN.getId());
            String fieldOnCurEntity = simpleFilterRow.getFieldName();
            String fieldOnOrgEntity = fieldOnCurEntity.substring(fieldOnCurEntity.indexOf(POINT) + 1);
            String orgViewType = FlexFilterUtil.getOrgFieldFuncType(fieldOnCurEntity, mainEntityType);
            List orgIdList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.valueOf(orgViewType), Collections.singletonList(orgId), (boolean)Boolean.TRUE);
            List<FilterValue> values = FlexFilterUtil.getOrgFilterValues(orgIdList, fieldOnOrgEntity);
            simpleFilterRow.setValue(values);
        }
    }

    private static String getOrgFieldFuncType(String fieldOnCurEntity, MainEntityType mainEntityType) {
        Map map = mainEntityType.getAllFields();
        Object[] fieldArray = fieldOnCurEntity.split(POINT_REGEX);
        if (ArrayUtils.isEmpty((Object[])fieldArray)) {
            return "15";
        }
        int index = fieldArray.length <= 1 ? 0 : fieldArray.length - 2;
        Object prop = map.get(fieldArray[index]);
        if (prop instanceof OrgProp) {
            OrgProp orgProp = (OrgProp)prop;
            return orgProp.getOrgFunc() == null ? "15" : orgProp.getOrgFunc();
        }
        return "15";
    }

    private static List<FilterValue> getOrgFilterValues(List<Long> orgIdList, String fieldOnOrgEntity) {
        ArrayList<FilterValue> filterValues = new ArrayList<FilterValue>(orgIdList.size());
        QFilter idFilter = new QFilter(ID, "in", orgIdList);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)FlexFilterUtil.class.getName(), (String)BOS_ORG, (String)fieldOnOrgEntity, (QFilter[])idFilter.toArray(), null);){
            for (Row row : ds) {
                filterValues.add(FlexFilterUtil.parseToFilterValue(row.get(fieldOnOrgEntity)));
            }
        }
        return filterValues;
    }

    private static FilterValue parseToFilterValue(Object value) {
        FilterValue filterValue = new FilterValue();
        if (value instanceof Boolean) {
            boolean booleanValue = (Boolean)value;
            value = booleanValue ? TRUE_STR : FALSE_STR;
        }
        filterValue.setValue((Object)String.valueOf(value));
        return filterValue;
    }

    public static QFilter getAssgrpFilter(long orgId, long accountTableId, long accountId, long assistTypeId, MainEntityType mainEntityType) {
        if (!FlexFilterUtil.checkArgument(orgId, accountTableId, accountId, assistTypeId)) {
            return null;
        }
        FlexBDValueCondition flexBDValueCondition = FlexFilterUtil.getFlexBdValueCondition(orgId, accountTableId, accountId, assistTypeId);
        if (flexBDValueCondition == null) {
            return null;
        }
        FilterCondition filterCondition = FlexFilterUtil.getFilterCondition(flexBDValueCondition, orgId, mainEntityType);
        return FlexFilterUtil.buildFilter(filterCondition, mainEntityType);
    }

    private static QFilter buildFilter(FilterCondition filterCondition, MainEntityType mainEntityType) {
        String orgViewType = null;
        if (BOS_ORG.equals(mainEntityType.getName())) {
            orgViewType = FlexFilterUtil.getOrgViewType(filterCondition);
        }
        FilterBuilder builder = new FilterBuilder(mainEntityType, filterCondition);
        builder.buildFilter();
        QFilter filter = builder.getQFilter();
        if (StringUtils.isNotBlank((CharSequence)orgViewType) && filter != null) {
            return FlexFilterUtil.getOrgParentFilter(orgViewType, filter);
        }
        return filter;
    }

    private static QFilter getOrgParentFilter(String orgViewType, QFilter filter) {
        QFilter topFilter = FlexFilterUtil.getTopFilter(orgViewType, filter);
        List nests = filter.getNests(false);
        int size = nests.size();
        if (size > 0) {
            List<Tuple2<String, QFilter>> op2Filters = FlexFilterUtil.getOp2Filters(orgViewType, nests);
            FlexFilterUtil.handleOp2Filter(topFilter, op2Filters);
        }
        return topFilter;
    }

    private static List<Tuple2<String, QFilter>> getOp2Filters(String orgViewType, List<QFilter.QFilterNest> nests) {
        ArrayList<Tuple2<String, QFilter>> op2Filters = new ArrayList<Tuple2<String, QFilter>>(nests.size());
        for (QFilter.QFilterNest tempNest : nests) {
            String op = tempNest.isAnd() ? AND : OR;
            QFilter tempFilter = tempNest.getFilter();
            QFilter topFilter = FlexFilterUtil.getTopFilter(orgViewType, tempFilter);
            List tempNests = tempFilter.getNests(false);
            if (!tempNests.isEmpty()) {
                List<Tuple2<String, QFilter>> tempOp2Filters = FlexFilterUtil.getOp2Filters(orgViewType, tempNests);
                FlexFilterUtil.handleOp2Filter(topFilter, tempOp2Filters);
            }
            op2Filters.add((Tuple2<String, QFilter>)new Tuple2((Object)op, (Object)topFilter));
        }
        return op2Filters;
    }

    private static QFilter getTopFilter(String orgViewType, QFilter filter) {
        String property = filter.getProperty();
        if (property.startsWith(PARENT)) {
            String parentProp = property.substring(property.indexOf(POINT) + 1);
            QFilter parentFilter = new QFilter(parentProp, filter.getCP(), filter.getValue());
            List parentOrgs = QueryServiceHelper.queryPrimaryKeys((String)BOS_ORG, (QFilter[])parentFilter.toArray(), null, (int)-1);
            List parentOrgIds = parentOrgs.stream().mapToLong(v -> Long.parseLong(v.toString())).boxed().collect(Collectors.toList());
            List allSubordinateOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((String)orgViewType, parentOrgIds, (boolean)true);
            return new QFilter(ID, "in", (Object)allSubordinateOrgs);
        }
        return new QFilter(property, filter.getCP(), filter.getValue());
    }

    private static void handleOp2Filter(QFilter topFilter, List<Tuple2<String, QFilter>> op2Filters) {
        for (Tuple2<String, QFilter> op2filter : op2Filters) {
            String op = (String)op2filter.t1;
            QFilter filter = (QFilter)op2filter.t2;
            if (AND.equals(op)) {
                topFilter = topFilter.and(filter);
                continue;
            }
            if (!OR.equals(op)) continue;
            topFilter = topFilter.or(filter);
        }
    }

    private static String getOrgViewType(FilterCondition filterCondition) {
        List filterRows = filterCondition.getFilterRow();
        for (SimpleFilterRow filterRow : filterRows) {
            String key = filterRow.getFieldName();
            String orgViewType = ORG_VIEW_MAP.get(key);
            if (!StringUtils.isNotBlank((CharSequence)orgViewType)) continue;
            return orgViewType;
        }
        return "15";
    }

    public static boolean checkAssgrpFilter(long orgId, long accountTableId, long accountId, String flexField, Object val, String valField) {
        FlexProperty flexProperty = FlexEntityMetaUtils.getFlexProperty((String)flexField);
        if (null == flexProperty) {
            return true;
        }
        if ("3".equals(flexProperty.getValueType())) {
            return true;
        }
        String valueEntity = flexProperty.getValueSource();
        QFilter filter = FlexFilterUtil.getAssgrpFilter(orgId, accountTableId, accountId, flexProperty.getId(), EntityMetadataCache.getDataEntityType((String)valueEntity));
        if (filter == null) {
            return true;
        }
        filter = filter.and(new QFilter(valField, "=", val));
        return QueryServiceHelper.exists((String)valueEntity, (QFilter[])filter.toArray());
    }

    public static void getAccountbankFilter(String basedataId, BeforeF7SelectEvent e, long orgId, long bookTypeId, List<Long> curIds) {
        ListShowParameter list = (ListShowParameter)e.getFormShowParameter();
        list.setCustomParam("isclearcorefilter", (Object)"true");
        List qFilters = list.getListFilterParameter().getQFilters();
        BasedataEdit edit = (BasedataEdit)e.getSource();
        IFormView view = edit.getView();
        SourceType type = view instanceof ReportView ? SourceType.report : (view instanceof BillView ? SourceType.bill : SourceType.dynamicform);
        FilterInfo info = FlexFilterUtil.getBankQFilter(orgId, bookTypeId, basedataId, type, curIds, qFilters);
        if (info != null) {
            if (info.isIgnoreSysFilter()) {
                qFilters.clear();
            }
            qFilters.add(info.getFilter());
        }
    }

    public static FilterInfo getBankQFilter(long orgId, long bookTypeId, String basedataId, SourceType sourceType, List<Long> curIds, List<QFilter> filters) {
        DynamicObject obj = QueryServiceHelper.queryOne((String)"gl_flexplugin", (String)"plugin", (QFilter[])new QFilter("entity", "=", (Object)basedataId).toArray());
        if (obj != null) {
            try {
                AbstractCustomFlexFilter plugin = (AbstractCustomFlexFilter)Class.forName(obj.getString("plugin")).newInstance();
                Set<Long> bankOrgIds = FlexFilterUtil.getBankOrg(orgId, bookTypeId);
                FilterArgs args = new FilterArgs();
                args.setOrgId(Long.valueOf(orgId));
                args.setClearcorefilter(true);
                args.setqFilters(filters);
                args.setSourceType(sourceType);
                bankOrgIds.add(orgId);
                HashSet<Long> finalBankOrgSet = new HashSet<Long>(16);
                finalBankOrgSet.addAll(bankOrgIds);
                for (Long org : bankOrgIds) {
                    List unitOrgs3 = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"08", (Long)org);
                    finalBankOrgSet.addAll(unitOrgs3);
                }
                args.setBankOrgIds(finalBankOrgSet);
                if (curIds != null) {
                    args.setCurIds(curIds);
                }
                return plugin.getCustomFilter(args);
            }
            catch (Exception ex) {
                log.error("getCustomFilter error." + FlexFilterUtil.printError(ex));
            }
        }
        return null;
    }

    private static String printError(Throwable t) {
        if (null == t) {
            return null;
        }
        StringBuilder upper = new StringBuilder();
        if (null != t.getCause() && null != t.getCause().getStackTrace()) {
            upper.append(FlexFilterUtil.printError(t.getCause())).append("\n");
        }
        StringWriter sW = new StringWriter();
        try (PrintWriter writer = new PrintWriter(sW);){
            t.printStackTrace(writer);
            writer.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return upper.append(sW.toString()).toString();
    }

    private static Set<Long> getBankOrg(Long orgId, long bookTypeId) {
        DynamicObject accountBookDyn = FlexFilterUtil.getAccountBookDyn(orgId, bookTypeId);
        Long accountingSysId = accountBookDyn == null ? 0L : accountBookDyn.getLong("accountingsys.id");
        DynamicObject accountingsys = BusinessDataServiceHelper.loadSingleFromCache((Object)accountingSysId, (String)"bd_accountingsys", (String)"bizorgentry.bizacctorg,bizorgentry.bizorg");
        DynamicObjectCollection bizOrgEntry = accountingsys.getDynamicObjectCollection("bizorgentry");
        HashSet<Long> orgIdSet = new HashSet<Long>();
        for (DynamicObject bizOrgRow : bizOrgEntry) {
            if (orgId == null || !orgId.equals(bizOrgRow.getLong("bizacctorg.id"))) continue;
            orgIdSet.add(bizOrgRow.getLong("bizorg.id"));
        }
        return orgIdSet;
    }

    private static DynamicObject getAccountBookDyn(long orgId, long bookTypeId) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(ORG, "=", orgId);
        qfBuilder.add("bookstype", "=", bookTypeId);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"gl_accountbook", (QFilter[])qfBuilder.toArray());
    }

    public static boolean isBankAccount(String entity) {
        return StringUtils.isNotBlank((CharSequence)entity) && BANK_ACCOUNT_ENTITY.contains(entity.toLowerCase());
    }

    static {
        ORG_VIEW_MAP.put("fisadministrative", "01");
        ORG_VIEW_MAP.put("fispurchase", "02");
        ORG_VIEW_MAP.put("fissale", "03");
        ORG_VIEW_MAP.put("fisproduce", "04");
        ORG_VIEW_MAP.put("fisinventory", "05");
        ORG_VIEW_MAP.put("fisqc", "06");
        ORG_VIEW_MAP.put("fisbankroll", "08");
        ORG_VIEW_MAP.put("fisasset", "09");
        ORG_VIEW_MAP.put("fisaccounting", "10");
        ORG_VIEW_MAP.put("fishr", "11");
        ORG_VIEW_MAP.put("fisscc", "12");
        ORG_VIEW_MAP.put("fisbudget", "13");
    }
}

