/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.flex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.fi.ai.PresetCashItemUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class FlexRelationUtil {
    public static List<QFilter> getFilterByRelationMap(String fromFlex, Map<String, Object> toFlexToVal, Long orgid) {
        Map<String, String> bToProp = FlexRelationUtil.getRelationMapByFromFlex(fromFlex, toFlexToVal.keySet(), orgid);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        for (Map.Entry<String, String> bprop : bToProp.entrySet()) {
            Object toFlexVal = toFlexToVal.get(bprop.getKey());
            if (FlexRelationUtil.isValNull(toFlexVal)) continue;
            QFilter filter = new QFilter(bprop.getValue(), "=", toFlexVal);
            filters.add(filter);
        }
        return filters;
    }

    public static Map<String, String> getRelationMapByFromFlex(String fromFlex, Set<String> flexs, Long orgid) {
        String selectFields = "targetassgrp.flexfield toflex, propvalue";
        List<Object> assgrRelaPKByOrg = FlexRelationUtil.getAssgrRelaPKByOrg(orgid);
        QFilter[] filters = new QFilter[]{new QFilter("assgrp.flexfield", "=", (Object)fromFlex), new QFilter("targetassgrp.flexfield", "in", flexs), new QFilter("enable", "=", (Object)Character.valueOf('1')), new QFilter("id", "in", assgrRelaPKByOrg)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.gl.util.FlexRelationUtil.getRelationMap", (String)"gl_assgrprelation", (String)selectFields, (QFilter[])filters, null);){
            HashMap<String, String> bToProp = new HashMap<String, String>(16);
            for (Row row : dataSet) {
                String toflex = row.getString("toflex");
                String prop = row.getString("propvalue");
                bToProp.put(toflex, prop);
            }
            HashMap<String, String> hashMap = bToProp;
            return hashMap;
        }
    }

    public static boolean isValNull(Object obj) {
        return StringUtils.isBlank((Object)obj) || "0".equals(String.valueOf(obj));
    }

    public static List<Object> getAssgrRelaPKByOrg(Long orgId) {
        List<Long> superOrg = FlexRelationUtil.getAllSuperiorOrgIdsOrderByLevel(orgId);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter allCtrl = new QFilter("ctrlstrategy", "=", (Object)"5");
        if (superOrg != null && !superOrg.isEmpty()) {
            QFilter orgFilter = new QFilter("createorg.id", "in", superOrg).and(new QFilter("ctrlstrategy", "=", (Object)"6"));
            filters.add(allCtrl.or(orgFilter));
        } else {
            filters.add(allCtrl);
        }
        return QueryServiceHelper.queryPrimaryKeys((String)"gl_assgrprelation", (QFilter[])filters.toArray(new QFilter[0]), null, (int)-1);
    }

    public static List<Long> getAllSuperiorOrgIdsOrderByLevel(long orgid) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (orgid == 0L) {
            return ids;
        }
        QFilter f2 = new QFilter("view.number", "=", (Object)"10");
        QFilter f3 = new QFilter("org", "=", (Object)orgid);
        String longNumber = "";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)PresetCashItemUtil.class.getName(), (String)"bos_org_structure", (String)"longnumber", (QFilter[])new QFilter[]{f2, f3}, null);){
            if (ds.hasNext()) {
                Row row = ds.next();
                longNumber = row.getString("longnumber");
            }
        }
        if (StringUtils.isBlank((CharSequence)longNumber) || longNumber.indexOf("!") == 0) {
            return ids;
        }
        String[] numbers = StringUtils.substringBeforeLast((String)longNumber, (String)"!").split("!");
        QFilter numberFilter = new QFilter("org.number", "in", (Object)numbers);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)PresetCashItemUtil.class.getName(), (String)"bos_org_structure", (String)"org", (QFilter[])new QFilter[]{f2, numberFilter}, (String)"level");){
            while (ds.hasNext()) {
                Row row = ds.next();
                ids.add(row.getLong("org"));
            }
        }
        if (!ids.contains(orgid)) {
            ids.add(orgid);
        }
        return ids;
    }
}

