/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.accounthealth;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.bd.accounthealth.IAccountChecker;
import kd.fi.bd.accounthealth.executor.IAccountBuild;
import kd.fi.bd.accounthealth.executor.IAccountCheck;

public class OrgCrossChecker
implements IAccountChecker {
    private final IAccountBuild builder;
    private final IAccountCheck checker;
    protected Long accountTableId;
    protected Long orgId;
    protected Long parentOrgId;
    private Map<String, DynamicObject> longNumberAccountMaps;
    private Map<String, DynamicObject> parentLongNumberAccountMaps;

    public Map<String, DynamicObject> getLongNumberAccountMaps() {
        return this.longNumberAccountMaps;
    }

    public OrgCrossChecker(Long accountTableId, Long orgId, Long parentOrgId, IAccountBuild builder, IAccountCheck checker) {
        this.accountTableId = accountTableId;
        this.orgId = orgId;
        this.parentOrgId = parentOrgId;
        this.builder = builder;
        this.checker = checker;
    }

    @Override
    public void check() throws Exception {
        this.longNumberAccountMaps = this.builder.build(this.accountTableId, this.orgId);
        this.parentLongNumberAccountMaps = this.builder.build(this.accountTableId, this.parentOrgId);
        this.checker.check(this);
    }

    public Long getAccountTableId() {
        return this.accountTableId;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public Long getParentOrgId() {
        return this.parentOrgId;
    }

    public Map<String, DynamicObject> getParentLongNumberAccountMaps() {
        return this.parentLongNumberAccountMaps;
    }
}

