/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.accounthealth.executor;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bd.accounthealth.CheckResult;
import kd.fi.bd.accounthealth.IAccountChecker;
import kd.fi.bd.accounthealth.executor.IAccountCheck;

public abstract class AbstractAccountCheck
implements IAccountCheck {
    private List<DynamicObject> taskResults = new ArrayList<DynamicObject>(16);
    protected IAccountChecker accountChecker;

    protected DynamicObject buildCheckLog(DynamicObject account, Long useOrg, Date date, List<CheckResult> checkResultList) {
        DynamicObject healthCheckObj = BusinessDataServiceHelper.newDynamicObject((String)"bd_account_checkresult");
        healthCheckObj.set("acctnumber", (Object)account.getString("number"));
        healthCheckObj.set("longnumber", (Object)account.getString("longnumber"));
        healthCheckObj.set("accounttable", (Object)account.getDynamicObject("accounttable"));
        healthCheckObj.set("accountid", (Object)account.getLong("id"));
        healthCheckObj.set("useorg", (Object)useOrg);
        healthCheckObj.set("createtime", (Object)date);
        healthCheckObj.set("modifytime", (Object)date);
        DynamicObjectCollection newColl = healthCheckObj.getDynamicObjectCollection("entryentity");
        StringBuilder error = new StringBuilder();
        int seq = 1;
        for (CheckResult checkResult : checkResultList) {
            error.append(checkResult.getPropDetail().getName()).append("\u3001");
            DynamicObject newRow = new DynamicObject(newColl.getDynamicObjectType());
            newRow.set("detailcategory", (Object)checkResult.getPropDetail().getType());
            newRow.set("seq", (Object)seq++);
            newRow.set("checkdetail", (Object)(checkResult.getMessage().length() > 500 ? checkResult.getMessage().substring(0, 500) : checkResult.getMessage()));
            newColl.add((Object)newRow);
        }
        int index = error.lastIndexOf("\u3001");
        error.deleteCharAt(index);
        String result = ResManager.loadKDString((String)"%s\u4e0e\u4e0a\u7ea7\u79d1\u76ee\u4e0d\u7b26\u5408\u7ba1\u63a7", (String)"AbstractAccountCheck_0", (String)"fi-bd-common", (Object[])new Object[]{error});
        result = result.length() > 500 ? result.substring(0, 500) : result;
        healthCheckObj.set("checkres", (Object)result);
        return healthCheckObj;
    }

    protected void persistCheckLog() {
        if (!this.taskResults.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])this.taskResults.toArray(new DynamicObject[0]));
        }
    }

    protected void pushLog(DynamicObject dynamicObject) {
        this.taskResults.add(dynamicObject);
        if (this.taskResults.size() > 100) {
            this.persistCheckLog();
            this.taskResults.clear();
        }
    }
}

