/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.accounthealth.task;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.ext.fi.ai.FIDataCheckTask;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.accounthealth.CheckContext;
import kd.fi.bd.accounthealth.impl.AccountCheckServiceImpl;
import kd.fi.bd.util.BillParamUtil;
import org.apache.commons.collections4.CollectionUtils;

public class AccountCheckAutoTask
implements FIDataCheckTask {
    private static final DBRoute ROUTE_FI = DBRoute.of((String)"fi");
    private static final Log log = LogFactory.getLog(AccountCheckAutoTask.class);

    public boolean execute() {
        HashSet<Long> accountTableIdSet = new HashSet<Long>(8);
        try {
            boolean isOpen = BillParamUtil.getBooleanValue("P9H6JC5EVP1", "fi.bd.account.healthcheck", false);
            if (!isOpen) {
                log.info("check switch not open");
                return true;
            }
            QFilter enableFilter = new QFilter("enable", "=", (Object)true);
            try (DataSet tableSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_accounttable", (String)"id", (QFilter[])new QFilter[]{enableFilter}, null);){
                while (tableSet.hasNext()) {
                    Row row = tableSet.next();
                    accountTableIdSet.add(row.getLong(0));
                }
            }
            log.info("check accountTableId:{}", accountTableIdSet);
            if (CollectionUtils.isEmpty(accountTableIdSet)) {
                return true;
            }
            Set<Long> orgSet = this.queryNeedCheckOrgList();
            if (CollectionUtils.isEmpty(orgSet)) {
                return true;
            }
            log.info("check orgSet:{}", orgSet);
            accountTableIdSet.forEach(accountTableId -> {
                CheckContext context = new CheckContext((long)accountTableId, orgSet);
                AccountCheckServiceImpl accountCheckService = new AccountCheckServiceImpl(context);
                accountCheckService.check();
            });
            this.updateStatus(orgSet);
        }
        catch (Exception e) {
            log.error("AccountCheckAutoTask Exception:" + e.getMessage(), (Throwable)e);
        }
        return true;
    }

    protected Set<Long> queryNeedCheckOrgList() {
        QFilter checkFilter = new QFilter("checked", "=", (Object)false);
        HashSet<Long> orgSet = new HashSet<Long>(8);
        try (DataSet orgDateSet = QueryServiceHelper.queryDataSet((String)"AccountCheckAutoTask", (String)"bd_org_changeinfo", (String)"org", (QFilter[])checkFilter.toArray(), null);){
            for (Row row : orgDateSet) {
                orgSet.add(row.getLong(0));
            }
        }
        return orgSet;
    }

    protected void updateStatus(Set<Long> orgSet) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("UPDATE T_BD_ORG_CHANGEINFO SET FCHECKED = '1' WHERE ", new Object[0]);
        sqlBuilder.appendIn("FORGID", new ArrayList<Long>(orgSet));
        sqlBuilder.append("AND FCHECKED <>'1'", new Object[0]);
        DB.execute((DBRoute)ROUTE_FI, (SqlBuilder)sqlBuilder);
    }
}

