/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.accounthealth.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.accounthealth.CheckResult;
import kd.fi.bd.enums.AccountPropDetail;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AccountPropCheckUtil {
    private static final String OWN_ORG_ACCOUNT = "0";
    private static final String SUP_ORG_ACCOUNT = "1";
    private static final String SEPARATOR = ResManager.loadKDString((String)"\u3001", (String)"AccountPropCheckUtil_44", (String)"fi-bd-common", (Object[])new Object[0]);

    public static List<CheckResult> validateAccountControlRelation(String number, String type, DynamicObject parentOrg, Map<String, Object> relativeChildProp, Map<String, Object> relativeSuperProp) {
        boolean childBank;
        boolean superBank;
        boolean childCash;
        boolean superCash;
        String msg;
        ArrayList<CheckResult> checkResultList = new ArrayList<CheckResult>(16);
        Object superDirection = relativeSuperProp.get("accrualdirection");
        Object childDirection = relativeChildProp.get("accrualdirection");
        String orgNumber = "";
        String orgName = "";
        if (!ObjectUtils.isEmpty((Object)parentOrg)) {
            orgNumber = parentOrg.getString("number");
            orgName = parentOrg.getString("name");
        }
        if (!"nocontrol".equals(superDirection) && !superDirection.equals(childDirection)) {
            msg = OWN_ORG_ACCOUNT.equals(type) ? ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee%1$s\u79d1\u76ee\u5f55\u5165\u65b9\u5411\u4e3a%2$s\uff0c\u6b64\u79d1\u76ee\u4e3a%3$s\u3002", (String)"AccountPropCheckUtil_0", (String)"fi-bd-common", (Object[])new Object[]{number, AccountPropCheckUtil.changeDirection(superDirection), AccountPropCheckUtil.changeDirection(childDirection)}) : ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\uff08%1$s %2$s\uff09%3$s\u79d1\u76ee\u5f55\u5165\u65b9\u5411\u4e3a%4$s\uff0c\u6b64\u79d1\u76ee\u4e3a%5$s\u3002", (String)"AccountPropCheckUtil_1", (String)"fi-bd-common", (Object[])new Object[]{orgNumber, orgName, number, AccountPropCheckUtil.changeDirection(superDirection), AccountPropCheckUtil.changeDirection(childDirection)});
            checkResultList.add(new CheckResult(AccountPropDetail.ACC_RUAL_DIRECTION, msg));
        }
        int superControlLevel = Integer.parseInt(relativeSuperProp.get("orgcontrollevel").toString());
        int childControlLevel = Integer.parseInt(relativeChildProp.get("orgcontrollevel").toString());
        if (childControlLevel < superControlLevel) {
            msg = OWN_ORG_ACCOUNT.equals(type) ? ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee%1$s\u63a7\u5236\u7ea7\u6b21\u4e3a%2$s\uff0c\u6b64\u79d1\u76ee\u63a7\u5236\u7ea7\u6b21\u4e3a%3$s\u3002", (String)"AccountPropCheckUtil_2", (String)"fi-bd-common", (Object[])new Object[]{number, superControlLevel, childControlLevel}) : ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\uff08%1$s %2$s\uff09%3$s\u79d1\u76ee\u63a7\u5236\u7ea7\u6b21\u4e3a%4$s\uff0c\u6b64\u79d1\u76ee\u4e3a%5$s\u3002", (String)"AccountPropCheckUtil_3", (String)"fi-bd-common", (Object[])new Object[]{orgNumber, orgName, number, superControlLevel, childControlLevel});
            checkResultList.add(new CheckResult(AccountPropDetail.CONTROL_LEVEL, msg));
        }
        if (!((Boolean)relativeSuperProp.get("isallowca")).booleanValue() && ((Boolean)relativeChildProp.get("isallowca")).booleanValue()) {
            msg = OWN_ORG_ACCOUNT.equals(type) ? ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee%s\u4e0d\u5141\u8bb8\u516c\u53f8\u589e\u52a0\u4e0b\u7ea7\u79d1\u76ee\uff0c\u6b64\u79d1\u76ee\u5141\u8bb8\u3002", (String)"AccountPropCheckUtil_4", (String)"fi-bd-common", (Object[])new Object[]{number}) : ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\uff08%1$s %2$s\uff09%3$s\u4e0d\u5141\u8bb8\u516c\u53f8\u589e\u52a0\u4e0b\u7ea7\u79d1\u76ee\uff0c\u6b64\u79d1\u76ee\u5141\u8bb8\u3002", (String)"AccountPropCheckUtil_5", (String)"fi-bd-common", (Object[])new Object[]{orgNumber, orgName, number});
            checkResultList.add(new CheckResult(AccountPropDetail.ALLOW_ADD, msg));
        }
        if (!((Boolean)relativeSuperProp.get("ismanual")).booleanValue() && ((Boolean)relativeChildProp.get("ismanual")).booleanValue()) {
            msg = OWN_ORG_ACCOUNT.equals(type) ? ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee%s\u4e0d\u5141\u8bb8\u624b\u5de5\u5f55\u5165\uff0c\u6b64\u79d1\u76ee\u5141\u8bb8\u3002", (String)"AccountPropCheckUtil_6", (String)"fi-bd-common", (Object[])new Object[]{number}) : ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\uff08%1$s %2$s\uff09%3$s\u4e0d\u5141\u8bb8\u624b\u5de5\u5f55\u5165\uff0c\u6b64\u79d1\u76ee\u5141\u8bb8\u3002", (String)"AccountPropCheckUtil_7", (String)"fi-bd-common", (Object[])new Object[]{orgNumber, orgName, number});
            checkResultList.add(new CheckResult(AccountPropDetail.MANUAL, msg));
        }
        if ((superCash = ((Boolean)relativeSuperProp.get("iscash")).booleanValue()) != (childCash = ((Boolean)relativeChildProp.get("iscash")).booleanValue())) {
            msg = OWN_ORG_ACCOUNT.equals(type) ? ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee%1$s%2$s\u73b0\u91d1\u79d1\u76ee\uff0c\u6b64\u79d1\u76ee%3$s\u3002", (String)"AccountPropCheckUtil_8", (String)"fi-bd-common", (Object[])new Object[]{number, AccountPropCheckUtil.changeBooleanTipWorlds(superCash), AccountPropCheckUtil.changeBooleanTipWorlds(childCash)}) : ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\uff08%1$s %2$s\uff09%3$s\u79d1\u76ee%4$s\u73b0\u91d1\u79d1\u76ee\uff0c\u6b64\u79d1\u76ee%5$s\u3002", (String)"AccountPropCheckUtil_9", (String)"fi-bd-common", (Object[])new Object[]{orgNumber, orgName, number, AccountPropCheckUtil.changeBooleanTipWorlds(superCash), AccountPropCheckUtil.changeBooleanTipWorlds(childCash)});
            checkResultList.add(new CheckResult(AccountPropDetail.CASH, msg));
        }
        if ((superBank = ((Boolean)relativeSuperProp.get("isbank")).booleanValue()) != (childBank = ((Boolean)relativeChildProp.get("isbank")).booleanValue())) {
            msg = OWN_ORG_ACCOUNT.equals(type) ? ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee%1$s%2$s\u94f6\u884c\u79d1\u76ee\uff0c\u6b64\u79d1\u76ee%3$s\u3002", (String)"AccountPropCheckUtil_10", (String)"fi-bd-common", (Object[])new Object[]{number, AccountPropCheckUtil.changeBooleanTipWorlds(superBank), AccountPropCheckUtil.changeBooleanTipWorlds(childBank)}) : ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\uff08%1$s %2$s\uff09%3$s\u79d1\u76ee%4$s\u94f6\u884c\u79d1\u76ee\uff0c\u6b64\u79d1\u76ee%5$s\u3002", (String)"AccountPropCheckUtil_11", (String)"fi-bd-common", (Object[])new Object[]{orgNumber, orgName, number, AccountPropCheckUtil.changeBooleanTipWorlds(superBank), AccountPropCheckUtil.changeBooleanTipWorlds(childBank)});
            checkResultList.add(new CheckResult(AccountPropDetail.BANK, msg));
        }
        if (((Boolean)relativeSuperProp.get("iscashequivalent")).booleanValue() && !((Boolean)relativeChildProp.get("iscashequivalent")).booleanValue()) {
            msg = OWN_ORG_ACCOUNT.equals(type) ? ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee%s\u662f\u73b0\u91d1\u7b49\u4ef7\u7269\u7c7b\u79d1\u76ee\uff0c\u6b64\u79d1\u76ee\u4e0d\u662f\u3002", (String)"AccountPropCheckUtil_12", (String)"fi-bd-common", (Object[])new Object[]{number}) : ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\uff08%1$s %2$s\uff09%3$s\u79d1\u76ee\u662f\u73b0\u91d1\u7b49\u4ef7\u7269\u7c7b\u79d1\u76ee\uff0c\u6b64\u79d1\u76ee\u4e0d\u662f\u3002", (String)"AccountPropCheckUtil_13", (String)"fi-bd-common", (Object[])new Object[]{orgNumber, orgName, number});
            checkResultList.add(new CheckResult(AccountPropDetail.CASH_EQUIVALENT, msg));
        }
        if (((Boolean)relativeSuperProp.get("isjournal")).booleanValue() && !((Boolean)relativeChildProp.get("isjournal")).booleanValue()) {
            msg = OWN_ORG_ACCOUNT.equals(type) ? ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee%s\u52fe\u9009\u767b\u65e5\u8bb0\u8d26\uff0c\u6b64\u79d1\u76ee\u672a\u52fe\u9009\u3002", (String)"AccountPropCheckUtil_14", (String)"fi-bd-common", (Object[])new Object[]{number}) : ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\uff08%1$s %2$s\uff09%3$s\u79d1\u76ee\u52fe\u9009\u767b\u65e5\u8bb0\u8d26\uff0c\u6b64\u79d1\u76ee\u672a\u52fe\u9009\u3002", (String)"AccountPropCheckUtil_15", (String)"fi-bd-common", (Object[])new Object[]{orgNumber, orgName, number});
            checkResultList.add(new CheckResult(AccountPropDetail.JOURNAL, msg));
        }
        if (((Boolean)relativeSuperProp.get("acnotice")).booleanValue() && !((Boolean)relativeChildProp.get("acnotice")).booleanValue()) {
            msg = OWN_ORG_ACCOUNT.equals(type) ? ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee%s\u52fe\u9009\u5f80\u6765\u901a\u77e5\uff0c\u6b64\u79d1\u76ee\u672a\u52fe\u9009\u3002", (String)"AccountPropCheckUtil_16", (String)"fi-bd-common", (Object[])new Object[]{number}) : ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\uff08%1$s %2$s\uff09%3$s\u79d1\u76ee\u52fe\u9009\u5f80\u6765\u901a\u77e5\uff0c\u6b64\u79d1\u76ee\u672a\u52fe\u9009\u3002", (String)"AccountPropCheckUtil_17", (String)"fi-bd-common", (Object[])new Object[]{orgNumber, orgName, number});
            checkResultList.add(new CheckResult(AccountPropDetail.AC_NOTICE, msg));
        }
        if (((Boolean)relativeSuperProp.get("ischangecurrency")).booleanValue() && !((Boolean)relativeChildProp.get("ischangecurrency")).booleanValue()) {
            msg = OWN_ORG_ACCOUNT.equals(type) ? ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee%s\u52fe\u9009\u671f\u672b\u8c03\u6c47\uff0c\u6b64\u79d1\u76ee\u672a\u52fe\u9009\u3002", (String)"AccountPropCheckUtil_18", (String)"fi-bd-common", (Object[])new Object[]{number}) : ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\uff08%1$s %2$s\uff09%3$s\u79d1\u76ee\u52fe\u9009\u671f\u672b\u8c03\u6c47\uff0c\u6b64\u79d1\u76ee\u672a\u52fe\u9009\u3002", (String)"AccountPropCheckUtil_19", (String)"fi-bd-common", (Object[])new Object[]{orgNumber, orgName, number});
            checkResultList.add(new CheckResult(AccountPropDetail.CHANGE_CURRENCY, msg));
        }
        if (((Boolean)relativeSuperProp.get("isqty")).booleanValue() && !((Boolean)relativeChildProp.get("isqty")).booleanValue()) {
            msg = OWN_ORG_ACCOUNT.equals(type) ? ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee%s\u52fe\u9009\u6570\u91cf\u6838\u7b97\uff0c\u6b64\u79d1\u76ee\u672a\u52fe\u9009\u3002", (String)"AccountPropCheckUtil_20", (String)"fi-bd-common", (Object[])new Object[]{number}) : ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\uff08%1$s %2$s\uff09%3$s\u79d1\u76ee\u52fe\u9009\u6570\u91cf\u6838\u7b97\uff0c\u6b64\u79d1\u76ee\u672a\u52fe\u9009\u3002", (String)"AccountPropCheckUtil_21", (String)"fi-bd-common", (Object[])new Object[]{orgNumber, orgName, number});
            checkResultList.add(new CheckResult(AccountPropDetail.QTY, msg));
        }
        Object childCurrency = relativeChildProp.get("acctcurrency");
        Object superCurrency = relativeSuperProp.get("acctcurrency");
        if ("nocurrency".equals(superCurrency) && !"nocurrency".equals(childCurrency)) {
            msg = OWN_ORG_ACCOUNT.equals(type) ? ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee%1$s\u5e01\u79cd\u6838\u7b97\u8bbe\u7f6e\u4e3a\u4e0d\u6838\u7b97\u5916\u5e01\uff0c\u6b64\u79d1\u76ee\u5e01\u79cd\u6838\u7b97\u8bbe\u7f6e\u4e3a%2$s\u3002", (String)"AccountPropCheckUtil_22", (String)"fi-bd-common", (Object[])new Object[]{number, AccountPropCheckUtil.changeCurrencyType(childCurrency)}) : ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\uff08%1$s %2$s\uff09%3$s\u79d1\u76ee\u5e01\u79cd\u6838\u7b97\u8bbe\u7f6e\u4e3a\u4e0d\u6838\u7b97\u5916\u5e01\uff0c\u6b64\u79d1\u76ee\u5e01\u79cd\u6838\u7b97\u8bbe\u7f6e\u4e3a%4$s\u3002", (String)"AccountPropCheckUtil_23", (String)"fi-bd-common", (Object[])new Object[]{orgNumber, orgName, number, AccountPropCheckUtil.changeCurrencyType(childCurrency)});
            checkResultList.add(new CheckResult(AccountPropDetail.CURRENCY, msg));
        }
        if ("descurrency".equals(superCurrency) && "allcurrency".equals(childCurrency)) {
            msg = OWN_ORG_ACCOUNT.equals(type) ? ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee%s\u5e01\u79cd\u6838\u7b97\u8bbe\u7f6e\u4e3a\u6307\u5b9a\u6838\u7b97\u5e01\u79cd\uff0c\u6b64\u79d1\u76ee\u5e01\u79cd\u6838\u7b97\u8bbe\u7f6e\u4e3a\u6838\u7b97\u6240\u6709\u5e01\u79cd\u3002", (String)"AccountPropCheckUtil_24", (String)"fi-bd-common", (Object[])new Object[]{number}) : ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\uff08%1$s %2$s\uff09%3$s\u79d1\u76ee\u5e01\u79cd\u6838\u7b97\u8bbe\u7f6e\u4e3a\u6307\u5b9a\u6838\u7b97\u5e01\u79cd\uff0c\u6b64\u79d1\u76ee\u5e01\u79cd\u6838\u7b97\u8bbe\u7f6e\u4e3a\u6838\u7b97\u6240\u6709\u5e01\u79cd\u3002", (String)"AccountPropCheckUtil_25", (String)"fi-bd-common", (Object[])new Object[]{orgNumber, orgName, number});
            checkResultList.add(new CheckResult(AccountPropDetail.CURRENCY, msg));
        }
        if ("descurrency".equals(superCurrency)) {
            DynamicObjectCollection parDycol = (DynamicObjectCollection)relativeSuperProp.get("currencyentry");
            DynamicObjectCollection subDycol = (DynamicObjectCollection)relativeChildProp.get("currencyentry");
            ArrayList<Long> parList = new ArrayList<Long>(parDycol.size());
            ArrayList<Long> subList = new ArrayList<Long>(subDycol.size());
            if (parDycol != null) {
                for (DynamicObject parDy : parDycol) {
                    parList.add(parDy.getLong("currency_id"));
                }
            }
            if (subDycol != null) {
                for (DynamicObject subDy : subDycol) {
                    subList.add(subDy.getLong("currency_id"));
                }
            }
            if (!parList.containsAll(subList)) {
                List<String> parNameList = AccountPropCheckUtil.getCurrencyNames(parList);
                List<String> subNameList = AccountPropCheckUtil.getCurrencyNames(subList);
                String parName = StringUtils.join((Iterable)parNameList, (String)SEPARATOR);
                String subName = StringUtils.join(subNameList, (String)SEPARATOR);
                msg = OWN_ORG_ACCOUNT.equals(type) ? ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee%1$s\u5e01\u79cd\u6838\u7b97\u8bbe\u7f6e\u4e3a%2$s\uff0c\u6b64\u79d1\u76ee\u5e01\u79cd\u6838\u7b97\u8bbe\u7f6e\u4e3a%3$s\u3002", (String)"AccountPropCheckUtil_26", (String)"fi-bd-common", (Object[])new Object[]{number, parName, subName}) : ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\uff08%1$s %2$s\uff09%3$s\u79d1\u76ee\u5e01\u79cd\u6838\u7b97\u8bbe\u7f6e\u4e3a%4$s\uff0c\u6b64\u79d1\u76ee\u5e01\u79cd\u6838\u7b97\u8bbe\u7f6e\u4e3a%5$s\u3002", (String)"AccountPropCheckUtil_27", (String)"fi-bd-common", (Object[])new Object[]{orgNumber, orgName, number, parName, subName});
                checkResultList.add(new CheckResult(AccountPropDetail.CURRENCY, msg));
            }
        }
        DynamicObjectCollection parAssistEntry = (DynamicObjectCollection)relativeSuperProp.get("checkitementry");
        DynamicObjectCollection assistEntry = (DynamicObjectCollection)relativeChildProp.get("checkitementry");
        HashMap parFlexfields = new HashMap(parAssistEntry.size());
        HashMap<String, String> parAssNameMap = new HashMap<String, String>(parAssistEntry.size());
        for (Object dyn : parAssistEntry) {
            DynamicObject assgrp = dyn.getDynamicObject("asstactitem");
            ArrayList<Boolean> propList = new ArrayList<Boolean>(3);
            propList.add(dyn.getBoolean("isrequire"));
            propList.add(dyn.getBoolean("isdetail"));
            propList.add(dyn.getBoolean("enaccheck"));
            String assKey = assgrp.getString("flexfield");
            parFlexfields.put(assKey, propList);
            parAssNameMap.put(assKey, assgrp.getString("name"));
        }
        HashMap subflexfields = new HashMap(assistEntry.size());
        for (DynamicObject dyn : assistEntry) {
            DynamicObject assgrp = dyn.getDynamicObject("asstactitem");
            ArrayList<Boolean> propList = new ArrayList<Boolean>(3);
            propList.add(dyn.getBoolean("isrequire"));
            propList.add(dyn.getBoolean("isdetail"));
            propList.add(dyn.getBoolean("enaccheck"));
            String assKey = assgrp.getString("flexfield");
            subflexfields.put(assKey, propList);
        }
        ArrayList parentAssTypeList = new ArrayList(8);
        ArrayList parentAssRequireList = new ArrayList(8);
        ArrayList parentAssDetailList = new ArrayList(8);
        ArrayList parentAssAccheckList = new ArrayList(8);
        for (Map.Entry parent : parFlexfields.entrySet()) {
            ArrayList subPropList = (ArrayList)subflexfields.get(parent.getKey());
            ArrayList parPropList = (ArrayList)parFlexfields.get(parent.getKey());
            if (subPropList != null && parPropList != null) {
                boolean parIsRequire = (Boolean)parPropList.get(0);
                boolean parIsDetail = (Boolean)parPropList.get(1);
                boolean parEnAccheck = (Boolean)parPropList.get(2);
                boolean subIsRequire = (Boolean)subPropList.get(0);
                boolean subIsDetail = (Boolean)subPropList.get(1);
                boolean subEnAccheck = (Boolean)subPropList.get(2);
                if (parIsRequire && !subIsRequire) {
                    parentAssRequireList.add(parAssNameMap.get(parent.getKey()));
                }
                if (parIsDetail && !subIsDetail) {
                    parentAssDetailList.add(parAssNameMap.get(parent.getKey()));
                }
                if (!parEnAccheck || subEnAccheck) continue;
                parentAssAccheckList.add(parAssNameMap.get(parent.getKey()));
                continue;
            }
            parentAssTypeList.add(parAssNameMap.get(parent.getKey()));
        }
        if (CollectionUtils.isNotEmpty(parentAssTypeList)) {
            String parentAssType = StringUtils.join(parentAssTypeList, (String)SEPARATOR);
            msg = OWN_ORG_ACCOUNT.equals(type) ? ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee%1$s\u79d1\u76ee\u6709%2$s\u7ef4\u5ea6\uff0c\u6b64\u79d1\u76ee\u65e0\u6b64\u7ef4\u5ea6\u3002", (String)"AccountPropCheckUtil_28", (String)"fi-bd-common", (Object[])new Object[]{number, parentAssType}) : ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\uff08%1$s %2$s\uff09%3$s\u79d1\u76ee\u6709%4$s\u7ef4\u5ea6\uff0c\u6b64\u79d1\u76ee\u65e0\u6b64\u7ef4\u5ea6\u3002", (String)"AccountPropCheckUtil_29", (String)"fi-bd-common", (Object[])new Object[]{orgNumber, orgName, number, parentAssType});
            checkResultList.add(new CheckResult(AccountPropDetail.ASST_TYPE, msg));
        }
        if (CollectionUtils.isNotEmpty(parentAssDetailList)) {
            String parentAssDetail = StringUtils.join(parentAssDetailList, (String)SEPARATOR);
            msg = OWN_ORG_ACCOUNT.equals(type) ? ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee%1$s%2$s\u7ef4\u5ea6\u52fe\u9009\u660e\u7ec6\u5c5e\u6027\uff0c\u6b64\u79d1\u76ee\u672a\u52fe\u9009\u3002", (String)"AccountPropCheckUtil_30", (String)"fi-bd-common", (Object[])new Object[]{number, parentAssDetail}) : ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\uff08%1$s %2$s\uff09%3$s\u79d1\u76ee%4$s\u7ef4\u5ea6\u52fe\u9009\u660e\u7ec6\u5c5e\u6027\uff0c\u6b64\u79d1\u76ee\u672a\u52fe\u9009\u3002", (String)"AccountPropCheckUtil_31", (String)"fi-bd-common", (Object[])new Object[]{orgNumber, orgName, number, parentAssDetail});
            checkResultList.add(new CheckResult(AccountPropDetail.ASST_DETAIL, msg));
        }
        if (CollectionUtils.isNotEmpty(parentAssRequireList)) {
            String parentAssRequire = StringUtils.join(parentAssRequireList, (String)SEPARATOR);
            msg = OWN_ORG_ACCOUNT.equals(type) ? ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee%1$s%2$s\u7ef4\u5ea6\u52fe\u9009\u5fc5\u5f55\u5c5e\u6027\uff0c\u6b64\u79d1\u76ee\u672a\u52fe\u9009\u3002", (String)"AccountPropCheckUtil_32", (String)"fi-bd-common", (Object[])new Object[]{number, parentAssRequire}) : ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\uff08%1$s %2$s\uff09%3$s\u79d1\u76ee%4$s\u7ef4\u5ea6\u52fe\u9009\u5fc5\u5f55\u5c5e\u6027\uff0c\u6b64\u79d1\u76ee\u672a\u52fe\u9009\u3002", (String)"AccountPropCheckUtil_33", (String)"fi-bd-common", (Object[])new Object[]{orgNumber, orgName, number, parentAssRequire});
            checkResultList.add(new CheckResult(AccountPropDetail.ASST_REQUIRE, msg));
        }
        if (CollectionUtils.isNotEmpty(parentAssAccheckList)) {
            String parentAssAccheck = StringUtils.join(parentAssAccheckList, (String)SEPARATOR);
            msg = OWN_ORG_ACCOUNT.equals(type) ? ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee%1$s%2$s\u7ef4\u5ea6\u52fe\u9009\u5f80\u6765\u6838\u7b97\u5c5e\u6027\uff0c\u6b64\u79d1\u76ee\u672a\u52fe\u9009\u3002", (String)"AccountPropCheckUtil_34", (String)"fi-bd-common", (Object[])new Object[]{number, parentAssAccheck}) : ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\uff08%1$s %2$s\uff09%3$s\u79d1\u76ee%4$s\u7ef4\u5ea6\u52fe\u9009\u5f80\u6765\u6838\u7b97\u5c5e\u6027\uff0c\u6b64\u79d1\u76ee\u672a\u52fe\u9009\u3002", (String)"AccountPropCheckUtil_35", (String)"fi-bd-common", (Object[])new Object[]{orgNumber, orgName, number, parentAssAccheck});
            checkResultList.add(new CheckResult(AccountPropDetail.AC_CHECK, msg));
        }
        return checkResultList;
    }

    protected static String changeBooleanTipWorlds(boolean flag) {
        if (flag) {
            return ResManager.loadKDString((String)"\u662f", (String)"AccountPropCheckUtil_36", (String)"fi-bd-common", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u4e0d\u662f", (String)"AccountPropCheckUtil_37", (String)"fi-bd-common", (Object[])new Object[0]);
    }

    protected static String changeDirection(Object direction) {
        if ("nocontrol".equals(direction)) {
            return ResManager.loadKDString((String)"\u4e0d\u63a7\u5236", (String)"AccountPropCheckUtil_38", (String)"fi-bd-common", (Object[])new Object[0]);
        }
        if ("debit".equals(direction)) {
            return ResManager.loadKDString((String)"\u501f\u65b9", (String)"AccountPropCheckUtil_39", (String)"fi-bd-common", (Object[])new Object[0]);
        }
        if ("credit".equals(direction)) {
            return ResManager.loadKDString((String)"\u8d37\u65b9", (String)"AccountPropCheckUtil_40", (String)"fi-bd-common", (Object[])new Object[0]);
        }
        return "";
    }

    protected static String changeCurrencyType(Object currency) {
        if ("nocurrency".equals(currency)) {
            return ResManager.loadKDString((String)"\u4e0d\u6838\u7b97\u5916\u5e01", (String)"AccountPropCheckUtil_41", (String)"fi-bd-common", (Object[])new Object[0]);
        }
        if ("descurrency".equals(currency)) {
            return ResManager.loadKDString((String)"\u6307\u5b9a\u6838\u7b97\u5e01\u79cd", (String)"AccountPropCheckUtil_42", (String)"fi-bd-common", (Object[])new Object[0]);
        }
        if ("allcurrency".equals(currency)) {
            return ResManager.loadKDString((String)"\u6838\u7b97\u6240\u6709\u5e01\u79cd", (String)"AccountPropCheckUtil_43", (String)"fi-bd-common", (Object[])new Object[0]);
        }
        return "";
    }

    public static Map<String, Object> getAccountProp(DynamicObject parentAcc) {
        Map<String, Object> propMap = AccountPropCheckUtil.getWithoutEntryAccountProp(parentAcc);
        propMap.put("currencyentry", parentAcc.getDynamicObjectCollection("currencyentry"));
        propMap.put("checkitementry", parentAcc.getDynamicObjectCollection("checkitementry"));
        return propMap;
    }

    public static Map<String, Object> getWithoutEntryAccountProp(DynamicObject parentAcc) {
        HashMap<String, Object> propMap = new HashMap<String, Object>();
        propMap.put("number", parentAcc.getString("number"));
        propMap.put("isjournal", parentAcc.getBoolean("isjournal"));
        propMap.put("dc", parentAcc.getString("dc"));
        propMap.put("accrualdirection", parentAcc.getString("accrualdirection"));
        propMap.put("orgcontrollevel", parentAcc.getString("orgcontrollevel"));
        propMap.put("isallowca", parentAcc.getBoolean("isallowca"));
        propMap.put("ismanual", parentAcc.getBoolean("ismanual"));
        propMap.put("iscash", parentAcc.getBoolean("iscash"));
        propMap.put("isbank", parentAcc.getBoolean("isbank"));
        propMap.put("iscashequivalent", parentAcc.getBoolean("iscashequivalent"));
        propMap.put("acnotice", parentAcc.getBoolean("acnotice"));
        propMap.put("ischangecurrency", parentAcc.getBoolean("ischangecurrency"));
        propMap.put("isqty", parentAcc.getBoolean("isqty"));
        propMap.put("acctcurrency", parentAcc.getString("acctcurrency"));
        return propMap;
    }

    protected static List<String> getCurrencyNames(List<Long> ids) {
        ArrayList<String> currencyNameList = new ArrayList<String>(8);
        QFilter idFilter = new QFilter("id", "in", ids);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)AccountPropCheckUtil.class.getName(), (String)"bd_currency", (String)"id, name", (QFilter[])idFilter.toArray(), null);){
            for (Row row : ds) {
                currencyNameList.add(row.getString("name"));
            }
        }
        return currencyNameList;
    }
}

