/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.accounthealth.util;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.fi.util.StringUtils;
import kd.fi.bd.accounthealth.vo.AccountRepairResVO;
import kd.fi.bd.consts.BDCommonResource;
import kd.fi.bd.enums.AccountPropCategory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class SXSSFWorkbookUtils {
    public static SXSSFWorkbook fillDetailResultWorkbook(List<AccountRepairResVO> dataList, boolean isRealRepair, String repairType) {
        SXSSFWorkbook wb = new SXSSFWorkbook(50000);
        wb.setCompressTempFiles(true);
        SXSSFWorkbookUtils.writeHeadLine(wb, isRealRepair, repairType);
        SXSSFSheet sh = wb.getSheet("sheet1");
        int size = dataList.size();
        int rowIndex = 2;
        for (AccountRepairResVO accountRepairResVO : dataList) {
            Cell dcell3;
            Cell dcell2;
            Cell dcell1;
            Cell dcell0;
            Row row = sh.createRow(rowIndex);
            if (repairType.equals(AccountPropCategory.ASST.getType())) {
                dcell0 = row.createCell(0);
                dcell1 = row.createCell(1);
                dcell2 = row.createCell(2);
                dcell3 = row.createCell(3);
                dcell0.setCellValue(accountRepairResVO.getCreateOrgInfo());
                dcell1.setCellValue(accountRepairResVO.getUseOrgInfo());
                dcell2.setCellValue(accountRepairResVO.getAccNumber());
                dcell3.setCellValue(accountRepairResVO.getQty());
                String repairAccInfo = accountRepairResVO.getRepairAccInfo();
                if (!StringUtils.isBlank((String)repairAccInfo)) {
                    String[] repairInfos = repairAccInfo.split(",");
                    for (int i = 0; i < repairInfos.length; ++i) {
                    }
                    int cellIndex = 4;
                    for (String repairInfo : repairInfos) {
                        Cell cell = row.createCell(cellIndex);
                        cell.setCellValue(repairInfo);
                        ++cellIndex;
                    }
                }
                ++rowIndex;
                continue;
            }
            dcell0 = row.createCell(0);
            dcell1 = row.createCell(1);
            dcell2 = row.createCell(2);
            dcell3 = row.createCell(3);
            dcell0.setCellValue(accountRepairResVO.getCreateOrgInfo());
            dcell1.setCellValue(accountRepairResVO.getUseOrgInfo());
            dcell2.setCellValue(accountRepairResVO.getAccNumber());
            dcell3.setCellValue(accountRepairResVO.getRepairAccInfo());
            ++rowIndex;
        }
        return wb;
    }

    public static void writeHeadLine(SXSSFWorkbook wb, boolean isRealRepair, String repairType) {
        SXSSFSheet sh = wb.createSheet("sheet1");
        Row row1 = sh.createRow(1);
        List<Object> headerList = new ArrayList(8);
        headerList = SXSSFWorkbookUtils.getHeaderInfo(isRealRepair, repairType);
        SXSSFWorkbookUtils.writeDescription(wb, (Sheet)sh, isRealRepair);
        CellStyle headerCellStyle = wb.createCellStyle();
        Font headerFont = wb.createFont();
        headerFont.setBold(true);
        headerCellStyle.setFont(headerFont);
        int size = headerList.size();
        for (int i = 0; i < size; ++i) {
            Cell cell = row1.createCell(i);
            cell.setCellValue((String)headerList.get(i));
            cell.setCellStyle(headerCellStyle);
        }
        Cell commentCell = isRealRepair ? row1.getCell(5) : row1.getCell(3);
        SXSSFWorkbookUtils.setComment((Sheet)sh, commentCell, repairType);
    }

    protected static List<String> getHeaderInfo(boolean isRealRepair, String repairType) {
        List<String> headerList = isRealRepair ? Arrays.asList(BDCommonResource.getResultText(), BDCommonResource.getDescriptionText(), BDCommonResource.getCreateOrgNameText(), BDCommonResource.getUseOrgNameText(), BDCommonResource.getAccountNumberText(), BDCommonResource.getChangePropText()) : (repairType.equals(AccountPropCategory.ASST.getType()) ? Arrays.asList(BDCommonResource.getCreateOrgNameText(), BDCommonResource.getUseOrgNameText(), BDCommonResource.getAccountNumberText(), BDCommonResource.getQtyText(), BDCommonResource.getAsstactTypeText(), BDCommonResource.getModifyTypeText(), BDCommonResource.getAsstactTypeText(), BDCommonResource.getModifyTypeText(), BDCommonResource.getAsstactTypeText(), BDCommonResource.getModifyTypeText(), BDCommonResource.getAsstactTypeText(), BDCommonResource.getModifyTypeText(), BDCommonResource.getAsstactTypeText(), BDCommonResource.getModifyTypeText(), BDCommonResource.getAsstactTypeText(), BDCommonResource.getModifyTypeText(), BDCommonResource.getAsstactTypeText(), BDCommonResource.getModifyTypeText(), BDCommonResource.getAsstactTypeText(), BDCommonResource.getModifyTypeText(), BDCommonResource.getAsstactTypeText(), BDCommonResource.getModifyTypeText(), BDCommonResource.getAsstactTypeText(), BDCommonResource.getModifyTypeText()) : Arrays.asList(BDCommonResource.getCreateOrgNameText(), BDCommonResource.getUseOrgNameText(), BDCommonResource.getAccountNumberText(), BDCommonResource.getChangePropText()));
        return headerList;
    }

    protected static Comment setComment(Sheet sh, Cell cell, String repairType) {
        XSSFClientAnchor anchor = new XSSFClientAnchor();
        anchor.setDx1(0);
        anchor.setDx2(0);
        anchor.setDy1(9);
        anchor.setDy2(6);
        anchor.setCol1(cell.getColumnIndex());
        anchor.setRow1(cell.getRowIndex());
        anchor.setCol2(cell.getColumnIndex() + 5);
        anchor.setRow2(cell.getRowIndex() + 6);
        Drawing drawing = sh.createDrawingPatriarch();
        Comment comment = drawing.createCellComment((ClientAnchor)anchor);
        String commentDescForProp = ResManager.loadKDString((String)"\u4ee3\u8868\u6b64\u6b21\u4fee\u6539\u4e2d\uff0c\u8be5\u79d1\u76ee\u7684\u54ea\u4e9b\u5c5e\u6027\u4f1a\u5728\u7b26\u5408\u96c6\u56e2\u7ba1\u63a7\u7684\u524d\u63d0\u4e0b\u8fdb\u884c\u4fee\u6539\u3002", (String)"AccountRepairUtil_3", (String)"fi-bd-common", (Object[])new Object[0]);
        String commentDescForQty = ResManager.loadKDString((String)"\u6b64\u79d1\u76ee\u4e0a\u7ea7\u79d1\u76ee\u6216\u4e0a\u7ea7\u7ec4\u7ec7\u540c\u79d1\u76ee\u5df2\u52fe\u9009\u6570\u91cf\u6838\u7b97\uff0c\u6b64\u6b21\u7248\u672c\u5316\u4fee\u6539\u64cd\u4f5c\u4f1a\u7ed9\u8be5\u79d1\u76ee\u6dfb\u52a0\u6570\u91cf\u6838\u7b97\u5c5e\u6027\u4ee5\u7b26\u5408\u96c6\u56e2\u7ba1\u63a7\u3002", (String)"AccountRepairUtil_4", (String)"fi-bd-common", (Object[])new Object[0]);
        XSSFRichTextString commentAch = new XSSFRichTextString(repairType.equals(AccountPropCategory.PROP.getType()) ? commentDescForProp : commentDescForQty);
        comment.setString((RichTextString)commentAch);
        cell.setCellComment(comment);
        return comment;
    }

    private static void writeDescription(SXSSFWorkbook wb, Sheet sh, boolean isRealRepair) {
        Row row = sh.createRow(0);
        CellStyle descCellStyle = wb.createCellStyle();
        Font desFont = wb.createFont();
        desFont.setColor((short)10);
        desFont.setFontName("Calibri");
        desFont.setFontHeightInPoints((short)11);
        descCellStyle.setWrapText(true);
        descCellStyle.setFont(desFont);
        descCellStyle.setAlignment(HorizontalAlignment.LEFT);
        descCellStyle.setVerticalAlignment(VerticalAlignment.TOP);
        Cell desCell = row.createCell(0);
        sh.setColumnWidth(0, 5120);
        row.setHeightInPoints(180.0f);
        StringBuilder description = new StringBuilder();
        String desc1 = ResManager.loadKDString((String)"1\u3001\u8bf7\u5c06\u9f20\u6807\u79fb\u52a8\u5230\u7070\u8272\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u89e3\u91ca\u8bf4\u660e\u3002\r\n", (String)"AccountRepairUtil_0", (String)"fi-bd-common", (Object[])new Object[0]);
        String desc2 = ResManager.loadKDString((String)"2\u3001\u56e0\u79d1\u76ee\u5065\u5eb7\u5de1\u67e5\u5217\u8868\u4e2d\u5c55\u793a\u7684\u6570\u636e\u4e3a\u5386\u53f2\u68c0\u67e5\u7ed3\u679c\uff0c\u800c\u8868\u683c\u4e2d\u5c55\u793a\u7684\u662f\u6700\u65b0\u6bd4\u5bf9\u540e\u7684\u7ed3\u679c\uff0c\u6545\u8868\u683c\u4e2d\u5c55\u793a\u7684\u79d1\u76ee\u6570\u91cf\u53ca\u4fee\u6539\u7684\u5c5e\u6027\u53ef\u80fd\u4e0e\u5217\u8868\u4e2d\u5c55\u793a\u7684\u4fe1\u606f\u4e0d\u7b26\uff0c\u6700\u7ec8\u4fee\u6539\u4f1a\u4ee5\u8868\u683c\u4e2d\u7684\u6700\u65b0\u7ed3\u679c\u4e3a\u51c6\u3002\r\n", (String)"AccountRepairUtil_1", (String)"fi-bd-common", (Object[])new Object[0]);
        description.append(desc1);
        description.append(desc2);
        desCell.setCellValue(description.toString());
        desCell.setCellStyle(descCellStyle);
    }

    public static String generateFileName() {
        String fileName = ResManager.loadKDString((String)"\u4e0b\u8f7d\u660e\u7ec6", (String)"AccountRepairUtil_2", (String)"fi-bd-common", (Object[])new Object[0]);
        fileName = fileName + LocalDate.now().toString() + ".xlsx";
        return fileName;
    }
}

