/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.accountmap;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.accountmap.AccountMappingParam;
import kd.fi.bd.accountmap.exception.AccountMappingNotFoundException;
import kd.fi.bd.cache.CacheModule;
import kd.fi.bd.cache.cacheservice.IDataLocalCache;
import kd.fi.bd.util.filter.QFilterBuilder;

public class AccountMappingReader {
    private static final IDataLocalCache localCache = IDataLocalCache.getCache(CacheModule.accountMapping, 60);
    private static final String SELECT = "id,mappinginfoentry.srcact.masterid srcact,mappinginfoentry.goalact.masterid goalact";
    private final MappingType mappingType;

    public AccountMappingReader(MappingType mappingType) {
        this.mappingType = mappingType;
    }

    public Map<Long, Long> readFromCache(AccountMappingParam param) throws AccountMappingNotFoundException {
        String cacheKey = (String)this.mappingType.keyBuilder.apply(param);
        HashMap<Long, Long> result = localCache.get(cacheKey, Map.class);
        if (result != null) {
            return result;
        }
        try (DataSet mappingDataSet = this.query(param);){
            if (mappingDataSet.isEmpty()) {
                throw new AccountMappingNotFoundException(param.getSrcOrgId());
            }
            result = new HashMap<Long, Long>(64);
            for (Row mappingRow : mappingDataSet) {
                result.put(mappingRow.getLong("srcact"), mappingRow.getLong("goalact"));
            }
        }
        localCache.put(cacheKey, result);
        return result;
    }

    private DataSet query(AccountMappingParam param) {
        return QueryServiceHelper.queryDataSet((String)"AccountMappingReader#query", (String)"bd_accountmapping", (String)SELECT, (QFilter[])((QFilter[])this.mappingType.filterBuilder.apply(param)), (String)"");
    }

    public static enum MappingType {
        MAIN_AND_AUX("0", p -> MappingType.buildCacheKey(p.getSrcOrgId(), p.getSrcAccountTableId(), p.getDestOrgId(), p.getDestAccountTableId()), param -> new QFilterBuilder().add(BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountmapping", (Long)param.getSrcOrgId())).addEqual("mappingtype", "0").addEqual("srcacttable", param.getSrcAccountTableId()).addEqual("goalacttable.fbasedataid_id", param.getDestAccountTableId()).addEqual("enable", Boolean.TRUE).toArray(new QFilter[0])),
        GOV_ACCOUNTING("2", p -> MappingType.buildCacheKey(p.getSrcOrgId(), p.getSrcAccountTableId()), param -> new QFilterBuilder().add(BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountmapping", (Long)param.getSrcOrgId())).addEqual("mappingtype", "2").addEqual("srcacttable", param.getSrcAccountTableId()).addEqual("enable", Boolean.TRUE).toArray(new QFilter[0]));

        private final String comboValue;
        private final Function<AccountMappingParam, String> keyBuilder;
        private final Function<AccountMappingParam, QFilter[]> filterBuilder;

        private MappingType(String comboValue, Function<AccountMappingParam, String> keyBuilder, Function<AccountMappingParam, QFilter[]> filterBuilder) {
            this.comboValue = comboValue;
            this.keyBuilder = keyBuilder;
            this.filterBuilder = filterBuilder;
        }

        private static String buildCacheKey(Object ... param) {
            return Arrays.stream(param).map(Object::toString).collect(Collectors.joining("$"));
        }

        public String getComboValue() {
            return this.comboValue;
        }
    }
}

