/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.accounttableref;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.accountref.AccountRef;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.accounttableref.DisableParam;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.AccountVersionControlChecker;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.MasterBaseDataUtils;
import kd.fi.bd.util.QFBuilder;

public class AccountTableRefCastUtils {
    private static final Log logger = LogFactory.getLog(AccountTableRefCastUtils.class);
    private static final String FI_BD_COMMON = "fi-bd-common";
    private static final String FLEXFIELD = "flexfield";
    private static final String[] ARG_FIELDS = new String[]{"iscash", "isbank", "iscashequivalent", "isqty"};

    private AccountTableRefCastUtils() {
    }

    protected static AccountTableRef castFromDynamicObject(DynamicObject accountTableRefDO, Date versionDate, long orgId, DisableParam disableParam) throws KDBizException {
        boolean isOwner = orgId == accountTableRefDO.getLong("createorg_id");
        boolean isEnable = Objects.isNull(disableParam);
        boolean isPartChange = !isEnable && !disableParam.isDeleteRecord() && disableParam.isRealDisable();
        DynamicObjectCollection mappingEntries = accountTableRefDO.getDynamicObjectCollection("mappingentry");
        int size = mappingEntries.size();
        ArrayList<String> errorMsgs = new ArrayList<String>(size);
        HashMap<String, Set> flexValues = new HashMap<String, Set>(size);
        HashSet<Long> srcAccountSet = new HashSet<Long>(8);
        HashSet<Long> targetAccountSet = new HashSet<Long>(8);
        for (DynamicObject row : mappingEntries) {
            String seq = row.getString("seq");
            DynamicObject oldAccount = row.getDynamicObject("oldaccount");
            DynamicObject dynamicObject = row.getDynamicObject("newaccount");
            if (Objects.isNull(oldAccount)) {
                errorMsgs.add(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u7b2c%s\u884c\u6e90\u79d1\u76ee\u672a\u586b\u5199\u3002", (String)"AccountTableRefCastUtils_0", (String)FI_BD_COMMON, (Object[])new Object[0]), seq));
                continue;
            }
            srcAccountSet.add(oldAccount.getLong("id"));
            if (isEnable && Objects.isNull(dynamicObject)) {
                errorMsgs.add(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u7b2c%s\u884c\u76ee\u6807\u79d1\u76ee\u672a\u586b\u5199\u3002", (String)"AccountTableRefCastUtils_1", (String)FI_BD_COMMON, (Object[])new Object[0]), seq));
                continue;
            }
            if (Objects.nonNull(dynamicObject)) {
                targetAccountSet.add(dynamicObject.getLong("id"));
            }
            DynamicObjectCollection flexDefVals = row.getDynamicObjectCollection("assgrpentry");
            for (DynamicObject flexDefVal : flexDefVals) {
                String value = flexDefVal.getString("value");
                if (StringUtils.isBlank((CharSequence)value)) continue;
                DynamicObject assistType = flexDefVal.getDynamicObject("assisttype");
                String entityId = null;
                String valueType = assistType.getString("valuetype");
                if ("1".equals(valueType)) {
                    entityId = assistType.getString("valuesource.number");
                } else if ("2".equals(valueType)) {
                    entityId = "bos_assistantdata_detail";
                }
                if (!StringUtils.isNotBlank((CharSequence)entityId)) continue;
                flexValues.compute(entityId, (k, v) -> {
                    if (Objects.isNull(v)) {
                        v = new HashSet<Long>(10);
                    }
                    v.add(Long.valueOf(value));
                    return v;
                });
            }
        }
        AccountTableRefCastUtils.throwKDBizException(errorMsgs, isOwner);
        QFBuilder qfBuilder = new QFBuilder();
        HashMap curOrgCanUseFlexValues = new HashMap(flexValues.size());
        HashMap<String, Map<String, Long>> entityIdMasterIdMap = new HashMap<String, Map<String, Long>>(flexValues.size());
        if (isEnable) {
            for (Map.Entry entry : flexValues.entrySet()) {
                String entityId;
                QFilter baseDataFilter;
                Set values = (Set)entry.getValue();
                if (values.isEmpty() || Objects.isNull(baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)(entityId = (String)entry.getKey()), (Long)orgId))) continue;
                qfBuilder.clear();
                qfBuilder.add("id", "in", values);
                qfBuilder.add(baseDataFilter);
                List canUseValues = QueryServiceHelper.queryPrimaryKeys((String)entityId, (QFilter[])qfBuilder.toArray(), null, (int)-1);
                Map<Object, Long> idMasterIdMap = MasterBaseDataUtils.batchGetMasterIds(entityId, canUseValues.toArray());
                if (!idMasterIdMap.isEmpty()) {
                    entityIdMasterIdMap.put(entityId, idMasterIdMap.entrySet().stream().collect(Collectors.toMap(x -> x.getKey().toString(), Map.Entry::getValue)));
                }
                curOrgCanUseFlexValues.put(entityId, canUseValues.stream().map(Object::toString).collect(Collectors.toList()));
            }
        }
        AccountRef accountRef = new AccountRef();
        long l = accountTableRefDO.getLong("oldacttable_id");
        List<DynamicObject> oldAccountDOs = AccountUtils.getAccountDOs(orgId, l, versionDate, null, new String[0]);
        if (oldAccountDOs.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6e90\u79d1\u76ee\u8868\u5f53\u524d\u542f\u7528\u65e5\u671f\u6ca1\u6709\u53ef\u7528\u7684\u79d1\u76ee\u3002", (String)"AccountTableRefCastUtils_2", (String)FI_BD_COMMON, (Object[])new Object[0]));
        }
        Set allSrcAccountSet = oldAccountDOs.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
        allSrcAccountSet.removeAll(srcAccountSet);
        if (!CollectionUtils.isEmpty(allSrcAccountSet)) {
            if (DebugTrace.enable()) {
                logger.info("currOrg allSrcAccountSet : {}", allSrcAccountSet);
                logger.info("currOrg srcAccountSet : {}", srcAccountSet);
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6e90\u79d1\u76ee\u5df2\u53d1\u751f\u589e\u51cf\u53d8\u52a8\uff0c\u8bf7\u70b9\u5f00\u79d1\u76ee\u8868\u7248\u672c\u5316\u65b9\u6848\uff0c\u70b9\u51fb\u66f4\u65b0\u79d1\u76ee\u540e\u7ef4\u62a4\u5bf9\u7167\u4fe1\u606f\u3002", (String)"AccountTableRefCastUtils_21", (String)FI_BD_COMMON, (Object[])new Object[0]));
        }
        Map<Long, DynamicObject> oldMasterId2oldAccountDOs = oldAccountDOs.stream().collect(Collectors.toMap(x -> x.getLong("id"), x -> x, (oldVal, newVal) -> newVal));
        HashSet<Long> allOldMasterIds = new HashSet<Long>(oldMasterId2oldAccountDOs.keySet());
        long newTabId = accountTableRefDO.getLong("newacttable_id");
        List<DynamicObject> newAccountDOs = AccountUtils.getAccountDOs(orgId, newTabId, versionDate, null, new String[0]);
        if (newAccountDOs.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u76ee\u6807\u79d1\u76ee\u8868\u5f53\u524d\u542f\u7528\u65e5\u671f\u6ca1\u6709\u53ef\u7528\u7684\u79d1\u76ee\u3002", (String)"AccountTableRefCastUtils_3", (String)FI_BD_COMMON, (Object[])new Object[0]));
        }
        Set allTargetAccounts = newAccountDOs.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
        Map<Long, DynamicObject> newMasterId2oldAccountDOs = newAccountDOs.stream().collect(Collectors.toMap(x -> x.getLong("id"), x -> x, (oldVal, newVal) -> newVal));
        targetAccountSet.removeAll(allTargetAccounts);
        if (!CollectionUtils.isEmpty(targetAccountSet)) {
            if (DebugTrace.enable()) {
                logger.info("currOrg allTargetAccounts : {}", allTargetAccounts);
                logger.info("currOrg targetAccountSet : {}", targetAccountSet);
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u76ee\u6807\u79d1\u76ee\u5df2\u53d1\u751f\u7248\u672c\u53d8\u5316\uff0c\u8bf7\u70b9\u5f00\u79d1\u76ee\u8868\u7248\u672c\u5316\u65b9\u6848\uff0c\u70b9\u51fb\u66f4\u65b0\u79d1\u76ee\u540e\u7ef4\u62a4\u5bf9\u7167\u4fe1\u606f\u3002", (String)"AccountTableRefCastUtils_22", (String)FI_BD_COMMON, (Object[])new Object[0]));
        }
        boolean checkAccountType = accountTableRefDO.getBoolean("checkaccounttype");
        HashMap<Long, DynamicObject> accountTypeMap = new HashMap<Long, DynamicObject>(10);
        for (DynamicObject row : mappingEntries) {
            long count;
            String seq = row.getString("seq");
            DynamicObject oldAccountDO = row.getDynamicObject("oldaccount");
            DynamicObject newAccountDO = row.getDynamicObject("newaccount");
            if (Objects.isNull(oldAccountDO)) continue;
            long oldMasterId = oldAccountDO.getLong("id");
            DynamicObject oldAccount = oldMasterId2oldAccountDOs.get(oldMasterId);
            if (Objects.isNull(oldAccount)) {
                errorMsgs.add(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u7b2c%s\u884c\u6e90\u79d1\u76ee\u627e\u4e0d\u5230\u5bf9\u5e94\u7ec4\u7ec7\u4f7f\u7528\u7684\u79d1\u76ee\u3002", (String)"AccountTableRefCastUtils_4", (String)FI_BD_COMMON, (Object[])new Object[0]), seq));
                continue;
            }
            allOldMasterIds.remove(oldMasterId);
            if (Objects.isNull(newAccountDO)) continue;
            long newAccountId = newAccountDO.getLong("id");
            DynamicObject newAccount = newMasterId2oldAccountDOs.get(newAccountId);
            if (Objects.isNull(newAccount)) {
                errorMsgs.add(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u7b2c%s\u884c\u76ee\u6807\u79d1\u76ee\u627e\u4e0d\u5230\u5bf9\u5e94\u7ec4\u7ec7\u4f7f\u7528\u7684\u79d1\u76ee\u3002", (String)"AccountTableRefCastUtils_5", (String)FI_BD_COMMON, (Object[])new Object[0]), seq));
                continue;
            }
            accountRef.getAccountLongNumberRef().put(newAccountId, newAccountDO.getString("longnumber"));
            if (isEnable) {
                if (checkAccountType) {
                    long oldAccountTypeId = oldAccount.getLong("accounttype_id");
                    long newAccountTypeId = newAccount.getLong("accounttype_id");
                    DynamicObject oldType = (DynamicObject)accountTypeMap.get(oldAccountTypeId);
                    DynamicObject newType = (DynamicObject)accountTypeMap.get(newAccountTypeId);
                    if (oldType == null || newType == null) {
                        DynamicObjectCollection accountTypeColl = QueryServiceHelper.query((String)"bd_accounttype", (String)"id,accounttype", (QFilter[])new QFilter("id", "in", Arrays.asList(oldAccountTypeId, newAccountTypeId)).toArray());
                        for (DynamicObject accountType : accountTypeColl) {
                            accountTypeMap.put(accountType.getLong("id"), accountType);
                        }
                        oldType = (DynamicObject)accountTypeMap.get(oldAccountTypeId);
                        newType = (DynamicObject)accountTypeMap.get(newAccountTypeId);
                    }
                    if (oldType == null || newType == null || !oldType.getString("accounttype").equals(newType.getString("accounttype"))) {
                        errorMsgs.add(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u7b2c%s\u884c\u6e90\u79d1\u76ee\u4e0e\u76ee\u6807\u79d1\u76ee\u79d1\u76ee\u7c7b\u578b\u4e0d\u4e00\u81f4\u3002", (String)"AccountTableRefCastUtils_8", (String)FI_BD_COMMON, (Object[])new Object[0]), seq));
                        continue;
                    }
                }
                if (AccountVersionControlChecker.accountCurrencyControlCheck(oldAccount, newAccount)) {
                    errorMsgs.add(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u7b2c%s\u884c\u76ee\u6807\u79d1\u76ee\u5e01\u79cd\u6838\u7b97\u8303\u56f4\u672a\u5305\u542b\u6e90\u79d1\u76ee\u5e01\u79cd\u6838\u7b97\u8303\u56f4\u3002", (String)"AccountTableRefCastUtils_23", (String)FI_BD_COMMON, (Object[])new Object[0]), seq));
                    continue;
                }
            }
            DynamicObjectCollection oldAssgrpEntries = oldAccount.getDynamicObjectCollection("checkitementry");
            DynamicObjectCollection newAssgrpEntries = newAccount.getDynamicObjectCollection("checkitementry");
            if (isEnable && oldAccount.getBoolean("accheck") && newAccount.getBoolean("accheck")) {
                List oldAccountAcItems = oldAssgrpEntries.stream().filter(x -> x.getBoolean("enaccheck")).map(x -> x.getLong("asstactitem_id")).collect(Collectors.toList());
                List newAccountAcItems = newAssgrpEntries.stream().filter(x -> x.getBoolean("enaccheck")).map(x -> x.getLong("asstactitem_id")).collect(Collectors.toList());
                if (oldAccountAcItems.size() != newAccountAcItems.size()) {
                    errorMsgs.add(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u7b2c%s\u884c\u76ee\u6807\u79d1\u76ee\u4e0e\u6e90\u79d1\u76ee\u5f80\u6765\u6838\u7b97\u7ef4\u5ea6\u4e0d\u4e00\u81f4\u3002", (String)"AccountTableRefCastUtils_24", (String)FI_BD_COMMON, (Object[])new Object[0]), seq));
                    continue;
                }
                oldAccountAcItems.removeAll(newAccountAcItems);
                if (!oldAccountAcItems.isEmpty()) {
                    errorMsgs.add(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u7b2c%s\u884c\u76ee\u6807\u79d1\u76ee\u4e0e\u6e90\u79d1\u76ee\u5f80\u6765\u6838\u7b97\u7ef4\u5ea6\u4e0d\u4e00\u81f4\u3002", (String)"AccountTableRefCastUtils_17", (String)FI_BD_COMMON, (Object[])new Object[0]), seq));
                    continue;
                }
            }
            if ((count = row.getDynamicObjectCollection("assgrpentry").stream().collect(Collectors.groupingBy(x -> x.getLong("assisttype_id"))).values().stream().filter(x -> x.size() > 1).count()) > 0L) {
                errorMsgs.add(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u7b2c%s\u884c\u6838\u7b97\u7ef4\u5ea6\u8bbe\u7f6e\u6838\u7b97\u7ef4\u5ea6\u91cd\u590d\u3002", (String)"AccountTableRefCastUtils_19", (String)FI_BD_COMMON, (Object[])new Object[0]), seq));
                continue;
            }
            Map<Long, String> rowFlexValues = row.getDynamicObjectCollection("assgrpentry").stream().collect(Collectors.toMap(x -> x.getLong("assisttype_id"), x -> x.getString("value")));
            Map<Long, Boolean> oldAssists2mustInput = oldAssgrpEntries.stream().collect(Collectors.toMap(x -> x.getLong("asstactitem_id"), x -> x.getBoolean("isrequire"), (oldVal, newVal) -> newVal));
            boolean isCheckPass = true;
            HashMap<String, Object> assgrpMap = new HashMap<String, Object>(rowFlexValues.size());
            for (DynamicObject newAssgrpEntry : newAssgrpEntries) {
                DynamicObject assistItem = newAssgrpEntry.getDynamicObject("asstactitem");
                if (Objects.isNull(assistItem)) continue;
                long newAssistId = assistItem.getLong("id");
                String value = rowFlexValues.get(newAssistId);
                if (StringUtils.isNotBlank((CharSequence)value)) {
                    String entityId = null;
                    String valueType = assistItem.getString("valuetype");
                    if ("1".equals(valueType)) {
                        entityId = assistItem.getString("valuesource.number");
                    } else if ("2".equals(valueType)) {
                        entityId = "bos_assistantdata_detail";
                    }
                    if (StringUtils.isNotBlank((CharSequence)entityId)) {
                        if (isEnable && !Objects.isNull(curOrgCanUseFlexValues.get(entityId)) && !((List)curOrgCanUseFlexValues.get(entityId)).contains(value)) {
                            errorMsgs.add(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u7b2c%1$s\u884c\u201c%2$s\u201d\u6838\u7b97\u7ef4\u5ea6\u9ed8\u8ba4\u503c\u5f53\u524d\u7ec4\u7ec7\u4e0d\u53ef\u7528\u3002", (String)"AccountTableRefCastUtils_11", (String)FI_BD_COMMON, (Object[])new Object[0]), seq, assistItem.getString("name")));
                            isCheckPass = false;
                            break;
                        }
                        Map idMasterIdMap = (Map)entityIdMasterIdMap.get(entityId);
                        if (idMasterIdMap != null) {
                            Long masterId = (Long)idMasterIdMap.get(value);
                            if (masterId != null && masterId != 0L) {
                                assgrpMap.put(assistItem.getString(FLEXFIELD), masterId);
                                continue;
                            }
                            assgrpMap.put(assistItem.getString(FLEXFIELD), Long.valueOf(value));
                            continue;
                        }
                        assgrpMap.put(assistItem.getString(FLEXFIELD), Long.valueOf(value));
                        continue;
                    }
                    assgrpMap.put(assistItem.getString(FLEXFIELD), value);
                    continue;
                }
                if (!isEnable) continue;
                boolean newMustInput = newAssgrpEntry.getBoolean("isrequire");
                Boolean oldMustInput = oldAssists2mustInput.get(newAssistId);
                if (!Objects.isNull(oldMustInput) && oldMustInput.booleanValue() || !newMustInput) continue;
                errorMsgs.add(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u7b2c%s\u884c\u6838\u7b97\u7ef4\u5ea6\u9ed8\u8ba4\u503c\u672a\u8bbe\u7f6e\u5b8c\u6210\u3002", (String)"AccountTableRefCastUtils_12", (String)FI_BD_COMMON, (Object[])new Object[0]), seq));
                isCheckPass = false;
                break;
            }
            if (!isCheckPass || isPartChange && !row.getBoolean("ischange")) continue;
            accountRef.addAccountRef(newAccount.getLong("id"), oldAccount.getLong("id"), assgrpMap);
        }
        AccountTableRefCastUtils.throwKDBizException(errorMsgs, isOwner);
        if (isEnable && !allOldMasterIds.isEmpty()) {
            if (isOwner) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6e90\u79d1\u76ee\u672a\u5168\u90e8\u7ef4\u62a4\u5bf9\u7167\u5173\u7cfb\uff0c\u8bf7\u7ef4\u62a4\u4e4b\u540e\u518d\u70b9\u51fb\u542f\u7528\u3002", (String)"AccountTableRefCastUtils_14", (String)FI_BD_COMMON, (Object[])new Object[0]));
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u6e90\u79d1\u76ee\u672a\u5b8c\u5168\u5bf9\u7167\uff0c\u8bf7\u70b9\u51fb\u201c\u7ba1\u7406-\u7ef4\u62a4\u4e2a\u6027\u5316\u6570\u636e\u201d\u6309\u94ae\u8fdb\u884c\u5bf9\u7167\u3002", (String)"AccountTableRefCastUtils_15", (String)FI_BD_COMMON, (Object[])new Object[0]));
        }
        return new AccountTableRef(l, newTabId, accountRef);
    }

    private static void throwKDBizException(List<String> errorMsgs, boolean isOwner) {
        if (!errorMsgs.isEmpty()) {
            if (!isOwner) {
                errorMsgs.add(0, ResManager.loadKDString((String)"\u975e\u672c\u7ec4\u7ec7\u521b\u5efa\u7684\u79d1\u76ee\u8868\u7248\u672c\u5316\u5bf9\u7167\u5173\u7cfb\uff0c\u8bf7\u70b9\u51fb\u201c\u7ba1\u7406-\u7ef4\u62a4\u4e2a\u6027\u5316\u6570\u636e\u201d\u6309\u94ae\u8fdb\u884c\u5904\u7406\uff1a", (String)"AccountTableRefCastUtils_16", (String)FI_BD_COMMON, (Object[])new Object[0]));
            }
            throw new KDBizException(StringUtils.join((Object[])errorMsgs.toArray(), (String)"\n"));
        }
    }
}

