/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.accounttableref;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.fi.bd.accounttableref.AccountTableRefOpService;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.DebugTraceHelper;

public class AccountTableRefTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(AccountTableRefTask.class);

    public void execute(RequestContext paramRequestContext, Map<String, Object> paramMap) throws KDException {
        if (DebugTrace.enable()) {
            logger.info("customparams_paramMap :{}", (Object)DebugTraceHelper.toString(paramMap));
        }
        HashMap<String, Object> reports = new HashMap<String, Object>(1);
        long orgId = Long.parseLong(paramMap.get("org").toString());
        long accountTableRefId = Long.parseLong(paramMap.get("accountTableRefId").toString());
        String key = (String)paramMap.get("op_key");
        Object dateParam = paramMap.get("date");
        boolean isDate = dateParam instanceof Date;
        Date date = null;
        if (!Objects.isNull(dateParam)) {
            if (!isDate) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    date = sdf.parse(dateParam.toString());
                }
                catch (ParseException e) {
                    logger.error("date parse exception :{}, dateParam :{}", (Object)e.getStackTrace(), dateParam);
                }
            } else {
                date = (Date)dateParam;
            }
        }
        if (orgId <= 0L || accountTableRefId <= 0L || Objects.isNull(date)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u79d1\u76ee\u8868\u7248\u672c\u5316\u6267\u884c\u53c2\u6570\u6709\u8bef\u3002", (String)"AccountTableRefTask_0", (String)"fi-bd-common", (Object[])new Object[0]));
        }
        Object report = null;
        switch (key) {
            case "refenable": {
                report = AccountTableRefOpService.enable(orgId, date, accountTableRefId, this.taskId);
                break;
            }
            case "refdisable": {
                report = AccountTableRefOpService.disable(orgId, date, accountTableRefId, this.taskId);
                break;
            }
            case "refdelete": {
                report = AccountTableRefOpService.deleteRecord(orgId, date, accountTableRefId, this.taskId);
                break;
            }
            case "refreenable": {
                report = AccountTableRefOpService.reEnable(orgId, date, accountTableRefId, this.taskId);
                break;
            }
            case "baltrans": {
                report = AccountTableRefOpService.balTrans(orgId, date, accountTableRefId, this.taskId);
                break;
            }
        }
        if (!Objects.isNull(report)) {
            reports.put("report", report);
            this.feedbackCustomdata(reports);
        }
    }
}

