/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.accounttableref;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.fi.bd.accounttableref.OrgNode;

public class OrgStructure
implements Serializable {
    private static final long serialVersionUID = 868868624772539443L;
    private final long rootOrgId;
    private final List<OrgNode> nodes;
    private int maxLevel = 0;

    protected OrgStructure(long rootOrgId, Set<Long> retainOrgIds, Set<Long> removeOrgIds) {
        this.rootOrgId = rootOrgId;
        this.nodes = this.initNodes(rootOrgId, retainOrgIds, removeOrgIds);
    }

    protected final long getRootOrgId() {
        return this.rootOrgId;
    }

    protected final List<OrgNode> getAllNodes() {
        return this.nodes;
    }

    protected final List<OrgNode> getNodesWithLevel(int level) {
        return this.nodes.stream().filter(x -> x.getParentLevel() == level).collect(Collectors.toList());
    }

    protected final int getMaxLevel() {
        return this.maxLevel;
    }

    private List<OrgNode> initNodes(long rootOrgId, Set<Long> retainOrgIds, Set<Long> removeOrgIds) {
        ArrayList<OrgNode> result = new ArrayList<OrgNode>(10);
        List childOrgIds = OrgViewServiceHelper.getChildOrgId((String)"10", (long)rootOrgId, (boolean)false);
        if (!Objects.isNull(retainOrgIds)) {
            childOrgIds.retainAll(retainOrgIds);
        }
        if (!Objects.isNull(removeOrgIds)) {
            childOrgIds.removeAll(removeOrgIds);
        }
        OrgNode node = new OrgNode(rootOrgId, childOrgIds, 0);
        result.add(node);
        if (!childOrgIds.isEmpty()) {
            for (Long childOrgId : childOrgIds) {
                result.addAll(this.initChildNodes(childOrgId, 1, retainOrgIds, removeOrgIds));
            }
        }
        return result;
    }

    private List<OrgNode> initChildNodes(long rootOrgId, int parentLevel, Set<Long> retainOrgIds, Set<Long> removeOrgIds) {
        ArrayList<OrgNode> result = new ArrayList<OrgNode>(10);
        List childOrgIds = OrgViewServiceHelper.getChildOrgId((String)"10", (long)rootOrgId, (boolean)false);
        if (!Objects.isNull(retainOrgIds)) {
            childOrgIds.retainAll(retainOrgIds);
        }
        if (!Objects.isNull(removeOrgIds)) {
            childOrgIds.removeAll(removeOrgIds);
        }
        if (!childOrgIds.isEmpty()) {
            OrgNode node = new OrgNode(rootOrgId, childOrgIds, parentLevel);
            result.add(node);
            for (Long childOrgId : childOrgIds) {
                if (this.getMaxLevel() < ++parentLevel) {
                    this.maxLevel = parentLevel;
                }
                result.addAll(this.initChildNodes(childOrgId, parentLevel, retainOrgIds, removeOrgIds));
                --parentLevel;
            }
        }
        return result;
    }
}

