/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.accounttableref;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.accounttableref.AccountTableRefCastUtils;
import kd.fi.bd.accounttableref.DisableParam;
import kd.fi.bd.util.QFBuilder;

public class SingleOrgExcuteParam
implements Serializable {
    private static final long serialVersionUID = -8203182660042724402L;
    private final long orgId;
    private final Date excuteDate;
    private final long accountTableRefMasterId;
    private DynamicObject accountTableRefDO;
    private AccountTableRef accountTableRef;
    private boolean isRefChanged = false;
    private boolean isAccountTableChanged = true;
    private DisableParam disableParam;
    private boolean isQuery = false;

    protected SingleOrgExcuteParam(long orgId, Date excuteDate, long accountTableRefMasterId, DisableParam disableParam) {
        this.orgId = orgId;
        this.excuteDate = excuteDate;
        this.accountTableRefMasterId = accountTableRefMasterId;
        this.disableParam = disableParam;
    }

    protected static SingleOrgExcuteParam create(long orgId, Date excuteDate, long accountTableRefMasterId, DisableParam disableParam) {
        return new SingleOrgExcuteParam(orgId, excuteDate, accountTableRefMasterId, disableParam);
    }

    protected static SingleOrgExcuteParam create(long orgId, Date excuteDate, long accountTableRefMasterId, DisableParam disableParam, DynamicObject accountTableRefDO) {
        SingleOrgExcuteParam singleOrgExcuteParam = new SingleOrgExcuteParam(orgId, excuteDate, accountTableRefMasterId, disableParam);
        singleOrgExcuteParam.setAccountTableRefDO(accountTableRefDO);
        return singleOrgExcuteParam;
    }

    public long getOrgId() {
        return this.orgId;
    }

    protected Date getExcuteDate() {
        return this.excuteDate;
    }

    protected long getAccountTableRefMasterId() {
        return this.accountTableRefMasterId;
    }

    protected void setAccountTableRefDO(DynamicObject accountTableRefDO) {
        this.accountTableRefDO = accountTableRefDO;
    }

    protected DynamicObject getAccountTableRefDO() {
        if (!this.isQuery && Objects.isNull(this.accountTableRefDO)) {
            QFBuilder masterFilter = new QFBuilder("masterid", "=", this.accountTableRefMasterId);
            masterFilter.add("enabledate", "=", this.excuteDate);
            masterFilter.add(BaseDataServiceHelper.getBaseDataFilter((String)"bd_accounttableref", (Long)this.orgId));
            this.accountTableRefDO = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accounttableref", (QFilter[])masterFilter.toArray());
            this.isQuery = true;
        }
        return this.accountTableRefDO;
    }

    protected AccountTableRef getAccountTableRef() {
        if (!Objects.isNull(this.getAccountTableRefDO()) && Objects.isNull(this.accountTableRef)) {
            this.accountTableRef = AccountTableRefCastUtils.castFromDynamicObject(this.getAccountTableRefDO(), this.excuteDate, this.orgId, this.getDisableParam());
        }
        return this.accountTableRef;
    }

    protected DisableParam getDisableParam() {
        return this.disableParam;
    }

    protected void setDisableParam(DisableParam disableParam) {
        this.disableParam = disableParam;
        this.accountTableRef = null;
    }

    protected boolean isRefChanged() {
        if (!Objects.isNull(this.getAccountTableRefDO())) {
            this.isRefChanged = this.getAccountTableRefDO().getDynamicObjectCollection("mappingentry").stream().anyMatch(x -> x.getBoolean("ischange"));
        }
        return this.isRefChanged;
    }

    protected boolean isAccountTableChanged() {
        if (!Objects.isNull(this.getAccountTableRefDO())) {
            this.isAccountTableChanged = this.getAccountTableRefDO().getBoolean("isentrychange") || null == this.getDisableParam() || this.getDisableParam().isDeleteRecord();
        }
        return this.isAccountTableChanged;
    }
}

