/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.accounttableref;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.accounttableref.DisableParam;
import kd.fi.bd.accounttableref.OrgNode;
import kd.fi.bd.accounttableref.OrgStructure;
import kd.fi.bd.accounttableref.SingleOrgExcuteParam;
import kd.fi.bd.accounttableref.SingleOrgExcuteResult;
import kd.fi.bd.util.QFBuilder;

public class VirtualOrgExcuteParam
implements Serializable {
    private static final long serialVersionUID = 1092446025882725315L;
    private static final String FI = "fi";
    private static final String FUSEORGID = "fuseorgid";
    private static final String ASSIGN_SQL = "select fuseorgid from T_BD_ACCOUNTTABLEREFUSEREG u where fisassign = '1' and fdataid in (%s)";
    private long rootOrgId;
    private Date excuteDate;
    private long accountTableRefMasterId;
    private OrgStructure orgStructure;
    private Map<Long, SingleOrgExcuteParam> orgParams = new HashMap<Long, SingleOrgExcuteParam>(16);
    private Map<Long, SingleOrgExcuteResult> orgResults = new HashMap<Long, SingleOrgExcuteResult>(16);
    private DisableParam disableParam;
    private String taskId;

    private VirtualOrgExcuteParam() {
    }

    protected static VirtualOrgExcuteParam create(long rootOrgId, Date excuteDate, long accountTableRefMasterId) {
        return VirtualOrgExcuteParam.create(rootOrgId, excuteDate, accountTableRefMasterId, null);
    }

    protected static VirtualOrgExcuteParam create(long rootOrgId, Date excuteDate, long accountTableRefMasterId, DisableParam disableParam) {
        return VirtualOrgExcuteParam.create(rootOrgId, excuteDate, accountTableRefMasterId, null, "");
    }

    protected static VirtualOrgExcuteParam create(long rootOrgId, Date excuteDate, long accountTableRefMasterId, DisableParam disableParam, String taskId) {
        VirtualOrgExcuteParam excuteParam = new VirtualOrgExcuteParam();
        excuteParam.setRootOrgId(rootOrgId);
        excuteParam.setExcuteDate(excuteDate);
        excuteParam.setAccountTableRefMasterId(accountTableRefMasterId);
        excuteParam.setDisableParam(disableParam);
        excuteParam.setTaskId(taskId);
        HashSet<Long> assignOrgIds = new HashSet<Long>(16);
        assignOrgIds.add(rootOrgId);
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("masterid", "=", accountTableRefMasterId);
        List accountTableRefIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_accounttableref", (QFilter[])qfBuilder.toArray(), null, (int)-1);
        if (accountTableRefIds.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u79d1\u76ee\u8868\u7248\u672c\u5316\u57fa\u7840\u8d44\u6599\u6ca1\u6709\u5bf9\u5e94\u7684\u6570\u636e\uff0c\u53ef\u80fd\u88ab\u5220\u9664\u3002", (String)"VirtualOrgExcuteParam_0", (String)"fi-bd-common", (Object[])new Object[0]));
        }
        String sql = String.format(ASSIGN_SQL, StringUtils.join((Object[])accountTableRefIds.toArray(), (String)","));
        DataSet ds = DB.queryDataSet((String)VirtualOrgExcuteParam.class.getName(), (DBRoute)DBRoute.of((String)FI), (String)sql);
        Object object = null;
        try {
            for (Row row : ds) {
                assignOrgIds.add(row.getLong(FUSEORGID));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        excuteParam.setOrgStructure(new OrgStructure(rootOrgId, assignOrgIds, Collections.emptySet()));
        List<OrgNode> allNodes = excuteParam.getOrgStructure().getAllNodes();
        for (OrgNode orgNode : allNodes) {
            long parentOrgId = orgNode.getParentOrgId();
            if (!excuteParam.getOrgParams().containsKey(parentOrgId)) {
                excuteParam.addOrgParam(SingleOrgExcuteParam.create(parentOrgId, excuteDate, accountTableRefMasterId, disableParam));
            }
            List<Long> childOrgIds = orgNode.getChildOrgIds();
            for (Long childOrgId : childOrgIds) {
                if (excuteParam.getOrgParams().containsKey(childOrgId)) continue;
                excuteParam.addOrgParam(SingleOrgExcuteParam.create(childOrgId, excuteDate, accountTableRefMasterId, disableParam));
            }
        }
        return excuteParam;
    }

    protected static VirtualOrgExcuteParam createRestoreParam(DynamicObject saveData, long orgId, boolean isPersonalized) {
        OrgStructure orgStructure;
        if (saveData == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VirtualOrgExcuteParam_1", (String)"fi-bd-common", (Object[])new Object[0]));
        }
        VirtualOrgExcuteParam excuteParam = new VirtualOrgExcuteParam();
        excuteParam.setRootOrgId(orgId);
        Date excuteDate = saveData.getDate("enabledate");
        excuteParam.setExcuteDate(excuteDate);
        long id = saveData.getLong("id");
        long accountTableRefMasterId = saveData.getLong("masterid");
        if (id <= 0L) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u6570\u636e\u8fd8\u672a\u4fdd\u5b58\u3002", (String)"VirtualOrgExcuteParam_2", (String)"fi-bd-common", (Object[])new Object[0]));
        }
        excuteParam.setAccountTableRefMasterId(accountTableRefMasterId);
        excuteParam.setDisableParam(DisableParam.getRealDisableParam());
        if (isPersonalized) {
            orgStructure = new OrgStructure(orgId, Collections.emptySet(), Collections.emptySet());
        } else {
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("accountref", "=", id);
            qfBuilder.add("enablestatus", "in", new String[]{"C", "D"});
            Set<Long> enableOrgs = BusinessDataServiceHelper.loadFromCache((String)"bd_accttabref_record", (String)"org", (QFilter[])qfBuilder.toArray()).values().stream().map(x -> x.getLong("org_id")).collect(Collectors.toSet());
            orgStructure = new OrgStructure(orgId, enableOrgs, Collections.emptySet());
        }
        excuteParam.setOrgStructure(orgStructure);
        List<OrgNode> allNodes = excuteParam.getOrgStructure().getAllNodes();
        for (OrgNode orgNode : allNodes) {
            long parentOrgId = orgNode.getParentOrgId();
            if (!excuteParam.getOrgParams().containsKey(parentOrgId)) {
                excuteParam.addOrgParam(SingleOrgExcuteParam.create(parentOrgId, excuteDate, accountTableRefMasterId, DisableParam.getRealDisableParam(), saveData));
            }
            List<Long> childOrgIds = orgNode.getChildOrgIds();
            for (Long childOrgId : childOrgIds) {
                if (excuteParam.getOrgParams().containsKey(childOrgId)) continue;
                excuteParam.addOrgParam(SingleOrgExcuteParam.create(childOrgId, excuteDate, accountTableRefMasterId, DisableParam.getRealDisableParam(), saveData));
            }
        }
        return excuteParam;
    }

    protected final long getRootOrgId() {
        return this.rootOrgId;
    }

    protected final void setRootOrgId(long rootOrgId) {
        this.rootOrgId = rootOrgId;
    }

    protected final Date getExcuteDate() {
        return this.excuteDate;
    }

    protected final void setExcuteDate(Date excuteDate) {
        this.excuteDate = excuteDate;
    }

    protected final long getAccountTableRefMasterId() {
        return this.accountTableRefMasterId;
    }

    protected final void setAccountTableRefMasterId(long accountTableRefMasterId) {
        this.accountTableRefMasterId = accountTableRefMasterId;
    }

    protected final OrgStructure getOrgStructure() {
        return this.orgStructure;
    }

    protected final void setOrgStructure(OrgStructure orgStructure) {
        this.orgStructure = orgStructure;
    }

    protected final Map<Long, SingleOrgExcuteParam> getOrgParams() {
        return this.orgParams;
    }

    protected final void setOrgParams(Map<Long, SingleOrgExcuteParam> orgParams) {
        this.orgParams = orgParams;
    }

    protected final void addOrgParam(SingleOrgExcuteParam orgParam) {
        this.orgParams.put(orgParam.getOrgId(), orgParam);
    }

    protected final SingleOrgExcuteParam getOrgParam(long orgId) {
        SingleOrgExcuteParam orgParam = this.getOrgParams().get(orgId);
        if (Objects.isNull(orgParam)) {
            orgParam = SingleOrgExcuteParam.create(orgId, this.getExcuteDate(), this.getAccountTableRefMasterId(), this.disableParam);
            this.addOrgParam(orgParam);
        }
        return orgParam;
    }

    protected final Map<Long, SingleOrgExcuteResult> getOrgResults() {
        return this.orgResults;
    }

    protected final SingleOrgExcuteResult getOrgResult(long orgId) {
        return this.getOrgResults().get(orgId);
    }

    protected void setOrgResults(Map<Long, SingleOrgExcuteResult> orgResults) {
        this.orgResults = orgResults;
    }

    protected void putAllOrgResults(Map<Long, SingleOrgExcuteResult> orgResults) {
        this.orgResults.putAll(orgResults);
    }

    protected void addOrgResult(long orgId, SingleOrgExcuteResult result) {
        this.orgResults.put(orgId, result);
    }

    protected DisableParam getDisableParam() {
        return this.disableParam;
    }

    protected void setDisableParam(DisableParam disableParam) {
        this.disableParam = disableParam;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }
}

