/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.accounttableref;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.bd.accounttableref.AccountTableRefTaskHelper;
import kd.fi.bd.accounttableref.OrgNode;
import kd.fi.bd.accounttableref.OrgStructure;
import kd.fi.bd.accounttableref.SingleOrgExcuteParam;
import kd.fi.bd.accounttableref.SingleOrgExcuteResult;
import kd.fi.bd.accounttableref.SingleOrgExcutor;
import kd.fi.bd.accounttableref.VirtualOrgExcuteParam;
import kd.fi.bd.util.QFBuilder;

public class VirtualOrgExcutor {
    private static final VirtualOrgExcutor INSTANCE = new VirtualOrgExcutor();
    private static final Log LOGGER = LogFactory.getLog(VirtualOrgExcutor.class);

    private VirtualOrgExcutor() {
    }

    public static VirtualOrgExcutor getInstance() {
        return INSTANCE;
    }

    public List<SingleOrgExcuteResult> enable(VirtualOrgExcuteParam virtualOrgExcuteParam) {
        int maxLevel;
        long accountTableRefMasterId = virtualOrgExcuteParam.getAccountTableRefMasterId();
        if (!QueryServiceHelper.exists((String)"bd_accounttableref", (Object)accountTableRefMasterId)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524dID\u201c%s\u201d\u5bf9\u5e94\u7684\u79d1\u76ee\u8868\u7248\u672c\u5316\u57fa\u7840\u8d44\u6599\u5df2\u7ecf\u4e0d\u5b58\u5728\uff0c\u6570\u636e\u5df2\u88ab\u5220\u9664\u3002", (String)"VirtualOrgExcutor_0", (String)"fi-bd-common", (Object[])new Object[0]), accountTableRefMasterId));
        }
        List allSuperiorOrgs = OrgUnitServiceHelper.getAllSuperiorOrgs((String)"10", (long)virtualOrgExcuteParam.getRootOrgId());
        QFBuilder qfBuilder = new QFBuilder("accountref.masterid", "=", accountTableRefMasterId);
        qfBuilder.add("org", "in", allSuperiorOrgs);
        qfBuilder.add("enablestatus", "=", "C");
        if (QueryServiceHelper.exists((String)"bd_accttabref_record", (QFilter[])qfBuilder.toArray())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u5b58\u5728\u4e0a\u7ea7\u7ec4\u7ec7\u5df2\u542f\u7528\u8be5\u5bf9\u7167\u5173\u7cfb\uff0c\u8be5\u7ec4\u7ec7\u53ca\u5176\u4e0b\u7ea7\u4e0d\u80fd\u542f\u7528\u3002", (String)"VirtualOrgExcutor_1", (String)"fi-bd-common", (Object[])new Object[0]));
        }
        VirtualOrgExcutor.setTaskTotal(virtualOrgExcuteParam);
        OrgStructure orgStructure = virtualOrgExcuteParam.getOrgStructure();
        for (int i = maxLevel = orgStructure.getMaxLevel(); i >= 0; --i) {
            List<OrgNode> nodes = orgStructure.getNodesWithLevel(i);
            for (OrgNode node : nodes) {
                virtualOrgExcuteParam.putAllOrgResults(this.singleOrgNodeEnable(node, virtualOrgExcuteParam));
            }
        }
        Collection<SingleOrgExcuteResult> allResults = virtualOrgExcuteParam.getOrgResults().values();
        return new ArrayList<SingleOrgExcuteResult>(allResults);
    }

    private Map<Long, SingleOrgExcuteResult> singleOrgNodeEnable(OrgNode node, VirtualOrgExcuteParam virtualOrgExcuteParam) {
        SingleOrgExcuteResult parentResult;
        long parentOrgId = node.getParentOrgId();
        List<Long> childOrgIds = node.getChildOrgIds();
        HashMap<Long, SingleOrgExcuteResult> singleNodeResults = new HashMap<Long, SingleOrgExcuteResult>(childOrgIds.size() + 1);
        if (CollectionUtils.isEmpty(childOrgIds)) {
            parentResult = VirtualOrgExcutor.singleOrgExcuteEnable(virtualOrgExcuteParam.getOrgParam(parentOrgId));
        } else {
            SingleOrgExcuteResult childOrgResult;
            boolean allChildResult = true;
            HashMap<Long, Future> childResults = new HashMap<Long, Future>(childOrgIds.size());
            for (Long l : childOrgIds) {
                childOrgResult = virtualOrgExcuteParam.getOrgResult(l);
                if (Objects.isNull(childOrgResult)) {
                    childResults.put(l, ThreadService.submit(() -> VirtualOrgExcutor.singleOrgExcuteEnable(virtualOrgExcuteParam.getOrgParam(childOrgId)), (TaskType)TaskType.FIBD_ACCT_TABLE_VERSION_ENABLE_TASK));
                    continue;
                }
                allChildResult &= childOrgResult.getCommonResult().isSuccess();
            }
            for (Map.Entry entry : childResults.entrySet()) {
                try {
                    childOrgResult = (SingleOrgExcuteResult)((Future)entry.getValue()).get();
                    allChildResult &= childOrgResult.getCommonResult().isSuccess();
                    singleNodeResults.put((Long)entry.getKey(), childOrgResult);
                    VirtualOrgExcutor.addOneExcutedOrg(virtualOrgExcuteParam);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    throw new KDException((Throwable)e, new ErrorCode("THREAD_POOL_EXECUTION", ResManager.loadKDString((String)"\u7ebf\u7a0b\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u6392\u67e5\u3002", (String)"VirtualOrgExcutor_2", (String)"fi-bd-common", (Object[])new Object[0])), new Object[0]);
                }
            }
            parentResult = allChildResult ? VirtualOrgExcutor.singleOrgExcuteEnable(virtualOrgExcuteParam.getOrgParam(parentOrgId)) : VirtualOrgExcutor.createFailResult(virtualOrgExcuteParam.getOrgParam(parentOrgId), ResManager.loadKDString((String)"\u4e0b\u7ea7\u7ec4\u7ec7\u5b58\u5728\u542f\u7528\u5931\u8d25\u3002", (String)"VirtualOrgExcutor_3", (String)"fi-bd-common", (Object[])new Object[0]));
        }
        VirtualOrgExcutor.addOneExcutedOrg(virtualOrgExcuteParam);
        singleNodeResults.put(parentOrgId, parentResult);
        return singleNodeResults;
    }

    public List<SingleOrgExcuteResult> disable(VirtualOrgExcuteParam virtualOrgExcuteParam) {
        long accountTableRefMasterId = virtualOrgExcuteParam.getAccountTableRefMasterId();
        if (!QueryServiceHelper.exists((String)"bd_accounttableref", (Object)accountTableRefMasterId)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524dID\u201c%s\u201d\u5bf9\u5e94\u7684\u79d1\u76ee\u8868\u7248\u672c\u5316\u57fa\u7840\u8d44\u6599\u5df2\u7ecf\u4e0d\u5b58\u5728\uff0c\u6570\u636e\u5df2\u88ab\u5220\u9664\u3002", (String)"VirtualOrgExcutor_0", (String)"fi-bd-common", (Object[])new Object[0]), accountTableRefMasterId));
        }
        List allSuperiorOrgs = OrgUnitServiceHelper.getAllSuperiorOrgs((String)"10", (long)virtualOrgExcuteParam.getRootOrgId());
        QFBuilder qfBuilder = new QFBuilder("accountref.masterid", "=", accountTableRefMasterId);
        qfBuilder.add("org", "in", allSuperiorOrgs);
        qfBuilder.add("enablestatus", "=", "C");
        if (QueryServiceHelper.exists((String)"bd_accttabref_record", (QFilter[])qfBuilder.toArray())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u5b58\u5728\u4e0a\u7ea7\u7ec4\u7ec7\u8fd8\u672a\u53cd\u542f\u7528\u8be5\u5bf9\u7167\u5173\u7cfb\uff0c\u8be5\u7ec4\u7ec7\u53ca\u5176\u4e0b\u7ea7\u4e0d\u80fd\u53cd\u542f\u7528\u3002", (String)"VirtualOrgExcutor_4", (String)"fi-bd-common", (Object[])new Object[0]));
        }
        VirtualOrgExcutor.setTaskTotal(virtualOrgExcuteParam);
        OrgStructure orgStructure = virtualOrgExcuteParam.getOrgStructure();
        int maxLevel = orgStructure.getMaxLevel();
        for (int i = 0; i <= maxLevel; ++i) {
            List<OrgNode> nodes = orgStructure.getNodesWithLevel(i);
            for (OrgNode node : nodes) {
                virtualOrgExcuteParam.putAllOrgResults(this.singleOrgNodeDisable(node, virtualOrgExcuteParam));
            }
        }
        Collection<SingleOrgExcuteResult> allResults = virtualOrgExcuteParam.getOrgResults().values();
        return new ArrayList<SingleOrgExcuteResult>(allResults);
    }

    private Map<Long, SingleOrgExcuteResult> singleOrgNodeDisable(OrgNode node, VirtualOrgExcuteParam virtualOrgExcuteParam) {
        long parentOrgId = node.getParentOrgId();
        List<Long> childOrgIds = node.getChildOrgIds();
        HashMap<Long, SingleOrgExcuteResult> singleNodeResults = new HashMap<Long, SingleOrgExcuteResult>(childOrgIds.size() + 1);
        SingleOrgExcuteResult parentResult = virtualOrgExcuteParam.getOrgResult(parentOrgId);
        if (Objects.isNull(parentResult)) {
            parentResult = VirtualOrgExcutor.singleOrgExcuteDisable(virtualOrgExcuteParam.getOrgParam(parentOrgId));
            singleNodeResults.put(parentOrgId, parentResult);
            VirtualOrgExcutor.addOneExcutedOrg(virtualOrgExcuteParam);
        }
        if (CollectionUtils.isEmpty(childOrgIds)) {
            return singleNodeResults;
        }
        if (!parentResult.getCommonResult().isSuccess()) {
            for (Long childOrgId : childOrgIds) {
                singleNodeResults.put(childOrgId, VirtualOrgExcutor.createFailResult(virtualOrgExcuteParam.getOrgParam(childOrgId), ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u53cd\u542f\u7528\u5931\u8d25\u3002", (String)"VirtualOrgExcutor_5", (String)"fi-bd-common", (Object[])new Object[0])));
                VirtualOrgExcutor.addOneExcutedOrg(virtualOrgExcuteParam);
            }
        } else {
            HashMap<Long, Future> childResults = new HashMap<Long, Future>(childOrgIds.size());
            for (Long l : childOrgIds) {
                childResults.put(l, ThreadService.submit(() -> VirtualOrgExcutor.singleOrgExcuteDisable(virtualOrgExcuteParam.getOrgParam(childOrgId)), (TaskType)TaskType.FIBD_ACCT_TABLE_VERSION_ENABLE_TASK));
            }
            for (Map.Entry entry : childResults.entrySet()) {
                try {
                    SingleOrgExcuteResult singleOrgExcuteResult = (SingleOrgExcuteResult)((Future)entry.getValue()).get();
                    singleNodeResults.put((Long)entry.getKey(), singleOrgExcuteResult);
                    VirtualOrgExcutor.addOneExcutedOrg(virtualOrgExcuteParam);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    throw new KDException((Throwable)e, new ErrorCode("THREAD_POOL_EXECUTION", ResManager.loadKDString((String)"\u7ebf\u7a0b\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u6392\u67e5\u3002", (String)"VirtualOrgExcutor_2", (String)"fi-bd-common", (Object[])new Object[0])), new Object[0]);
                }
            }
        }
        return singleNodeResults;
    }

    private static SingleOrgExcuteResult singleOrgExcuteDisable(SingleOrgExcuteParam excuteParam) {
        try {
            return SingleOrgExcutor.getInstance().disable(excuteParam);
        }
        catch (KDBizException e) {
            LOGGER.error((Throwable)e);
            return VirtualOrgExcutor.createFailResult(excuteParam, e.getMessage());
        }
    }

    private static SingleOrgExcuteResult singleOrgExcuteEnable(SingleOrgExcuteParam excuteParam) {
        try {
            return SingleOrgExcutor.getInstance().enable(excuteParam);
        }
        catch (KDBizException e) {
            LOGGER.error((Throwable)e);
            return VirtualOrgExcutor.createFailResult(excuteParam, e.getMessage());
        }
    }

    private static SingleOrgExcuteResult createFailResult(SingleOrgExcuteParam param, String msg) {
        SingleOrgExcuteResult excuteResult = new SingleOrgExcuteResult(param);
        excuteResult.getCommonResult().addMsg(msg);
        excuteResult.getCommonResult().setSuccess(false);
        return excuteResult;
    }

    private static void addOneExcutedOrg(VirtualOrgExcuteParam virtualOrgExcuteParam) {
        String taskId = virtualOrgExcuteParam.getTaskId();
        if (StringUtils.isNotBlank((CharSequence)taskId)) {
            AccountTableRefTaskHelper.addExcutedCount(taskId, 1);
        }
    }

    private static void setTaskTotal(VirtualOrgExcuteParam virtualOrgExcuteParam) {
        String taskId = virtualOrgExcuteParam.getTaskId();
        if (StringUtils.isNotBlank((CharSequence)taskId)) {
            AccountTableRefTaskHelper.setTotalCount(taskId, virtualOrgExcuteParam.getOrgParams().size());
        }
    }
}

