/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.accversion;

import com.google.common.base.Preconditions;
import com.google.common.collect.Table;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.accversion.AddingAssistService;
import kd.fi.bd.util.AccountBizCheckUtil;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.BiTreeNode;
import kd.fi.bd.vo.AccountVO;
import kd.fi.bd.vo.AssistEntryVO;
import kd.fi.bd.vo.OrgAccOwnershipVO;
import kd.fi.bd.vo.OrgVO;

public class AddingAssistServiceImpl
implements AddingAssistService {
    @Override
    public DynamicObject queryAccountDynObj(long accountId, String ... fields) {
        Preconditions.checkArgument((boolean)Objects.nonNull(fields));
        return QueryServiceHelper.queryOne((String)"bd_accountview", (String)String.join((CharSequence)",", fields), (QFilter[])new QFilter("id", "=", (Object)accountId).toArray());
    }

    @Override
    public BiTreeNode<Long, OrgVO> buildSubTreeByOrgId(int orgViewId, long rootOrgId) {
        return BDUtil.buildSubTreeByOrgId(orgViewId, Optional.of(rootOrgId));
    }

    @Override
    public BiTreeNode<String, AccountVO> buildSubTreeByAccountNumber(long accountTableId, String accountNumber, String longnumber, List<Long> useOrgIdList) {
        return BDUtil.buildSubTreeByAccountNumber(accountTableId, accountNumber, longnumber, useOrgIdList);
    }

    @Override
    public Map<Long, OrgAccOwnershipVO> getAllSubLatestAccountInfoInUseOrgRange(long rootAccountId, List<Long> useOrgIdList, Date versionDate) {
        return BDUtil.getAllSubLatestAccountInfoInUseOrgRange(rootAccountId, useOrgIdList, versionDate);
    }

    @Override
    public Map<Long, DynamicObject> loadAccountIdDynObjMap(Collection<Long> accountIds) {
        return this.loadIdDynObjMap(accountIds, "bd_accountview");
    }

    @Override
    public Map<Long, DynamicObject> loadOrgIdDynObjMap(Collection<Long> orgIds) {
        return this.loadIdDynObjMap(orgIds, "bos_org");
    }

    @Override
    public Map<Long, DynamicObject> loadAssistIdDynObjMap(Collection<Long> assistIds) {
        return this.loadIdDynObjMap(assistIds, "bd_asstacttype");
    }

    @Override
    public Map<Long, Map<String, Boolean>> isAccountIncludeAssist(Map<Long, OrgAccOwnershipVO> orgNumberIdMap, List<AssistEntryVO> addingAssitList) {
        return BDUtil.isAccountIncludeAssist(orgNumberIdMap, addingAssitList);
    }

    @Override
    public Table<Long, Long, Integer> batchCheckAfterSpecificDate(Map<Long, Set<Long>> orgAccountMap, Date versionDate) {
        return AccountBizCheckUtil.batchCheckAfterSpecificDate(orgAccountMap, versionDate);
    }

    private Map<Long, DynamicObject> loadIdDynObjMap(Collection<Long> ids, String entityName) {
        DynamicObject[] loadDatas = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
        return Arrays.stream(loadDatas).collect(Collectors.toMap(x -> x.getLong("id"), x -> x, (oldVal, newVal) -> newVal));
    }
}

