/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.assign;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataService;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.bd.assign.AccountAssigner;
import kd.fi.bd.assign.AssignAccountNumTreeNode;
import kd.fi.bd.assign.AssignCtx;
import kd.fi.bd.assign.AssignResult;
import kd.fi.bd.assign.BuildOrgAcctParentAndOtherParentsAssign;
import kd.fi.bd.assign.BuildOrgAcctParents;
import kd.fi.bd.assign.CheckOorgCreateSameAcctByNum;
import kd.fi.bd.assign.CheckOpAcctVersioned;
import kd.fi.bd.assign.MakeAssignExcuter;
import kd.fi.bd.assign.OrgAcctParent;
import kd.fi.bd.assign.OrgSingleAssignCtx;
import kd.fi.bd.assign.RemoveAlreadyAssignAcctId;
import kd.fi.bd.consts.AccountOperationType;
import kd.fi.bd.consts.OperationLogEntry;
import kd.fi.bd.util.AccountOperationLogUtil;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.vo.AssignOrgTreeNode;

public class AssignHandle {
    private static final Log logger = LogFactory.getLog(AssignHandle.class);
    private AssignCtx ctx;
    private IFormView view;
    private Set<Long> doNotAssignOrgs;

    public AssignHandle(AssignCtx ctx, IFormView view) {
        this.ctx = ctx;
        this.view = view;
        this.doNotAssignOrgs = new HashSet<Long>(10);
        if (view != null) {
            view.getPageCache().put(view.getPageId() + "asignedDatas", SerializationUtils.toJsonString(ctx.getDataIDs()));
        }
    }

    public AssignResult handle() {
        AssignResult assignResult;
        block24: {
            assignResult = new AssignResult(AssignResult.ResultType.success);
            String lockMsg = String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u5206\u914d\u6216\u53d6\u6d88\u5206\u914d\u4e2d\uff0c\u8bf7\u7b49\u5f85\u64cd\u4f5c\u7ed3\u675f\u518d\u8fdb\u884c\u5206\u914d", (String)"AssignHandle_22", (String)"fi-bd-common", (Object[])new Object[0]), RequestContext.get().getUserName());
            String lockKey = "assignlock" + this.ctx.getAccountTableId();
            try (DLock dLock = DLock.create((String)lockKey, (String)lockMsg);){
                if (dLock.tryLock()) {
                    AccountOperationLogUtil.initRawOperationLog(this.ctx.getUseOrgid(), AccountOperationType.ASSIGN, this.ctx.getAccountTableId(), new HashSet<Long>(this.ctx.getDataIDs()));
                    AccountOperationLogUtil.setOperationLog(operationLog -> operationLog.setOrgIds(new HashSet<Long>(this.ctx.getOrgIds())));
                    OrgSingleAssignCtx pAssignCtx = this.buildAssignCtx(this.ctx.getUseOrgid());
                    Map<String, OrgAcctParent> oapopMap = pAssignCtx.getOapopMap();
                    for (Map.Entry<String, OrgAcctParent> entry : oapopMap.entrySet()) {
                        OrgAcctParent oapop = entry.getValue();
                        if (this.parentTreeContainsAssignOrg(oapop, pAssignCtx)) continue;
                        String useOrgName = BDUtil.getOrgById(this.ctx.getUseOrgid()).getString("name");
                        String tip = String.format(ResManager.loadKDString((String)"%1$s\u79d1\u76ee\uff1a\u516c\u53f8'%2$s'\u7684%3$s\u79d1\u76ee\u7684\u521b\u5efa\u7ec4\u7ec7\u4e0d\u518d\u662f\u73b0\u6709\u6838\u7b97\u7ec4\u7ec7\u7684\u4e0a\u7ea7\u7ec4\u7ec7\uff0c\u8bf7\u5148\u5bf9'%4$s'\u7684%5$s\u79d1\u76ee\u8fdb\u884c\u7248\u672c\u5316\uff0c\u7136\u540e\u518d\u5206\u914d\u8be5\u79d1\u76ee\u3002", (String)"MakeAssignExcuter_1", (String)"fi-bd-formplugin", (Object[])new Object[0]), oapop.getAcctNum(), useOrgName, oapop.getAcctNum(), useOrgName, oapop.getAcctNum());
                        OperationLogEntry entity = new OperationLogEntry(this.ctx.getUseOrgid(), oapop.getAcctId(), AccountOperationType.ASSIGN, Boolean.FALSE);
                        entity.setLog(tip);
                        AccountOperationLogUtil.addLogEntryRow(entity);
                        this.ctx.getAcctCheckErrMsg().add(tip);
                        throw new Exception(tip);
                    }
                    this.doAssign(this.ctx.getUseOrgid());
                    if (this.ctx.getAcctCheckErrMsg().size() > 0) {
                        AccountOperationLogUtil.persistLog(ResManager.loadKDString((String)"\u5931\u8d25", (String)"UnAssignHandle_8", (String)"fi-bd-common", (Object[])new Object[0]));
                        assignResult.getMsgs().addAll(this.ctx.getAcctCheckErrMsg());
                        assignResult.setResultType(AssignResult.ResultType.failed);
                    } else {
                        AccountOperationLogUtil.persistLog("");
                    }
                    break block24;
                }
                assignResult.getMsgs().add(DLock.getLockInfo((String)lockKey).getDesc());
                assignResult.setResultType(AssignResult.ResultType.locking);
                AssignResult assignResult2 = assignResult;
                return assignResult2;
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                AccountOperationLogUtil.persistLog(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                throw new KDBizException(new ErrorCode("common", "%s"), new Object[]{e.getMessage()});
            }
            finally {
                this.refreshBaseDataUseRange();
            }
        }
        return assignResult;
    }

    private OrgSingleAssignCtx buildAssignCtx(Long orgId) throws Exception {
        OrgSingleAssignCtx curAssignCtx = new OrgSingleAssignCtx(this.ctx);
        curAssignCtx.setUseOrgid(orgId);
        AccountAssigner accountAssigner = new AccountAssigner(curAssignCtx, null);
        BuildOrgAcctParentAndOtherParentsAssign accountAssign = new BuildOrgAcctParentAndOtherParentsAssign();
        accountAssign.setNextAssigner(new BuildOrgAcctParents());
        accountAssigner.setAccountAssign(accountAssign);
        accountAssigner.assign();
        return curAssignCtx;
    }

    private void doAssign(Long orgId) throws Exception {
        OrgSingleAssignCtx pAssignCtx = this.buildAssignCtx(orgId);
        Map<Long, AssignOrgTreeNode> assignOrgTreeNodeMap = this.ctx.getAssignOrgTreeNodeMap();
        AssignOrgTreeNode assignOrgTreeNode = assignOrgTreeNodeMap.get(orgId);
        Set<Long> childIds = assignOrgTreeNode.getChildIds();
        CountDownLatch cdl = new CountDownLatch(childIds.size());
        this.processExplain(assignOrgTreeNodeMap, orgId);
        String requestId = RequestContext.getOrCreate().getRequestId();
        for (Long childId : childIds) {
            ThreadService.execute(() -> {
                try {
                    RequestContext.getOrCreate().setRequestId(requestId);
                    OrgSingleAssignCtx childSingleAssignCtx = new OrgSingleAssignCtx(this.ctx);
                    childSingleAssignCtx.setUseOrgid(childId);
                    BuildOrgAcctParentAndOtherParentsAssign accountAssign = new BuildOrgAcctParentAndOtherParentsAssign();
                    accountAssign.setNextAssigner(new BuildOrgAcctParents()).setNextAssigner(new RemoveAlreadyAssignAcctId()).setNextAssigner(new CheckOpAcctVersioned()).setNextAssigner(new CheckOorgCreateSameAcctByNum()).setNextAssigner(new MakeAssignExcuter());
                    AccountAssigner accountAssigner = new AccountAssigner(childSingleAssignCtx, pAssignCtx);
                    accountAssigner.setAccountAssign(accountAssign);
                    accountAssigner.assign();
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    this.ctx.getAcctCheckErrMsg().add(e.getMessage());
                    logger.error(e.getMessage());
                    this.doNotAssignOrgs.add(childId);
                }
                finally {
                    cdl.countDown();
                }
            }, (TaskType)TaskType.FIBD_ACCOUNT_ASSIGN_TASK);
        }
        try {
            cdl.await();
        }
        catch (InterruptedException e) {
            this.ctx.getAcctCheckErrMsg().add(e.getMessage());
            logger.error(e.getMessage());
            throw new KDBizException(new ErrorCode("common", "%s"), new Object[]{e.getMessage()});
        }
        if (this.ctx.getAcctCheckErrMsg().size() > 0) {
            return;
        }
        for (Long childId : childIds) {
            if (this.doNotAssignOrgs.contains(childId)) continue;
            this.doAssign(childId);
        }
    }

    private boolean parentTreeContainsAssignOrg(OrgAcctParent oapop, OrgSingleAssignCtx ctx) {
        Long useOrgId = ctx.getUseOrgid();
        Long assignOrgId = oapop.getCreateOrgId();
        logger.info("useOrgId:" + useOrgId + ",assignOrgId:" + oapop.toString());
        if (null == assignOrgId) {
            return true;
        }
        Map<Long, AssignOrgTreeNode> assignOrgTreeNodeMapToTopOrg = ctx.getAssignCtx().getAssignOrgTreeNodeMapToTopOrg();
        return this.rescuMatch(assignOrgId, useOrgId, assignOrgTreeNodeMapToTopOrg);
    }

    private boolean rescuMatch(Long assignOrgId, Long useOrgId, Map<Long, AssignOrgTreeNode> assignOrgTreeNodeMapToTopOrg) {
        if (assignOrgId.compareTo(useOrgId) == 0) {
            return true;
        }
        if (assignOrgTreeNodeMapToTopOrg.get(useOrgId) == null) {
            return false;
        }
        if (assignOrgTreeNodeMapToTopOrg.get(useOrgId).getParentId() == null) {
            return false;
        }
        Long parentOrgId = assignOrgTreeNodeMapToTopOrg.get(useOrgId).getParentId();
        return this.rescuMatch(assignOrgId, parentOrgId, assignOrgTreeNodeMapToTopOrg);
    }

    private void processExplain(Map<Long, AssignOrgTreeNode> assignOrgTreeNodeMap, Long rootId) {
        this.orgTreeStructureExplain(assignOrgTreeNodeMap, rootId);
        this.acctTreeStructureExplain();
    }

    private void acctTreeStructureExplain() {
        Map<String, AssignAccountNumTreeNode> accountNumTreeNodeMap = this.ctx.getAssignAcctountNumTreeNodeMap();
        List acctNumbers = accountNumTreeNodeMap.entrySet().stream().filter(e -> StringUtils.isEmpty((CharSequence)((AssignAccountNumTreeNode)e.getValue()).getPnumber())).map(x -> ((AssignAccountNumTreeNode)x.getValue()).getNumber()).collect(() -> new ArrayList(10), (r, x) -> r.add(x), (left, right) -> left.addAll(right));
        this.explainTopAccts(acctNumbers);
        this.recuExplainChild(acctNumbers, accountNumTreeNodeMap);
    }

    private void recuExplainChild(Collection<String> acctNumbers, Map<String, AssignAccountNumTreeNode> accountNumTreeNodeMap) {
        Set<String> childNumbers;
        AssignAccountNumTreeNode assignAccountNumTreeNode;
        for (String acctNumber : acctNumbers) {
            assignAccountNumTreeNode = accountNumTreeNodeMap.get(acctNumber);
            childNumbers = assignAccountNumTreeNode.getChildNumbers();
            this.explainAcctAndSubAccts(acctNumber, childNumbers);
        }
        for (String acctNumber : acctNumbers) {
            assignAccountNumTreeNode = accountNumTreeNodeMap.get(acctNumber);
            childNumbers = assignAccountNumTreeNode.getChildNumbers();
            this.recuExplainChild(childNumbers, accountNumTreeNodeMap);
        }
    }

    private void explainTopAccts(List<String> acctNumbers) {
        this.explainAcctAndSubAccts("", acctNumbers);
    }

    private void explainAcctAndSubAccts(String parentAcct, Collection<String> acctNumbers) {
        StringBuilder acctNumExplainBuilder = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)parentAcct)) {
            acctNumExplainBuilder.append("top level acct : ");
        } else {
            acctNumExplainBuilder.append("pacctnumber : ").append(parentAcct).append(";");
        }
        if (null != acctNumbers && !acctNumbers.isEmpty()) {
            for (String acctNum : acctNumbers) {
                acctNumExplainBuilder.append("acctNumber : ").append(acctNum).append(",");
            }
            if (acctNumExplainBuilder.length() > 0) {
                acctNumExplainBuilder.deleteCharAt(acctNumExplainBuilder.length() - 1).append(";");
            }
        } else {
            acctNumExplainBuilder.append("no child");
        }
        logger.info(acctNumExplainBuilder.toString());
    }

    private void orgTreeStructureExplain(Map<Long, AssignOrgTreeNode> assignOrgTreeNodeMap, Long orgId) {
        HashMap<Long, String> orgNameMap = new HashMap<Long, String>(assignOrgTreeNodeMap.size());
        this.buildOrgIdNameMap(assignOrgTreeNodeMap, orgNameMap);
        this.buildOrgExplainInfo(true, orgId, Long.parseLong("0"), orgNameMap);
        this.recuExplainChild(orgId, orgNameMap, assignOrgTreeNodeMap);
        this.ctx.getOrgNameMap().putAll(orgNameMap);
    }

    private void buildOrgIdNameMap(Map<Long, AssignOrgTreeNode> assignOrgTreeNodeMap, Map<Long, String> orgNameMap) {
        DynamicObject[] orgNames;
        Set<Long> orgExcuteOrgid = this.buildExcuteOrgIdSets(assignOrgTreeNodeMap);
        QFilter orgFilter = new QFilter("id", "in", orgExcuteOrgid);
        for (DynamicObject orgName : orgNames = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{orgFilter})) {
            orgNameMap.put(orgName.getLong("id"), orgName.getString("name"));
        }
    }

    private void recuExplainChild(Long orgId, Map<Long, String> orgNameMap, Map<Long, AssignOrgTreeNode> assignOrgTreeNodeMap) {
        AssignOrgTreeNode assignOrgTreeNode = assignOrgTreeNodeMap.get(orgId);
        Set<Long> childTreeNodes = assignOrgTreeNode.getChildIds();
        for (Long treeID : childTreeNodes) {
            this.buildOrgExplainInfo(false, treeID, orgId, orgNameMap);
        }
        for (Long childNode : childTreeNodes) {
            this.recuExplainChild(childNode, orgNameMap, assignOrgTreeNodeMap);
        }
    }

    private void buildOrgExplainInfo(boolean isroot, Long orgId, Long parentId, Map<Long, String> orgNameMap) {
        StringBuilder strBuild = new StringBuilder();
        if (isroot) {
            strBuild.append("assignOrgTreeNodeMap root : ");
        } else {
            strBuild.append("assignOrgTreeNodeMap node : ");
        }
        strBuild.append("parentId : ").append(parentId).append(";").append("parentname : ").append(orgNameMap.get(parentId)).append(";").append("id : ").append(orgId).append(";").append("name : ").append(orgNameMap.get(orgId)).append(";");
        logger.info(strBuild.toString());
    }

    private Set<Long> buildExcuteOrgIdSets(Map<Long, AssignOrgTreeNode> assignOrgTreeNodeMap) {
        HashSet<Long> orgExcuteOrgid = new HashSet<Long>(assignOrgTreeNodeMap.size());
        for (Map.Entry<Long, AssignOrgTreeNode> orgEntry : assignOrgTreeNodeMap.entrySet()) {
            orgExcuteOrgid.add(orgEntry.getKey());
        }
        return orgExcuteOrgid;
    }

    private void refreshBaseDataUseRange() {
        try {
            if (AccountVersionUtil.isRebuildDataUseRangeSystemProperty()) {
                List<Long> orgIds = this.ctx.getOrgIds();
                ArrayList<Long> singletonList = new ArrayList<Long>(1);
                BaseDataService baseDataService = new BaseDataService();
                for (Long orgId : orgIds) {
                    singletonList.clear();
                    singletonList.add(orgId);
                    baseDataService.clearBaseDataFilterCache("bd_accountview", orgId);
                    BaseDataServiceHelper.refreshBaseDataUseRange((String)"bd_accountview", singletonList);
                }
            }
            Set<String> acctCheckErrMsg = this.ctx.getAcctCheckErrMsg();
            if (this.view != null) {
                this.view.getPageCache().put("mark", "finish");
                this.view.getPageCache().put("msg", acctCheckErrMsg.size() > 0 ? JSONObject.toJSONString(acctCheckErrMsg) : null);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

