/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.assign;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.assign.AbstractAccountAssign;
import kd.fi.bd.assign.AccountAssignEvent;
import kd.fi.bd.assign.AssignCtx;
import kd.fi.bd.assign.OrgAcctParent;
import kd.fi.bd.assign.OrgSingleAssignCtx;

public class BuildOrgAcctParents
extends AbstractAccountAssign {
    private static final Log logger = LogFactory.getLog(BuildOrgAcctParents.class);

    @Override
    protected boolean process(AccountAssignEvent accountAssignEvent) {
        logger.info("orgid : " + accountAssignEvent.getAccountAssigner().getCtx().getUseOrgid() + " process start");
        OrgSingleAssignCtx ctx = accountAssignEvent.getAccountAssigner().getCtx();
        AssignCtx assignCtx = ctx.getAssignCtx();
        Map<String, OrgAcctParent> oapopMap = ctx.getOapopMap();
        HashSet<Long> parentId = new HashSet<Long>(10);
        for (Map.Entry<String, OrgAcctParent> oapopEntry : oapopMap.entrySet()) {
            Long pAcctId = oapopEntry.getValue().getpAcctId();
            if (null == pAcctId || pAcctId == 0L) continue;
            parentId.add(pAcctId);
        }
        if (null == parentId || parentId.size() == 0) {
            logger.info("orgid : " + accountAssignEvent.getAccountAssigner().getCtx().getUseOrgid() + " null == parentId||parentId.size()  return");
            return true;
        }
        ArrayList<Object> acctountSqlParams = new ArrayList<Object>(10);
        StringBuilder acctountSql = new StringBuilder();
        acctountSql.append(" select a.fid,a.fmasterid,a.fnumber,a.fcreateOrgId,a.fctrlstrategy,a.fenddate,l.fname ");
        acctountSql.append(" from  t_bd_account a");
        acctountSql.append(" left join t_bd_account_l l on a.fid=l.fid ");
        acctountSql.append(" and l.flocaleid =? ");
        String lang = RequestContext.get().getLang().getLocale().getLanguage() + "_" + RequestContext.get().getLang().getLocale().getCountry();
        acctountSqlParams.add(lang);
        acctountSql.append(" where a.fid in ( ");
        parentId.forEach(k -> acctountSql.append("?,"));
        acctountSqlParams.addAll(parentId);
        acctountSql.deleteCharAt(acctountSql.length() - 1).append(" ) ");
        Map acctountSqlResult = (Map)DB.query((DBRoute)DBRoute.of((String)"gl"), (String)acctountSql.toString(), (Object[])acctountSqlParams.toArray(), (ResultSetHandler)new ResultSetHandler<Map<Long, Map<String, Object>>>(){

            public Map<Long, Map<String, Object>> handle(ResultSet rs) throws Exception {
                HashMap<Long, Map<String, Object>> returnObjs = new HashMap<Long, Map<String, Object>>(16);
                while (rs.next()) {
                    HashMap<String, Object> returnObj = new HashMap<String, Object>(16);
                    long fid = rs.getLong("fid");
                    returnObj.put("fnumber", rs.getString("fnumber"));
                    returnObj.put("fid", fid);
                    returnObj.put("fmasterid", rs.getLong("fmasterid"));
                    returnObj.put("fctrlstrategy", rs.getString("fctrlstrategy"));
                    returnObj.put("fcreateorgid", rs.getLong("fcreateorgid"));
                    returnObj.put("fname", rs.getString("fname"));
                    returnObjs.put(fid, returnObj);
                }
                return returnObjs;
            }
        });
        for (Map.Entry<String, OrgAcctParent> oapopEntry : oapopMap.entrySet()) {
            Map accountInfo;
            OrgAcctParent oap = oapopEntry.getValue();
            Long pAcctId = oap.getpAcctId();
            if (null == pAcctId || pAcctId == 0L || (accountInfo = (Map)acctountSqlResult.get(pAcctId)) == null) continue;
            oap.setpAcctName((String)accountInfo.get("fname"));
            oap.setpAcctNum((String)accountInfo.get("fnumber"));
            oap.setpAcctMasterId((Long)accountInfo.get("fmasterid"));
        }
        logger.info("orgid : " + accountAssignEvent.getAccountAssigner().getCtx().getUseOrgid() + " process end");
        return true;
    }
}

