/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.assign;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.accountref.AccountRef;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.bd.accounttableref.AccountTableRefServiceParam;
import kd.fi.bd.assign.AbstractAccountAssign;
import kd.fi.bd.assign.AccountAssignEvent;
import kd.fi.bd.assign.AccountAssigner;
import kd.fi.bd.assign.AssignAccountNumTreeNode;
import kd.fi.bd.assign.AssignCtx;
import kd.fi.bd.assign.AssignServiceHelper;
import kd.fi.bd.assign.CloneUtilFactory;
import kd.fi.bd.assign.OrgAcctParent;
import kd.fi.bd.assign.OrgSingleAssignCtx;
import kd.fi.bd.consts.AccountOperationType;
import kd.fi.bd.consts.OperationLogEntry;
import kd.fi.bd.util.AccountOperationLogUtil;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.vo.AssignOrgTreeNode;

public class MakeAssignExcuter
extends AbstractAccountAssign {
    private static final Log log = LogFactory.getLog(MakeAssignExcuter.class);

    @Override
    protected boolean process(AccountAssignEvent accountAssignEvent) throws Exception {
        log.info("orgid : " + accountAssignEvent.getAccountAssigner().getCtx().getUseOrgid() + " process start");
        AccountAssigner accountAssigner = accountAssignEvent.getAccountAssigner();
        OrgSingleAssignCtx ctx = accountAssigner.getCtx();
        OrgSingleAssignCtx pCtx = accountAssigner.getpCtx();
        AssignCtx assignCtx = ctx.getAssignCtx();
        Map<String, OrgAcctParent> oapopMap = ctx.getOapopMap();
        Map<String, OrgAcctParent> pctxOapopMap = pCtx.getOapopMap();
        this.buildIDdataDynObjMap(ctx, oapopMap);
        log.info("orgid : " + accountAssignEvent.getAccountAssigner().getCtx().getUseOrgid() + " before  Map<String, AssignAccountNumTreeNode> accountNumTreeNodeMap ");
        Map<String, AssignAccountNumTreeNode> accountNumTreeNodeMap = assignCtx.getAssignAcctountNumTreeNodeMap();
        List acctNumbers = accountNumTreeNodeMap.entrySet().stream().filter(e -> StringUtils.isEmpty((CharSequence)((AssignAccountNumTreeNode)e.getValue()).getPnumber())).map(x -> ((AssignAccountNumTreeNode)x.getValue()).getNumber()).collect(() -> new ArrayList(10), (r, x) -> r.add(x), (left, right) -> left.addAll(right));
        this.explainAcctNumbers(true, "out", "top", acctNumbers);
        for (String acctNumber : acctNumbers) {
            this.testAssign(ctx, oapopMap, pctxOapopMap, accountNumTreeNodeMap, acctNumber);
        }
        if (ctx.getUseRegParam().size() > 0 || ctx.getExcParams().size() > 0) {
            AccountVersionUtil.doAssign(ctx.getExcParams(), ctx.getUseRegParam());
            ctx.getUseRegParam().clear();
            ctx.getExcParams().clear();
        }
        log.info("orgid : " + accountAssignEvent.getAccountAssigner().getCtx().getUseOrgid() + " process end");
        return true;
    }

    private void buildIDdataDynObjMap(OrgSingleAssignCtx ctx, Map<String, OrgAcctParent> oapopMap) {
        HashSet<Long> regAndExcdataIds = new HashSet<Long>(5);
        HashSet<Long> oapIds = new HashSet<Long>(5);
        Set<Map.Entry<String, OrgAcctParent>> oapopMapEntrys = oapopMap.entrySet();
        for (Map.Entry<String, OrgAcctParent> oapopMapEntry : oapopMapEntrys) {
            OrgAcctParent oapop = oapopMapEntry.getValue();
            regAndExcdataIds.addAll(oapop.getUseregIds());
            regAndExcdataIds.addAll(oapop.getExcIds());
            oapIds.add(oapop.getAcctId());
        }
        if (regAndExcdataIds.size() > 0) {
            HashMap<Long, DynamicObject> iddataMap = new HashMap<Long, DynamicObject>(regAndExcdataIds.size());
            QFilter dataIdsFilter = new QFilter("id", "in", regAndExcdataIds);
            DynamicObjectCollection cols = QueryServiceHelper.query((String)"bd_accountview", (String)"id,number,createorg_id,ctrlstrategy", (QFilter[])new QFilter[]{dataIdsFilter});
            for (DynamicObject acctDynObj : cols) {
                iddataMap.put(acctDynObj.getLong("id"), acctDynObj);
            }
            ctx.getIddataDynMap().putAll(iddataMap);
        }
        if (oapIds.size() > 0) {
            HashMap<Long, DynamicObject> acctLeafParent = new HashMap<Long, DynamicObject>(regAndExcdataIds.size());
            String selectFields = "id,isleaf,parent.id";
            QFilter[] qfArr = new QFilter[]{new QFilter("id", "in", oapIds)};
            DynamicObjectCollection dyCol = QueryServiceHelper.query((String)"bd_accountview", (String)selectFields, (QFilter[])qfArr);
            for (DynamicObject acctObj : dyCol) {
                acctLeafParent.put(acctObj.getLong("id"), acctObj);
            }
            ctx.getAcctLeafParent().putAll(acctLeafParent);
        }
    }

    private void explainAcctNumbers(boolean isTop, String outExplain, String parent, Collection<String> acctNumbers) {
        StringBuilder acctNumberBuilders = new StringBuilder();
        acctNumberBuilders.append("process acctNumbers : ");
        acctNumberBuilders.append(outExplain);
        if (isTop) {
            acctNumberBuilders.append(" top level ");
        } else {
            acctNumberBuilders.append(" child level ");
        }
        acctNumberBuilders.append("parent ").append(" : ").append(parent).append(";");
        acctNumberBuilders.append("child ").append(" : ");
        for (String acctNumber : acctNumbers) {
            acctNumberBuilders.append(acctNumber).append(",");
        }
        acctNumberBuilders.append(";");
        log.info(acctNumberBuilders.toString());
    }

    private boolean parentTreeContainsAssignOrg(OrgAcctParent oapop, OrgSingleAssignCtx ctx) {
        Long useOrgId = ctx.getUseOrgid();
        Long assignOrgId = oapop.getCreateOrgId();
        log.info("useOrgId:" + useOrgId + ",assignOrgId:" + oapop.toString());
        if (null == assignOrgId) {
            return true;
        }
        Map<Long, AssignOrgTreeNode> assignOrgTreeNodeMapToTopOrg = ctx.getAssignCtx().getAssignOrgTreeNodeMapToTopOrg();
        return this.rescuMatch(assignOrgId, useOrgId, assignOrgTreeNodeMapToTopOrg);
    }

    private boolean rescuMatch(Long assignOrgId, Long useOrgId, Map<Long, AssignOrgTreeNode> assignOrgTreeNodeMapToTopOrg) {
        if (assignOrgId.compareTo(useOrgId) == 0) {
            return true;
        }
        if (assignOrgTreeNodeMapToTopOrg.get(useOrgId) == null) {
            return false;
        }
        if (assignOrgTreeNodeMapToTopOrg.get(useOrgId).getParentId() == null) {
            return false;
        }
        Long parentOrgId = assignOrgTreeNodeMapToTopOrg.get(useOrgId).getParentId();
        return this.rescuMatch(assignOrgId, parentOrgId, assignOrgTreeNodeMapToTopOrg);
    }

    private void testAssign(OrgSingleAssignCtx ctx, Map<String, OrgAcctParent> oapopMap, Map<String, OrgAcctParent> pctxOapopMap, Map<String, AssignAccountNumTreeNode> accountNumTreeNodeMap, String acctNumber) throws Exception {
        Object createOrgId22;
        OrgAcctParent oapop = oapopMap.get(acctNumber);
        if (oapop == null) {
            String useOrgName = BDUtil.getOrgById(ctx.getUseOrgid()).getString("name");
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5728\u5bf9\u7ec4\u7ec7'%1$s'\u5206\u914d\u79d1\u76ee%2$s\u7684\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u95ee\u9898\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MakeAssignExcuter_5", (String)"fi-bd-common", (Object[])new Object[0]), useOrgName, acctNumber);
            OperationLogEntry entity = new OperationLogEntry(ctx.getUseOrgid(), 0L, AccountOperationType.ASSIGN, Boolean.FALSE);
            entity.setLog(errorMsg);
            AccountOperationLogUtil.addLogEntryRow(entity);
            throw new Exception(errorMsg);
        }
        this.testAssignExplain(ctx, acctNumber, oapopMap, pctxOapopMap);
        Long useOrgId = ctx.getUseOrgid();
        log.info("useOrgId:" + useOrgId + ",assignOrgId:" + oapop.toString());
        if (!this.parentTreeContainsAssignOrg(oapop, ctx)) {
            String useOrgName = BDUtil.getOrgById(ctx.getUseOrgid()).getString("name");
            String tip = String.format(ResManager.loadKDString((String)"%1$s\u79d1\u76ee\uff1a\u516c\u53f8'%2$s'\u7684%3$s\u79d1\u76ee\u7684\u521b\u5efa\u7ec4\u7ec7\u4e0d\u518d\u662f\u73b0\u6709\u6838\u7b97\u7ec4\u7ec7\u7684\u4e0a\u7ea7\u7ec4\u7ec7\uff0c\u8bf7\u5148\u5bf9'%4$s'\u7684%5$s\u79d1\u76ee\u8fdb\u884c\u7248\u672c\u5316\uff0c\u7136\u540e\u518d\u5206\u914d\u8be5\u79d1\u76ee\u3002", (String)"MakeAssignExcuter_1", (String)"fi-bd-formplugin", (Object[])new Object[0]), acctNumber, useOrgName, acctNumber, useOrgName, acctNumber);
            OperationLogEntry entity = new OperationLogEntry(useOrgId, oapop.getAcctId(), AccountOperationType.ASSIGN, Boolean.FALSE);
            entity.setLog(tip);
            AccountOperationLogUtil.addLogEntryRow(entity);
            throw new Exception(tip);
        }
        if (!oapop.isNeedDeal()) {
            AssignAccountNumTreeNode assignAccountNumTreeNode = accountNumTreeNodeMap.get(acctNumber);
            Set<String> childNumbers = assignAccountNumTreeNode.getChildNumbers();
            this.explainAcctNumbers(false, "testAssign noDeal", acctNumber, childNumbers);
            for (String childNumber : childNumbers) {
                this.testAssign(ctx, oapopMap, pctxOapopMap, accountNumTreeNodeMap, childNumber);
            }
            return;
        }
        OrgAcctParent pctOap = pctxOapopMap.get(acctNumber);
        String pacctNum = oapop.getpAcctNum();
        if (pctOap == null || pacctNum == null || !oapopMap.get(pacctNum).getCreateOrgId().equals(ctx.getUseOrgid())) {
            long acctParentId;
            if (pctOap != null && pacctNum != null) {
                boolean isIncludeParentAccount;
                Long pAccountId = pctxOapopMap.get(pacctNum).getAcctId();
                OrgAcctParent orgAcctParent = oapopMap.get(pacctNum);
                boolean bl = isIncludeParentAccount = null != orgAcctParent && orgAcctParent.getUseregIds().contains(pAccountId);
                if (!isIncludeParentAccount) {
                    oapop.setNeedDeal(false);
                    AssignCtx assignCtx = ctx.getAssignCtx();
                    Map<Long, String> orgNameMap = assignCtx.getOrgNameMap();
                    String msg = String.format(ResManager.loadKDString((String)"\u5206\u914d\u8fc7\u7a0b\u4e2d\u68c0\u67e5\u5230\u79d1\u76ee\u201c%1$s\u201d\u5f02\u5e38\uff0c\u8bf7\u5bf9\u7ec4\u7ec7\u201c%2$s\u201d\u7684\u79d1\u76ee\u201c%3$s\u201d\u5148\u8fdb\u884c\u7248\u672c\u5316\u518d\u5206\u914d\u3002", (String)"MakeAssignExcuter_3", (String)"fi-bd-common", (Object[])new Object[0]), pacctNum, orgNameMap.get(ctx.getUseOrgid()), pacctNum);
                    throw new KDBizException(new ErrorCode("common", "%s"), new Object[]{msg});
                }
            }
            oapop.setNeedVerison(false);
            HashSet<Long> acctIdSet = new HashSet<Long>(1);
            acctIdSet.add(oapop.getAcctId());
            DynamicObject acctDybOjb = ctx.getAcctLeafParent().get(oapop.getAcctId());
            if (acctDybOjb.getBoolean("isleaf") && ((acctParentId = acctDybOjb.getLong("parent.id")) == 0L || ctx.getTransParentIdatas().add(acctParentId))) {
                AssignServiceHelper.trans2LeafAccount(acctIdSet, new Long[]{ctx.getUseOrgid()}, ctx.getOrgPorgs());
            }
            ArrayList<Object[]> useRegParam = new ArrayList<Object[]>(1);
            ArrayList<Object[]> excParams = new ArrayList<Object[]>(1);
            HashSet<Long> dataIds = new HashSet<Long>(oapop.getUseregIds());
            dataIds.addAll(oapop.getExcIds());
            HashSet<String> excParamsKey = new HashSet<String>(dataIds.size());
            HashSet<String> upParamsKey = new HashSet<String>(dataIds.size());
            for (Long acctid : dataIds) {
                DynamicObject dynamicObject = ctx.getIddataDynMap().get(acctid);
                createOrgId22 = dynamicObject.getLong("createorg_id");
                long dataId = dynamicObject.getLong("id");
                Object[] exeParam = new Object[]{dataId, createOrgId22, oapop.getOrgId()};
                String excKey = StringUtils.join((Object[])new Object[]{dataId, createOrgId22, oapop.getOrgId()}, (String)"-");
                if (oapop.getExcIds().contains(dataId) && excParamsKey.add(excKey)) {
                    excParams.add(exeParam);
                }
                String ctrlstrategy = dynamicObject.getString("ctrlstrategy");
                Long assignOrgId = ctx.getAssignCtx().getUseOrgid();
                Object[] uparam = new Object[]{oapop.getOrgId(), dynamicObject.getLong("id"), createOrgId22, createOrgId22, ctrlstrategy, "1", assignOrgId == null ? createOrgId22 : assignOrgId};
                String upKey = StringUtils.join((Object[])new Object[]{dataId, oapop.getOrgId()}, (String)"-");
                if (!upParamsKey.add(upKey)) continue;
                useRegParam.add(uparam);
                OperationLogEntry operationLogEntry = new OperationLogEntry(oapop.getOrgId(), dynamicObject.getLong("id"), AccountOperationType.ASSIGN, Boolean.TRUE);
                AccountOperationLogUtil.addLogEntryRow(operationLogEntry);
            }
            ctx.getUseRegParam().addAll(useRegParam);
            ctx.getExcParams().addAll(excParams);
            if (ctx.getUseRegParam().size() > 500 || ctx.getExcParams().size() > 500) {
                AccountVersionUtil.doAssign(ctx.getExcParams(), ctx.getUseRegParam());
                ctx.getUseRegParam().clear();
                ctx.getExcParams().clear();
            }
        } else {
            DynamicObject[] successSaveAccts;
            OperationResult operationResult;
            oapop.setNeedVerison(true);
            Map<Object, DynamicObject> accountMap = ctx.getAccountMap();
            if (null == accountMap) {
                accountMap = new HashMap<Object, DynamicObject>(16);
            }
            DynamicObject acctObject = accountMap.computeIfAbsent(oapop.getAcctId(), id -> BusinessDataServiceHelper.loadSingle((Object)id, (String)"bd_accountview"));
            Map<Object, DynamicObject> opAccountMap = ctx.getOpAccountMap();
            if (null == opAccountMap) {
                opAccountMap = new HashMap<Object, DynamicObject>(16);
            }
            DynamicObject opAccountObj = null;
            if (null != oapop.getpAcctId() && oapop.getpAcctId() != 0L) {
                opAccountObj = opAccountMap.computeIfAbsent(oapop.getpAcctId(), id -> BusinessDataServiceHelper.loadSingle((Object)id, (String)"bd_accountview"));
            }
            if (null == ctx.getBosOrgMap()) {
                ctx.setBosOrgMap(new HashMap<Object, DynamicObject>(16));
            }
            DynamicObject bos_org = ctx.getBosOrgMap().computeIfAbsent(oapop.getOrgId(), id -> BusinessDataServiceHelper.loadSingle((Object)id, (String)"bos_org"));
            DynamicObject cloneAcct = (DynamicObject)CloneUtilFactory.getCloneUtil().clone((IDataEntityBase)acctObject);
            cloneAcct.set("createorg", (Object)bos_org);
            cloneAcct.set("org", (Object)bos_org);
            cloneAcct.set("useorg", (Object)bos_org);
            cloneAcct.set("parent", (Object)opAccountObj);
            log.info("cloneAcct_startdate ,enddate:");
            log.info("cloneAcct_startdate:" + cloneAcct.getDate("startdate") + " ,enddate:" + cloneAcct.getDate("enddate"));
            if (opAccountObj != null) {
                log.info("cloneAcctParent_startdate:" + opAccountObj.getDate("startdate") + ",enddate:{" + opAccountObj.getDate("enddate"));
            }
            SqlBuilder queryMidAndIsLeafSql = new SqlBuilder();
            queryMidAndIsLeafSql.append(" select a.fmasterid, a.fisleaf ", new Object[0]);
            queryMidAndIsLeafSql.append(" from t_bd_account_u as u ", new Object[0]);
            queryMidAndIsLeafSql.append(" inner join t_bd_account as a on a.fid = u.fdataid ", new Object[0]);
            queryMidAndIsLeafSql.append(" where a.faccounttableid = ? ", new Object[]{ctx.getAssignCtx().getAccountTableId()});
            queryMidAndIsLeafSql.append(" and a.fnumber = ? ", new Object[]{cloneAcct.getString("number")});
            queryMidAndIsLeafSql.append(" and u.fuseorgid = ? ", new Object[]{pctOap.getOrgId()});
            HashMap<Long, Boolean> queryMidAndIsLeafRs = new HashMap<Long, Boolean>(10);
            Throwable throwable = null;
            try (DataSet dataSet = DB.queryDataSet((String)MakeAssignExcuter.class.getName(), (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)queryMidAndIsLeafSql);){
                createOrgId22 = dataSet.iterator();
                while (createOrgId22.hasNext()) {
                    Row row = (Row)createOrgId22.next();
                    queryMidAndIsLeafRs.put(row.getLong("fmasterid"), row.getBoolean("fisleaf"));
                }
            }
            catch (Throwable createOrgId22) {
                Throwable throwable2 = createOrgId22;
                throw createOrgId22;
            }
            if (queryMidAndIsLeafRs.size() > 1) {
                for (Map.Entry entry2 : queryMidAndIsLeafRs.entrySet()) {
                    if (!((Boolean)entry2.getValue()).booleanValue()) continue;
                    cloneAcct.set("masterid", entry2.getKey());
                    cloneAcct.set("isleaf", (Object)true);
                    break;
                }
            }
            if (null != opAccountObj) {
                long opaccountTableId = opAccountObj.getLong("accounttable_id");
                String opnumber = opAccountObj.getString("number");
                if (oapop.getAcctTableId().compareTo(opaccountTableId) == 0 && oapop.getpAcctNum().equals(opnumber)) {
                    DynamicObject updateAssist;
                    if (opAccountObj.getBoolean("iscashequivalent")) {
                        cloneAcct.set("iscashequivalent", (Object)true);
                    }
                    if (opAccountObj.getBoolean("isjournal")) {
                        cloneAcct.set("isjournal", (Object)true);
                    }
                    if (opAccountObj.getBoolean("acnotice")) {
                        cloneAcct.set("acnotice", (Object)true);
                    }
                    if (opAccountObj.getBoolean("ischangecurrency")) {
                        cloneAcct.set("ischangecurrency", (Object)true);
                    }
                    if (opAccountObj.getBoolean("isqty")) {
                        cloneAcct.set("isqty", (Object)true);
                        cloneAcct.set("measureunitgroup", opAccountObj.get("measureunitgroup"));
                        cloneAcct.set("measureunit", opAccountObj.get("measureunit"));
                    }
                    cloneAcct.set("accrualdirection", opAccountObj.get("accrualdirection"));
                    ArrayList<Object> assistEntryObjs = new ArrayList<Object>(10);
                    DynamicObjectCollection cloneAssistEntry = cloneAcct.getDynamicObjectCollection("checkitementry");
                    HashMap<Long, DynamicObject> cloneAssistMap = new HashMap<Long, DynamicObject>(cloneAssistEntry.size());
                    HashMap<Long, DynamicObject> updateAssistMap = new HashMap<Long, DynamicObject>(cloneAssistEntry.size());
                    for (DynamicObject assistRow : cloneAssistEntry) {
                        assistRow.set("id", null);
                        long assistId = assistRow.getLong("asstactitem_id");
                        cloneAssistMap.put(assistId, assistRow);
                        updateAssistMap.put(assistId, assistRow);
                    }
                    DynamicObjectCollection opAssistEntry = opAccountObj.getDynamicObjectCollection("checkitementry");
                    opAssistEntry.sort((a, b) -> Integer.compare(a.getInt("seq"), b.getInt("seq")));
                    HashMap<Long, DynamicObject> opAssistMap = new HashMap<Long, DynamicObject>(opAssistEntry.size());
                    ArrayList<Long> opAssistIdWithSeq = new ArrayList<Long>(opAssistEntry.size());
                    for (DynamicObject dynamicObject : opAssistEntry) {
                        long assistId = dynamicObject.getLong("asstactitem_id");
                        opAssistMap.put(assistId, dynamicObject);
                        opAssistIdWithSeq.add(assistId);
                    }
                    for (Map.Entry entry3 : opAssistMap.entrySet()) {
                        Long assistId = (Long)entry3.getKey();
                        DynamicObject opAssistObj = (DynamicObject)entry3.getValue();
                        if (cloneAssistMap.containsKey(assistId)) {
                            DynamicObject cloneAssist = (DynamicObject)cloneAssistMap.get(assistId);
                            if (opAssistObj.getBoolean("isrequire")) {
                                cloneAssist.set("isrequire", (Object)true);
                            }
                            if (opAssistObj.getBoolean("enaccheck")) {
                                cloneAssist.set("enaccheck", (Object)true);
                            }
                            if (opAssistObj.getBoolean("isdetail")) {
                                cloneAssist.set("isdetail", (Object)true);
                            }
                            updateAssistMap.put(assistId, cloneAssist);
                            continue;
                        }
                        DynamicObject dynamicObject = new DynamicObject(cloneAssistEntry.getDynamicObjectType());
                        dynamicObject.set("asstactitem", opAssistObj.get("asstactitem"));
                        dynamicObject.set("isrequire", opAssistObj.get("isrequire"));
                        dynamicObject.set("enaccheck", opAssistObj.get("enaccheck"));
                        dynamicObject.set("isdetail", opAssistObj.get("isdetail"));
                        updateAssistMap.put(assistId, dynamicObject);
                    }
                    int seq = 1;
                    for (Long assistId : opAssistIdWithSeq) {
                        updateAssist = (DynamicObject)updateAssistMap.get(assistId);
                        if (updateAssist != null) {
                            updateAssist.set("seq", (Object)seq);
                            assistEntryObjs.add(updateAssist);
                            ++seq;
                        }
                        updateAssistMap.remove(assistId);
                    }
                    for (Map.Entry updateEntry : updateAssistMap.entrySet()) {
                        updateAssist = (DynamicObject)updateEntry.getValue();
                        updateAssist.set("seq", (Object)seq);
                        assistEntryObjs.add(updateEntry.getValue());
                        ++seq;
                    }
                    cloneAssistEntry.clear();
                    cloneAssistEntry.addAll(assistEntryObjs);
                    DynamicObjectCollection dynamicObjectCollection = cloneAcct.getDynamicObjectCollection("currencyentry");
                    String acctCurrencyType = opAccountObj.getString("acctcurrency");
                    if ("allcurrency".equals(acctCurrencyType) || "nocurrency".equals(acctCurrencyType)) {
                        cloneAcct.set("acctcurrency", (Object)acctCurrencyType);
                        dynamicObjectCollection.clear();
                    } else if ("descurrency".equals(acctCurrencyType)) {
                        DynamicObjectCollection opCurrencyEntry;
                        String cloneAcctCurrencyType = cloneAcct.getString("acctcurrency");
                        if ("nocurrency".equals(cloneAcctCurrencyType)) {
                            cloneAcct.set("acctcurrency", (Object)cloneAcctCurrencyType);
                            dynamicObjectCollection.clear();
                        } else if ("allcurrency".equals(cloneAcctCurrencyType)) {
                            cloneAcct.set("acctcurrency", (Object)acctCurrencyType);
                            opCurrencyEntry = opAccountObj.getDynamicObjectCollection("currencyentry");
                            ArrayList<DynamicObject> opCurrencyObjs = new ArrayList<DynamicObject>(opCurrencyEntry.size());
                            opCurrencyEntry.sort((a, b) -> Integer.compare(a.getInt("seq"), b.getInt("seq")));
                            int i = 0;
                            for (Object opCurrencyObject : opCurrencyEntry) {
                                DynamicObject dynamicObject = new DynamicObject(opCurrencyEntry.getDynamicObjectType());
                                dynamicObject.set("seq", (Object)i++);
                                dynamicObject.set("currency", opCurrencyObject.get("currency"));
                                opCurrencyObjs.add(dynamicObject);
                            }
                            dynamicObjectCollection.clear();
                            dynamicObjectCollection.addAll(opCurrencyObjs);
                        } else if ("descurrency".equals(cloneAcctCurrencyType)) {
                            cloneAcct.set("acctcurrency", (Object)acctCurrencyType);
                            opCurrencyEntry = opAccountObj.getDynamicObjectCollection("currencyentry");
                            Set cloneCurrencyIDSet = dynamicObjectCollection.stream().map(entry -> entry.getDynamicObject("currency").getPkValue()).collect(Collectors.toSet());
                            ArrayList<DynamicObject> opCurrencyObjs = new ArrayList<DynamicObject>(dynamicObjectCollection.size());
                            opCurrencyEntry.sort((a, b) -> Integer.compare(a.getInt("seq"), b.getInt("seq")));
                            int i = 0;
                            for (DynamicObject opCurrencyObj : opCurrencyEntry) {
                                if (!cloneCurrencyIDSet.contains(opCurrencyObj.getDynamicObject("currency").getPkValue())) continue;
                                DynamicObject dynamicObject = new DynamicObject(opCurrencyEntry.getDynamicObjectType());
                                dynamicObject.set("seq", (Object)i++);
                                dynamicObject.set("currency", opCurrencyObj.get("currency"));
                                opCurrencyObjs.add(dynamicObject);
                            }
                            dynamicObjectCollection.clear();
                            dynamicObjectCollection.addAll(opCurrencyObjs);
                        }
                    }
                }
            }
            OperateOption op = OperateOption.create();
            op.setVariableValue("isversion", "1");
            op.setVariableValue("isassign", "1");
            op.setVariableValue("useOrgID", String.valueOf(cloneAcct.getLong("useorg_id")));
            if (acctObject.getInt("level") > 1 && AccountVersionUtil.isVersionedChildAccount(acctObject.getLong("createorg_id"), acctObject.getLong("masterid"), acctObject.getLong("id"), acctObject.getString("number"))) {
                op.setVariableValue("isversionaddleaf", "1");
            }
            log.info("\u79d1\u76ee\u5206\u914d,\u9700\u8981\u7248\u672c\u5316\uff0c\u51c6\u5907\u8c03\u7528\u79d1\u76ee\u4fdd\u5b58\u65b9\u6cd5\uff1acloneAcct: " + cloneAcct.toString());
            Object var19_41 = null;
            try {
                operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"bd_accountview", (DynamicObject[])new DynamicObject[]{cloneAcct}, (OperateOption)op);
                if (operationResult.isSuccess()) {
                    OperationLogEntry entity = new OperationLogEntry(cloneAcct.getLong("useorg_id"), cloneAcct.getLong("id"), AccountOperationType.VERSION, Boolean.TRUE);
                    AccountOperationLogUtil.addLogEntryRow(entity);
                }
            }
            catch (Exception e) {
                log.info("org:" + oapop.getOrgId() + "\u79d1\u76ee\u7f16\u7801\uff1a" + cloneAcct.getString("number") + "\u79d1\u76ee\u5206\u914d\uff1a\u7248\u672c\u5316\u4fdd\u5b58\u64cd\u4f5c\u62a5\u9519\u4fe1\u606f: " + e.getMessage());
                String msg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0\uff1a%1$s,\u79d1\u76ee\uff1a%2$s,\u62a5\u9519\u4fe1\u606f\uff1a\u7248\u672c\u5316\u65b0\u589e\u4fdd\u5b58\u62a5\u9519", (String)"MakeAssignExcuter_4", (String)"fi-bd-formplugin", (Object[])new Object[0]), bos_org.getString("name"), cloneAcct.getString("number"));
                ctx.getAssignCtx().getAcctCheckErrMsg().add(msg);
                OperationLogEntry entity = new OperationLogEntry(cloneAcct.getLong("useorg_id"), cloneAcct.getLong("id"), AccountOperationType.VERSION, false);
                entity.setLog(msg);
                AccountOperationLogUtil.setOperationLog(operationLog -> {
                    operationLog.getEntryEntity().add(entity);
                    operationLog.setLog(ResManager.loadKDString((String)"\u5931\u8d25", (String)"MakeAssignExcuter_2", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                    operationLog.addNewAccount(cloneAcct);
                });
                return;
            }
            List valResults = operationResult.getValidateResult().getValidateErrors();
            for (ValidateResult validateResult : valResults) {
                OperationLogEntry entity = new OperationLogEntry(cloneAcct.getLong("useorg_id"), cloneAcct.getLong("id"), AccountOperationType.VERSION, Boolean.FALSE);
                entity.setNumber(cloneAcct.getString("number"));
                entity.setAccountName(cloneAcct.getString("name"));
                for (OperateErrorInfo errorInfo : validateResult.getAllErrorInfo()) {
                    if (!oapop.getFailedOorgIds().contains(oapop.getOrgId())) {
                        oapop.getFailedOorgIds().add(oapop.getOrgId());
                    }
                    ctx.getAssignCtx().getAcctCheckErrMsg().add(errorInfo.getMessage() + "\r\n");
                    log.info("Account_assign\uff1aversionalized faield msg: " + errorInfo.getMessage());
                    entity.setLog(StringUtils.isEmpty((CharSequence)entity.getLog()) ? errorInfo.getMessage() : entity.getLog() + "\n" + errorInfo.getMessage());
                    AccountOperationLogUtil.addLogEntryRow(entity);
                }
            }
            List successPkIds = operationResult.getSuccessPkIds();
            log.info("Account_assign\uff1aversionalized successed acc ids: " + StringUtils.join((Object[])new List[]{successPkIds}));
            for (DynamicObject successSaveAcct : successSaveAccts = BusinessDataServiceHelper.load((Object[])successPkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"))) {
                ArrayList<Object[]> useRegParam = new ArrayList<Object[]>(1);
                ArrayList<Object[]> excParams = new ArrayList<Object[]>(1);
                Long l = successSaveAcct.getLong("createorg_id");
                long orgId = successSaveAcct.getLong("org_id");
                this.resetCtxOrgPorgs(ctx.getOrgPorgs(), orgId);
                long dataId = successSaveAcct.getLong("id");
                String successSaveAcctctrlstrategy = successSaveAcct.getString("ctrlstrategy");
                Long assignOrgId = ctx.getAssignCtx().getUseOrgid();
                useRegParam.add(new Object[]{orgId, dataId, l, l, successSaveAcct.getString("ctrlstrategy"), "0", assignOrgId == null ? l : assignOrgId});
                log.info("Account_assign\uff1aassign releation, ctrl strategy\uff1a" + successSaveAcctctrlstrategy + ",useRegParam:{fuseorgid=" + orgId + ",fdataid=" + dataId + ",fcreateorgid=" + l + ",fadminorgid=" + l + ",fctrlstrategy=" + successSaveAcct.getString("ctrlstrategy") + ",fisassign=" + 0 + ",fassignorgid=" + (assignOrgId == null ? l : assignOrgId));
                HashSet<Long> existsUseDataIds = new HashSet<Long>(oapop.getUseregIds());
                existsUseDataIds.add(oapop.getAcctId());
                OrgAcctParent poapop = pctxOapopMap.get(acctNumber);
                HashSet<Long> pexistsUseDataIds = new HashSet<Long>(poapop.getUseregIds());
                pexistsUseDataIds.addAll(existsUseDataIds);
                for (Long acctid : pexistsUseDataIds) {
                    DynamicObject account2 = ctx.getIddataDynMap().get(acctid);
                    if (account2 == null) {
                        account2 = BusinessDataServiceHelper.loadSingleFromCache((Object)acctid, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"));
                    }
                    Long oldCreateOrgId = account2.getLong("createorg_id");
                    String ctrlstrategy = account2.getString("ctrlstrategy");
                    useRegParam.add(new Object[]{orgId, acctid, oldCreateOrgId, oldCreateOrgId, ctrlstrategy, "1", assignOrgId});
                    excParams.add(new Object[]{acctid, oldCreateOrgId, orgId});
                    OperationLogEntry entry3 = new OperationLogEntry(orgId, acctid, AccountOperationType.ASSIGN, true);
                    AccountOperationLogUtil.addLogEntryRow(entry3);
                }
                AccountVersionUtil.doAssign(excParams, useRegParam);
                OperationLogEntry entry4 = new OperationLogEntry(orgId, dataId, AccountOperationType.ASSIGN, true);
                AccountOperationLogUtil.addLogEntryRow(entry4);
                AssignServiceHelper.assignAllOldVersionAccts(dataId, assignOrgId, orgId, ctx.getOrgPorgs());
                log.info("Account_assign\uff1aexecute assign\uff1adoAssign,execute assignAllOldVersionAccts assign current account history version:,accountId=" + dataId + ",assignorgId=" + assignOrgId + ",useOrgId=" + orgId + ",orgPorgs=" + ctx.getOrgPorgs());
                oapop.setCreateOrgId(oapop.getOrgId());
                oapop.setAcctId((Long)successPkIds.get(0));
                AssignAccountNumTreeNode assignAccountNumTreeNode = accountNumTreeNodeMap.get(acctNumber);
                Set<String> childNumbers = assignAccountNumTreeNode.getChildNumbers();
                if (null != childNumbers && childNumbers.size() > 0) {
                    for (String childNumber : childNumbers) {
                        OrgAcctParent childOap = oapopMap.get(childNumber);
                        childOap.setpAcctId((Long)successPkIds.get(0));
                    }
                }
                this.prepareServiceParam(ctx.getRefServiceParamMapTemp(), orgId, successSaveAcct.getLong("accounttable_id"), successSaveAcct.getDate("startdate"), successSaveAcct.getLong("id"), oapop.getAcctId(), this.getAsstActItemMap(successSaveAcct));
                List<Long> cid = AssignServiceHelper.getLeafs(successSaveAcct, l);
                if (cid.size() != 1) continue;
                this.prepareServiceParam(ctx.getRefServiceParamMap(), orgId, successSaveAcct.getLong("accounttable_id"), successSaveAcct.getDate("startdate"), successSaveAcct.getLong("id"), oapop.getAcctId(), this.getAsstActItemMap(successSaveAcct));
            }
        }
        AssignAccountNumTreeNode assignAccountNumTreeNode = accountNumTreeNodeMap.get(acctNumber);
        Set<String> childNumbers = assignAccountNumTreeNode.getChildNumbers();
        this.explainAcctNumbers(false, "testAssign deal", acctNumber, childNumbers);
        for (String childNumber : childNumbers) {
            this.testAssign(ctx, oapopMap, pctxOapopMap, accountNumTreeNodeMap, childNumber);
        }
    }

    private void testAssignExplain(OrgSingleAssignCtx ctx, String acctNumber, Map<String, OrgAcctParent> oapopMap, Map<String, OrgAcctParent> pctxOapopMap) {
        long orgid = ctx.getUseOrgid();
        String orgName = ctx.getAssignCtx().getOrgNameMap().get(orgid);
        StringBuilder assignStrBuilder = new StringBuilder();
        assignStrBuilder.append("acctNum : ").append(acctNumber).append("---").append("org : ").append(ctx.getUseOrgid()).append("---").append("orgName : ").append(orgName).append("---").append("oapopMap : ").append(oapopMap.get(acctNumber) == null ? "" : oapopMap.get(acctNumber).toString()).append("pctxOapopMap : ").append(pctxOapopMap.get(acctNumber) == null ? "" : pctxOapopMap.get(acctNumber).toString()).append(";");
        log.info(assignStrBuilder.toString());
    }

    private void resetCtxOrgPorgs(Map<Long, Long> orgPorgs, long useOrgId) {
        HashSet<Long> useOrgIds = new HashSet<Long>();
        if (orgPorgs.get(useOrgId) == null) {
            useOrgIds.add(useOrgId);
        }
        QFilter f2 = new QFilter("view", "=", (Object)10);
        if (!useOrgIds.isEmpty()) {
            QFilter f3 = new QFilter("org", "in", useOrgIds);
            try (DataSet dt = QueryServiceHelper.queryDataSet((String)"getUseregParams", (String)"bos_org_structure", (String)"org,parent", (QFilter[])new QFilter[]{f2, f3}, null);){
                for (Row row : dt) {
                    orgPorgs.put(row.getLong("org"), row.getLong("parent"));
                }
            }
        }
    }

    private Map<String, Object> getAsstActItemMap(DynamicObject obj) {
        DynamicObjectCollection entry = obj.getDynamicObjectCollection("checkitementry");
        HashMap<String, Object> result = new HashMap<String, Object>(10);
        for (DynamicObject row : entry) {
            DynamicObject item = row.getDynamicObject("asstactitem");
            String defaultvalue = row.getString("defaulid");
            if (item == null || StringUtils.isEmpty((CharSequence)defaultvalue)) continue;
            Object value = defaultvalue;
            if (!"3".equals(item.getString("valuetype"))) {
                value = Long.parseLong(String.valueOf(defaultvalue));
            }
            result.put(item.getString("flexfield"), value);
        }
        return result;
    }

    private void prepareServiceParam(Map<String, AccountTableRefServiceParam> refServiceParamMap, long orgId, long tableId, Date versiondate, long newAcctId, long oldAcctId, Map<String, Object> assgrpMap) {
        AccountTableRefServiceParam param = refServiceParamMap.computeIfAbsent(AccountVersionUtil.getRefServiceKey(orgId, tableId, versiondate), k -> new AccountTableRefServiceParam(orgId, tableId, versiondate, new AccountTableRef(tableId, tableId, new AccountRef())));
        param.getAccountTableRef().getAccountRef().addAccountRef(newAcctId, oldAcctId, assgrpMap);
    }
}

