/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.assign.unassign;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.fi.bd.assign.unassign.AbstractUnAssign;
import kd.fi.bd.assign.unassign.OrgAccountInfo;
import kd.fi.bd.assign.unassign.OrgAcctParent;
import kd.fi.bd.assign.unassign.OrgSingleAssignCtx;
import kd.fi.bd.assign.unassign.UnAssignCtx;
import kd.fi.bd.assign.unassign.UnAssignEvent;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BDUtil;

public class BuildOrgAcctParentAndOtherParents
extends AbstractUnAssign {
    @Override
    protected boolean process(UnAssignEvent unAssignEvent) {
        OrgSingleAssignCtx ctx = unAssignEvent.getUnAssigner().getCtx();
        UnAssignCtx assignCtx = ctx.getAssignCtx();
        Map<String, OrgAcctParent> oapopMap = ctx.getOapopMap();
        Long useOrgid = ctx.getUseOrgid();
        Set<Object> accountIds = new HashSet(100);
        Map<String, OrgAccountInfo> orgAccountInfoMap = assignCtx.getOrgAndDatas().get(useOrgid);
        if (orgAccountInfoMap == null || orgAccountInfoMap.size() == 0) {
            accountIds = assignCtx.getDataIDs();
        } else {
            for (Map.Entry<String, OrgAccountInfo> orgAccountInfoEntry : orgAccountInfoMap.entrySet()) {
                accountIds.addAll(orgAccountInfoEntry.getValue().getAccountIds());
            }
        }
        ArrayList<Object> acctountSqlParams = new ArrayList<Object>(10);
        StringBuilder acctountSql = new StringBuilder();
        acctountSql.append(" select a.fid,a.fmasterid,a.fparentid, a.fnumber,a.fcreateOrgId,a.fctrlstrategy,a.fenddate,a.faccounttableid,l.fname ");
        acctountSql.append(" from  t_bd_account a");
        acctountSql.append(" inner join t_bd_account ms on ms.fmasterid = a.fmasterid ");
        acctountSql.append(" inner join t_bd_account_l l on a.fid=l.fid and l.flocaleid =? ");
        String lang = RequestContext.get().getLang().getLocale().getLanguage() + "_" + RequestContext.get().getLang().getLocale().getCountry();
        acctountSqlParams.add(lang);
        acctountSql.append(" where a.faccounttableid= ?  ");
        acctountSqlParams.add(assignCtx.getAccountTableId());
        acctountSql.append(" and a.fcreateorgid = ? ");
        acctountSqlParams.add(useOrgid);
        acctountSql.append(" and ms.fid in ( ");
        accountIds.forEach(k -> acctountSql.append("?,"));
        acctountSqlParams.addAll(accountIds);
        acctountSql.deleteCharAt(acctountSql.length() - 1).append(" ) ");
        List<Map<String, Object>> acctountSqlResult = BDUtil.DBquery(DBRoute.of((String)"gl"), acctountSql.toString(), acctountSqlParams.toArray(), (ResultSetHandler<List<Map<String, Object>>>)((ResultSetHandler)rs -> {
            ArrayList returnObjs = new ArrayList(10);
            while (rs.next()) {
                HashMap<String, Object> returnObj = new HashMap<String, Object>(16);
                returnObj.put("fnumber", rs.getString("fnumber"));
                returnObj.put("fid", rs.getLong("fid"));
                returnObj.put("fmasterid", rs.getLong("fmasterid"));
                returnObj.put("fparentid", rs.getLong("fparentid"));
                returnObj.put("fctrlstrategy", rs.getString("fctrlstrategy"));
                returnObj.put("fcreateorgid", rs.getLong("fcreateorgid"));
                returnObj.put("fname", rs.getString("fname"));
                returnObj.put("fenddate", rs.getDate("fenddate"));
                returnObj.put("faccounttableid", rs.getLong("faccounttableid"));
                returnObjs.add(returnObj);
            }
            return returnObjs;
        }));
        for (Map<String, Object> acctountObj : acctountSqlResult) {
            String fnumber = (String)acctountObj.get("fnumber");
            Object orgAcctParam = oapopMap.get(fnumber);
            if (null == orgAcctParam) {
                orgAcctParam = new OrgAcctParent();
                oapopMap.put(fnumber, (OrgAcctParent)orgAcctParam);
                ((OrgAcctParent)orgAcctParam).setOrgId(useOrgid);
                ((OrgAcctParent)orgAcctParam).setAcctNum(fnumber);
            }
            ((OrgAcctParent)orgAcctParam).setVerison(true);
            Date date = (Date)acctountObj.get("fenddate");
            Long id = (Long)acctountObj.get("fid");
            if (date.compareTo(AccountVersionUtil.getEndDate()) == 0) {
                Long masterid = (Long)acctountObj.get("fmasterid");
                ((OrgAcctParent)orgAcctParam).setAcctMasterId(masterid);
                ((OrgAcctParent)orgAcctParam).setAcctTableId((Long)acctountObj.get("faccounttableid"));
                ((OrgAcctParent)orgAcctParam).setAcctName((String)acctountObj.get("fname"));
                ((OrgAcctParent)orgAcctParam).setCtrlstrategy((String)acctountObj.get("fctrlstrategy"));
                ((OrgAcctParent)orgAcctParam).setCreateOrgId((Long)acctountObj.get("fcreateorgid"));
            }
            ((OrgAcctParent)orgAcctParam).getVersionIds().add(id);
            ((OrgAcctParent)orgAcctParam).getVersionAcctIDEndDateMap().put(id, date);
            ((OrgAcctParent)orgAcctParam).getUseregIds().add(id);
            ((OrgAcctParent)orgAcctParam).getExcIds().add(id);
        }
        ArrayList<Object> useregSqlParams = new ArrayList<Object>(10);
        StringBuilder useregSql = new StringBuilder();
        useregSql.append(" select a.fid,a.fmasterid,a.fparentid,a.fnumber,a.fcreateOrgId,a.fctrlstrategy,a.fenddate,a.faccounttableid,l.fname, ");
        useregSql.append(" reg.fuseorgid,reg.FCREATEORGID,reg.FADMINORGID,reg.FCTRLSTRATEGY,reg.FISASSIGN,reg.FASSIGNORGID ");
        useregSql.append(" from  t_bd_accountusereg reg ");
        useregSql.append(" inner join t_bd_account a ON reg.fdataid=a.fid ");
        useregSql.append(" inner join t_bd_account ms on ms.fmasterid = a.fmasterid ");
        useregSql.append(" left join t_bd_account_l l on a.fid=l.fid and l.flocaleid =? ");
        useregSqlParams.add(lang);
        useregSql.append(" where a.faccounttableid= ? ");
        useregSqlParams.add(assignCtx.getAccountTableId());
        useregSql.append(" and reg.FUSEORGID = ? ");
        useregSqlParams.add(useOrgid);
        useregSql.append(" and ms.fid in ( ");
        accountIds.forEach(k -> useregSql.append("?,"));
        useregSqlParams.addAll(accountIds);
        useregSql.deleteCharAt(useregSql.length() - 1).append(" ) ");
        List<Map<String, Object>> useregSqlResult = BDUtil.DBquery(DBRoute.of((String)"gl"), useregSql.toString(), useregSqlParams.toArray(), (ResultSetHandler<List<Map<String, Object>>>)((ResultSetHandler)rs -> {
            ArrayList returnObjs = new ArrayList(10);
            while (rs.next()) {
                long fuseorgid = rs.getLong("fuseorgid");
                long fcreateorgid = rs.getLong("fcreateorgid");
                HashMap<String, Object> returnObj = new HashMap<String, Object>(16);
                returnObj.put("fnumber", rs.getString("fnumber"));
                returnObj.put("fid", rs.getLong("fid"));
                returnObj.put("fmasterid", rs.getLong("fmasterid"));
                returnObj.put("fparentid", rs.getLong("fparentid"));
                returnObj.put("fctrlstrategy", rs.getString("fctrlstrategy"));
                returnObj.put("fcreateorgid", rs.getLong("fcreateorgid"));
                returnObj.put("fname", rs.getString("fname"));
                returnObj.put("fenddate", rs.getDate("fenddate"));
                returnObj.put("faccounttableid", rs.getLong("faccounttableid"));
                returnObj.put("fisassign", fuseorgid == fcreateorgid ? "0" : "1");
                returnObj.put("fassignorgid", rs.getLong("fassignorgid"));
                returnObjs.add(returnObj);
            }
            return returnObjs;
        }));
        for (Map map : useregSqlResult) {
            String fnumber = (String)map.get("fnumber");
            OrgAcctParent orgAcctParam = oapopMap.get(fnumber);
            if (null == orgAcctParam) {
                orgAcctParam = new OrgAcctParent();
                oapopMap.put(fnumber, orgAcctParam);
                orgAcctParam.setOrgId(useOrgid);
                orgAcctParam.setAcctNum(fnumber);
                Date fenddate = (Date)map.get("fenddate");
                if (fenddate.compareTo(AccountVersionUtil.getEndDate()) == 0) {
                    Long masterid = (Long)map.get("fmasterid");
                    orgAcctParam.setAcctMasterId(masterid);
                    orgAcctParam.setAcctTableId((Long)map.get("faccounttableid"));
                    orgAcctParam.setAcctName((String)map.get("fname"));
                    orgAcctParam.setCtrlstrategy((String)map.get("fctrlstrategy"));
                    orgAcctParam.setCreateOrgId((Long)map.get("fcreateorgid"));
                }
            }
            orgAcctParam.getUseregIds().add((Long)map.get("fid"));
            orgAcctParam.getExcIds().add((Long)map.get("fid"));
        }
        ArrayList<Object> excSqlParams = new ArrayList<Object>(10);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" select a.FNUMBER, ");
        stringBuilder.append(" exc.FDATAID,exc.FCREATEORGID,exc.FUSEORGID ");
        stringBuilder.append(" from  t_bd_accountexc exc ");
        stringBuilder.append(" inner join t_bd_account a ON exc.fdataid=a.fid ");
        stringBuilder.append(" inner join t_bd_account ms on ms.fmasterid = a.fmasterid ");
        stringBuilder.append(" where a.faccounttableid= ?  ");
        excSqlParams.add(assignCtx.getAccountTableId());
        stringBuilder.append(" and exc.FUSEORGID = ? ");
        excSqlParams.add(useOrgid);
        stringBuilder.append(" and ms.fid in ( ");
        accountIds.forEach(k -> excSql.append("?,"));
        excSqlParams.addAll(accountIds);
        stringBuilder.deleteCharAt(stringBuilder.length() - 1).append(" ) ");
        List<Map<String, Object>> excSqlResult = BDUtil.DBquery(DBRoute.of((String)"gl"), stringBuilder.toString(), excSqlParams.toArray(), (ResultSetHandler<List<Map<String, Object>>>)((ResultSetHandler)rs -> {
            ArrayList returnObjs = new ArrayList(10);
            while (rs.next()) {
                HashMap<String, Object> returnObj = new HashMap<String, Object>(16);
                returnObj.put("fnumber", rs.getString("fnumber"));
                returnObj.put("fdataid", rs.getLong("fdataid"));
                returnObj.put("fcreateorgid", rs.getLong("fcreateorgid"));
                returnObj.put("fuseorgid", rs.getLong("fuseorgid"));
                returnObjs.add(returnObj);
            }
            return returnObjs;
        }));
        for (Map<String, Object> acctountObj : excSqlResult) {
            String fnumber = (String)acctountObj.get("fnumber");
            OrgAcctParent orgAcctParam = oapopMap.get(fnumber);
            if (null == orgAcctParam) continue;
            orgAcctParam.getExcIds().add((Long)acctountObj.get("fdataid"));
        }
        return true;
    }
}

