/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.assign.unassign;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.accountref.AccountRefUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.assign.unassign.OrgAccountInfo;
import kd.fi.bd.assign.unassign.UnAssignCtx;
import kd.fi.bd.util.BizHappenUtils;
import kd.fi.bd.vo.AssignOrgTreeNode;

public class CheckUnAssignRes {
    private static final Log LOGGER = LogFactory.getLog(CheckUnAssignRes.class);

    public boolean process(UnAssignCtx assignCtx) {
        this.checkRef(assignCtx);
        return true;
    }

    private void checkRef(UnAssignCtx ctx) {
        Map<Long, Map<String, OrgAccountInfo>> orgAndDatas = ctx.getOrgAndDatas();
        for (Map.Entry<Long, Map<String, OrgAccountInfo>> orgAndDatasEntry : orgAndDatas.entrySet()) {
            long useOrgId = orgAndDatasEntry.getKey();
            Map<String, OrgAccountInfo> datasMap = orgAndDatasEntry.getValue();
            Set<String> numbers = datasMap.keySet();
            if (null == numbers || numbers.size() == 0) continue;
            Map<String, List<Object[]>> newParamsMap = this.getUseRegDataByAcctAndOrg(ctx, numbers, useOrgId);
            for (Map.Entry<String, List<Object[]>> newParamsEntry : newParamsMap.entrySet()) {
                String number = newParamsEntry.getKey();
                List<Object[]> newParamsE = newParamsEntry.getValue();
                if (!this.isAccountUsed(newParamsE)) continue;
                this.unDisParentAndSelfAcct(datasMap, number);
                this.unDisParentAndSelfOrgAcct(ctx, datasMap, number, useOrgId);
                DynamicObject targetOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)useOrgId, (String)"bos_org", (String)"id,number,name");
                if (null == targetOrg) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\uff08ID=%s\uff09\u5df2\u7ecf\u4e0d\u5b58\u5728\uff0c\u8981\u5148\u6e05\u9664\u810f\u6570\u636e\u624d\u80fd\u7ee7\u7eed\u64cd\u4f5c\u3002", (String)"UnAssignHandle_11", (String)"fi-bd-common", (Object[])new Object[0]), useOrgId));
                }
                String msg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0\uff1a%1$s \u79d1\u76ee\u7f16\u7801\uff1a%2$s \u5df2\u7ecf\u53d1\u751f\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u5206\u914d\u3002", (String)"CheckUnAssignRes_0", (String)"fi-bd-common", (Object[])new Object[0]), targetOrg.getString("name"), number);
                OrgAccountInfo orgAccountInfo = datasMap.get(number);
                orgAccountInfo.setMsg(msg);
                ctx.getAcctCheckErrMsg().add(msg);
            }
        }
    }

    private void unDisParentAndSelfOrgAcct(UnAssignCtx ctx, Map<String, OrgAccountInfo> datasMap, String number, long useOrgId) {
        Map<Long, AssignOrgTreeNode> treeMap = ctx.getAssignOrgTreeNodeMap();
        Map<Long, Map<String, OrgAccountInfo>> orgAndDatas = ctx.getOrgAndDatas();
        this.setParentOrgAcctRef(number, useOrgId, treeMap, orgAndDatas);
    }

    private void setParentOrgAcctRef(String number, long useOrgId, Map<Long, AssignOrgTreeNode> treeMap, Map<Long, Map<String, OrgAccountInfo>> orgAndDatas) {
        Map<String, OrgAccountInfo> orgAccount;
        AssignOrgTreeNode treeNode = treeMap.get(useOrgId);
        if (treeNode == null) {
            return;
        }
        Long parentOrgId = treeNode.getParentId();
        if (null != parentOrgId && Long.compare(parentOrgId, 0L) > 0 && null != (orgAccount = orgAndDatas.get(parentOrgId))) {
            orgAccount.get(number).setRef(true);
            this.unDisParentAndSelfAcct(orgAccount, number);
            this.setParentOrgAcctRef(number, parentOrgId, treeMap, orgAndDatas);
        }
    }

    private void unDisParentAndSelfAcct(Map<String, OrgAccountInfo> datasMap, String number) {
        for (Map.Entry<String, OrgAccountInfo> datasEntry : datasMap.entrySet()) {
            String acctNum = datasEntry.getKey();
            if (!number.contains(acctNum)) continue;
            OrgAccountInfo parentAndSelfAccountInfo = datasMap.get(acctNum);
            parentAndSelfAccountInfo.setRef(true);
        }
    }

    protected Map<String, List<Object[]>> getUseRegDataByAcctAndOrg(UnAssignCtx ctx, Set<String> numbers, Long orgId) {
        ArrayList<Object> useregSqlParams = new ArrayList<Object>(10);
        StringBuilder useRegSqlByNumber = new StringBuilder();
        useRegSqlByNumber.append(" select reg.fdataid fdataid, reg.fuseorgid fuseorgid, acct.fmasterid fmasterid, acct.fnumber ");
        useRegSqlByNumber.append(" from T_BD_AccountUseReg reg ");
        useRegSqlByNumber.append(" left join t_bd_account acct on reg.FDATAID = acct.fid ");
        useRegSqlByNumber.append(" where reg.fuseorgid = ? ");
        useregSqlParams.add(orgId);
        useRegSqlByNumber.append(" and acct.faccounttableid = ? ");
        useregSqlParams.add(ctx.getAccountTableId());
        useRegSqlByNumber.append(" and acct.fnumber in( ");
        numbers.forEach(k -> useRegSqlByNumber.append("?,"));
        useregSqlParams.addAll(numbers);
        useRegSqlByNumber.deleteCharAt(useRegSqlByNumber.length() - 1).append(" ) ");
        Map params = (Map)DB.query((DBRoute)DBRoute.of((String)"gl"), (String)useRegSqlByNumber.toString(), (Object[])useregSqlParams.toArray(), rs -> {
            HashMap<String, List> rsParams = new HashMap<String, List>(16);
            while (rs.next()) {
                Object[] paramsNew = new Object[3];
                Long fdataid = rs.getLong("fdataid");
                Long fuseorgid = rs.getLong("fuseorgid");
                String fnumber = rs.getString("fnumber");
                paramsNew[0] = fdataid;
                paramsNew[1] = fuseorgid;
                paramsNew[2] = fnumber;
                rsParams.computeIfAbsent(fnumber, k -> new ArrayList(10)).add(paramsNew);
            }
            return rsParams;
        });
        return params;
    }

    private boolean isAccountUsed(List<Object[]> newParamsE) {
        Set accIds = newParamsE.stream().map(x -> (Long)x[0]).collect(Collectors.toSet());
        DynamicObjectCollection accounts = QueryServiceHelper.query((String)"bd_accountview", (String)"id,startdate", (QFilter[])new QFilter("id", "in", accIds).toArray());
        Map<Long, Date> idDateMap = accounts.stream().collect(Collectors.toMap(x -> x.getLong("id"), x -> x.getDate("startdate")));
        for (Object[] objects : newParamsE) {
            long accId = (Long)objects[0];
            if (idDateMap.get(accId) == null) {
                LOGGER.error("failed to find account:" + accId);
            }
            if (!BizHappenUtils.existOnLaterPeriods(accId, Collections.singleton((Long)objects[1]), idDateMap.get(accId))) continue;
            return true;
        }
        return false;
    }

    private void checkTableEnable(UnAssignCtx ctx) {
        Map<Long, Map<String, OrgAccountInfo>> orgAndDatas = ctx.getOrgAndDatas();
        for (Map.Entry<Long, Map<String, OrgAccountInfo>> orgAndDatasEntry : orgAndDatas.entrySet()) {
            long useOrgId = orgAndDatasEntry.getKey();
            Map<String, OrgAccountInfo> datasMap = orgAndDatasEntry.getValue();
            ArrayList<Long> dataIds = new ArrayList<Long>(10);
            for (Map.Entry<String, OrgAccountInfo> datasEntry : datasMap.entrySet()) {
                dataIds.addAll(datasEntry.getValue().getAccountIds());
            }
            Map<Long, Boolean> isEnableMap = AccountRefUtils.isAccountTableRefEnabled(useOrgId, dataIds);
            for (Map.Entry<Long, Boolean> isEnableEntry : isEnableMap.entrySet()) {
                DynamicObject accountObj;
                if (!isEnableEntry.getValue().booleanValue() || (accountObj = BusinessDataServiceHelper.loadSingleFromCache((Object)isEnableEntry.getKey(), (String)"bd_accountview", (String)"number")) == null || !datasMap.containsKey(accountObj.getString("number"))) continue;
                String number = accountObj.getString("number");
                OrgAccountInfo orgAccountInfo = datasMap.get(number);
                orgAccountInfo.setRef(true);
                String msg = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%1$s\u7684\u79d1\u76ee\u5728%2$s\u5df2\u7ecf\u505a\u4e86\u79d1\u76ee\u5bf9\u7167\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u5206\u914d\u3002", (String)"CheckUnAssignRes_6", (String)"fi-bd-common", (Object[])new Object[0]), number, orgAccountInfo.getOrgName());
                orgAccountInfo.setMsg(msg);
                ctx.getAcctCheckErrMsg().add(msg);
            }
        }
    }
}

