/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.assign.unassign;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.util.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.bd.assign.AssignAccountNumTreeNode;
import kd.fi.bd.assign.unassign.OrgAccountInfo;
import kd.fi.bd.vo.AssignOrgTreeNode;

public class UnAssignCtx
implements Serializable {
    private static final long serialVersionUID = 620680174849424062L;
    private Set<String> acctCheckErrMsg = new HashSet<String>(10);
    private Long useOrgid;
    private Map<Long, Map<String, OrgAccountInfo>> orgAndDatas = new HashMap<Long, Map<String, OrgAccountInfo>>(16);
    private Map<Long, Map<String, OrgAccountInfo>> dataInfoMap = new HashMap<Long, Map<String, OrgAccountInfo>>(16);
    private Map<Long, String> accountNumberIds = new HashMap<Long, String>(16);
    private Map<Long, String> useOrgs = new HashMap<Long, String>(16);
    private Set<Long> orgIds = new HashSet<Long>(10);
    private Set<Long> dataIDs = new HashSet<Long>(10);
    private Long accountTableId;
    private Map<String, AssignAccountNumTreeNode> assignAcctountNumTreeNodeMap;
    private Map<Long, AssignOrgTreeNode> assignOrgTreeNodeMap;
    private Map<String, AssignAccountNumTreeNode> cuAccountNumTreeNodeMap;
    private Map<String, AssignAccountNumTreeNode> freeAccountNumTreeNodeMap;
    private List<String> successPkIds = new ArrayList<String>(10);
    private Map<Object, String> successInfoMap = new HashMap<Object, String>(10);

    public void init() {
        this.assignOrgTreeNodeMap = new HashMap<Long, AssignOrgTreeNode>(this.orgIds.size());
        this.assignAcctountNumTreeNodeMap = new HashMap<String, AssignAccountNumTreeNode>(this.dataIDs.size());
        this.cuAccountNumTreeNodeMap = new HashMap<String, AssignAccountNumTreeNode>(this.dataIDs.size());
        this.freeAccountNumTreeNodeMap = new HashMap<String, AssignAccountNumTreeNode>(this.dataIDs.size());
        this.buildOrgNodes();
        this.buildAccountNumNodes();
        this.buildCuOrFreedAccountNumNodes();
    }

    private void buildCuOrFreedAccountNumNodes() {
        List pNumbers = this.assignAcctountNumTreeNodeMap.entrySet().stream().filter(e -> StringUtils.isEmpty((String)((AssignAccountNumTreeNode)e.getValue()).getPnumber())).map(x -> ((AssignAccountNumTreeNode)x.getValue()).getNumber()).collect(() -> new ArrayList(10), (r, x) -> r.add(x), (left, right) -> left.addAll(right));
        ArrayList<Long> sqlParams = new ArrayList<Long>(10);
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append(" Select fnumber,fctrlstrategy from t_bd_account ");
        sqlSb.append(" where fnumber in ( ");
        pNumbers.forEach(t -> sqlSb.append("?,"));
        sqlParams.addAll(pNumbers);
        sqlSb.deleteCharAt(sqlSb.length() - 1).append(" ) ");
        sqlSb.append(" and fid in ( ");
        this.dataIDs.forEach(t -> sqlSb.append("?,"));
        sqlParams.addAll(this.dataIDs);
        sqlSb.deleteCharAt(sqlSb.length() - 1).append(" ) ");
        Map queryRsl = (Map)DB.query((DBRoute)DBRoute.of((String)"fi"), (String)sqlSb.toString(), (Object[])sqlParams.toArray(), rs -> {
            HashMap<String, Set> result = new HashMap<String, Set>(2);
            while (rs.next()) {
                String ctrlStategyKey = "free";
                String ctrlStategy = rs.getString("fctrlstrategy");
                if ("1".equals(ctrlStategy) || "3".equals(ctrlStategy)) {
                    ctrlStategyKey = "cu";
                }
                result.computeIfAbsent(ctrlStategyKey, k -> new HashSet(10)).add(rs.getString("fnumber"));
            }
            return result;
        });
        this.iterratorNodeMap((Set)queryRsl.get("free"), this.freeAccountNumTreeNodeMap);
        this.iterratorNodeMap((Set)queryRsl.get("cu"), this.cuAccountNumTreeNodeMap);
    }

    private void iterratorNodeMap(Set<String> frees, Map<String, AssignAccountNumTreeNode> map) {
        if (null != frees && frees.size() != 0) {
            HashSet<String> numberSet = new HashSet<String>(10);
            for (String free : frees) {
                this.addCNumber(this.assignAcctountNumTreeNodeMap, free, numberSet);
            }
            for (String number : numberSet) {
                map.put(number, this.assignAcctountNumTreeNodeMap.get(number));
            }
        }
    }

    private void addCNumber(Map<String, AssignAccountNumTreeNode> assignAcctountNumTreeNodeMap, String acctNumber, Set<String> numberSet) {
        AssignAccountNumTreeNode node = assignAcctountNumTreeNodeMap.get(acctNumber);
        Set<String> childNumbers = node.getChildNumbers();
        if (null != childNumbers && childNumbers.size() > 0) {
            numberSet.addAll(childNumbers);
            for (String childNumber : childNumbers) {
                this.addCNumber(assignAcctountNumTreeNodeMap, childNumber, numberSet);
            }
        }
    }

    private void buildOrgNodes() {
        if (null == this.orgIds || this.orgIds.size() == 0) {
            throw new KDBizException(new ErrorCode("common", "%s"), new Object[]{ResManager.loadKDString((String)"\u5206\u914d\u7ec4\u7ec7\u4e3a\u7a7a", (String)"AssignCtx_0", (String)"fi-bd-common", (Object[])new Object[0])});
        }
        HashSet<Long> allSuperiorOrgIds = new HashSet<Long>(100);
        Map allSuperiorOrgs = OrgUnitServiceHelper.getAllSuperiorOrgs((String)"10", new ArrayList<Long>(this.orgIds));
        allSuperiorOrgIds.addAll(this.orgIds);
        for (Map.Entry entry : allSuperiorOrgs.entrySet()) {
            allSuperiorOrgIds.addAll((Collection)entry.getValue());
        }
        QFilter orgViewFilter = new QFilter("view", "=", (Object)10L);
        QFilter orgIdFilter = new QFilter("org", "in", allSuperiorOrgIds);
        DataSet dt = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bos_org_structure", (String)"org,parent", (QFilter[])new QFilter[]{orgViewFilter, orgIdFilter}, null);
        Iterator<Long> iterator = null;
        try {
            for (Row row : dt) {
                Long orgId = row.getLong("org");
                AssignOrgTreeNode curorgNode = this.assignOrgTreeNodeMap.get(orgId);
                if (null != curorgNode) continue;
                curorgNode = new AssignOrgTreeNode(orgId);
                curorgNode.setParentId(row.getLong("parent"));
                this.assignOrgTreeNodeMap.put(orgId, curorgNode);
            }
        }
        catch (Throwable throwable) {
            iterator = throwable;
            throw throwable;
        }
        finally {
            if (dt != null) {
                if (iterator != null) {
                    try {
                        dt.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)((Object)iterator)).addSuppressed(throwable);
                    }
                } else {
                    dt.close();
                }
            }
        }
        Set<Long> assignOrgIds = this.assignOrgTreeNodeMap.keySet();
        assignOrgIds = new HashSet<Long>(assignOrgIds);
        for (Long assignOrgId : assignOrgIds) {
            AssignOrgTreeNode curOrgNode = this.assignOrgTreeNodeMap.get(assignOrgId);
            Long parentOrgId = curOrgNode.getParentId();
            AssignOrgTreeNode parentOrgNode = this.assignOrgTreeNodeMap.computeIfAbsent(parentOrgId, k -> new AssignOrgTreeNode((Long)k));
            parentOrgNode.getChildIds().add(assignOrgId);
        }
        for (Long orgId : this.orgIds) {
            AssignOrgTreeNode curorgNode = this.assignOrgTreeNodeMap.get(orgId);
            if (null != curorgNode) continue;
            curorgNode = new AssignOrgTreeNode(orgId);
            this.assignOrgTreeNodeMap.put(orgId, curorgNode);
        }
    }

    private void buildAccountNumNodes() {
        DynamicObject[] accts;
        HashSet<Long> pidSet = new HashSet<Long>(this.dataIDs.size());
        for (DynamicObject acct : accts = BusinessDataServiceHelper.load((Object[])this.dataIDs.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"))) {
            String number = acct.getString("number");
            AssignAccountNumTreeNode node = this.assignAcctountNumTreeNodeMap.computeIfAbsent(number, k -> new AssignAccountNumTreeNode((String)k));
            Object parent = acct.getParent();
            String pnumber = acct.getString("parent.number");
            if (StringUtils.isNotEmpty((String)pnumber)) {
                node.setPnumber(pnumber);
                AssignAccountNumTreeNode pnode = this.assignAcctountNumTreeNodeMap.computeIfAbsent(pnumber, k -> new AssignAccountNumTreeNode((String)k));
                pnode.getChildNumbers().add(number);
            }
            if (acct.getLong("parent.id") == 0L) continue;
            pidSet.add(acct.getLong("parent.id"));
        }
        if (pidSet.size() > 0) {
            this.fixAcctTreeDataComplete(new HashSet<Long>(this.dataIDs), pidSet);
        }
        Set<Map.Entry<String, AssignAccountNumTreeNode>> entries = this.assignAcctountNumTreeNodeMap.entrySet();
        for (Map.Entry<String, AssignAccountNumTreeNode> treeNodeEntry : entries) {
            AssignAccountNumTreeNode node = treeNodeEntry.getValue();
            String pnumber = node.getPnumber();
            if (!StringUtils.isNotEmpty((String)pnumber)) continue;
            AssignAccountNumTreeNode parentOrgNode = this.assignAcctountNumTreeNodeMap.computeIfAbsent(pnumber, k -> new AssignAccountNumTreeNode((String)k));
            parentOrgNode.getChildNumbers().add(treeNodeEntry.getKey());
        }
    }

    private void fixAcctTreeDataComplete(Set<Long> dataIDs, Set<Long> pidSet) {
        DynamicObject[] accts = BusinessDataServiceHelper.load((Object[])pidSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"));
        pidSet.clear();
        for (DynamicObject acct : accts) {
            String number = acct.getString("number");
            if (this.assignAcctountNumTreeNodeMap.containsKey(number)) continue;
            dataIDs.add((Long)acct.getPkValue());
            if (acct.getLong("parent.id") != 0L) {
                pidSet.add(acct.getLong("parent.id"));
            }
            AssignAccountNumTreeNode node = new AssignAccountNumTreeNode(number);
            String pnumber = acct.getString("parent.number");
            if (StringUtils.isNotEmpty((String)pnumber)) {
                node.setPnumber(pnumber);
                AssignAccountNumTreeNode pnode = this.assignAcctountNumTreeNodeMap.computeIfAbsent(pnumber, k -> new AssignAccountNumTreeNode((String)k));
                pnode.getChildNumbers().add(pnumber);
            }
            this.assignAcctountNumTreeNodeMap.put(number, node);
        }
        if (pidSet.size() > 0) {
            this.fixAcctTreeDataComplete(dataIDs, pidSet);
        }
    }

    public Map<Long, Map<String, OrgAccountInfo>> getOrgAndDatas() {
        return this.orgAndDatas;
    }

    public void setOrgAndDatas(Map<Long, Map<String, OrgAccountInfo>> orgAndDatas) {
        this.orgAndDatas = orgAndDatas;
    }

    public Map<Long, String> getAccountNumberIds() {
        return this.accountNumberIds;
    }

    public void setAccountNumberIds(Map<Long, String> accountNumberIds) {
        this.accountNumberIds = accountNumberIds;
    }

    public Set<Long> getOrgIds() {
        return this.orgIds;
    }

    public void setOrgIds(Set<Long> orgIds) {
        this.orgIds = orgIds;
    }

    public Set<Long> getDataIDs() {
        return this.dataIDs;
    }

    public void setDataIDs(Set<Long> dataIDs) {
        this.dataIDs = dataIDs;
    }

    public Map<Long, String> getUseOrgs() {
        return this.useOrgs;
    }

    public void setUseOrgs(Map<Long, String> useOrgs) {
        this.useOrgs = useOrgs;
    }

    public Long getUseOrgid() {
        return this.useOrgid;
    }

    public void setUseOrgid(Long useOrgid) {
        this.useOrgid = useOrgid;
    }

    public Map<Long, AssignOrgTreeNode> getAssignOrgTreeNodeMap() {
        return this.assignOrgTreeNodeMap;
    }

    public void setAssignOrgTreeNodeMap(Map<Long, AssignOrgTreeNode> assignOrgTreeNodeMap) {
        this.assignOrgTreeNodeMap = assignOrgTreeNodeMap;
    }

    public Map<String, AssignAccountNumTreeNode> getAssignAcctountNumTreeNodeMap() {
        return this.assignAcctountNumTreeNodeMap;
    }

    public void setAssignAcctountNumTreeNodeMap(Map<String, AssignAccountNumTreeNode> assignAcctountNumTreeNodeMap) {
        this.assignAcctountNumTreeNodeMap = assignAcctountNumTreeNodeMap;
    }

    public Long getAccountTableId() {
        return this.accountTableId;
    }

    public void setAccountTableId(Long accountTableId) {
        this.accountTableId = accountTableId;
    }

    public Set<String> getAcctCheckErrMsg() {
        return this.acctCheckErrMsg;
    }

    public void setAcctCheckErrMsg(Set<String> acctCheckErrMsg) {
        this.acctCheckErrMsg = acctCheckErrMsg;
    }

    public Map<String, AssignAccountNumTreeNode> getCuAccountNumTreeNodeMap() {
        return this.cuAccountNumTreeNodeMap;
    }

    public void setCuAccountNumTreeNodeMap(Map<String, AssignAccountNumTreeNode> cuAccountNumTreeNodeMap) {
        this.cuAccountNumTreeNodeMap = cuAccountNumTreeNodeMap;
    }

    public Map<String, AssignAccountNumTreeNode> getFreeAccountNumTreeNodeMap() {
        return this.freeAccountNumTreeNodeMap;
    }

    public void setFreeAccountNumTreeNodeMap(Map<String, AssignAccountNumTreeNode> freeAccountNumTreeNodeMap) {
        this.freeAccountNumTreeNodeMap = freeAccountNumTreeNodeMap;
    }

    public Map<Long, Map<String, OrgAccountInfo>> getDataInfoMap() {
        return this.dataInfoMap;
    }

    public void setDataInfoMap(Map<Long, Map<String, OrgAccountInfo>> dataInfoMap) {
        this.dataInfoMap = dataInfoMap;
    }

    public List<String> getSuccessPkIds() {
        return this.successPkIds;
    }

    public Map<Object, String> getSuccessInfoMap() {
        return this.successInfoMap;
    }
}

