/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.assign.unassign;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.bd.assign.AssignAccountNumTreeNode;
import kd.fi.bd.assign.unassign.AbstractUnAssign;
import kd.fi.bd.assign.unassign.OrgAccountInfo;
import kd.fi.bd.assign.unassign.OrgAcctParent;
import kd.fi.bd.assign.unassign.OrgSingleAssignCtx;
import kd.fi.bd.assign.unassign.UnAssignCtx;
import kd.fi.bd.assign.unassign.UnAssignEvent;
import kd.fi.bd.vo.AssignOrgTreeNode;

public class UnAssignExcuter
extends AbstractUnAssign {
    private UnAssignCtx assignCtx;
    private OrgSingleAssignCtx ctx;
    private Map<String, OrgAccountInfo> accountMap;
    private Set<String> numbers;

    @Override
    protected boolean process(UnAssignEvent unAssignEvent) {
        this.ctx = unAssignEvent.getUnAssigner().getCtx();
        this.assignCtx = this.ctx.getAssignCtx();
        Map<String, OrgAcctParent> oapopMap = this.ctx.getOapopMap();
        Long orgId = this.ctx.getUseOrgid();
        this.accountMap = this.assignCtx.getOrgAndDatas().get(orgId);
        if (null == oapopMap || null == this.accountMap || this.accountMap.size() == 0) {
            return true;
        }
        this.numbers = this.accountMap.entrySet().stream().filter(e -> ((OrgAccountInfo)e.getValue()).getRef() == false).map(x -> (String)x.getKey()).collect(Collectors.toSet());
        if (null == this.numbers) {
            return true;
        }
        Map<String, AssignAccountNumTreeNode> accountNumTreeNodeMap = this.assignCtx.getAssignAcctountNumTreeNodeMap();
        List<String> acctNumbers = accountNumTreeNodeMap.entrySet().stream().filter(e -> ((AssignAccountNumTreeNode)e.getValue()).getChildNumbers().size() == 0).filter(e -> this.numbers.contains(((AssignAccountNumTreeNode)e.getValue()).getNumber())).map(x -> ((AssignAccountNumTreeNode)x.getValue()).getNumber()).collect(Collectors.toList());
        this.unAssign(oapopMap, orgId, acctNumbers);
        return true;
    }

    private void unAssign(Map<String, OrgAcctParent> oapopMap, Long orgId, List<String> acctNumbers) {
        for (String acctNumber : acctNumbers) {
            this.excuteUnAssign(oapopMap, orgId, acctNumber);
        }
        HashSet<String> pnumberSet = new HashSet<String>(10);
        Map<String, AssignAccountNumTreeNode> accountNumTreeNodeMap = this.assignCtx.getAssignAcctountNumTreeNodeMap();
        for (String acctNumber : acctNumbers) {
            String pnumber;
            AssignAccountNumTreeNode assignAccountNumTreeNode = accountNumTreeNodeMap.get(acctNumber);
            if (null == assignAccountNumTreeNode || !StringUtils.isNotEmpty((CharSequence)(pnumber = assignAccountNumTreeNode.getPnumber())) || !this.numbers.contains(pnumber)) continue;
            pnumberSet.add(pnumber);
        }
        if (pnumberSet.size() > 0) {
            this.unAssign(oapopMap, orgId, new ArrayList<String>(pnumberSet));
        }
    }

    private void excuteUnAssign(Map<String, OrgAcctParent> oapopMap, Long orgId, String acctNumber) {
        OperationResult result;
        OrgAcctParent orgAcctParent = oapopMap.get(acctNumber);
        if (null == orgAcctParent) {
            return;
        }
        Set<Long> versionIds = orgAcctParent.getVersionIds();
        if (versionIds.size() > 0 && (result = this.deleteVersion(orgId, orgAcctParent)) != null && !result.isSuccess()) {
            StringBuilder msgSb = new StringBuilder();
            List valResults = result.getValidateResult().getValidateErrors();
            for (ValidateResult validateResult : valResults) {
                for (OperateErrorInfo errorInfo : validateResult.getAllErrorInfo()) {
                    msgSb.append(errorInfo.getMessage()).append("\r\n");
                }
            }
            if (StringUtils.isBlank((CharSequence)msgSb)) {
                msgSb.append(result.getMessage());
            }
            String msg = String.format(ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u914d\u62a5\u9519\uff0c\u79d1\u76ee\u7f16\u7801\uff1a%1$s,\u7ec4\u7ec7\u540d\u79f0\uff1a%2$s,\u62a5\u9519\u4fe1\u606f\uff1a%3$s", (String)"UnAssignExcuter_3", (String)"fi-bd-common", (Object[])new Object[0]), acctNumber, this.assignCtx.getUseOrgs().get(orgId), msgSb.toString());
            this.assignCtx.getDataInfoMap().get(orgId).get(acctNumber).setMsg(msg);
            this.assignCtx.getAcctCheckErrMsg().add(msg);
            HashSet<String> numbers = new HashSet<String>(10);
            this.findAllpNumbers(acctNumber, numbers);
            HashSet<Long> orgIds = new HashSet<Long>(10);
            this.findAllPOrgs(orgId, orgIds);
            this.removeFailNumbers(numbers, orgIds);
            return;
        }
        Set<Long> useregIds = orgAcctParent.getUseregIds();
        String successKey = orgId.toString() + useregIds.toArray()[useregIds.size() - 1].toString();
        this.assignCtx.getSuccessPkIds().add(successKey);
        String orgName = this.assignCtx.getUseOrgs().get(orgId);
        String successMess = String.format(ResManager.loadKDString((String)"%1s\u7ec4\u7ec7\u7684%2s\u79d1\u76ee\uff0c\u53d6\u6d88\u5206\u914d", (String)"UnAssignExcuter_0", (String)"fi-bd-common", (Object[])new Object[0]), orgName, acctNumber);
        this.assignCtx.getSuccessInfoMap().put(successKey, successMess);
        Set<Long> excIds = orgAcctParent.getExcIds();
        ArrayList<Object[]> params = new ArrayList<Object[]>(useregIds.size() + excIds.size());
        for (Long useregId : useregIds) {
            params.add(new Object[]{useregId, orgId});
        }
        for (Long excId : excIds) {
            params.add(new Object[]{excId, orgId});
        }
        this.clearCache(params);
    }

    private OperationResult deleteVersion(Long orgId, OrgAcctParent orgAcctParent) {
        ArrayList<Map.Entry<Long, Date>> versionAcctIDEndDateSet = new ArrayList<Map.Entry<Long, Date>>(orgAcctParent.getVersionAcctIDEndDateMap().entrySet());
        Comparator<Map.Entry<Long, Date>> versionAcctIDEndDateSetComparator = new Comparator<Map.Entry<Long, Date>>(){

            @Override
            public int compare(Map.Entry<Long, Date> arg0, Map.Entry<Long, Date> arg1) {
                return -arg0.getValue().compareTo(arg1.getValue());
            }
        };
        Collections.sort(versionAcctIDEndDateSet, versionAcctIDEndDateSetComparator);
        OperateOption operation = OperateOption.create();
        operation.setVariableValue("createOrg", orgId.toString());
        operation.setVariableValue("isassign", "1");
        OperationResult result = null;
        for (Map.Entry<Long, Date> versionAcctIDEndDateEnty : versionAcctIDEndDateSet) {
            result = OperationServiceHelper.executeOperate((String)"versiondelete", (String)"bd_accountview", (Object[])new Object[]{versionAcctIDEndDateEnty.getKey()}, (OperateOption)operation);
            if (result.isSuccess()) continue;
            return result;
        }
        orgAcctParent.getVersionIds().clear();
        orgAcctParent.getVersionAcctIDEndDateMap().clear();
        return result;
    }

    private void removeFailNumbers(Set<String> numbers, Set<Long> orgIds) {
        Map<Long, Map<String, OrgAccountInfo>> orgAndDatas = this.assignCtx.getOrgAndDatas();
        for (Long orgId : orgIds) {
            Map<String, OrgAccountInfo> datasMap = orgAndDatas.get(orgId);
            for (String number : numbers) {
                datasMap.remove(number);
            }
        }
    }

    private void findAllPOrgs(Long orgId, Set<Long> orgIds) {
        orgIds.add(orgId);
        Map<Long, AssignOrgTreeNode> assignOrgTreeNodeMap = this.assignCtx.getAssignOrgTreeNodeMap();
        AssignOrgTreeNode pNode = assignOrgTreeNodeMap.get(orgId).getParent();
        if (null == pNode) {
            return;
        }
        Long pOrigId = pNode.getParentId();
        orgIds.add(pOrigId);
        this.findAllPOrgs(pOrigId, orgIds);
    }

    private void findAllpNumbers(String number, Set<String> numbers) {
        numbers.add(number);
        Map<String, AssignAccountNumTreeNode> assignAcctountNumTreeNodeMap = this.assignCtx.getAssignAcctountNumTreeNodeMap();
        AssignAccountNumTreeNode parent = assignAcctountNumTreeNodeMap.get(number).getParent();
        if (null == parent) {
            return;
        }
        String pNumber = parent.getNumber();
        numbers.add(pNumber);
        this.findAllpNumbers(pNumber, numbers);
    }

    private void clearCache(List<Object[]> params) {
        if (params != null && !params.isEmpty()) {
            String deleteUseRangeSql = "delete from t_bd_accountusereg where fdataid = ? and fuseorgid = ?";
            DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)deleteUseRangeSql, params);
            deleteUseRangeSql = "DELETE from t_bd_accountusereg  where FDataID in(SELECT fid from t_bd_account where fid <> fmasterid  and fmasterid = ?  and fcreateorgid = ? ) ";
            DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)deleteUseRangeSql, params);
            deleteUseRangeSql = "delete from t_bd_accountExc where fdataid = ? and fuseorgid = ?";
            DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)deleteUseRangeSql, params);
            deleteUseRangeSql = "DELETE from t_bd_accountExc  where FDataID in(SELECT fid from t_bd_account where fid <> fmasterid  and fmasterid = ?  and fcreateorgid = ? ) ";
            DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)deleteUseRangeSql, params);
            deleteUseRangeSql = "delete from t_bd_account_u where fdataid = ? and fuseorgid = ?";
            DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)deleteUseRangeSql, params);
            deleteUseRangeSql = "DELETE from t_bd_account_u  where FDataID in(SELECT fid from t_bd_account where fid <> fmasterid  and fmasterid = ?  and fcreateorgid = ? ) ";
            DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)deleteUseRangeSql, params);
        }
    }
}

