/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.assign.unassign;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataService;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.fi.bd.assign.unassign.BuildOrgAcctParentAndOtherParents;
import kd.fi.bd.assign.unassign.BuildOrgAcctParents;
import kd.fi.bd.assign.unassign.CheckUnAssignRes;
import kd.fi.bd.assign.unassign.OrgAccountInfo;
import kd.fi.bd.assign.unassign.OrgSingleAssignCtx;
import kd.fi.bd.assign.unassign.UnAssignCtx;
import kd.fi.bd.assign.unassign.UnAssignExcuter;
import kd.fi.bd.assign.unassign.UnAssigner;
import kd.fi.bd.consts.AccountOperationType;
import kd.fi.bd.consts.OperationLogEntry;
import kd.fi.bd.util.AccountOperationLogUtil;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.vo.AssignOrgTreeNode;

public class UnAssignHandle {
    private static final Log logger = LogFactory.getLog(UnAssignHandle.class);
    private IFormView view;
    private UnAssignCtx assignCtx;

    public UnAssignHandle(UnAssignCtx assignCtx, IFormView view) {
        this.assignCtx = assignCtx;
        this.view = view;
        try {
            this.buildUnAssignDatas();
            assignCtx.init();
        }
        catch (Exception e) {
            String msg = String.format(ResManager.loadKDString((String)"\u5206\u914d\u7ec4\u7ec7\u62a5\u9519,\u62a5\u9519\u4fe1\u606f\uff1a%s", (String)"UnAssignHandle_9", (String)"fi-bd-common", (Object[])new Object[0]), e.getMessage());
            this.refreshBaseDataUseRange();
            logger.error(msg, (Throwable)e);
        }
    }

    private void buildUnAssignDatas() {
        this.findAllAssign();
    }

    private void findAllAssign() {
        Map<Long, Map<String, OrgAccountInfo>> orgAndDatas = this.assignCtx.getOrgAndDatas();
        for (Map.Entry<Long, Map<String, OrgAccountInfo>> orgAndDatasEntry : orgAndDatas.entrySet()) {
            Long orgId = orgAndDatasEntry.getKey();
            Map<String, OrgAccountInfo> datasMap = orgAndDatasEntry.getValue();
            this.findAllAssignByOrg(orgId, datasMap);
        }
    }

    private void findAllAssignByOrg(Long orgId, Map<String, OrgAccountInfo> datasMap) {
        Set<String> numbers = datasMap.keySet();
        if (null == numbers || numbers.size() == 0) {
            return;
        }
        long accountTableId = this.assignCtx.getAccountTableId();
        ArrayList<Object> ups = new ArrayList<Object>(10);
        StringBuilder useRegSqlByNumber = new StringBuilder();
        useRegSqlByNumber.append(" select reg.fdataid fdataid, reg.fuseorgid fuseorgid, acct.fmasterid fmasterid, acct.fnumber ");
        useRegSqlByNumber.append(" from T_BD_AccountUseReg reg ");
        useRegSqlByNumber.append(" left join t_bd_account acct on reg.FDATAID = acct.fid ");
        useRegSqlByNumber.append(" where acct.faccounttableid = ? ");
        ups.add(accountTableId);
        useRegSqlByNumber.append(" and reg.fuseorgid = ? ");
        ups.add(orgId);
        useRegSqlByNumber.append(" and acct.fnumber in ( ");
        numbers.forEach(k -> useRegSqlByNumber.append("?,"));
        ups.addAll(numbers);
        useRegSqlByNumber.deleteCharAt(useRegSqlByNumber.length() - 1).append(")");
        Map queryRs = (Map)DB.query((DBRoute)DBRoute.of((String)"fi"), (String)useRegSqlByNumber.toString(), (Object[])ups.toArray(), rs -> {
            HashMap<String, Set> datas = new HashMap<String, Set>(16);
            while (rs.next()) {
                long fdataid = rs.getLong("fdataid");
                String fnumber = rs.getString("fnumber");
                datas.computeIfAbsent(fnumber, k -> new HashSet(16)).add(fdataid);
            }
            return datas;
        });
        for (Map.Entry queryRsEntry : queryRs.entrySet()) {
            String number = (String)queryRsEntry.getKey();
            Set dataIds = (Set)queryRsEntry.getValue();
            String orgName = this.assignCtx.getUseOrgs().computeIfAbsent(orgId, id -> BusinessDataServiceHelper.loadSingle((Object)id, (String)"bos_org").getString("name"));
            OrgAccountInfo orgAccountInfo = datasMap.computeIfAbsent(number, k -> new OrgAccountInfo(orgId, orgName, (String)k));
            orgAccountInfo.getAccountIds().addAll(dataIds);
        }
        HashSet<Long> dataIds = new HashSet<Long>(10);
        for (Map.Entry<String, OrgAccountInfo> datasMapEntry : datasMap.entrySet()) {
            dataIds.addAll(datasMapEntry.getValue().getAccountIds());
        }
        this.recursiveDatas(orgId, dataIds);
    }

    private void recursiveDatas(Long orgId, Set<Long> dataIds) {
        Map<Long, Map<String, OrgAccountInfo>> orgAndDatas = this.assignCtx.getOrgAndDatas();
        ArrayList<Long> params = new ArrayList<Long>(10);
        StringBuilder sql = new StringBuilder();
        sql.append(" select reg.fdataid,reg.fuseorgid,reg.fassignorgid,a.fnumber ");
        sql.append(" from T_BD_AccountUseReg reg");
        sql.append(" left join T_BD_Account a on a.fid=reg.fdataid ");
        sql.append(" where reg.fassignorgid = ? ");
        params.add(orgId);
        sql.append(" and reg.fdataid in ( ");
        dataIds.forEach(k -> sql.append("?,"));
        sql.deleteCharAt(sql.length() - 1).append(" ) ");
        params.addAll(dataIds);
        Map assignOrgDataSetRs = (Map)DB.query((DBRoute)DBRoute.of((String)"fi"), (String)sql.toString(), (Object[])params.toArray(), resultSet -> {
            HashMap<Long, Map> assignOrgDatas = new HashMap<Long, Map>(16);
            while (resultSet.next()) {
                long fdataid = resultSet.getLong("fdataid");
                long fuseorgid = resultSet.getLong("fuseorgid");
                String fnumber = resultSet.getString("fnumber");
                assignOrgDatas.computeIfAbsent(fuseorgid, k -> new HashMap(16)).computeIfAbsent(fnumber, k -> new HashSet(10)).add(fdataid);
            }
            return assignOrgDatas;
        });
        if (null == assignOrgDataSetRs || assignOrgDataSetRs.size() == 0) {
            return;
        }
        for (Map.Entry assignOrgDataSetRsEntry : assignOrgDataSetRs.entrySet()) {
            Long nOrgId = (Long)assignOrgDataSetRsEntry.getKey();
            Map assigDatasMap = (Map)assignOrgDataSetRsEntry.getValue();
            for (Map.Entry assigDatasMapEntry : assigDatasMap.entrySet()) {
                String aNumber = (String)assigDatasMapEntry.getKey();
                Set ADataIds = (Set)assigDatasMapEntry.getValue();
                for (Long aDataId : ADataIds) {
                    String orgName = this.assignCtx.getUseOrgs().computeIfAbsent(orgId, id -> BusinessDataServiceHelper.loadSingle((Object)id, (String)"bos_org").getString("name"));
                    OrgAccountInfo orgAccountInfo = orgAndDatas.computeIfAbsent(nOrgId, k -> new HashMap(16)).computeIfAbsent(aNumber, k -> new OrgAccountInfo(nOrgId, orgName, aNumber));
                    orgAccountInfo.getAccountIds().add(aDataId);
                }
            }
        }
        for (Map.Entry assignOrgDataSetRsEntry : assignOrgDataSetRs.entrySet()) {
            Long aOrgId = (Long)assignOrgDataSetRsEntry.getKey();
            Map aDatas = (Map)assignOrgDataSetRsEntry.getValue();
            HashSet<Long> aDataIds = new HashSet<Long>(10);
            for (Map.Entry aDatasEntry : aDatas.entrySet()) {
                aDataIds.addAll((Collection)aDatasEntry.getValue());
            }
            if (aOrgId.compareTo(orgId) == 0) continue;
            this.recursiveDatas(aOrgId, aDataIds);
        }
    }

    public void handle() {
        try {
            AccountOperationLogUtil.setOperationLog(operationLog -> operationLog.setOrgIds(this.assignCtx.getOrgIds()));
            new CheckUnAssignRes().process(this.assignCtx);
            Map<Long, AssignOrgTreeNode> orgTreeNodeMap = this.assignCtx.getAssignOrgTreeNodeMap();
            List orgIds = orgTreeNodeMap.entrySet().stream().filter(e -> ((AssignOrgTreeNode)e.getValue()).getChildIds().size() == 0).map(x -> ((AssignOrgTreeNode)x.getValue()).getId()).collect(() -> new ArrayList(10), (r, x) -> r.add(x), (left, right) -> left.addAll(right));
            orgIds.remove(this.assignCtx.getUseOrgid());
            for (Map.Entry<Long, Map<String, OrgAccountInfo>> orgAndDataEntry : this.assignCtx.getOrgAndDatas().entrySet()) {
                Long key = orgAndDataEntry.getKey();
                Map<String, OrgAccountInfo> value = orgAndDataEntry.getValue();
                this.assignCtx.getDataInfoMap().put(key, new HashMap<String, OrgAccountInfo>(value));
            }
            this.doUnAssign(orgIds);
            AccountOperationLogUtil.setOperationLog(operationLog -> {
                List<OperationLogEntry> entryEntity = operationLog.getEntryEntity();
                boolean success = true;
                for (Map.Entry<Long, Map<String, OrgAccountInfo>> orgAndDataEntry : this.assignCtx.getDataInfoMap().entrySet()) {
                    Long orgId = orgAndDataEntry.getKey();
                    for (Map.Entry<String, OrgAccountInfo> accountInfoEntry : orgAndDataEntry.getValue().entrySet()) {
                        OrgAccountInfo accountInfo = accountInfoEntry.getValue();
                        Long accountId = 0L;
                        for (Long dataId : this.assignCtx.getDataIDs()) {
                            if (!accountInfo.getAccountIds().contains(dataId)) continue;
                            accountId = dataId;
                            break;
                        }
                        OperationLogEntry entry = new OperationLogEntry(orgId, accountId, AccountOperationType.UNASSIGN, StringUtils.isEmpty((String)accountInfo.getMsg()));
                        entry.setLog(accountInfo.getMsg());
                        entryEntity.add(entry);
                        if (!success || !StringUtils.isNotEmpty((String)accountInfo.getMsg())) continue;
                        success = false;
                    }
                }
                operationLog.setLog(success ? ResManager.loadKDString((String)"\u6210\u529f", (String)"UnAssignHandle_7", (String)"fi-bd-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5931\u8d25", (String)"UnAssignHandle_8", (String)"fi-bd-common", (Object[])new Object[0]));
            });
        }
        catch (Exception e2) {
            String msg = String.format(ResManager.loadKDString((String)"\u5206\u914d\u7ec4\u7ec7\u62a5\u9519,\u62a5\u9519\u4fe1\u606f\uff1a%s", (String)"UnAssignHandle_9", (String)"fi-bd-common", (Object[])new Object[0]), e2.getMessage());
            logger.error(msg, (Throwable)e2);
        }
    }

    public void doUnAssign(List<Long> orgIds) {
        if (null == orgIds || orgIds.size() == 0) {
            return;
        }
        HashSet<Long> parentOrgIds = new HashSet<Long>(10);
        CountDownLatch cdl = new CountDownLatch(orgIds.size());
        String requestId = RequestContext.getOrCreate().getRequestId();
        for (Long orgId : orgIds) {
            ThreadService.execute(() -> {
                RequestContext.getOrCreate().setRequestId(requestId);
                try {
                    this.doUnAssign(orgId);
                }
                catch (Exception e) {
                    String printError = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                    String msg = String.format(ResManager.loadKDString((String)"\u5206\u914d\u7ec4\u7ec7\u62a5\u9519\uff0c\u7ec4\u7ec7\u540d\u79f0\uff1a%1$s,\u62a5\u9519\u4fe1\u606f\uff1a%2$s", (String)"UnAssignHandle_10", (String)"fi-bd-common", (Object[])new Object[0]), this.assignCtx.getUseOrgs().get(orgId), e.getMessage());
                    logger.error(msg + printError);
                }
                finally {
                    cdl.countDown();
                }
            }, (TaskType)TaskType.FIBD_ACCOUNT_UNASSIGN_TASK);
        }
        try {
            cdl.await();
        }
        catch (InterruptedException e) {
            String msg = String.format(ResManager.loadKDString((String)"\u5206\u914d\u7ec4\u7ec7\u62a5\u9519,\u62a5\u9519\u4fe1\u606f\uff1a%s", (String)"UnAssignHandle_9", (String)"fi-bd-common", (Object[])new Object[0]), e.getMessage());
            logger.error(msg, (Throwable)e);
        }
        Map<Long, AssignOrgTreeNode> orgTreeNodeMap = this.assignCtx.getAssignOrgTreeNodeMap();
        for (Long orgId : orgIds) {
            Long parentId;
            AssignOrgTreeNode assignOrgTreeNode = orgTreeNodeMap.get(orgId);
            if (null == assignOrgTreeNode || (parentId = assignOrgTreeNode.getParentId()) == null || parentId.longValue() == this.assignCtx.getUseOrgid().longValue()) continue;
            parentOrgIds.add(parentId);
        }
        this.doUnAssign(new ArrayList<Long>(parentOrgIds));
    }

    public void doUnAssign(Long orgId) {
        OrgSingleAssignCtx orgSingleAssignCtx = new OrgSingleAssignCtx(this.assignCtx, orgId);
        BuildOrgAcctParentAndOtherParents unAssign = new BuildOrgAcctParentAndOtherParents();
        unAssign.setNextUnAssign(new BuildOrgAcctParents()).setNextUnAssign(new UnAssignExcuter());
        UnAssigner unAssigner = new UnAssigner(orgSingleAssignCtx);
        unAssigner.setUnAssign(unAssign);
        unAssigner.doUnAssign();
    }

    private void refreshBaseDataUseRange() {
        if (AccountVersionUtil.isRebuildDataUseRangeSystemProperty()) {
            Set<Long> orgIds = this.assignCtx.getOrgIds();
            ArrayList<Long> singletonList = new ArrayList<Long>(1);
            BaseDataService baseDataService = new BaseDataService();
            for (Long orgId : orgIds) {
                singletonList.clear();
                singletonList.add(orgId);
                baseDataService.clearBaseDataFilterCache("bd_accountview", orgId);
                BaseDataServiceHelper.refreshBaseDataUseRange((String)"bd_accountview", singletonList);
            }
        }
        Set<String> acctCheckErrMsg = this.assignCtx.getAcctCheckErrMsg();
        this.view.getPageCache().put("mark", "finish");
        this.view.getPageCache().put("msg", acctCheckErrMsg.size() > 0 ? JSONObject.toJSONString(acctCheckErrMsg) : null);
    }
}

