/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.assignv2.unassign;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.basedata.cache.BaseDataCtrlCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataService;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.bd.assign.AssignAccountNumTreeNode;
import kd.fi.bd.assign.AssignResult;
import kd.fi.bd.assign.unassign.CheckUnAssignRes;
import kd.fi.bd.assign.unassign.OrgAccountInfo;
import kd.fi.bd.assign.unassign.OrgAcctParent;
import kd.fi.bd.assign.unassign.OrgSingleAssignCtx;
import kd.fi.bd.assign.unassign.UnAssignCtx;
import kd.fi.bd.consts.AccountOperationType;
import kd.fi.bd.consts.OperationLogEntry;
import kd.fi.bd.util.AccountOperationLogUtil;
import kd.fi.bd.util.AccountVersionOpVars;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.BizHappenUtils;
import kd.fi.bd.vo.AssignOrgTreeNode;

public class UnAssignHandle {
    private static final Log logger = LogFactory.getLog(UnAssignHandle.class);
    private UnAssignCtx assignCtx;
    private AssignResult assignResult;

    public UnAssignHandle(UnAssignCtx assignCtx) {
        this.assignCtx = assignCtx;
        this.assignResult = new AssignResult(AssignResult.ResultType.success);
        try {
            this.buildUnAssignDatas();
            assignCtx.init();
        }
        catch (Exception e) {
            String msg = String.format(ResManager.loadKDString((String)"\u5206\u914d\u7ec4\u7ec7\u62a5\u9519,\u62a5\u9519\u4fe1\u606f\uff1a%s", (String)"UnAssignHandle_9", (String)"fi-bd-common", (Object[])new Object[0]), e.getMessage());
            this.refreshBaseDataUseRange();
            logger.error(msg, (Throwable)e);
        }
    }

    private void buildUnAssignDatas() {
        Map<Long, Map<String, OrgAccountInfo>> orgAndDatas = this.assignCtx.getOrgAndDatas();
        for (Map.Entry<Long, Map<String, OrgAccountInfo>> orgAndDatasEntry : orgAndDatas.entrySet()) {
            Long orgId = orgAndDatasEntry.getKey();
            Map<String, OrgAccountInfo> datasMap = orgAndDatasEntry.getValue();
            this.findAllAssignByOrg(orgId, datasMap);
        }
    }

    private void findAllAssignByOrg(Long orgId, Map<String, OrgAccountInfo> datasMap) {
        Set<String> numbers = datasMap.keySet();
        if (null == numbers || numbers.size() == 0) {
            return;
        }
        SqlBuilder useRegSqlByNumber = new SqlBuilder();
        useRegSqlByNumber.append(" select reg.fdataid fdataid, reg.fuseorgid fuseorgid, acct.fmasterid fmasterid, acct.fnumber ", new Object[0]);
        useRegSqlByNumber.append(" from T_BD_AccountUseReg reg ", new Object[0]);
        useRegSqlByNumber.append(" left join t_bd_account acct on reg.FDATAID = acct.fid ", new Object[0]);
        useRegSqlByNumber.append(" where acct.faccounttableid = ? ", new Object[]{this.assignCtx.getAccountTableId()});
        useRegSqlByNumber.append(" and reg.fuseorgid = ? ", new Object[]{orgId});
        useRegSqlByNumber.appendIn(" and acct.fnumber ", new ArrayList<String>(numbers));
        DataSet dataSet = DB.queryDataSet((String)"findAllAssignByOrg", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)useRegSqlByNumber);
        Object object = null;
        try {
            for (Row row : dataSet) {
                String orgName = this.assignCtx.getUseOrgs().computeIfAbsent(orgId, id -> BusinessDataServiceHelper.loadSingle((Object)id, (String)"bos_org").getString("name"));
                OrgAccountInfo orgAccountInfo = datasMap.computeIfAbsent(row.getString("fnumber"), k -> new OrgAccountInfo(orgId, orgName, (String)k));
                orgAccountInfo.getAccountIds().add(row.getLong("fdataid"));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        HashSet<Long> dataIds = new HashSet<Long>(10);
        for (Map.Entry entry : datasMap.entrySet()) {
            dataIds.addAll(((OrgAccountInfo)entry.getValue()).getAccountIds());
        }
        this.recursiveDatas(orgId, dataIds);
    }

    private void recursiveDatas(Long orgId, Set<Long> dataIds) {
        Set<Long> allChildrenOrgIds = BDUtil.getAllChildrenOrgIds(orgId, false);
        Map<Long, Map<String, OrgAccountInfo>> orgAndDatas = this.assignCtx.getOrgAndDatas();
        SqlBuilder sql = new SqlBuilder();
        sql.append(" select reg.fdataid,reg.fuseorgid,reg.fassignorgid,a.fnumber ", new Object[0]);
        sql.append(" from T_BD_AccountUseReg reg", new Object[0]);
        sql.append(" left join T_BD_Account a on a.fid=reg.fdataid ", new Object[0]);
        sql.append(" where reg.fassignorgid = ? ", new Object[]{orgId});
        sql.appendIn(" and reg.fdataid ", new ArrayList<Long>(dataIds));
        HashMap<Long, Map> assignOrgDataSetRs = new HashMap<Long, Map>(16);
        try (DataSet dataSet = DB.queryDataSet((String)"recursiveDatas", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sql);){
            for (Row row : dataSet) {
                long fdataid = row.getLong("fdataid");
                long fuseorgid = row.getLong("fuseorgid");
                String fnumber = row.getString("fnumber");
                if (!allChildrenOrgIds.contains(fuseorgid)) continue;
                assignOrgDataSetRs.computeIfAbsent(fuseorgid, k -> new HashMap(16)).computeIfAbsent(fnumber, k -> new HashSet(10)).add(fdataid);
            }
        }
        if (null == assignOrgDataSetRs || assignOrgDataSetRs.size() == 0) {
            return;
        }
        for (Map.Entry assignOrgDataSetRsEntry : assignOrgDataSetRs.entrySet()) {
            Long nOrgId = (Long)assignOrgDataSetRsEntry.getKey();
            Map assigDatasMap = (Map)assignOrgDataSetRsEntry.getValue();
            for (Map.Entry assigDatasMapEntry : assigDatasMap.entrySet()) {
                String aNumber = (String)assigDatasMapEntry.getKey();
                Set ADataIds = (Set)assigDatasMapEntry.getValue();
                for (Long aDataId : ADataIds) {
                    String orgName = this.assignCtx.getUseOrgs().computeIfAbsent(orgId, id -> BusinessDataServiceHelper.loadSingle((Object)id, (String)"bos_org").getString("name"));
                    OrgAccountInfo orgAccountInfo = orgAndDatas.computeIfAbsent(nOrgId, k -> new HashMap(16)).computeIfAbsent(aNumber, k -> new OrgAccountInfo(nOrgId, orgName, aNumber));
                    orgAccountInfo.getAccountIds().add(aDataId);
                }
            }
        }
        for (Map.Entry assignOrgDataSetRsEntry : assignOrgDataSetRs.entrySet()) {
            Long aOrgId = (Long)assignOrgDataSetRsEntry.getKey();
            Map aDatas = (Map)assignOrgDataSetRsEntry.getValue();
            HashSet<Long> aDataIds = new HashSet<Long>(10);
            for (Map.Entry aDatasEntry : aDatas.entrySet()) {
                aDataIds.addAll((Collection)aDatasEntry.getValue());
            }
            if (aOrgId.compareTo(orgId) == 0) continue;
            this.recursiveDatas(aOrgId, aDataIds);
        }
    }

    public AssignResult handle() {
        try {
            AccountOperationLogUtil.setOperationLog(operationLog -> operationLog.setOrgIds(this.assignCtx.getOrgIds()));
            new CheckUnAssignRes().process(this.assignCtx);
            Map<Long, Map<String, OrgAccountInfo>> orgAndDatas = this.assignCtx.getOrgAndDatas();
            for (Map.Entry<Long, Map<String, OrgAccountInfo>> orgAndDatasEntry : orgAndDatas.entrySet()) {
                long useOrgId = orgAndDatasEntry.getKey();
                Map<String, OrgAccountInfo> datasMap = orgAndDatasEntry.getValue();
                Set<String> numbers = datasMap.keySet();
                if (null == numbers || numbers.size() == 0) continue;
                HashSet<String> createOrgAccountNums = new HashSet<String>();
                SqlBuilder sql = new SqlBuilder();
                sql.append("select a.fnumber from t_bd_account as a inner join t_bd_account_u as u on a.fid=u.fdataid", new Object[0]);
                sql.append("where a.fcreateorgid = ?", new Object[]{useOrgId});
                sql.appendIn("and a.fnumber", new ArrayList<String>(numbers));
                sql.append("and a.faccounttableid = ?", new Object[]{this.assignCtx.getAccountTableId()});
                sql.append("and a.fid = a.fmasterid", new Object[0]);
                DataSet dt = DB.queryDataSet((String)AccountVersionUtil.class.getName(), (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sql);
                Object object = null;
                try {
                    for (Row row : dt) {
                        createOrgAccountNums.add(row.getString("fnumber"));
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (dt != null) {
                        if (object != null) {
                            try {
                                dt.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            dt.close();
                        }
                    }
                }
                if (createOrgAccountNums.isEmpty()) continue;
                DynamicObject targetOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)useOrgId, (String)"bos_org", (String)"name");
                if (null == targetOrg) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\uff08ID=%s\uff09\u5df2\u7ecf\u4e0d\u5b58\u5728\uff0c\u8981\u5148\u6e05\u9664\u810f\u6570\u636e\u624d\u80fd\u7ee7\u7eed\u64cd\u4f5c\u3002", (String)"UnAssignHandle_11", (String)"fi-bd-common", (Object[])new Object[0]), useOrgId));
                }
                for (String createOrgAccountNum : createOrgAccountNums) {
                    String msg = String.format(ResManager.loadKDString((String)"\u4e0b\u7ea7\u7ec4\u7ec7\uff1a%1$s \u516c\u53f8\u7684\u79d1\u76ee\u4e3a\u8be5\u79d1\u76ee\u7684\u539f\u59cb\u521b\u5efa\u7ec4\u7ec7\uff0c\u4e0d\u5141\u8bb8\u53cd\u5206\u914d\u3002", (String)"UnAssignHandle_14", (String)"fi-bd-common", (Object[])new Object[0]), targetOrg.getString("name"), createOrgAccountNum);
                    datasMap.get(createOrgAccountNum).setMsg(msg);
                    this.assignCtx.getAcctCheckErrMsg().add(msg);
                }
            }
            if (this.assignCtx.getAcctCheckErrMsg() != null && this.assignCtx.getAcctCheckErrMsg().size() > 0) {
                this.assignResult.setResultType(AssignResult.ResultType.failed);
                this.assignResult.getMsgs().addAll(this.assignCtx.getAcctCheckErrMsg());
            }
            Map<Long, AssignOrgTreeNode> orgTreeNodeMap = this.assignCtx.getAssignOrgTreeNodeMap();
            List orgIds = orgTreeNodeMap.entrySet().stream().filter(e -> ((AssignOrgTreeNode)e.getValue()).getChildIds().size() == 0).map(x -> ((AssignOrgTreeNode)x.getValue()).getId()).collect(() -> new ArrayList(10), (r, x) -> r.add(x), (left, right) -> left.addAll(right));
            orgIds.remove(this.assignCtx.getUseOrgid());
            for (Map.Entry<Long, Map<String, OrgAccountInfo>> orgAndDataEntry : this.assignCtx.getOrgAndDatas().entrySet()) {
                Long key = orgAndDataEntry.getKey();
                Map<String, OrgAccountInfo> value = orgAndDataEntry.getValue();
                this.assignCtx.getDataInfoMap().put(key, new HashMap<String, OrgAccountInfo>(value));
            }
            this.doUnAssign(orgIds);
            AccountOperationLogUtil.setOperationLog(operationLog -> {
                List<OperationLogEntry> entryEntity = operationLog.getEntryEntity();
                boolean success = true;
                for (Map.Entry<Long, Map<String, OrgAccountInfo>> orgAndDataEntry : this.assignCtx.getDataInfoMap().entrySet()) {
                    Long orgId = orgAndDataEntry.getKey();
                    for (Map.Entry<String, OrgAccountInfo> accountInfoEntry : orgAndDataEntry.getValue().entrySet()) {
                        OrgAccountInfo accountInfo = accountInfoEntry.getValue();
                        Long accountId = 0L;
                        for (Long dataId : this.assignCtx.getDataIDs()) {
                            if (!accountInfo.getAccountIds().contains(dataId)) continue;
                            accountId = dataId;
                            break;
                        }
                        OperationLogEntry entry = new OperationLogEntry(orgId, accountId, AccountOperationType.UNASSIGN, kd.bos.util.StringUtils.isEmpty((String)accountInfo.getMsg()));
                        entry.setLog(accountInfo.getMsg());
                        entryEntity.add(entry);
                        if (!success || !kd.bos.util.StringUtils.isNotEmpty((String)accountInfo.getMsg())) continue;
                        success = false;
                    }
                }
                operationLog.setLog(success ? ResManager.loadKDString((String)"\u6210\u529f", (String)"UnAssignHandle_7", (String)"fi-bd-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5931\u8d25", (String)"UnAssignHandle_8", (String)"fi-bd-common", (Object[])new Object[0]));
            });
        }
        catch (Exception e2) {
            String msg = String.format(ResManager.loadKDString((String)"\u5206\u914d\u7ec4\u7ec7\u62a5\u9519,\u62a5\u9519\u4fe1\u606f\uff1a%s", (String)"UnAssignHandle_9", (String)"fi-bd-common", (Object[])new Object[0]), e2.getMessage());
            this.assignResult.setResultType(AssignResult.ResultType.failed);
            this.assignResult.getMsgs().add(msg);
            logger.error(msg, (Throwable)e2);
        }
        return this.assignResult;
    }

    public void doUnAssign(List<Long> orgIds) {
        if (null == orgIds || orgIds.size() == 0) {
            return;
        }
        HashSet<Long> parentOrgIds = new HashSet<Long>(10);
        CountDownLatch cdl = new CountDownLatch(orgIds.size());
        String requestId = RequestContext.getOrCreate().getRequestId();
        for (Long orgId : orgIds) {
            ThreadService.execute(() -> {
                RequestContext.getOrCreate().setRequestId(requestId);
                try {
                    this.doUnAssign(orgId);
                }
                catch (Exception e) {
                    String msg = String.format(ResManager.loadKDString((String)"\u5206\u914d\u7ec4\u7ec7\u62a5\u9519\uff0c\u7ec4\u7ec7\u540d\u79f0\uff1a%1$s,\u62a5\u9519\u4fe1\u606f\uff1a%2$s", (String)"UnAssignHandle_10", (String)"fi-bd-common", (Object[])new Object[0]), this.assignCtx.getUseOrgs().get(orgId), e.getMessage());
                    this.assignResult.getMsgs().add(e.getMessage());
                    this.assignResult.setResultType(AssignResult.ResultType.failed);
                    logger.error(msg + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                }
                finally {
                    cdl.countDown();
                }
            }, (TaskType)TaskType.FIBD_ACCOUNT_UNASSIGN_TASK);
        }
        try {
            cdl.await();
        }
        catch (InterruptedException e) {
            String msg = String.format(ResManager.loadKDString((String)"\u5206\u914d\u7ec4\u7ec7\u62a5\u9519,\u62a5\u9519\u4fe1\u606f\uff1a%s", (String)"UnAssignHandle_9", (String)"fi-bd-common", (Object[])new Object[0]), e.getMessage());
            this.assignResult.setResultType(AssignResult.ResultType.failed);
            this.assignResult.getMsgs().add(msg);
            logger.error(msg, (Throwable)e);
            return;
        }
        Map<Long, AssignOrgTreeNode> orgTreeNodeMap = this.assignCtx.getAssignOrgTreeNodeMap();
        for (Long orgId : orgIds) {
            Long parentId;
            AssignOrgTreeNode assignOrgTreeNode = orgTreeNodeMap.get(orgId);
            if (null == assignOrgTreeNode || (parentId = assignOrgTreeNode.getParentId()) == null || parentId.longValue() == this.assignCtx.getUseOrgid().longValue()) continue;
            parentOrgIds.add(parentId);
        }
        this.doUnAssign(new ArrayList<Long>(parentOrgIds));
    }

    public void doUnAssign(Long orgId) {
        OrgSingleAssignCtx orgSingleAssignCtx = new OrgSingleAssignCtx(this.assignCtx, orgId);
        this.buildOrgAcctParentAndOtherParents(orgSingleAssignCtx);
        this.unAssignExcuter(orgSingleAssignCtx);
    }

    private void refreshBaseDataUseRange() {
        Set<String> acctCheckErrMsg;
        if (AccountVersionUtil.isRebuildDataUseRangeSystemProperty()) {
            Set<Long> orgIds = this.assignCtx.getOrgIds();
            ArrayList<Long> singletonList = new ArrayList<Long>(1);
            BaseDataService baseDataService = new BaseDataService();
            for (Long orgId : orgIds) {
                singletonList.clear();
                singletonList.add(orgId);
                baseDataService.clearBaseDataFilterCache("bd_accountview", orgId);
                BaseDataServiceHelper.refreshBaseDataUseRange((String)"bd_accountview", singletonList);
            }
        }
        if ((acctCheckErrMsg = this.assignCtx.getAcctCheckErrMsg()) != null && acctCheckErrMsg.size() > 0) {
            this.assignResult.setResultType(AssignResult.ResultType.failed);
            this.assignResult.getMsgs().add(JSONObject.toJSONString(acctCheckErrMsg));
        }
    }

    private boolean buildOrgAcctParentAndOtherParents(OrgSingleAssignCtx ctx) {
        OrgAcctParent orgAcctParam;
        String fnumber;
        UnAssignCtx assignCtx = ctx.getAssignCtx();
        Map<String, OrgAcctParent> oapopMap = ctx.getOapopMap();
        Long useOrgid = ctx.getUseOrgid();
        Set<Object> accountIds = new HashSet(100);
        Map<String, OrgAccountInfo> orgAccountInfoMap = assignCtx.getOrgAndDatas().get(useOrgid);
        if (orgAccountInfoMap == null || orgAccountInfoMap.size() == 0) {
            accountIds = assignCtx.getDataIDs();
        } else {
            for (Map.Entry<String, OrgAccountInfo> orgAccountInfoEntry : orgAccountInfoMap.entrySet()) {
                accountIds.addAll(orgAccountInfoEntry.getValue().getAccountIds());
            }
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(" select a.fid,a.fmasterid,a.fparentid, a.fnumber,a.fcreateOrgId,a.fctrlstrategy,a.fenddate,a.faccounttableid,l.fname ", new Object[0]);
        sqlBuilder.append(" from  t_bd_account a", new Object[0]);
        sqlBuilder.append(" inner join t_bd_account ms on ms.fmasterid = a.fmasterid ", new Object[0]);
        String lang = RequestContext.get().getLang().getLocale().getLanguage() + "_" + RequestContext.get().getLang().getLocale().getCountry();
        sqlBuilder.append(" inner join t_bd_account_l l on a.fid=l.fid and l.flocaleid =? ", new Object[]{lang});
        sqlBuilder.append(" where a.faccounttableid= ?  ", new Object[]{assignCtx.getAccountTableId()});
        sqlBuilder.append(" and a.fcreateorgid = ? ", new Object[]{useOrgid});
        sqlBuilder.appendIn(" and ms.fid ", new ArrayList<Object>(accountIds));
        try (DataSet dataSet = DB.queryDataSet((String)"buildOrgAcctParentAndOtherParents_acctountSql", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                fnumber = row.getString("fnumber");
                orgAcctParam = oapopMap.get(fnumber);
                if (null == orgAcctParam) {
                    orgAcctParam = new OrgAcctParent();
                    oapopMap.put(fnumber, orgAcctParam);
                    orgAcctParam.setOrgId(useOrgid);
                    orgAcctParam.setAcctNum(fnumber);
                }
                orgAcctParam.setVerison(true);
                Date fenddate = row.getDate("fenddate");
                Long id = row.getLong("fid");
                if (fenddate.compareTo(AccountVersionUtil.getEndDate()) == 0) {
                    orgAcctParam.setAcctMasterId(row.getLong("fmasterid"));
                    orgAcctParam.setAcctTableId(row.getLong("faccounttableid"));
                    orgAcctParam.setAcctName(row.getString("fname"));
                    orgAcctParam.setCtrlstrategy(row.getString("fctrlstrategy"));
                    orgAcctParam.setCreateOrgId(row.getLong("fcreateorgid"));
                }
                orgAcctParam.getVersionIds().add(id);
                orgAcctParam.getVersionAcctIDEndDateMap().put(id, fenddate);
                orgAcctParam.getUseregIds().add(id);
                orgAcctParam.getExcIds().add(id);
            }
        }
        sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,a.fmasterid,a.fparentid,a.fnumber,a.fcreateOrgId,a.fctrlstrategy,a.fenddate,a.faccounttableid,l.fname, ", new Object[0]);
        sqlBuilder.append(" reg.fuseorgid,reg.FCREATEORGID,reg.FADMINORGID,reg.FCTRLSTRATEGY,reg.FISASSIGN,reg.FASSIGNORGID ", new Object[0]);
        sqlBuilder.append(" from  t_bd_accountusereg reg ", new Object[0]);
        sqlBuilder.append(" inner join t_bd_account a ON reg.fdataid=a.fid ", new Object[0]);
        sqlBuilder.append(" inner join t_bd_account ms on ms.fmasterid = a.fmasterid ", new Object[0]);
        sqlBuilder.append(" left join t_bd_account_l l on a.fid=l.fid and l.flocaleid =? ", new Object[]{lang});
        sqlBuilder.append(" where a.faccounttableid= ? ", new Object[]{assignCtx.getAccountTableId()});
        sqlBuilder.append(" and reg.FUSEORGID = ? ", new Object[]{useOrgid});
        sqlBuilder.appendIn(" and ms.fid ", new ArrayList<Object>(accountIds));
        dataSet = DB.queryDataSet((String)"buildOrgAcctParentAndOtherParents_useregSql", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);
        var10_10 = null;
        try {
            for (Row row : dataSet) {
                fnumber = row.getString("fnumber");
                orgAcctParam = oapopMap.get(fnumber);
                if (null == orgAcctParam) {
                    orgAcctParam = new OrgAcctParent();
                    oapopMap.put(fnumber, orgAcctParam);
                    orgAcctParam.setOrgId(useOrgid);
                    orgAcctParam.setAcctNum(fnumber);
                    if (row.getDate("fenddate").compareTo(AccountVersionUtil.getEndDate()) == 0) {
                        orgAcctParam.setAcctMasterId(row.getLong("fmasterid"));
                        orgAcctParam.setAcctTableId(row.getLong("faccounttableid"));
                        orgAcctParam.setAcctName(row.getString("fname"));
                        orgAcctParam.setCtrlstrategy(row.getString("fctrlstrategy"));
                        orgAcctParam.setCreateOrgId(row.getLong("fcreateorgid"));
                    }
                }
                orgAcctParam.getUseregIds().add(row.getLong("fid"));
                orgAcctParam.getExcIds().add(row.getLong("fid"));
            }
        }
        catch (Throwable throwable) {
            var10_10 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (var10_10 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        var10_10.addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        sqlBuilder = new SqlBuilder();
        sqlBuilder.append(" select a.FNUMBER, ", new Object[0]);
        sqlBuilder.append(" exc.FDATAID,exc.FCREATEORGID,exc.FUSEORGID ", new Object[0]);
        sqlBuilder.append(" from  t_bd_accountexc exc ", new Object[0]);
        sqlBuilder.append(" inner join t_bd_account a ON exc.fdataid=a.fid ", new Object[0]);
        sqlBuilder.append(" inner join t_bd_account ms on ms.fmasterid = a.fmasterid ", new Object[0]);
        sqlBuilder.append(" where a.faccounttableid= ?  ", new Object[]{assignCtx.getAccountTableId()});
        sqlBuilder.append(" and exc.FUSEORGID = ? ", new Object[]{useOrgid});
        sqlBuilder.appendIn(" and ms.fid ", new ArrayList<Object>(accountIds));
        dataSet = DB.queryDataSet((String)"buildOrgAcctParentAndOtherParents_excSql", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);
        var10_10 = null;
        try {
            for (Row row : dataSet) {
                OrgAcctParent orgAcctParam2 = oapopMap.get(row.getString("fnumber"));
                if (null == orgAcctParam2) continue;
                orgAcctParam2.getExcIds().add(row.getLong("fdataid"));
            }
        }
        catch (Throwable throwable) {
            var10_10 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (var10_10 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        var10_10.addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        return true;
    }

    private boolean unAssignExcuter(OrgSingleAssignCtx orgSingleAssignCtx) {
        UnAssignCtx assignCtx = orgSingleAssignCtx.getAssignCtx();
        Map<String, OrgAcctParent> oapopMap = orgSingleAssignCtx.getOapopMap();
        Long orgId = orgSingleAssignCtx.getUseOrgid();
        Map<String, OrgAccountInfo> accountMap = assignCtx.getOrgAndDatas().get(orgId);
        if (null == oapopMap || null == accountMap || accountMap.size() == 0) {
            return true;
        }
        Set<String> numbers = accountMap.entrySet().stream().filter(e -> ((OrgAccountInfo)e.getValue()).getRef() == false).map(x -> (String)x.getKey()).collect(Collectors.toSet());
        if (null == numbers) {
            return true;
        }
        Map<String, AssignAccountNumTreeNode> accountNumTreeNodeMap = assignCtx.getAssignAcctountNumTreeNodeMap();
        List<String> acctNumbers = accountNumTreeNodeMap.entrySet().stream().filter(e -> ((AssignAccountNumTreeNode)e.getValue()).getChildNumbers().size() == 0).filter(e -> numbers.contains(((AssignAccountNumTreeNode)e.getValue()).getNumber())).map(x -> ((AssignAccountNumTreeNode)x.getValue()).getNumber()).collect(Collectors.toList());
        this.unAssign(oapopMap, orgId, acctNumbers, numbers);
        return true;
    }

    private void unAssign(Map<String, OrgAcctParent> oapopMap, Long orgId, List<String> acctNumbers, Set<String> numbers) {
        Map<String, OrgAccountInfo> orgAccountInfoMap = this.assignCtx.getDataInfoMap().get(orgId);
        for (String acctNumber : acctNumbers) {
            OrgAccountInfo orgAccountInfo;
            if (orgAccountInfoMap != null && (orgAccountInfo = orgAccountInfoMap.get(acctNumber)) != null && !kd.bos.util.StringUtils.isEmpty((String)orgAccountInfo.getMsg())) continue;
            this.excuteUnAssign(oapopMap, orgId, acctNumber);
        }
        HashSet<String> pnumberSet = new HashSet<String>(10);
        Map<String, AssignAccountNumTreeNode> accountNumTreeNodeMap = this.assignCtx.getAssignAcctountNumTreeNodeMap();
        for (String acctNumber : acctNumbers) {
            String pnumber;
            AssignAccountNumTreeNode assignAccountNumTreeNode;
            OrgAccountInfo orgAccountInfo;
            if (orgAccountInfoMap != null && (orgAccountInfo = orgAccountInfoMap.get(acctNumber)) != null && !kd.bos.util.StringUtils.isEmpty((String)orgAccountInfo.getMsg()) || null == (assignAccountNumTreeNode = accountNumTreeNodeMap.get(acctNumber)) || !StringUtils.isNotEmpty((CharSequence)(pnumber = assignAccountNumTreeNode.getPnumber())) || !numbers.contains(pnumber)) continue;
            pnumberSet.add(pnumber);
        }
        if (pnumberSet.size() > 0) {
            this.unAssign(oapopMap, orgId, new ArrayList<String>(pnumberSet), numbers);
        }
    }

    private void excuteUnAssign(Map<String, OrgAcctParent> oapopMap, Long orgId, String acctNumber) {
        OrgAcctParent orgAcctParent = oapopMap.get(acctNumber);
        if (null == orgAcctParent) {
            return;
        }
        Set<Long> versionIds = orgAcctParent.getVersionIds();
        long versionId = 0L;
        if (versionIds.size() > 0) {
            Map<Long, Date> versionAcctIDEndDateMap = orgAcctParent.getVersionAcctIDEndDateMap();
            for (Map.Entry<Long, Date> entry : versionAcctIDEndDateMap.entrySet()) {
                if (entry.getValue().compareTo(AccountVersionUtil.getEndDate()) != 0) continue;
                versionId = entry.getKey();
                break;
            }
            for (Long accountId : versionIds) {
                DynamicObject acct = BusinessDataServiceHelper.loadSingle((Object)accountId, (String)"bd_accountview");
                HashSet<Long> orgIds = new HashSet<Long>(10);
                orgIds.add(orgId);
                SqlBuilder acctountSql = new SqlBuilder();
                acctountSql.append(" select fuseorgid from t_bd_accountusereg where fdataid = ? ", new Object[]{accountId});
                Throwable throwable = null;
                try (DataSet dataSet = DB.queryDataSet((String)"ssdfs", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)acctountSql);){
                    for (Row row : dataSet) {
                        orgIds.add(row.getLong("fuseorgid"));
                    }
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
                if (!BizHappenUtils.existOnLaterPeriods(accountId, (Set<Long>)orgIds, acct.getDate("startdate"))) continue;
                DynamicObject targetOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org", (String)"id,number,name");
                if (null == targetOrg) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\uff08ID=%s\uff09\u5df2\u7ecf\u4e0d\u5b58\u5728\uff0c\u8981\u5148\u6e05\u9664\u810f\u6570\u636e\u624d\u80fd\u7ee7\u7eed\u64cd\u4f5c\u3002", (String)"UnAssignHandle_11", (String)"fi-bd-common", (Object[])new Object[0]), orgId));
                }
                String string = String.format(ResManager.loadKDString((String)"\u53cd\u5206\u914d\u5931\u8d25\uff0c\u5bf9\u7ec4\u7ec7'%1$s'\u7684\u79d1\u76ee%2$s\u4e2a\u6027\u5316\u5904\u7406\u65f6\u5931\u8d25: \u5f53\u524d\u9009\u62e9\u7684\u79d1\u76ee\u5b58\u5728\u51ed\u8bc1\u3001\u4f59\u989d\u6216\u521d\u59cb\u5316\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u53cd\u5206\u914d\u3002", (String)"UnAssignHandle_13", (String)"fi-bd-common", (Object[])new Object[0]), targetOrg.getString("name"), acctNumber);
                this.assignCtx.getDataInfoMap().get(orgId).get(acctNumber).setMsg(string);
                this.assignCtx.getAcctCheckErrMsg().add(string);
                throw new KDBizException(string);
            }
            Set<Long> allChildrenOrgIds = BDUtil.getAllChildrenOrgIds(orgId, true);
            Set<Long> assignRawOrgIds = AccountVersionUtil.queryAssignedRawOrgIds(versionId);
            assignRawOrgIds.removeAll(allChildrenOrgIds);
            Set<Long> outerOrgIds = assignRawOrgIds;
            for (Long outerOrgId : outerOrgIds) {
                for (Long l : versionIds) {
                    DynamicObject parentAccountFromDb = BusinessDataServiceHelper.loadSingle((Object)l, (String)"bd_accountview");
                    DynamicObject outerOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)outerOrgId, (String)"bos_org", (String)"id,number,name");
                    if (null == outerOrg) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\uff08ID=%s\uff09\u5df2\u7ecf\u4e0d\u5b58\u5728\uff0c\u8981\u5148\u6e05\u9664\u810f\u6570\u636e\u624d\u80fd\u7ee7\u7eed\u64cd\u4f5c\u3002", (String)"AccountVersionPersonalizeUtil_2", (String)"fi-bd-common", (Object[])new Object[0]), orgId));
                    }
                    parentAccountFromDb.set("useorg", (Object)outerOrg);
                    parentAccountFromDb.set("useorg_id", (Object)outerOrgId);
                    OperateOption personalizeOp = OperateOption.create();
                    personalizeOp.setVariableValue("isPersonalizeData", "1");
                    AccountVersionOpVars.setAutoAssignChildAfterVersioned(personalizeOp, true);
                    AccountVersionOpVars.setIsFromRepairOrAssignView(personalizeOp, true);
                    OperationResult personalizeResult = OperationServiceHelper.executeOperate((String)"save", (String)"bd_accountview", (DynamicObject[])new DynamicObject[]{parentAccountFromDb}, (OperateOption)personalizeOp);
                    if (!personalizeResult.isSuccess()) {
                        String failedMsg = BDUtil.buildOperationResultFailedMsg(personalizeResult, false);
                        logger.info("batch_personalized_account failed on account: {} on org: {} for {}", new Object[]{acctNumber, outerOrg.getString("name"), failedMsg});
                        String errMsg = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5bf9\u7ec4\u7ec7%1$s\u7684\u79d1\u76ee%2$s\u4e2a\u6027\u5316\u5904\u7406\u65f6\u5931\u8d25: \"%3$s\"", (String)"UnAssignHandle_12", (String)"fi-bd-common", (Object[])new Object[0]), outerOrg.getString("name"), acctNumber, failedMsg);
                        throw new KDBizException(errMsg);
                    }
                    ArrayList<Object[]> params = new ArrayList<Object[]>(1);
                    params.add(new Object[]{l, orgId, outerOrgId});
                    DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)"delete from t_bd_accountexc where fdataid = ? and fcreateorgid = ? and fuseorgid = ?", params);
                    DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)"delete from t_bd_accountusereg where fdataid = ? and fcreateorgid = ? and fuseorgid = ?", params);
                }
                HashSet<Long> singletonList = new HashSet<Long>(1);
                singletonList.add(outerOrgId);
                BaseDataCtrlCache.clearBaseDataUseRange((String)"bd_accountview", singletonList);
                BaseDataCtrlCache.clearBaseDataFilter((String)"bd_accountview", singletonList);
            }
            OperationResult result = this.deleteVersion(orgId, orgAcctParent);
            if (result != null && !result.isSuccess()) {
                StringBuilder msgSb = new StringBuilder();
                List valResults = result.getValidateResult().getValidateErrors();
                for (ValidateResult validateResult : valResults) {
                    for (OperateErrorInfo errorInfo : validateResult.getAllErrorInfo()) {
                        msgSb.append(errorInfo.getMessage()).append("\r\n");
                    }
                }
                if (StringUtils.isBlank((CharSequence)msgSb)) {
                    msgSb.append(result.getMessage());
                }
                String string = String.format(ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u914d\u62a5\u9519\uff0c\u79d1\u76ee\u7f16\u7801\uff1a%1$s,\u7ec4\u7ec7\u540d\u79f0\uff1a%2$s,\u62a5\u9519\u4fe1\u606f\uff1a%3$s", (String)"UnAssignExcuter_3", (String)"fi-bd-common", (Object[])new Object[0]), acctNumber, this.assignCtx.getUseOrgs().get(orgId), msgSb.toString());
                this.assignCtx.getDataInfoMap().get(orgId).get(acctNumber).setMsg(string);
                this.assignCtx.getAcctCheckErrMsg().add(string);
                HashSet<String> numbers = new HashSet<String>(10);
                this.findAllpNumbers(acctNumber, numbers);
                HashSet<Long> orgIds = new HashSet<Long>(10);
                this.findAllPOrgs(orgId, orgIds);
                this.removeFailNumbers(numbers, orgIds);
                throw new KDBizException(string);
            }
        }
        Set<Long> useregIds = orgAcctParent.getUseregIds();
        String successKey = orgId.toString() + useregIds.toArray()[useregIds.size() - 1].toString();
        this.assignCtx.getSuccessPkIds().add(successKey);
        String orgName = this.assignCtx.getUseOrgs().get(orgId);
        String successMess = String.format(ResManager.loadKDString((String)"%1s\u7ec4\u7ec7\u7684%2s\u79d1\u76ee\uff0c\u53d6\u6d88\u5206\u914d", (String)"UnAssignExcuter_0", (String)"fi-bd-common", (Object[])new Object[0]), orgName, acctNumber);
        this.assignCtx.getSuccessInfoMap().put(successKey, successMess);
        Set<Long> excIds = orgAcctParent.getExcIds();
        ArrayList<Object[]> params = new ArrayList<Object[]>(useregIds.size() + excIds.size());
        for (Long l : useregIds) {
            params.add(new Object[]{l, orgId});
        }
        for (Long l : excIds) {
            params.add(new Object[]{l, orgId});
        }
        this.clearCache(params);
    }

    private OperationResult deleteVersion(Long orgId, OrgAcctParent orgAcctParent) {
        ArrayList<Map.Entry<Long, Date>> versionAcctIDEndDateSet = new ArrayList<Map.Entry<Long, Date>>(orgAcctParent.getVersionAcctIDEndDateMap().entrySet());
        Comparator<Map.Entry<Long, Date>> versionAcctIDEndDateSetComparator = new Comparator<Map.Entry<Long, Date>>(){

            @Override
            public int compare(Map.Entry<Long, Date> arg0, Map.Entry<Long, Date> arg1) {
                return -arg0.getValue().compareTo(arg1.getValue());
            }
        };
        Collections.sort(versionAcctIDEndDateSet, versionAcctIDEndDateSetComparator);
        OperateOption operation = OperateOption.create();
        operation.setVariableValue("createOrg", orgId.toString());
        operation.setVariableValue("isassign", "1");
        OperationResult result = null;
        for (Map.Entry<Long, Date> versionAcctIDEndDateEnty : versionAcctIDEndDateSet) {
            result = OperationServiceHelper.executeOperate((String)"versiondelete", (String)"bd_accountview", (Object[])new Object[]{versionAcctIDEndDateEnty.getKey()}, (OperateOption)operation);
            if (result.isSuccess()) continue;
            return result;
        }
        orgAcctParent.getVersionIds().clear();
        orgAcctParent.getVersionAcctIDEndDateMap().clear();
        return result;
    }

    private void removeFailNumbers(Set<String> numbers, Set<Long> orgIds) {
        Map<Long, Map<String, OrgAccountInfo>> orgAndDatas = this.assignCtx.getOrgAndDatas();
        for (Long orgId : orgIds) {
            Map<String, OrgAccountInfo> datasMap = orgAndDatas.get(orgId);
            for (String number : numbers) {
                datasMap.remove(number);
            }
        }
    }

    private void findAllPOrgs(Long orgId, Set<Long> orgIds) {
        orgIds.add(orgId);
        Map<Long, AssignOrgTreeNode> assignOrgTreeNodeMap = this.assignCtx.getAssignOrgTreeNodeMap();
        AssignOrgTreeNode pNode = assignOrgTreeNodeMap.get(orgId).getParent();
        if (null == pNode) {
            return;
        }
        Long pOrigId = pNode.getParentId();
        orgIds.add(pOrigId);
        this.findAllPOrgs(pOrigId, orgIds);
    }

    private void findAllpNumbers(String number, Set<String> numbers) {
        numbers.add(number);
        Map<String, AssignAccountNumTreeNode> assignAcctountNumTreeNodeMap = this.assignCtx.getAssignAcctountNumTreeNodeMap();
        AssignAccountNumTreeNode parent = assignAcctountNumTreeNodeMap.get(number).getParent();
        if (null == parent) {
            return;
        }
        String pNumber = parent.getNumber();
        numbers.add(pNumber);
        this.findAllpNumbers(pNumber, numbers);
    }

    private void clearCache(List<Object[]> params) {
        if (params != null && !params.isEmpty()) {
            String deleteUseRangeSql = "delete from t_bd_accountusereg where fdataid = ? and fuseorgid = ?";
            DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)deleteUseRangeSql, params);
            deleteUseRangeSql = "DELETE from t_bd_accountusereg  where FDataID in(SELECT fid from t_bd_account where fid <> fmasterid  and fmasterid = ?  and fcreateorgid = ? ) ";
            DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)deleteUseRangeSql, params);
            deleteUseRangeSql = "delete from t_bd_accountExc where fdataid = ? and fuseorgid = ?";
            DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)deleteUseRangeSql, params);
            deleteUseRangeSql = "DELETE from t_bd_accountExc  where FDataID in(SELECT fid from t_bd_account where fid <> fmasterid  and fmasterid = ?  and fcreateorgid = ? ) ";
            DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)deleteUseRangeSql, params);
            deleteUseRangeSql = "delete from t_bd_account_u where fdataid = ? and fuseorgid = ?";
            DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)deleteUseRangeSql, params);
            deleteUseRangeSql = "DELETE from t_bd_account_u  where FDataID in(SELECT fid from t_bd_account where fid <> fmasterid  and fmasterid = ?  and fcreateorgid = ? ) ";
            DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)deleteUseRangeSql, params);
        }
    }
}

